/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.scopes.impl;

import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.SessionAndScopeSessionHolder;
import org.jetbrains.kotlin.fir.declarations.FirNamedFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import org.jetbrains.kotlin.fir.scopes.CallableCopyTypeCalculator;
import org.jetbrains.kotlin.fir.scopes.DelicateScopeAPI;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.ProcessorAction;
import org.jetbrains.kotlin.fir.scopes.impl.FirDynamicScopeConstructor;
import org.jetbrains.kotlin.fir.scopes.impl.FirDynamicScopeKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ*\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u000e0\u0012H\u0016J*\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u000e0\u0012H\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J$\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00182\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020 0\"H\u0016J(\u0010#\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00182\u0016\u0010\u0011\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030$\u0012\u0004\u0012\u00020 0\"H\u0016J\u0018\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u0006H\u0017R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u001a\u001a\u0004\u0018\u00010\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/fir/scopes/impl/FirDynamicScope;", "Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;", "Lorg/jetbrains/kotlin/fir/SessionAndScopeSessionHolder;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;)V", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "processDirectOverriddenFunctionsWithBaseScope", "Lorg/jetbrains/kotlin/fir/scopes/ProcessorAction;", "functionSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "processor", "Lkotlin/Function2;", "processDirectOverriddenPropertiesWithBaseScope", "propertySymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "getCallableNames", "", "Lorg/jetbrains/kotlin/name/Name;", "getClassifierNames", "anyTypeScope", "getAnyTypeScope", "()Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;", "anyTypeScope$delegate", "Lkotlin/Lazy;", "processFunctionsByName", "", "name", "Lkotlin/Function1;", "processPropertiesByName", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "withReplacedSessionOrNull", "newSession", "newScopeSession", "providers"})
public final class FirDynamicScope
extends FirTypeScope
implements SessionAndScopeSessionHolder {
    @NotNull
    private final FirSession session;
    @NotNull
    private final ScopeSession scopeSession;
    @NotNull
    private final Lazy anyTypeScope$delegate;

    @FirDynamicScopeConstructor
    public FirDynamicScope(@NotNull FirSession session2, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter((Object)((Object)session2), (String)"session");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        this.session = session2;
        this.scopeSession = scopeSession;
        this.anyTypeScope$delegate = LazyKt.lazy(() -> FirDynamicScope.anyTypeScope_delegate$lambda$0(this));
    }

    @Override
    @NotNull
    public FirSession getSession() {
        return this.session;
    }

    @Override
    @NotNull
    public ScopeSession getScopeSession() {
        return this.scopeSession;
    }

    @Override
    @NotNull
    public ProcessorAction processDirectOverriddenFunctionsWithBaseScope(@NotNull FirNamedFunctionSymbol functionSymbol, @NotNull Function2<? super FirNamedFunctionSymbol, ? super FirTypeScope, ? extends ProcessorAction> processor2) {
        Intrinsics.checkNotNullParameter((Object)functionSymbol, (String)"functionSymbol");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        return ProcessorAction.NEXT;
    }

    @Override
    @NotNull
    public ProcessorAction processDirectOverriddenPropertiesWithBaseScope(@NotNull FirPropertySymbol propertySymbol, @NotNull Function2<? super FirPropertySymbol, ? super FirTypeScope, ? extends ProcessorAction> processor2) {
        Intrinsics.checkNotNullParameter((Object)propertySymbol, (String)"propertySymbol");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        return ProcessorAction.NEXT;
    }

    @Override
    @NotNull
    public Set<Name> getCallableNames() {
        return SetsKt.emptySet();
    }

    @Override
    @NotNull
    public Set<Name> getClassifierNames() {
        return SetsKt.emptySet();
    }

    private final FirTypeScope getAnyTypeScope() {
        Lazy lazy = this.anyTypeScope$delegate;
        return (FirTypeScope)lazy.getValue();
    }

    @Override
    public void processFunctionsByName(@NotNull Name name2, @NotNull Function1<? super FirNamedFunctionSymbol, Unit> processor2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        Ref.BooleanRef foundMemberInAny = new Ref.BooleanRef();
        FirTypeScope firTypeScope = this.getAnyTypeScope();
        if (firTypeScope != null) {
            firTypeScope.processFunctionsByName(name2, (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)arg_0 -> FirDynamicScope.processFunctionsByName$lambda$0(foundMemberInAny, processor2, arg_0)));
        }
        if (foundMemberInAny.element) {
            return;
        }
        Object v = FirDynamicScopeKt.getDynamicMembersStorage(this.getSession()).getFunctionsCacheByName().getValue(name2, null);
        FirNamedFunction it = (FirNamedFunction)v;
        boolean bl = false;
        processor2.invoke((Object)it.getSymbol());
    }

    @Override
    public void processPropertiesByName(@NotNull Name name2, @NotNull Function1<? super FirVariableSymbol<?>, Unit> processor2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        Ref.BooleanRef foundMemberInAny = new Ref.BooleanRef();
        FirTypeScope firTypeScope = this.getAnyTypeScope();
        if (firTypeScope != null) {
            firTypeScope.processPropertiesByName(name2, arg_0 -> FirDynamicScope.processPropertiesByName$lambda$0(foundMemberInAny, processor2, arg_0));
        }
        if (foundMemberInAny.element) {
            return;
        }
        Object v = FirDynamicScopeKt.getDynamicMembersStorage(this.getSession()).getPropertiesCacheByName().getValue(name2, null);
        FirProperty it = (FirProperty)v;
        boolean bl = false;
        processor2.invoke((Object)it.getSymbol());
    }

    @Override
    @DelicateScopeAPI
    @NotNull
    public FirDynamicScope withReplacedSessionOrNull(@NotNull FirSession newSession, @NotNull ScopeSession newScopeSession) {
        Intrinsics.checkNotNullParameter((Object)((Object)newSession), (String)"newSession");
        Intrinsics.checkNotNullParameter((Object)newScopeSession, (String)"newScopeSession");
        return new FirDynamicScope(newSession, newScopeSession);
    }

    private static final FirTypeScope anyTypeScope_delegate$lambda$0(FirDynamicScope this$0) {
        return ScopeUtilsKt.scope(this$0, this$0.getSession().getBuiltinTypes().getAnyType().getConeType(), CallableCopyTypeCalculator.DoNothing.INSTANCE, null);
    }

    private static final Unit processFunctionsByName$lambda$0(Ref.BooleanRef $foundMemberInAny, Function1 $processor, FirNamedFunctionSymbol it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $foundMemberInAny.element = true;
        $processor.invoke((Object)it);
        return Unit.INSTANCE;
    }

    private static final Unit processPropertiesByName$lambda$0(Ref.BooleanRef $foundMemberInAny, Function1 $processor, FirVariableSymbol it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $foundMemberInAny.element = true;
        $processor.invoke((Object)it);
        return Unit.INSTANCE;
    }
}

