/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.scopes.impl;

import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirComposableSessionComponent;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.SessionConfiguration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00000\u0013H\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\b\u001a\u00020\t8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\b\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/scopes/impl/FirEnumEntriesSupport;", "Lorg/jetbrains/kotlin/fir/FirComposableSessionComponent;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "isEnumEntriesAvailable", "", "()Z", "isEnumEntriesAvailable$delegate", "Lkotlin/Lazy;", "canSynthesizeEnumEntriesFor", "klass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "createComposed", "Lorg/jetbrains/kotlin/fir/scopes/impl/FirEnumEntriesSupport$Composed;", "components", "", "Composed", "providers"})
public class FirEnumEntriesSupport
implements FirComposableSessionComponent<FirEnumEntriesSupport> {
    @NotNull
    private final FirSession session;
    @NotNull
    private final Lazy isEnumEntriesAvailable$delegate;

    public FirEnumEntriesSupport(@NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)((Object)session2), (String)"session");
        this.session = session2;
        this.isEnumEntriesAvailable$delegate = LazyKt.lazy(() -> FirEnumEntriesSupport.isEnumEntriesAvailable_delegate$lambda$0(this));
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    protected final boolean isEnumEntriesAvailable() {
        Lazy lazy = this.isEnumEntriesAvailable$delegate;
        return (Boolean)lazy.getValue();
    }

    public boolean canSynthesizeEnumEntriesFor(@NotNull FirClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        return ClassMembersKt.getHasEnumEntries(klass) && this.isEnumEntriesAvailable();
    }

    @SessionConfiguration
    @NotNull
    public Composed createComposed(@NotNull List<? extends FirEnumEntriesSupport> components) {
        Intrinsics.checkNotNullParameter(components, (String)"components");
        return new Composed(this.session, components);
    }

    private static final boolean isEnumEntriesAvailable_delegate$lambda$0(FirEnumEntriesSupport this$0) {
        return FirSymbolProviderKt.getRegularClassSymbolByClassId(this$0.session, StandardClassIds.INSTANCE.getEnumEntries()) != null;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00010\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/scopes/impl/FirEnumEntriesSupport$Composed;", "Lorg/jetbrains/kotlin/fir/scopes/impl/FirEnumEntriesSupport;", "Lorg/jetbrains/kotlin/fir/FirComposableSessionComponent$Composed;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "components", "", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Ljava/util/List;)V", "getComponents", "()Ljava/util/List;", "canSynthesizeEnumEntriesFor", "", "klass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "providers"})
    @SourceDebugExtension(value={"SMAP\nFirEnumEntriesSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirEnumEntriesSupport.kt\norg/jetbrains/kotlin/fir/scopes/impl/FirEnumEntriesSupport$Composed\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,46:1\n1786#2,3:47\n*S KotlinDebug\n*F\n+ 1 FirEnumEntriesSupport.kt\norg/jetbrains/kotlin/fir/scopes/impl/FirEnumEntriesSupport$Composed\n*L\n30#1:47,3\n*E\n"})
    public static final class Composed
    extends FirEnumEntriesSupport
    implements FirComposableSessionComponent.Composed<FirEnumEntriesSupport> {
        @NotNull
        private final List<FirEnumEntriesSupport> components;

        public Composed(@NotNull FirSession session2, @NotNull List<? extends FirEnumEntriesSupport> components) {
            Intrinsics.checkNotNullParameter((Object)((Object)session2), (String)"session");
            Intrinsics.checkNotNullParameter(components, (String)"components");
            super(session2);
            this.components = components;
        }

        @Override
        @NotNull
        public List<FirEnumEntriesSupport> getComponents() {
            return this.components;
        }

        @Override
        public boolean canSynthesizeEnumEntriesFor(@NotNull FirClass klass) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
                Iterable $this$all$iv = this.getComponents();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        FirEnumEntriesSupport it = (FirEnumEntriesSupport)element$iv;
                        boolean bl2 = false;
                        if (it.canSynthesizeEnumEntriesFor(klass)) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            return bl;
        }
    }
}

