/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.session;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticsContainer;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSessionComponent;
import org.jetbrains.kotlin.fir.SessionConfiguration;
import org.jetbrains.kotlin.fir.analysis.CheckersComponent;
import org.jetbrains.kotlin.fir.analysis.CheckersComponentKt;
import org.jetbrains.kotlin.fir.analysis.checkers.LanguageVersionSettingsCheckers;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationCheckers;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.ExpressionCheckers;
import org.jetbrains.kotlin.fir.analysis.checkers.type.TypeCheckers;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirComposedDiagnosticRendererFactoryKt;
import org.jetbrains.kotlin.fir.analysis.extensions.FirAdditionalCheckersExtension;
import org.jetbrains.kotlin.fir.analysis.extensions.FirAdditionalCheckersExtensionKt;
import org.jetbrains.kotlin.fir.extensions.BunchOfRegisteredExtensions;
import org.jetbrains.kotlin.fir.extensions.FirExtension;
import org.jetbrains.kotlin.fir.extensions.FirExtensionRegistrar;
import org.jetbrains.kotlin.fir.extensions.FirExtensionRegistrarKt;
import org.jetbrains.kotlin.fir.extensions.FirExtensionServiceKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bJ\u000e\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000fJ\u000e\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0010J\u000e\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0011J\u001e\u0010\u0012\u001a\u00020\n2\u000e\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0015J\u001f\u0010\u0017\u001a\u00020\n2\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\u0019\"\u00020\u001a\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\nH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/fir/session/FirSessionConfigurator;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "registeredExtensions", "", "Lorg/jetbrains/kotlin/fir/extensions/BunchOfRegisteredExtensions;", "registerExtensions", "", "extensions", "useCheckers", "checkers", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/ExpressionCheckers;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/DeclarationCheckers;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/type/TypeCheckers;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/LanguageVersionSettingsCheckers;", "registerComponent", "componentKey", "Lkotlin/reflect/KClass;", "Lorg/jetbrains/kotlin/fir/FirSessionComponent;", "componentValue", "registerDiagnosticContainers", "diagnosticContainers", "", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticsContainer;", "([Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticsContainer;)V", "configure", "entrypoint"})
@SourceDebugExtension(value={"SMAP\nFirSessionConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirSessionConfigurator.kt\norg/jetbrains/kotlin/fir/session/FirSessionConfigurator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,89:1\n2829#2,7:90\n1915#2,2:104\n491#3,7:97\n*S KotlinDebug\n*F\n+ 1 FirSessionConfigurator.kt\norg/jetbrains/kotlin/fir/session/FirSessionConfigurator\n*L\n75#1:90,7\n84#1:104,2\n77#1:97,7\n*E\n"})
public final class FirSessionConfigurator {
    @NotNull
    private final FirSession session;
    @NotNull
    private final List<BunchOfRegisteredExtensions> registeredExtensions;

    public FirSessionConfigurator(@NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)((Object)session2), (String)"session");
        this.session = session2;
        Object[] objectArray = new BunchOfRegisteredExtensions[]{BunchOfRegisteredExtensions.Companion.empty()};
        this.registeredExtensions = CollectionsKt.mutableListOf((Object[])objectArray);
    }

    public final void registerExtensions(@NotNull BunchOfRegisteredExtensions extensions) {
        Intrinsics.checkNotNullParameter((Object)extensions, (String)"extensions");
        ((Collection)this.registeredExtensions).add(extensions);
    }

    public final void useCheckers(@NotNull ExpressionCheckers checkers) {
        Intrinsics.checkNotNullParameter((Object)checkers, (String)"checkers");
        CheckersComponentKt.getCheckersComponent(this.session).register(checkers);
    }

    public final void useCheckers(@NotNull DeclarationCheckers checkers) {
        Intrinsics.checkNotNullParameter((Object)checkers, (String)"checkers");
        CheckersComponentKt.getCheckersComponent(this.session).register(checkers);
    }

    public final void useCheckers(@NotNull TypeCheckers checkers) {
        Intrinsics.checkNotNullParameter((Object)checkers, (String)"checkers");
        CheckersComponentKt.getCheckersComponent(this.session).register(checkers);
    }

    public final void useCheckers(@NotNull LanguageVersionSettingsCheckers checkers) {
        Intrinsics.checkNotNullParameter((Object)checkers, (String)"checkers");
        CheckersComponentKt.getCheckersComponent(this.session).register(checkers);
    }

    public final void registerComponent(@NotNull KClass<? extends FirSessionComponent> componentKey, @NotNull FirSessionComponent componentValue) {
        Intrinsics.checkNotNullParameter(componentKey, (String)"componentKey");
        Intrinsics.checkNotNullParameter((Object)componentValue, (String)"componentValue");
        this.session.register(componentKey, componentValue);
    }

    public final void registerDiagnosticContainers(KtDiagnosticsContainer ... diagnosticContainers) {
        Intrinsics.checkNotNullParameter((Object)diagnosticContainers, (String)"diagnosticContainers");
        FirComposedDiagnosticRendererFactoryKt.getRegisteredDiagnosticFactoriesStorage(this.session).registerDiagnosticContainers(Arrays.copyOf(diagnosticContainers, diagnosticContainers.length));
    }

    @SessionConfiguration
    public final void configure() {
        block6: {
            Iterable $this$reduce$iv = this.registeredExtensions;
            boolean $i$f$reduce = false;
            Iterator iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                Iterator<Map.Entry<KClass<? extends FirExtension>, List<FirExtension.Factory<FirExtension>>>> p1;
                BunchOfRegisteredExtensions bunchOfRegisteredExtensions = (BunchOfRegisteredExtensions)iterator$iv.next();
                BunchOfRegisteredExtensions p0 = (BunchOfRegisteredExtensions)accumulator$iv;
                boolean bl = false;
                accumulator$iv = p0.plus((BunchOfRegisteredExtensions)((Object)p1));
            }
            BunchOfRegisteredExtensions extensions = (BunchOfRegisteredExtensions)accumulator$iv;
            if (this.session.getKind() == FirSession.Kind.Library) {
                Map<KClass<? extends FirExtension>, List<FirExtension.Factory<FirExtension>>> $this$filterKeys$iv = extensions.getExtensions();
                boolean $i$f$filterKeys = false;
                LinkedHashMap<KClass<? extends FirExtension>, List<FirExtension.Factory<FirExtension>>> result$iv = new LinkedHashMap<KClass<? extends FirExtension>, List<FirExtension.Factory<FirExtension>>>();
                for (Map.Entry<KClass<? extends FirExtension>, List<FirExtension.Factory<FirExtension>>> entry$iv : $this$filterKeys$iv.entrySet()) {
                    KClass<? extends FirExtension> it = entry$iv.getKey();
                    boolean bl = false;
                    if (!FirExtensionRegistrar.Companion.getALLOWED_EXTENSIONS_FOR_LIBRARY_SESSION$entrypoint().contains(it)) continue;
                    result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                }
                Map filteredExtensions = result$iv;
                extensions = new BunchOfRegisteredExtensions(filteredExtensions, CollectionsKt.emptyList());
            }
            FirExtensionRegistrarKt.registerExtensions(FirExtensionServiceKt.getExtensionService(this.session), extensions);
            if (this.session.getKind() != FirSession.Kind.Source) break block6;
            CheckersComponent checkersComponent = CheckersComponentKt.getNullableCheckersComponent(this.session);
            if (checkersComponent != null) {
                CheckersComponent checkersComponent2 = checkersComponent;
                boolean bl = false;
                Iterable $this$forEach$iv = FirAdditionalCheckersExtensionKt.getAdditionalCheckers(FirExtensionServiceKt.getExtensionService(this.session));
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    FirAdditionalCheckersExtension p0 = (FirAdditionalCheckersExtension)element$iv;
                    boolean bl2 = false;
                    checkersComponent2.register(p0);
                }
            }
        }
    }
}

