/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.scripting.shared;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.scripting.shared.UtilsKt;
import org.jetbrains.kotlin.gradle.scripting.shared.roots.GradleBuildRoot;
import org.jetbrains.kotlin.gradle.scripting.shared.roots.GradleBuildRootsLocator;
import org.jetbrains.kotlin.idea.core.script.shared.CachedConfigurationInputs;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J)\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0014\u0010\u001a\u001a\u00020\u000f2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0083\u0004J\n\u0010\u001d\u001a\u00020\u001eH\u00d6\u0081\u0004J\n\u0010\u001f\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/gradle/scripting/shared/GradleKotlinScriptConfigurationInputs;", "Lorg/jetbrains/kotlin/idea/core/script/shared/CachedConfigurationInputs;", "sections", "", "lastModifiedTs", "", "buildRoot", "<init>", "(Ljava/lang/String;JLjava/lang/String;)V", "getSections", "()Ljava/lang/String;", "getLastModifiedTs", "()J", "getBuildRoot", "isUpToDate", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "", "toString", "kotlin.gradle.scripting.shared"})
public final class GradleKotlinScriptConfigurationInputs
implements CachedConfigurationInputs {
    @NotNull
    private final String sections;
    private final long lastModifiedTs;
    @Nullable
    private final String buildRoot;

    public GradleKotlinScriptConfigurationInputs(@NotNull String sections, long lastModifiedTs, @Nullable String buildRoot) {
        Intrinsics.checkNotNullParameter((Object)sections, (String)"sections");
        this.sections = sections;
        this.lastModifiedTs = lastModifiedTs;
        this.buildRoot = buildRoot;
    }

    public /* synthetic */ GradleKotlinScriptConfigurationInputs(String string, long l, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        this(string, l, string2);
    }

    @NotNull
    public final String getSections() {
        return this.sections;
    }

    public final long getLastModifiedTs() {
        return this.lastModifiedTs;
    }

    @Nullable
    public final String getBuildRoot() {
        return this.buildRoot;
    }

    @Override
    public boolean isUpToDate(@NotNull Project project, @NotNull VirtualFile file, @Nullable KtFile ktFile2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            GradleBuildRoot gradleBuildRoot;
            GradleBuildRootsLocator gradleBuildRootsLocator;
            GradleKotlinScriptConfigurationInputs gradleKotlinScriptConfigurationInputs = UtilsKt.getGradleScriptInputsStamp$default(project, file, ktFile2, 0L, 8, null);
            if (gradleKotlinScriptConfigurationInputs == null) {
                return false;
            }
            GradleKotlinScriptConfigurationInputs actualStamp = gradleKotlinScriptConfigurationInputs;
            if (!Intrinsics.areEqual((Object)actualStamp.sections, (Object)this.sections)) {
                return false;
            }
            return this.buildRoot == null || ((gradleBuildRootsLocator = GradleBuildRootsLocator.Companion.getInstance(project)) != null && (gradleBuildRoot = gradleBuildRootsLocator.getBuildRootByWorkingDir(this.buildRoot)) != null ? gradleBuildRoot.areRelatedFilesChangedBefore(file, this.lastModifiedTs) : false);
        }
        catch (ProcessCanceledException cancel) {
            return false;
        }
    }

    @NotNull
    public final String component1() {
        return this.sections;
    }

    public final long component2() {
        return this.lastModifiedTs;
    }

    @Nullable
    public final String component3() {
        return this.buildRoot;
    }

    @NotNull
    public final GradleKotlinScriptConfigurationInputs copy(@NotNull String sections, long lastModifiedTs, @Nullable String buildRoot) {
        Intrinsics.checkNotNullParameter((Object)sections, (String)"sections");
        return new GradleKotlinScriptConfigurationInputs(sections, lastModifiedTs, buildRoot);
    }

    public static /* synthetic */ GradleKotlinScriptConfigurationInputs copy$default(GradleKotlinScriptConfigurationInputs gradleKotlinScriptConfigurationInputs, String string, long l, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = gradleKotlinScriptConfigurationInputs.sections;
        }
        if ((n & 2) != 0) {
            l = gradleKotlinScriptConfigurationInputs.lastModifiedTs;
        }
        if ((n & 4) != 0) {
            string2 = gradleKotlinScriptConfigurationInputs.buildRoot;
        }
        return gradleKotlinScriptConfigurationInputs.copy(string, l, string2);
    }

    @NotNull
    public String toString() {
        return "GradleKotlinScriptConfigurationInputs(sections=" + this.sections + ", lastModifiedTs=" + this.lastModifiedTs + ", buildRoot=" + this.buildRoot + ")";
    }

    public int hashCode() {
        int result2 = this.sections.hashCode();
        result2 = result2 * 31 + Long.hashCode(this.lastModifiedTs);
        result2 = result2 * 31 + (this.buildRoot == null ? 0 : this.buildRoot.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GradleKotlinScriptConfigurationInputs)) {
            return false;
        }
        GradleKotlinScriptConfigurationInputs gradleKotlinScriptConfigurationInputs = (GradleKotlinScriptConfigurationInputs)other;
        if (!Intrinsics.areEqual((Object)this.sections, (Object)gradleKotlinScriptConfigurationInputs.sections)) {
            return false;
        }
        if (this.lastModifiedTs != gradleKotlinScriptConfigurationInputs.lastModifiedTs) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.buildRoot, (Object)gradleKotlinScriptConfigurationInputs.buildRoot);
    }
}

