/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.scripting.shared;

import com.intellij.gradle.toolingExtension.util.GradleVersionUtil;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.scripting.shared.GradleKotlinScriptConfigurationInputs;
import org.jetbrains.kotlin.gradle.scripting.shared.roots.GradleBuildRoot;
import org.jetbrains.kotlin.gradle.scripting.shared.roots.GradleBuildRootsLocator;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtScriptInitializer;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a.\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u001a\u000e\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0002\"\u001e\u0010\u0000\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0011\u001a\u00020\u0002X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"sections", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "isGradleKotlinScript", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getGradleScriptInputsStamp", "Lorg/jetbrains/kotlin/gradle/scripting/shared/GradleKotlinScriptConfigurationInputs;", "project", "Lcom/intellij/openapi/project/Project;", "file", "givenKtFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "givenTimeStamp", "", "minimal_gradle_version_supported", "kotlinDslScriptsModelImportSupported", "gradleVersion", "kotlin.gradle.scripting.shared"})
@SourceDebugExtension(value={"SMAP\nutils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 utils.kt\norg/jetbrains/kotlin/gradle/scripting/shared/UtilsKt\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,69:1\n265#2:70\n14060#3,2:71\n*S KotlinDebug\n*F\n+ 1 utils.kt\norg/jetbrains/kotlin/gradle/scripting/shared/UtilsKt\n*L\n37#1:70\n38#1:71,2\n*E\n"})
public final class UtilsKt {
    @NotNull
    private static final ArrayList<String> sections;
    @NotNull
    public static final String minimal_gradle_version_supported = "6.0";

    public static final boolean isGradleKotlinScript(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        CharSequence charSequence = virtualFile.getNameSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getNameSequence(...)");
        return StringsKt.endsWith$default((CharSequence)charSequence, (CharSequence)".gradle.kts", (boolean)false, (int)2, null);
    }

    @Nullable
    public static final GradleKotlinScriptConfigurationInputs getGradleScriptInputsStamp(@NotNull Project project, @NotNull VirtualFile file, @Nullable KtFile givenKtFile, long givenTimeStamp) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!UtilsKt.isGradleKotlinScript(file)) {
            return null;
        }
        return (GradleKotlinScriptConfigurationInputs)ActionsKt.runReadAction(() -> UtilsKt.getGradleScriptInputsStamp$lambda$0(givenKtFile, project, file, givenTimeStamp));
    }

    public static /* synthetic */ GradleKotlinScriptConfigurationInputs getGradleScriptInputsStamp$default(Project project, VirtualFile virtualFile, KtFile ktFile2, long l, int n, Object object) {
        if ((n & 4) != 0) {
            ktFile2 = null;
        }
        if ((n & 8) != 0) {
            l = virtualFile.getModificationStamp();
        }
        return UtilsKt.getGradleScriptInputsStamp(project, virtualFile, ktFile2, l);
    }

    public static final boolean kotlinDslScriptsModelImportSupported(@NotNull String gradleVersion) {
        Intrinsics.checkNotNullParameter((Object)gradleVersion, (String)"gradleVersion");
        return GradleVersionUtil.isGradleAtLeast((String)gradleVersion, (String)minimal_gradle_version_supported);
    }

    /*
     * WARNING - void declaration
     */
    private static final GradleKotlinScriptConfigurationInputs getGradleScriptInputsStamp$lambda$0(KtFile $givenKtFile, Project $project, VirtualFile $file, long $givenTimeStamp) {
        KtBlockExpression ktBlockExpression;
        PsiFile psiFile;
        KtFile ktFile2 = $givenKtFile;
        if (ktFile2 == null && (ktFile2 = (psiFile = PsiManager.getInstance((Project)$project).findFile($file)) instanceof KtFile ? (KtFile)psiFile : null) == null) {
            return null;
        }
        KtFile ktFile3 = ktFile2;
        StringBuilder result2 = new StringBuilder();
        psiFile = ktFile3.getScript();
        if (psiFile != null && (ktBlockExpression = psiFile.getBlockExpression()) != null) {
            KtScriptInitializer[] ktScriptInitializerArray;
            KtScriptInitializer[] $this$getChildrenOfType$iv;
            PsiElement psiElement = (PsiElement)ktBlockExpression;
            boolean $i$f$getChildrenOfType = false;
            PsiElement[] psiElementArray = PsiTreeUtil.getChildrenOfType((PsiElement)$this$getChildrenOfType$iv, KtScriptInitializer.class);
            if (psiElementArray == null) {
                psiElementArray = (PsiElement[])new KtScriptInitializer[0];
            }
            if ((ktScriptInitializerArray = (KtScriptInitializer[])psiElementArray) != null) {
                void $this$forEach$iv;
                $this$getChildrenOfType$iv = ktScriptInitializerArray;
                boolean $i$f$forEach = false;
                int n = ((void)$this$forEach$iv).length;
                for (int j = 0; j < n; ++j) {
                    void element$iv;
                    void it = element$iv = $this$forEach$iv[j];
                    boolean bl = false;
                    PsiElement[] psiElementArray2 = it.getChildren();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElementArray2, (String)"getChildren(...)");
                    Object object = ArraysKt.singleOrNull((Object[])psiElementArray2);
                    KtCallExpression call = object instanceof KtCallExpression ? (KtCallExpression)object : null;
                    Object object2 = call;
                    if (object2 != null && (object2 = object2.getFirstChild()) != null) {
                        KtLambdaArgument lambda2;
                        Object callRef;
                        if ((object2 = object2.getText()) == null || !sections.contains(callRef = object2)) continue;
                        result2.append((String)callRef);
                        KtLambdaArgument ktLambdaArgument = lambda2 = (KtLambdaArgument)CollectionsKt.singleOrNull((List)call.getLambdaArguments());
                        if (ktLambdaArgument != null) {
                            ktLambdaArgument.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(result2){
                                final /* synthetic */ StringBuilder $result;
                                {
                                    this.$result = $result;
                                    super(false);
                                }

                                public void visitElement(PsiElement element) {
                                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                                    super.visitElement(element);
                                    PsiElement psiElement = element;
                                    if (psiElement instanceof PsiWhiteSpace) {
                                        String string = ((PsiWhiteSpace)element).getText();
                                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                                        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"\n", (boolean)false, (int)2, null)) {
                                            this.$result.append("\n");
                                        }
                                    } else if (!(psiElement instanceof PsiComment) && psiElement instanceof LeafPsiElement) {
                                        this.$result.append(((LeafPsiElement)element).getText());
                                    }
                                }
                            });
                        }
                        result2.append("\n");
                    }
                }
            }
        }
        GradleBuildRootsLocator.ScriptUnderRoot scriptUnderRoot = GradleBuildRootsLocator.Companion.getInstance($project).findScriptBuildRoot($file);
        GradleBuildRoot buildRoot = scriptUnderRoot != null ? scriptUnderRoot.getNearest() : null;
        String string = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        GradleBuildRoot gradleBuildRoot = buildRoot;
        return new GradleKotlinScriptConfigurationInputs(string, $givenTimeStamp, gradleBuildRoot != null ? gradleBuildRoot.getExternalProjectPath() : null);
    }

    static {
        Object[] objectArray = new String[]{"buildscript", "plugins", "initscript", "pluginManagement"};
        sections = CollectionsKt.arrayListOf((Object[])objectArray);
    }
}

