/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.scripting.shared.roots;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.IntellijInternalApi;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.gist.storage.GistStorage;
import com.intellij.util.io.DataExternalizer;
import java.io.DataInput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.scripting.shared.GradleKotlinScriptConfigurationInputs;
import org.jetbrains.kotlin.gradle.scripting.shared.LastModifiedFiles;
import org.jetbrains.kotlin.gradle.scripting.shared.importing.KotlinDslScriptModel;
import org.jetbrains.kotlin.gradle.scripting.shared.roots.GradleBuildRootData;
import org.jetbrains.kotlin.gradle.scripting.shared.roots.StringsPool;
import org.jetbrains.kotlin.idea.core.script.v1.RawDataUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fH$J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0011\u001a\u00020\u0006J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u00062\b\u0010\u0014\u001a\u0004\u0018\u00010\u000bJ\u000e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0006R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR!\u0010\t\u001a\u0015\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\n\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/gradle/scripting/shared/roots/AbstractGradleBuildRootDataSerializer;", "", "<init>", "()V", "currentBuildRoot", "Ljava/lang/ThreadLocal;", "Lcom/intellij/openapi/vfs/VirtualFile;", "getCurrentBuildRoot", "()Ljava/lang/ThreadLocal;", "buildRootDataGist", "Lcom/intellij/util/gist/storage/GistStorage$Gist;", "Lorg/jetbrains/kotlin/gradle/scripting/shared/roots/GradleBuildRootData;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getExternalizer", "Lcom/intellij/util/io/DataExternalizer;", "read", "buildRoot", "write", "", "data", "remove", "Companion", "kotlin.gradle.scripting.shared"})
public abstract class AbstractGradleBuildRootDataSerializer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ThreadLocal<VirtualFile> currentBuildRoot = new ThreadLocal();
    @NotNull
    private final GistStorage.Gist<GradleBuildRootData> buildRootDataGist;

    public AbstractGradleBuildRootDataSerializer() {
        GistStorage.Gist gist = GistStorage.getInstance().newGist("GradleBuildRootData", 2, this.getExternalizer());
        Intrinsics.checkNotNullExpressionValue((Object)gist, (String)"newGist(...)");
        this.buildRootDataGist = gist;
    }

    @NotNull
    protected final ThreadLocal<VirtualFile> getCurrentBuildRoot() {
        return this.currentBuildRoot;
    }

    @NotNull
    protected abstract DataExternalizer<GradleBuildRootData> getExternalizer();

    @Nullable
    public final GradleBuildRootData read(@NotNull VirtualFile buildRoot) {
        Intrinsics.checkNotNullParameter((Object)buildRoot, (String)"buildRoot");
        this.currentBuildRoot.set(buildRoot);
        return (GradleBuildRootData)this.buildRootDataGist.getGlobalData(buildRoot, 0).data();
    }

    public final void write(@NotNull VirtualFile buildRoot, @Nullable GradleBuildRootData data) {
        Intrinsics.checkNotNullParameter((Object)buildRoot, (String)"buildRoot");
        this.currentBuildRoot.set(buildRoot);
        this.buildRootDataGist.putGlobalData(buildRoot, (Object)data, 0);
    }

    public final void remove(@NotNull VirtualFile buildRoot) {
        Intrinsics.checkNotNullParameter((Object)buildRoot, (String)"buildRoot");
        this.write(buildRoot, null);
        LastModifiedFiles.Companion.remove(buildRoot);
    }

    @JvmStatic
    @NotNull
    public static final AbstractGradleBuildRootDataSerializer getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\b\u0010\n\u001a\u00020\u000bH\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/gradle/scripting/shared/roots/AbstractGradleBuildRootDataSerializer$Companion;", "", "<init>", "()V", "readKotlinDslScriptModels", "Lorg/jetbrains/kotlin/gradle/scripting/shared/roots/GradleBuildRootData;", "input", "Ljava/io/DataInput;", "buildRoot", "", "getInstance", "Lorg/jetbrains/kotlin/gradle/scripting/shared/roots/AbstractGradleBuildRootDataSerializer;", "kotlin.gradle.scripting.shared"})
    @SourceDebugExtension(value={"SMAP\nAbstractGradleBuildRootDataSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractGradleBuildRootDataSerializer.kt\norg/jetbrains/kotlin/gradle/scripting/shared/roots/AbstractGradleBuildRootDataSerializer$Companion\n+ 2 AbstractGradleBuildRootDataSerializer.kt\norg/jetbrains/kotlin/gradle/scripting/shared/roots/AbstractGradleBuildRootDataSerializerKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,149:1\n142#2,6:150\n42#3,3:156\n*S KotlinDebug\n*F\n+ 1 AbstractGradleBuildRootDataSerializer.kt\norg/jetbrains/kotlin/gradle/scripting/shared/roots/AbstractGradleBuildRootDataSerializer$Companion\n*L\n54#1:150,6\n69#1:156,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @IntellijInternalApi
        @NotNull
        public final GradleBuildRootData readKotlinDslScriptModels(@NotNull DataInput input, @NotNull String buildRoot) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Intrinsics.checkNotNullParameter((Object)buildRoot, (String)"buildRoot");
            StringsPool.Reader strings = StringsPool.INSTANCE.reader(input);
            long importTs = input.readLong();
            List<String> projectRoots = strings.readStrings();
            String gradleHome = strings.readString();
            String javaHome = strings.readNullableString();
            DataInput $this$readList$iv = input;
            boolean $i$f$readList = false;
            int n$iv = $this$readList$iv.readInt();
            ArrayList<KotlinDslScriptModel> result$iv = new ArrayList<KotlinDslScriptModel>(n$iv);
            int n = 0;
            while (n < n$iv) {
                int it$iv = n++;
                boolean bl = false;
                ArrayList<KotlinDslScriptModel> arrayList = result$iv;
                boolean bl2 = false;
                arrayList.add(new KotlinDslScriptModel(strings.readString(), new GradleKotlinScriptConfigurationInputs(RawDataUtilsKt.readString(input), input.readLong(), buildRoot), strings.readStrings(), strings.readStrings(), strings.readStrings(), CollectionsKt.emptyList(), null, 64, null));
            }
            List models = result$iv;
            return new GradleBuildRootData(importTs, (Collection<String>)projectRoots, gradleHome, javaHome, models);
        }

        @JvmStatic
        @NotNull
        public final AbstractGradleBuildRootDataSerializer getInstance() {
            boolean $i$f$service = false;
            Class<AbstractGradleBuildRootDataSerializer> serviceClass$iv = AbstractGradleBuildRootDataSerializer.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (AbstractGradleBuildRootDataSerializer)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

