/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.scripting.shared.roots;

import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.scripting.shared.LastModifiedFiles;
import org.jetbrains.kotlin.gradle.scripting.shared.roots.Imported;
import org.jetbrains.kotlin.gradle.scripting.shared.roots.WithoutScriptModels;
import org.jetbrains.kotlin.idea.core.script.v1.ScriptingLoggerKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0001#B\u0019\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001eJ\u0016\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u001eJ\u0006\u0010\"\u001a\u00020\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001f\u0010\n\u001a\u0010\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u0082\u0001\u0002$%\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/gradle/scripting/shared/roots/GradleBuildRoot;", "", "lastModifiedFiles", "Lorg/jetbrains/kotlin/gradle/scripting/shared/LastModifiedFiles;", "externalProjectPath", "", "<init>", "(Lorg/jetbrains/kotlin/gradle/scripting/shared/LastModifiedFiles;Ljava/lang/String;)V", "getExternalProjectPath", "()Ljava/lang/String;", "importing", "Ljava/util/concurrent/atomic/AtomicReference;", "Lorg/jetbrains/kotlin/gradle/scripting/shared/roots/GradleBuildRoot$ImportingStatus;", "kotlin.jvm.PlatformType", "getImporting", "()Ljava/util/concurrent/atomic/AtomicReference;", "projectRoots", "", "getProjectRoots", "()Ljava/util/Collection;", "dir", "Lcom/intellij/openapi/vfs/VirtualFile;", "getDir", "()Lcom/intellij/openapi/vfs/VirtualFile;", "saveLastModifiedFiles", "", "areRelatedFilesChangedBefore", "", "file", "lastModified", "", "fileChanged", "filePath", "ts", "isImportingInProgress", "ImportingStatus", "Lorg/jetbrains/kotlin/gradle/scripting/shared/roots/Imported;", "Lorg/jetbrains/kotlin/gradle/scripting/shared/roots/WithoutScriptModels;", "kotlin.gradle.scripting.shared"})
public abstract sealed class GradleBuildRoot
permits Imported, WithoutScriptModels {
    @NotNull
    private final LastModifiedFiles lastModifiedFiles;
    @NotNull
    private final String externalProjectPath;
    @NotNull
    private final AtomicReference<ImportingStatus> importing;

    private GradleBuildRoot(LastModifiedFiles lastModifiedFiles, String externalProjectPath) {
        this.lastModifiedFiles = lastModifiedFiles;
        this.externalProjectPath = externalProjectPath;
        this.importing = new AtomicReference<ImportingStatus>(ImportingStatus.updated);
    }

    @NotNull
    public String getExternalProjectPath() {
        return this.externalProjectPath;
    }

    @NotNull
    public final AtomicReference<ImportingStatus> getImporting() {
        return this.importing;
    }

    @NotNull
    public abstract Collection<String> getProjectRoots();

    @Nullable
    public final VirtualFile getDir() {
        return LocalFileSystem.getInstance().findFileByPath(this.getExternalProjectPath());
    }

    public final void saveLastModifiedFiles() {
        ScriptingLoggerKt.scriptingDebugLog$default(null, () -> GradleBuildRoot.saveLastModifiedFiles$lambda$0(this), 1, null);
        VirtualFile virtualFile = this.getDir();
        if (virtualFile == null) {
            return;
        }
        LastModifiedFiles.Companion.write(virtualFile, this.lastModifiedFiles);
    }

    public final boolean areRelatedFilesChangedBefore(@NotNull VirtualFile file, long lastModified) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return this.lastModifiedFiles.lastModifiedTimeStampExcept(string) < lastModified;
    }

    public final void fileChanged(@NotNull String filePath, long ts) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        this.lastModifiedFiles.fileChanged(ts, filePath);
    }

    public final boolean isImportingInProgress() {
        return this.importing.get() != ImportingStatus.updated;
    }

    private static final String saveLastModifiedFiles$lambda$0(GradleBuildRoot this$0) {
        return "LasModifiedFiles saved: " + this$0.lastModifiedFiles;
    }

    public /* synthetic */ GradleBuildRoot(LastModifiedFiles lastModifiedFiles, String externalProjectPath, DefaultConstructorMarker $constructor_marker) {
        this(lastModifiedFiles, externalProjectPath);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/scripting/shared/roots/GradleBuildRoot$ImportingStatus;", "", "<init>", "(Ljava/lang/String;I)V", "importing", "updatingCaches", "updated", "kotlin.gradle.scripting.shared"})
    public static final class ImportingStatus
    extends Enum<ImportingStatus> {
        public static final /* enum */ ImportingStatus importing = new ImportingStatus();
        public static final /* enum */ ImportingStatus updatingCaches = new ImportingStatus();
        public static final /* enum */ ImportingStatus updated = new ImportingStatus();
        private static final /* synthetic */ ImportingStatus[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ImportingStatus[] values() {
            return (ImportingStatus[])$VALUES.clone();
        }

        public static ImportingStatus valueOf(String value) {
            return Enum.valueOf(ImportingStatus.class, value);
        }

        @NotNull
        public static EnumEntries<ImportingStatus> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = importingStatusArray = new ImportingStatus[]{ImportingStatus.importing, ImportingStatus.updatingCaches, ImportingStatus.updated};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

