/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.EventId3;
import com.intellij.internal.statistic.eventLog.events.PrimitiveEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.util.KotlinPlatformUtils;
import org.jetbrains.kotlin.idea.codeInsight.KotlinCodeInsightSettings;
import org.jetbrains.kotlin.idea.codeInsight.KotlinCodeInsightWorkspaceSettings;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinIdePlugin;
import org.jetbrains.kotlin.idea.core.script.v1.settings.KotlinScriptingSettings;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinitionProvider;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0014R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0013\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/IDESettingsFUSCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "<init>", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "project", "Lcom/intellij/openapi/project/Project;", "GROUP", "scriptingAREnabledField", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "scriptingDefNameField", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "scriptingPluginInfoField", "Lcom/intellij/internal/statistic/eventLog/events/PrimitiveEventField;", "Lcom/intellij/internal/statistic/utils/PluginInfo;", "scriptingAREvent", "Lcom/intellij/internal/statistic/eventLog/events/EventId3;", "", "", "unambiguousImportsEvent", "Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "optimizeImportsEvent", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nIDESettingsFUSCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IDESettingsFUSCollector.kt\norg/jetbrains/kotlin/idea/IDESettingsFUSCollector\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,80:1\n30#2,2:81\n1342#3,2:83\n*S KotlinDebug\n*F\n+ 1 IDESettingsFUSCollector.kt\norg/jetbrains/kotlin/idea/IDESettingsFUSCollector\n*L\n31#1:81,2\n31#1:83,2\n*E\n"})
public final class IDESettingsFUSCollector
extends ProjectUsagesCollector {
    @NotNull
    private final EventLogGroup GROUP = new EventLogGroup("kotlin.ide.settings", 4, null, 4, null);
    @NotNull
    private final BooleanEventField scriptingAREnabledField = EventFields.Boolean((String)"enabled");
    @NotNull
    private final StringEventField scriptingDefNameField;
    @NotNull
    private final PrimitiveEventField<PluginInfo> scriptingPluginInfoField;
    @NotNull
    private final EventId3<String, Boolean, PluginInfo> scriptingAREvent;
    @NotNull
    private final EventId2<Boolean, PluginInfo> unambiguousImportsEvent;
    @NotNull
    private final EventId2<Boolean, PluginInfo> optimizeImportsEvent;

    public IDESettingsFUSCollector() {
        Object[] objectArray = new String[]{"KotlinInitScript", "KotlinSettingsScript", "KotlinBuildScript", "Script_definition_for_extension_scripts_and_IDE_console", "MainKtsScript", "Kotlin_Script", "Space_Automation"};
        this.scriptingDefNameField = EventFields.String((String)"definition_name", (List)CollectionsKt.listOf((Object[])objectArray));
        this.scriptingPluginInfoField = EventFields.PluginInfo;
        this.scriptingAREvent = this.GROUP.registerEvent("scriptingAutoReloadEnabled", (EventField)this.scriptingDefNameField, (EventField)this.scriptingAREnabledField, (EventField)this.scriptingPluginInfoField);
        this.unambiguousImportsEvent = this.GROUP.registerEvent("addUnambiguousImportsOnTheFly", (EventField)EventFields.Boolean((String)"enabled"), (EventField)EventFields.PluginInfo);
        this.optimizeImportsEvent = this.GROUP.registerEvent("optimizeImportsOnTheFly", (EventField)EventFields.Boolean((String)"enabled"), (EventField)EventFields.PluginInfo);
    }

    @NotNull
    public EventLogGroup getGroup() {
        return this.GROUP;
    }

    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (KotlinPlatformUtils.isAndroidStudio()) {
            return SetsKt.emptySet();
        }
        Set metrics = new LinkedHashSet();
        PluginInfo pluginInfo = PluginInfoDetectorKt.getPluginInfoById((PluginId)KotlinIdePlugin.INSTANCE.getId());
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<ScriptDefinitionProvider> serviceClass$iv = ScriptDefinitionProvider.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        Sequence<ScriptDefinition> $this$forEach$iv = ((ScriptDefinitionProvider)object).getCurrentDefinitions();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ScriptDefinition definition = (ScriptDefinition)((Object)element$iv);
            boolean bl = false;
            if (!definition.getCanAutoReloadScriptConfigurationsBeSwitchedOff()) continue;
            boolean scriptingAutoReloadEnabled = KotlinScriptingSettings.Companion.getInstance(project).autoReloadConfigurations(definition);
            metrics.add(this.scriptingAREvent.metric((Object)definition.getName(), (Object)scriptingAutoReloadEnabled, (Object)pluginInfo));
        }
        KotlinCodeInsightSettings settings2 = KotlinCodeInsightSettings.Companion.getInstance();
        KotlinCodeInsightWorkspaceSettings projectSettings = KotlinCodeInsightWorkspaceSettings.Companion.getInstance(project);
        metrics.add(this.unambiguousImportsEvent.metric((Object)settings2.addUnambiguousImportsOnTheFly, (Object)pluginInfo));
        metrics.add(this.optimizeImportsEvent.metric((Object)projectSettings.optimizeImportsOnTheFly, (Object)pluginInfo));
        return metrics;
    }
}

