/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.actions;

import com.intellij.ide.actions.CreateFileFromTemplateAction;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.actions.NewKotlinFileActionKt;
import org.jetbrains.kotlin.idea.base.projectStructure.NewKotlinFileHook;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u0006H\u0002J0\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f\u0018\u00010\u000eH\u0014J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\"\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/actions/AbstractNewKotlinFileAction;", "Lcom/intellij/ide/actions/CreateFileFromTemplateAction;", "<init>", "()V", "editor", "Lcom/intellij/openapi/editor/Editor;", "Lorg/jetbrains/kotlin/psi/KtFile;", "postProcess", "", "createdElement", "Lcom/intellij/psi/PsiFile;", "templateName", "", "customProperties", "", "startInWriteAction", "", "createFileFromTemplate", "name", "template", "Lcom/intellij/ide/fileTemplates/FileTemplate;", "dir", "Lcom/intellij/psi/PsiDirectory;", "intellij.kotlin.ide"})
@SourceDebugExtension(value={"SMAP\nNewKotlinFileAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NewKotlinFileAction.kt\norg/jetbrains/kotlin/idea/actions/AbstractNewKotlinFileAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,333:1\n1#2:334\n*E\n"})
public abstract class AbstractNewKotlinFileAction
extends CreateFileFromTemplateAction {
    private final Editor editor(KtFile $this$editor) {
        Object object;
        Editor editor = FileEditorManager.getInstance((Project)$this$editor.getProject()).getSelectedTextEditor();
        if (editor != null) {
            Editor editor2;
            Editor it = editor2 = editor;
            boolean bl = false;
            object = Intrinsics.areEqual((Object)it.getDocument(), (Object)$this$editor.getViewProvider().getDocument()) ? editor2 : null;
        } else {
            object = null;
        }
        return object;
    }

    protected void postProcess(@NotNull PsiFile createdElement, @Nullable String templateName, @Nullable Map<String, String> customProperties) {
        Intrinsics.checkNotNullParameter((Object)createdElement, (String)"createdElement");
        super.postProcess((PsiElement)createdElement, templateName, customProperties);
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)createdElement));
        if (createdElement instanceof KtFile) {
            Object object;
            KtNamedDeclaration ktClass;
            if (module != null) {
                for (NewKotlinFileHook hook : (NewKotlinFileHook[])NewKotlinFileHook.Companion.getEP_NAME().getExtensions()) {
                    hook.postProcess((KtFile)createdElement, module);
                }
            }
            KtNamedDeclaration ktNamedDeclaration = ktClass = (object = CollectionsKt.singleOrNull((List)((KtFile)createdElement).getDeclarations())) instanceof KtNamedDeclaration ? (KtNamedDeclaration)object : null;
            if (ktClass != null) {
                KtPrimaryConstructor primaryConstructor;
                if (ktClass instanceof KtClass && ((KtClass)ktClass).isData() && (primaryConstructor = ((KtClass)ktClass).getPrimaryConstructor()) != null) {
                    Editor editor = this.editor((KtFile)createdElement);
                    if (editor != null && (editor = editor.getCaretModel()) != null) {
                        editor.moveToOffset(PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)primaryConstructor)) + 1);
                    }
                    return;
                }
                CreateFileFromTemplateAction.moveCaretAfterNameIdentifier((PsiNameIdentifierOwner)((PsiNameIdentifierOwner)ktClass));
            } else {
                Editor editor = this.editor((KtFile)createdElement);
                if (editor == null) {
                    return;
                }
                Editor editor2 = editor;
                int lineCount = editor2.getDocument().getLineCount();
                if (lineCount > 0) {
                    editor2.getCaretModel().moveToLogicalPosition(new LogicalPosition(lineCount - 1, 0));
                }
            }
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    protected PsiFile createFileFromTemplate(@NotNull String name2, @NotNull FileTemplate template2, @NotNull PsiDirectory dir) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)template2, (String)"template");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        return NewKotlinFileActionKt.createFileFromTemplateWithStat(name2, template2, dir);
    }
}

