/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.actions.internal;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.searches.ReferencesSearch;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.actions.internal.CheckComponentsUsageSearchAction$process$;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.search.usagesSearch.ExpressionsOfTypeProcessor;
import org.jetbrains.kotlin.idea.util.FileUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtParameter;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001e\u0010\b\u001a\u00020\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00122\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J)\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\f\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/actions/internal/CheckComponentsUsageSearchAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "process", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "project", "Lcom/intellij/openapi/project/Project;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "selectedKotlinFiles", "Lkotlin/sequences/Sequence;", "allKotlinFiles", "filesOrDirs", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "([Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/project/Project;)Lkotlin/sequences/Sequence;", "intellij.kotlin.ide"})
@SourceDebugExtension(value={"SMAP\nCheckComponentsUsageSearchAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CheckComponentsUsageSearchAction.kt\norg/jetbrains/kotlin/idea/actions/internal/CheckComponentsUsageSearchAction\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n*L\n1#1,123:1\n479#2:124\n81#3:125\n*S KotlinDebug\n*F\n+ 1 CheckComponentsUsageSearchAction.kt\norg/jetbrains/kotlin/idea/actions/internal/CheckComponentsUsageSearchAction\n*L\n44#1:124\n108#1:125\n*E\n"})
public final class CheckComponentsUsageSearchAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return;
        }
        Project project2 = project;
        List selectedKotlinFiles = SequencesKt.toList(this.selectedKotlinFiles(e));
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> CheckComponentsUsageSearchAction.actionPerformed$lambda$0(this, selectedKotlinFiles, project2), KotlinBundle.message((String)"checking.data.classes", (Object[])new Object[0]), true, project2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void process(Collection<? extends KtFile> files, Project project) {
        void $this$filterIsInstance$iv;
        Sequence sequence = SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)files), CheckComponentsUsageSearchAction::process$lambda$0);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)process$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        List dataClasses = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)sequence2, CheckComponentsUsageSearchAction::process$lambda$1));
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        Iterator iterator2 = ((Iterable)dataClasses).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            KtParameter parameter;
            Object object;
            Object object2;
            int i2 = n++;
            KtClass dataClass = (KtClass)iterator2.next();
            ProgressIndicator progressIndicator2 = progressIndicator;
            if (progressIndicator2 != null) {
                Object[] objectArray = new Object[]{i2 + 1, dataClasses.size()};
                progressIndicator2.setText(KotlinBundle.message((String)"checking.data.class.0.of.1", (Object[])objectArray));
            }
            if ((object2 = dataClass.getFqName()) == null || (object2 = object2.asString()) == null) {
                object2 = "";
            }
            Object fqName2 = object2;
            ProgressIndicator progressIndicator3 = progressIndicator;
            if (progressIndicator3 != null) {
                progressIndicator3.setText2((String)fqName2);
            }
            KtParameter ktParameter = (object = dataClass.getPrimaryConstructor()) != null && (object = object.getValueParameters()) != null ? (KtParameter)CollectionsKt.firstOrNull((List)object) : (parameter = null);
            if (parameter != null) {
                try {
                    Ref.IntRef smartRefsCount = new Ref.IntRef();
                    Ref.IntRef goldRefsCount = new Ref.IntRef();
                    ProgressManager.getInstance().runProcess(() -> CheckComponentsUsageSearchAction.process$lambda$2(smartRefsCount, parameter, goldRefsCount), (ProgressIndicator)new EmptyProgressIndicator());
                    if (smartRefsCount.element != goldRefsCount.element) {
                        SwingUtilities.invokeLater(() -> CheckComponentsUsageSearchAction.process$lambda$3(project, dataClass, smartRefsCount, goldRefsCount));
                        return;
                    }
                }
                finally {
                    ExpressionsOfTypeProcessor.Companion.setMode(ExpressionsOfTypeProcessor.Mode.PLAIN_WHEN_NEEDED);
                }
            }
            ProgressIndicator progressIndicator4 = progressIndicator;
            if (progressIndicator4 == null) continue;
            progressIndicator4.setFraction((double)(i2 + 1) / (double)dataClasses.size());
        }
        SwingUtilities.invokeLater(() -> CheckComponentsUsageSearchAction.process$lambda$4(project, dataClasses));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        boolean $i$f$isApplicationInternalMode = false;
        e.getPresentation().setEnabledAndVisible(ApplicationManager.getApplication().isInternal());
    }

    private final Sequence<KtFile> selectedKotlinFiles(AnActionEvent e) {
        VirtualFile[] virtualFileArray = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (virtualFileArray == null) {
            return SequencesKt.emptySequence();
        }
        VirtualFile[] virtualFiles = virtualFileArray;
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return SequencesKt.emptySequence();
        }
        Project project2 = project;
        return this.allKotlinFiles(virtualFiles, project2);
    }

    private final Sequence<KtFile> allKotlinFiles(VirtualFile[] filesOrDirs, Project project) {
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        PsiManager manager = psiManager;
        return SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)FileUtils.getAllFilesRecursively(filesOrDirs)), arg_0 -> CheckComponentsUsageSearchAction.allKotlinFiles$lambda$0(manager, arg_0));
    }

    private static final Unit actionPerformed$lambda$0$0(CheckComponentsUsageSearchAction this$0, List $selectedKotlinFiles, Project $project) {
        this$0.process($selectedKotlinFiles, $project);
        return Unit.INSTANCE;
    }

    private static final void actionPerformed$lambda$0(CheckComponentsUsageSearchAction this$0, List $selectedKotlinFiles, Project $project) {
        ActionsKt.runReadAction(() -> CheckComponentsUsageSearchAction.actionPerformed$lambda$0$0(this$0, $selectedKotlinFiles, $project));
    }

    private static final Sequence process$lambda$0(KtFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return CollectionsKt.asSequence((Iterable)it.getDeclarations());
    }

    private static final boolean process$lambda$1(KtClass it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isData();
    }

    private static final void process$lambda$2(Ref.IntRef $smartRefsCount, KtParameter $parameter, Ref.IntRef $goldRefsCount) {
        ExpressionsOfTypeProcessor.Companion.setMode(ExpressionsOfTypeProcessor.Mode.ALWAYS_SMART);
        $smartRefsCount.element = ReferencesSearch.search((PsiElement)((PsiElement)$parameter)).findAll().size();
        ExpressionsOfTypeProcessor.Companion.setMode(ExpressionsOfTypeProcessor.Mode.ALWAYS_PLAIN);
        $goldRefsCount.element = ReferencesSearch.search((PsiElement)((PsiElement)$parameter)).findAll().size();
    }

    private static final void process$lambda$3(Project $project, KtClass $dataClass, Ref.IntRef $smartRefsCount, Ref.IntRef $goldRefsCount) {
        Object[] objectArray = new Object[3];
        FqName fqName2 = $dataClass.getFqName();
        objectArray[0] = String.valueOf(fqName2 != null ? fqName2.asString() : null);
        objectArray[1] = $smartRefsCount.element;
        objectArray[2] = $goldRefsCount.element;
        Messages.showInfoMessage((Project)$project, (String)KotlinBundle.message((String)"difference.found.for.data.class.0.found.1.2", (Object[])objectArray), (String)KotlinBundle.message((String)"title.error", (Object[])new Object[0]));
    }

    private static final void process$lambda$4(Project $project, List $dataClasses) {
        Object[] objectArray = new Object[]{$dataClasses.size()};
        Messages.showInfoMessage((Project)$project, (String)KotlinBundle.message((String)"analyzed.0.classes.no.difference.found", (Object[])objectArray), (String)KotlinBundle.message((String)"title.success", (Object[])new Object[0]));
    }

    private static final KtFile allKotlinFiles$lambda$0(PsiManager $manager, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        PsiFile psiFile = $manager.findFile(it);
        return psiFile instanceof KtFile ? (KtFile)psiFile : null;
    }
}

