/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.actions.internal.refactoringTesting.cases;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.actions.internal.refactoringTesting.RandomMoveRefactoringResult;
import org.jetbrains.kotlin.idea.actions.internal.refactoringTesting.RefactoringCase;
import org.jetbrains.kotlin.idea.actions.internal.refactoringTesting.cases.FailedToRunCaseException;
import org.jetbrains.kotlin.idea.actions.internal.refactoringTesting.cases.MoveKotlinDeclarationsHandlerTestActions;
import org.jetbrains.kotlin.idea.actions.internal.refactoringTesting.cases.RandomUtilsKt;
import org.jetbrains.kotlin.idea.actions.internal.refactoringTesting.cases.TestDataKeeper;
import org.jetbrains.kotlin.idea.core.util.PhysicalFileSystemUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.move.MoveConflictsFoundException;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveKotlinDeclarationsHandler;
import org.jetbrains.kotlin.psi.KtClass;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/actions/internal/refactoringTesting/cases/MoveRefactoringCase;", "Lorg/jetbrains/kotlin/idea/actions/internal/refactoringTesting/RefactoringCase;", "<init>", "()V", "tryCreateAndRun", "Lorg/jetbrains/kotlin/idea/actions/internal/refactoringTesting/RandomMoveRefactoringResult;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.idea"})
public final class MoveRefactoringCase
implements RefactoringCase {
    @Override
    @NotNull
    public RandomMoveRefactoringResult tryCreateAndRun(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        List<VirtualFile> projectFiles = RandomUtilsKt.files(project);
        if (projectFiles.isEmpty()) {
        }
        PsiElement targetClass = null;
        KtClass ktClass = MoveRefactoringCase.tryCreateAndRun$getRandomKotlinClassOrNull(projectFiles, project);
        if (ktClass == null) {
            return RandomMoveRefactoringResult.Failed;
        }
        TestDataKeeper testDataKeeper = new TestDataKeeper("no data");
        MoveKotlinDeclarationsHandler handler2 = new MoveKotlinDeclarationsHandler(new MoveKotlinDeclarationsHandlerTestActions(testDataKeeper));
        KtClass sourceClass = ktClass;
        KtClass[] ktClassArray = new KtClass[]{sourceClass};
        KtClass[] sourceClassAsArray = ktClassArray;
        if (!handler2.canMove((PsiElement[])sourceClassAsArray, targetClass, null)) {
            return RandomMoveRefactoringResult.Failed;
        }
        try {
            handler2.doMove(project, (PsiElement[])sourceClassAsArray, targetClass, null);
        }
        catch (Throwable e) {
            RandomMoveRefactoringResult randomMoveRefactoringResult;
            Throwable throwable = e;
            if (throwable instanceof NotImplementedError || throwable instanceof FailedToRunCaseException || throwable instanceof MoveConflictsFoundException || throwable instanceof ConfigurationException) {
                randomMoveRefactoringResult = RandomMoveRefactoringResult.Failed;
            } else {
                String string = testDataKeeper.getCaseData();
                String string2 = e.getClass().getTypeName();
                String string3 = e.getMessage();
                if (string3 == null) {
                    string3 = "No message";
                }
                randomMoveRefactoringResult = new RandomMoveRefactoringResult.ExceptionCaused(string, string2 + ": " + string3);
            }
            return randomMoveRefactoringResult;
        }
        return new RandomMoveRefactoringResult.Success(testDataKeeper.getCaseData());
    }

    private static final KtClass tryCreateAndRun$getRandomKotlinClassOrNull(List<? extends VirtualFile> projectFiles, Project $project) {
        Class[] classArray = new Class[]{KtClass.class};
        Collection collection = PsiTreeUtil.collectElementsOfType((PsiElement)((PsiElement)PhysicalFileSystemUtilsKt.toPsiFile((VirtualFile)CollectionsKt.random((Collection)projectFiles, (Random)((Random)Random.Default)), $project)), (Class[])classArray);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"collectElementsOfType(...)");
        Collection classes = collection;
        if (!classes.isEmpty()) {
            return (KtClass)CollectionsKt.random((Collection)classes, (Random)((Random)Random.Default));
        }
        return null;
    }
}

