/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.actions.internal.resolutionDebugging;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.components.JBTextArea;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import java.awt.Rectangle;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.actions.internal.resolutionDebugging.DebugTypeResolutionActionKt;
import org.jetbrains.kotlin.idea.actions.internal.resolutionDebugging.ReportContext;
import org.jetbrains.kotlin.idea.actions.internal.resolutionDebugging.TypeMismatchDebugReport;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J4\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\nH\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/actions/internal/resolutionDebugging/DebugTypeResolutionAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "somethingWentWrong", "message", "", "psiFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "caret", "Lcom/intellij/openapi/editor/Caret;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "buildAndShowReport", "expected", "Lorg/jetbrains/kotlin/types/KotlinType;", "actual", "showReportWindow", "content", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nDebugTypeResolutionAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebugTypeResolutionAction.kt\norg/jetbrains/kotlin/idea/actions/internal/resolutionDebugging/DebugTypeResolutionAction\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,117:1\n253#2:118\n1#3:119\n*S KotlinDebug\n*F\n+ 1 DebugTypeResolutionAction.kt\norg/jetbrains/kotlin/idea/actions/internal/resolutionDebugging/DebugTypeResolutionAction\n*L\n33#1:118\n*E\n"})
public final class DebugTypeResolutionAction
extends AnAction {
    public DebugTypeResolutionAction() {
        super("Debug Resolution of Type at Caret");
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        KotlinType kotlinType;
        KotlinTypeInfo actualType;
        PsiElement expression;
        Caret caret;
        KtFile psiFile;
        block9: {
            PsiElement psiElement;
            block11: {
                block10: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (!ApplicationManager.getApplication().isInternal()) {
                        return;
                    }
                    Object object = e.getData(CommonDataKeys.PSI_FILE);
                    KtFile ktFile2 = object instanceof KtFile ? (KtFile)object : null;
                    if (ktFile2 == null) {
                        DebugTypeResolutionAction.somethingWentWrong$default(this, "Can't get a KtFile at current location. Are you in .kt-file?", null, null, null, 14, null);
                        return;
                    }
                    psiFile = ktFile2;
                    Caret caret2 = (Caret)e.getData(CommonDataKeys.CARET);
                    if (caret2 == null) {
                        DebugTypeResolutionAction.somethingWentWrong$default(this, "Can't get a position of caret in file", psiFile, null, null, 12, null);
                        return;
                    }
                    caret = caret2;
                    psiElement = psiFile.findElementAt(caret.getOffset());
                    if (psiElement == null) break block10;
                    PsiElement $this$getNonStrictParentOfType$iv = psiElement;
                    boolean $i$f$getNonStrictParentOfType = false;
                    psiElement = (KtNameReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtNameReferenceExpression.class, (boolean)false);
                    if (psiElement != null) break block11;
                }
                DebugTypeResolutionAction.somethingWentWrong$default(this, "Can't find a KtExpression at the caret. Check that the caret is at an expression", psiFile, caret, null, 8, null);
                return;
            }
            expression = psiElement;
            BindingContext bindingContext = ResolutionUtils.analyzeWithAllCompilerChecks(psiFile, new KtFile[0]).getBindingContext();
            KotlinTypeInfo kotlinTypeInfo = (KotlinTypeInfo)bindingContext.get((ReadOnlySlice)BindingContext.EXPRESSION_TYPE_INFO, (Object)expression);
            if (kotlinTypeInfo == null || (kotlinTypeInfo = kotlinTypeInfo.getType()) == null) {
                this.somethingWentWrong("Couldn't get a type from EXPRESSION_TYPE_INFO slice of BindingContext", psiFile, caret, (KtExpression)expression);
                return;
            }
            actualType = kotlinTypeInfo;
            for (PsiElement it : PsiUtilsKt.getParentsWithSelf((PsiElement)expression)) {
                boolean bl = false;
                KotlinType kotlinType2 = it instanceof KtExpression ? (KotlinType)bindingContext.get((ReadOnlySlice)BindingContext.EXPECTED_EXPRESSION_TYPE, (Object)it) : null;
                if (kotlinType2 == null) continue;
                kotlinType = kotlinType2;
                break block9;
            }
            kotlinType = null;
        }
        if (kotlinType == null) {
            this.somethingWentWrong("Couldn't get a type from the EXPECTED_EXPRESSION_TYPE slice of BindingContext", psiFile, caret, (KtExpression)expression);
            return;
        }
        KotlinType expectedType = kotlinType;
        this.buildAndShowReport(expectedType, (KotlinType)actualType);
    }

    private final void somethingWentWrong(String message2, KtFile psiFile, Caret caret, KtExpression expression) {
        KtExpression ktExpression = expression;
        this.showReportWindow(StringsKt.trimIndent((String)("\n            Something went wrong!\n            \n            " + message2 + "\n            \n            Context:\n            psiFile=" + psiFile + "\n            caret=" + caret + "\n            expression=" + (ktExpression != null ? ktExpression.getText() : null) + "\n        ")));
    }

    static /* synthetic */ void somethingWentWrong$default(DebugTypeResolutionAction debugTypeResolutionAction, String string, KtFile ktFile2, Caret caret, KtExpression ktExpression, int n, Object object) {
        if ((n & 2) != 0) {
            ktFile2 = null;
        }
        if ((n & 4) != 0) {
            caret = null;
        }
        if ((n & 8) != 0) {
            ktExpression = null;
        }
        debugTypeResolutionAction.somethingWentWrong(string, ktFile2, caret, ktExpression);
    }

    private final void buildAndShowReport(KotlinType expected, KotlinType actual) {
        TypeMismatchDebugReport report;
        ReportContext ctx = new ReportContext();
        TypeMismatchDebugReport $this$buildAndShowReport_u24lambda_u240 = report = DebugTypeResolutionActionKt.TypeMismatchDebugReport(ctx, expected, actual);
        boolean bl = false;
        String reportRendered = $this$buildAndShowReport_u24lambda_u240.render(ctx);
        this.showReportWindow(reportRendered);
    }

    private final void showReportWindow(String content) {
        Rectangle rectangle = ScreenUtil.getMainScreenBounds();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getMainScreenBounds(...)");
        Rectangle screenBounds = rectangle;
        int width = (int)((double)screenBounds.width * 0.8);
        int height = (int)((double)screenBounds.height * 0.8);
        DialogPanel window = (DialogPanel)BuilderKt.panel(arg_0 -> DebugTypeResolutionAction.showReportWindow$lambda$0(content, arg_0)).withPreferredSize(width, height);
        Intrinsics.checkNotNull((Object)window);
        ComponentsKt.dialog$default((String)"Debug Mismatch", (JComponent)((JComponent)window), (boolean)false, null, (boolean)false, null, null, null, null, null, null, (int)2044, null).showAndGet();
    }

    private static final Unit showReportWindow$lambda$0$0$0(String $content, JBTextArea $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setText($content);
        return Unit.INSTANCE;
    }

    private static final Unit showReportWindow$lambda$0$0(String $content, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.textArea().align(Align.FILL).applyToComponent(arg_0 -> DebugTypeResolutionAction.showReportWindow$lambda$0$0$0($content, arg_0)).resizableColumn();
        return Unit.INSTANCE;
    }

    private static final Unit showReportWindow$lambda$0(String $content, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> DebugTypeResolutionAction.showReportWindow$lambda$0$0($content, arg_0), (int)1, null).resizableRow();
        return Unit.INSTANCE;
    }
}

