/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.analysis.api.utils;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.components.KaReferenceShortenerKt;
import org.jetbrains.kotlin.analysis.api.components.QualifierToShortenInfo;
import org.jetbrains.kotlin.analysis.api.components.ShortenCommand;
import org.jetbrains.kotlin.analysis.api.components.ShortenOptions;
import org.jetbrains.kotlin.analysis.api.components.ShortenStrategy;
import org.jetbrains.kotlin.analysis.api.components.ThisLabelToShortenInfo;
import org.jetbrains.kotlin.analysis.api.components.TypeToShortenInfo;
import org.jetbrains.kotlin.analysis.api.permissions.KaAnalysisPermissionRegistry;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassLikeSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaConstructorSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaEnumEntrySymbol;
import org.jetbrains.kotlin.idea.base.psi.imports.ImportInsertionKt;
import org.jetbrains.kotlin.idea.core.formatter.KotlinCodeStyleSettings;
import org.jetbrains.kotlin.idea.formatter.CodeStyleUtilsKt;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocName;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000j\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001aF\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00012\b\b\u0002\u0010\u0003\u001a\u00020\u00042\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b0\u0006\u001aM\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0002\u001a\u00020\u00012\b\b\u0002\u0010\u0003\u001a\u00020\u00042\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b0\u0006H\u0007\u00a2\u0006\u0002\b\u0000\u001aJ\u0010\u0000\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00010\u000f2\b\b\u0002\u0010\u0003\u001a\u00020\u00042\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b0\u0006\u001aZ\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0003\u001a\u00020\u00042\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b0\u0006\u001aW\u0010\u0017\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0003\u001a\u00020\u00042\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b0\u0006H\u0007\u00a2\u0006\u0002\b\u0010\u001a\u0016\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00120\u0011*\u00020\u0019\u001a\f\u0010\u001a\u001a\u00020\r*\u00020\u001bH\u0002\u001aM\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u0002H\u001e0\u0006\"\u0004\b\u0000\u0010\u001d\"\u0004\b\u0001\u0010\u001f\"\u0004\b\u0002\u0010\u001e*\u000e\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u0002H\u001f0\u00062\u0014\b\u0004\u0010 \u001a\u000e\u0012\u0004\u0012\u0002H\u001f\u0012\u0004\u0012\u0002H\u001e0\u0006H\u0082\f\u001aa\u0010!\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0003\u001a\u00020\u00042\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b0\u0006H\u0007R\u00020\"j\u0006\u0010#\u001a\u00020\"\u00a2\u0006\u0002\u0010$\u001a\"\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006*\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u0007\u001a\"\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b0\u0006*\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u0007\u00a8\u0006)"}, d2={"shortenReferences", "Lorg/jetbrains/kotlin/psi/KtElement;", "element", "shortenOptions", "Lorg/jetbrains/kotlin/analysis/api/components/ShortenOptions;", "classShortenStrategy", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaClassLikeSymbol;", "Lorg/jetbrains/kotlin/analysis/api/components/ShortenStrategy;", "callableShortenStrategy", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaCallableSymbol;", "deprecatedShortenReferences", "Lcom/intellij/psi/PsiElement;", "", "elements", "", "shortenReferencesInRange", "", "Lcom/intellij/psi/SmartPsiElementPointer;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "selection", "Lcom/intellij/openapi/util/TextRange;", "deprecatedShortenReferencesInRange", "invokeShortening", "Lorg/jetbrains/kotlin/analysis/api/components/ShortenCommand;", "deleteQualifier", "Lorg/jetbrains/kotlin/kdoc/psi/impl/KDocName;", "andThen", "A", "C", "B", "function", "collectPossibleReferenceShorteningsForIde", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "<unused var>", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtFile;Lcom/intellij/openapi/util/TextRange;Lorg/jetbrains/kotlin/analysis/api/components/ShortenOptions;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/kotlin/analysis/api/components/ShortenCommand;", "defaultClassShortenStrategyForIde", "Lorg/jetbrains/kotlin/analysis/api/components/ShortenStrategy$Companion;", "context", "defaultCallableShortenStrategyForIde", "intellij.kotlin.base.analysis.utils"})
@SourceDebugExtension(value={"SMAP\nshortenUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 shortenUtils.kt\norg/jetbrains/kotlin/idea/base/analysis/api/utils/ShortenUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 analyzeUtils.kt\norg/jetbrains/kotlin/idea/base/analysis/api/utils/AnalyzeUtilsKt\n+ 5 permissions.kt\norg/jetbrains/kotlin/analysis/api/permissions/PermissionsKt\n+ 6 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 7 KaSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KaSessionProvider\n+ 8 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,303:1\n216#1:355\n216#1:356\n1#2:304\n1586#3:305\n1661#3,3:306\n47#4:309\n48#4:312\n49#4:315\n50#4:327\n51#4:332\n52#4:338\n53#4:351\n41#5,2:310\n102#5,2:313\n105#5,5:333\n44#5,3:339\n102#5,8:342\n48#5:350\n30#6,2:316\n36#7,9:318\n49#7,2:328\n46#7,2:330\n1342#8,2:352\n1342#8:354\n1343#8:357\n*S KotlinDebug\n*F\n+ 1 shortenUtils.kt\norg/jetbrains/kotlin/idea/base/analysis/api/utils/ShortenUtilsKt\n*L\n99#1:355\n100#1:356\n88#1:305\n88#1:306,3\n128#1:309\n128#1:312\n128#1:315\n128#1:327\n128#1:332\n128#1:338\n128#1:351\n128#1:310,2\n128#1:313,2\n128#1:333,5\n128#1:339,3\n128#1:342,8\n128#1:350\n128#1:316,2\n128#1:318,9\n128#1:328,2\n128#1:330,2\n211#1:352,2\n95#1:354\n95#1:357\n*E\n"})
public final class ShortenUtilsKt {
    @Nullable
    public static final KtElement shortenReferences(@NotNull KtElement element, @NotNull ShortenOptions shortenOptions, @NotNull Function1<? super KaClassLikeSymbol, ? extends ShortenStrategy> classShortenStrategy, @NotNull Function1<? super KaCallableSymbol, ? extends ShortenStrategy> callableShortenStrategy) {
        KtElement ktElement;
        block1: {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)shortenOptions, (String)"shortenOptions");
            Intrinsics.checkNotNullParameter(classShortenStrategy, (String)"classShortenStrategy");
            Intrinsics.checkNotNullParameter(callableShortenStrategy, (String)"callableShortenStrategy");
            KtFile ktFile2 = element.getContainingKtFile();
            Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"getContainingKtFile(...)");
            TextRange textRange = element.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            for (SmartPsiElementPointer it : (Iterable)ShortenUtilsKt.shortenReferencesInRange(ktFile2, textRange, shortenOptions, classShortenStrategy, callableShortenStrategy)) {
                boolean bl = false;
                KtElement ktElement2 = (KtElement)it.getElement();
                if (ktElement2 == null) continue;
                ktElement = ktElement2;
                break block1;
            }
            ktElement = null;
        }
        return ktElement;
    }

    public static /* synthetic */ KtElement shortenReferences$default(KtElement ktElement, ShortenOptions shortenOptions, Function1 function1, Function1 function12, int n, Object object) {
        if ((n & 2) != 0) {
            shortenOptions = ShortenOptions.Companion.getDEFAULT();
        }
        if ((n & 4) != 0) {
            function1 = ShortenUtilsKt.defaultClassShortenStrategyForIde(ShortenStrategy.Companion, ktElement);
        }
        if ((n & 8) != 0) {
            function12 = ShortenUtilsKt.defaultCallableShortenStrategyForIde(ShortenStrategy.Companion, ktElement);
        }
        return ShortenUtilsKt.shortenReferences(ktElement, shortenOptions, function1, function12);
    }

    @Deprecated(message="Use shortenReferences instead", replaceWith=@ReplaceWith(expression="shortenReferences(element, shortenOptions, classShortenStrategy, callableShortenStrategy)", imports={}), level=DeprecationLevel.HIDDEN)
    @JvmName(name="shortenReferences")
    public static final /* synthetic */ PsiElement shortenReferences(KtElement element, ShortenOptions shortenOptions, Function1 classShortenStrategy, Function1 callableShortenStrategy) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)shortenOptions, (String)"shortenOptions");
        Intrinsics.checkNotNullParameter((Object)classShortenStrategy, (String)"classShortenStrategy");
        Intrinsics.checkNotNullParameter((Object)callableShortenStrategy, (String)"callableShortenStrategy");
        return (PsiElement)ShortenUtilsKt.shortenReferences(element, shortenOptions, (Function1<? super KaClassLikeSymbol, ? extends ShortenStrategy>)classShortenStrategy, (Function1<? super KaCallableSymbol, ? extends ShortenStrategy>)callableShortenStrategy);
    }

    public static /* synthetic */ PsiElement shortenReferences$default(KtElement ktElement, ShortenOptions shortenOptions, Function1 function1, Function1 function12, int n, Object object) {
        if ((n & 2) != 0) {
            shortenOptions = ShortenOptions.Companion.getDEFAULT();
        }
        if ((n & 4) != 0) {
            function1 = ShortenStrategy.Companion.getDefaultClassShortenStrategy();
        }
        if ((n & 8) != 0) {
            function12 = ShortenStrategy.Companion.getDefaultCallableShortenStrategy();
        }
        return ShortenUtilsKt.shortenReferences(ktElement, shortenOptions, function1, function12);
    }

    /*
     * WARNING - void declaration
     */
    public static final void shortenReferences(@NotNull Iterable<? extends KtElement> elements, @NotNull ShortenOptions shortenOptions, @NotNull Function1<? super KaClassLikeSymbol, ? extends ShortenStrategy> classShortenStrategy, @NotNull Function1<? super KaCallableSymbol, ? extends ShortenStrategy> callableShortenStrategy) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter((Object)shortenOptions, (String)"shortenOptions");
        Intrinsics.checkNotNullParameter(classShortenStrategy, (String)"classShortenStrategy");
        Intrinsics.checkNotNullParameter(callableShortenStrategy, (String)"callableShortenStrategy");
        Iterable<? extends KtElement> $this$map$iv = elements;
        boolean $i$f$map = false;
        Iterable<? extends KtElement> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KtElement ktElement = (KtElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)it)));
        }
        List elementPointers = (List)destination$iv$iv;
        ShortenUtilsKt.shortenReferences$shortenReferences(elementPointers, shortenOptions, classShortenStrategy, callableShortenStrategy, (Function1<? super ShortenStrategy, ? extends ShortenStrategy>)((Function1)ShortenUtilsKt::shortenReferences$lambda$4));
        ShortenUtilsKt.shortenReferences$shortenReferences(elementPointers, shortenOptions, classShortenStrategy, callableShortenStrategy, (Function1<? super ShortenStrategy, ? extends ShortenStrategy>)((Function1)ShortenUtilsKt::shortenReferences$lambda$5));
    }

    public static /* synthetic */ void shortenReferences$default(Iterable iterable, ShortenOptions shortenOptions, Function1 function1, Function1 function12, int n, Object object) {
        if ((n & 2) != 0) {
            shortenOptions = ShortenOptions.Companion.getDEFAULT();
        }
        if ((n & 4) != 0) {
            function1 = ShortenUtilsKt.defaultClassShortenStrategyForIde(ShortenStrategy.Companion, (KtElement)CollectionsKt.firstOrNull((Iterable)iterable));
        }
        if ((n & 8) != 0) {
            function12 = ShortenUtilsKt.defaultCallableShortenStrategyForIde(ShortenStrategy.Companion, (KtElement)CollectionsKt.firstOrNull((Iterable)iterable));
        }
        ShortenUtilsKt.shortenReferences(iterable, shortenOptions, function1, (Function1<? super KaCallableSymbol, ? extends ShortenStrategy>)function12);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static final List<SmartPsiElementPointer<KtElement>> shortenReferencesInRange(@NotNull KtFile file, @NotNull TextRange selection, @NotNull ShortenOptions shortenOptions, @NotNull Function1<? super KaClassLikeSymbol, ? extends ShortenStrategy> classShortenStrategy, @NotNull Function1<? super KaCallableSymbol, ? extends ShortenStrategy> callableShortenStrategy) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        Intrinsics.checkNotNullParameter((Object)shortenOptions, (String)"shortenOptions");
        Intrinsics.checkNotNullParameter(classShortenStrategy, (String)"classShortenStrategy");
        Intrinsics.checkNotNullParameter(callableShortenStrategy, (String)"callableShortenStrategy");
        KtElement useSiteElement$iv = (KtElement)file;
        boolean $i$f$allowAnalysisFromWriteActionInEdt = false;
        boolean $i$f$allowAnalysisOnEdt = false;
        KaAnalysisPermissionRegistry permissionRegistry$iv$iv = KaAnalysisPermissionRegistry.Companion.getInstance();
        if (permissionRegistry$iv$iv.isAnalysisAllowedOnEdt()) {
            boolean bl = false;
            boolean $i$f$allowAnalysisFromWriteAction = false;
            KaAnalysisPermissionRegistry permissionRegistry$iv$iv2 = KaAnalysisPermissionRegistry.Companion.getInstance();
            if (permissionRegistry$iv$iv2.isAnalysisAllowedInWriteAction()) {
                Object lock$iv$iv$iv;
                void this_$iv$iv$iv;
                boolean bl2 = false;
                KtElement useSiteElement$iv$iv = useSiteElement$iv;
                boolean $i$f$analyze = false;
                Project project = useSiteElement$iv$iv.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project);
                KtElement useSiteElement$iv$iv$iv = useSiteElement$iv$iv;
                boolean $i$f$analyze2 = false;
                KaSession analysisSession$iv$iv$iv = this_$iv$iv$iv.getAnalysisSession(useSiteElement$iv$iv$iv);
                this_$iv$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv$iv, useSiteElement$iv$iv$iv);
                try {
                    ShortenCommand $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv$iv22;
                    Object object2 = lock$iv$iv$iv = new Object();
                    synchronized (object2) {
                        boolean $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv$iv22 = false;
                        KaSession $this$allowAnalysisFromWriteActionInEdt_u24lambda_u240_u240_u240$iv = analysisSession$iv$iv$iv;
                        boolean bl3 = false;
                        KtFile ktFile2 = (KtFile)useSiteElement$iv;
                        KaSession $this$shortenReferencesInRange_u24lambda_u240 = $this$allowAnalysisFromWriteActionInEdt_u24lambda_u240_u240_u240$iv;
                        boolean bl4 = false;
                        $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv$iv22 = ShortenUtilsKt.collectPossibleReferenceShorteningsForIde($this$shortenReferencesInRange_u24lambda_u240, file, selection, shortenOptions, classShortenStrategy, callableShortenStrategy);
                    }
                    lock$iv$iv$iv = $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv$iv22;
                }
                catch (Throwable throwable$iv$iv$iv) {
                    this_$iv$iv$iv.handleAnalysisException(throwable$iv$iv$iv, analysisSession$iv$iv$iv, useSiteElement$iv$iv$iv);
                    throw new KotlinNothingValueException();
                }
                finally {
                    this_$iv$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv$iv, useSiteElement$iv$iv$iv);
                }
                object = lock$iv$iv$iv;
                return ShortenUtilsKt.invokeShortening((ShortenCommand)object);
            }
            permissionRegistry$iv$iv2.setAnalysisAllowedInWriteAction(true);
            try {
                Object lock$iv$iv$iv;
                boolean bl5 = false;
                KtElement useSiteElement$iv$iv = useSiteElement$iv;
                boolean $i$f$analyze = false;
                Project project = useSiteElement$iv$iv.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                KaSessionProvider this_$iv$iv$iv = KaSessionProvider.Companion.getInstance(project);
                KtElement useSiteElement$iv$iv$iv = useSiteElement$iv$iv;
                boolean $i$f$analyze3 = false;
                KaSession analysisSession$iv$iv$iv = this_$iv$iv$iv.getAnalysisSession(useSiteElement$iv$iv$iv);
                this_$iv$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv$iv, useSiteElement$iv$iv$iv);
                try {
                    ShortenCommand $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv$iv32;
                    Object throwable$iv$iv$iv = lock$iv$iv$iv = new Object();
                    synchronized (throwable$iv$iv$iv) {
                        boolean $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv$iv32 = false;
                        KaSession $this$allowAnalysisFromWriteActionInEdt_u24lambda_u240_u240_u240$iv = analysisSession$iv$iv$iv;
                        boolean bl6 = false;
                        KtFile it = (KtFile)useSiteElement$iv;
                        KaSession $this$shortenReferencesInRange_u24lambda_u240 = $this$allowAnalysisFromWriteActionInEdt_u24lambda_u240_u240_u240$iv;
                        boolean bl7 = false;
                        $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv$iv32 = ShortenUtilsKt.collectPossibleReferenceShorteningsForIde($this$shortenReferencesInRange_u24lambda_u240, file, selection, shortenOptions, classShortenStrategy, callableShortenStrategy);
                    }
                    lock$iv$iv$iv = $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv$iv32;
                }
                catch (Throwable throwable$iv$iv$iv) {
                    this_$iv$iv$iv.handleAnalysisException(throwable$iv$iv$iv, analysisSession$iv$iv$iv, useSiteElement$iv$iv$iv);
                    throw new KotlinNothingValueException();
                }
                finally {
                    this_$iv$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv$iv, useSiteElement$iv$iv$iv);
                }
                Object object3 = lock$iv$iv$iv;
                object = object3;
                return ShortenUtilsKt.invokeShortening((ShortenCommand)object);
            }
            finally {
                permissionRegistry$iv$iv2.setAnalysisAllowedInWriteAction(false);
            }
        }
        permissionRegistry$iv$iv.setAnalysisAllowedOnEdt(true);
        try {
            Object object4;
            boolean bl = false;
            boolean $i$f$allowAnalysisFromWriteAction = false;
            KaAnalysisPermissionRegistry permissionRegistry$iv$iv3 = KaAnalysisPermissionRegistry.Companion.getInstance();
            if (permissionRegistry$iv$iv3.isAnalysisAllowedInWriteAction()) {
                Object lock$iv$iv$iv;
                boolean bl8 = false;
                KtElement useSiteElement$iv$iv = useSiteElement$iv;
                boolean $i$f$analyze = false;
                Project project = useSiteElement$iv$iv.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                KaSessionProvider this_$iv$iv$iv = KaSessionProvider.Companion.getInstance(project);
                KtElement useSiteElement$iv$iv$iv = useSiteElement$iv$iv;
                boolean $i$f$analyze4 = false;
                KaSession analysisSession$iv$iv$iv = this_$iv$iv$iv.getAnalysisSession(useSiteElement$iv$iv$iv);
                this_$iv$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv$iv, useSiteElement$iv$iv$iv);
                try {
                    ShortenCommand $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv$iv42;
                    Object throwable$iv$iv$iv = lock$iv$iv$iv = new Object();
                    synchronized (throwable$iv$iv$iv) {
                        boolean $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv$iv42 = false;
                        KaSession $this$allowAnalysisFromWriteActionInEdt_u24lambda_u240_u240_u240$iv = analysisSession$iv$iv$iv;
                        boolean bl9 = false;
                        KtFile it = (KtFile)useSiteElement$iv;
                        KaSession $this$shortenReferencesInRange_u24lambda_u240 = $this$allowAnalysisFromWriteActionInEdt_u24lambda_u240_u240_u240$iv;
                        boolean bl10 = false;
                        $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv$iv42 = ShortenUtilsKt.collectPossibleReferenceShorteningsForIde($this$shortenReferencesInRange_u24lambda_u240, file, selection, shortenOptions, classShortenStrategy, callableShortenStrategy);
                    }
                    lock$iv$iv$iv = $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv$iv42;
                }
                catch (Throwable throwable$iv$iv$iv) {
                    this_$iv$iv$iv.handleAnalysisException(throwable$iv$iv$iv, analysisSession$iv$iv$iv, useSiteElement$iv$iv$iv);
                    throw new KotlinNothingValueException();
                }
                finally {
                    this_$iv$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv$iv, useSiteElement$iv$iv$iv);
                }
                object4 = lock$iv$iv$iv;
            } else {
                permissionRegistry$iv$iv3.setAnalysisAllowedInWriteAction(true);
                try {
                    ShortenCommand shortenCommand;
                    boolean bl11 = false;
                    KtElement useSiteElement$iv$iv = useSiteElement$iv;
                    boolean $i$f$analyze = false;
                    Project project = useSiteElement$iv$iv.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    KaSessionProvider this_$iv$iv$iv = KaSessionProvider.Companion.getInstance(project);
                    KtElement useSiteElement$iv$iv$iv = useSiteElement$iv$iv;
                    boolean $i$f$analyze5 = false;
                    KaSession analysisSession$iv$iv$iv = this_$iv$iv$iv.getAnalysisSession(useSiteElement$iv$iv$iv);
                    this_$iv$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv$iv, useSiteElement$iv$iv$iv);
                    try {
                        ShortenCommand shortenCommand2;
                        Object lock$iv$iv$iv;
                        Object throwable$iv$iv$iv = lock$iv$iv$iv = new Object();
                        synchronized (throwable$iv$iv$iv) {
                            boolean bl12 = false;
                            KaSession $this$allowAnalysisFromWriteActionInEdt_u24lambda_u240_u240_u240$iv = analysisSession$iv$iv$iv;
                            boolean bl13 = false;
                            KtFile it = (KtFile)useSiteElement$iv;
                            KaSession $this$shortenReferencesInRange_u24lambda_u240 = $this$allowAnalysisFromWriteActionInEdt_u24lambda_u240_u240_u240$iv;
                            boolean bl14 = false;
                            shortenCommand2 = ShortenUtilsKt.collectPossibleReferenceShorteningsForIde($this$shortenReferencesInRange_u24lambda_u240, file, selection, shortenOptions, classShortenStrategy, callableShortenStrategy);
                        }
                        shortenCommand = shortenCommand2;
                    }
                    catch (Throwable throwable$iv$iv$iv) {
                        this_$iv$iv$iv.handleAnalysisException(throwable$iv$iv$iv, analysisSession$iv$iv$iv, useSiteElement$iv$iv$iv);
                        throw new KotlinNothingValueException();
                    }
                    finally {
                        this_$iv$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv$iv, useSiteElement$iv$iv$iv);
                    }
                    ShortenCommand shortenCommand3 = shortenCommand;
                    object4 = shortenCommand3;
                }
                finally {
                    permissionRegistry$iv$iv3.setAnalysisAllowedInWriteAction(false);
                }
            }
            Object object5 = object4;
            object = object5;
            return ShortenUtilsKt.invokeShortening((ShortenCommand)object);
        }
        finally {
            permissionRegistry$iv$iv.setAnalysisAllowedOnEdt(false);
        }
    }

    public static /* synthetic */ List shortenReferencesInRange$default(KtFile ktFile2, TextRange textRange, ShortenOptions shortenOptions, Function1 function1, Function1 function12, int n, Object object) {
        if ((n & 2) != 0) {
            TextRange textRange2 = ktFile2.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"getTextRange(...)");
            textRange = textRange2;
        }
        if ((n & 4) != 0) {
            shortenOptions = ShortenOptions.Companion.getDEFAULT();
        }
        if ((n & 8) != 0) {
            function1 = ShortenUtilsKt.defaultClassShortenStrategyForIde(ShortenStrategy.Companion, (KtElement)ktFile2);
        }
        if ((n & 0x10) != 0) {
            function12 = ShortenUtilsKt.defaultCallableShortenStrategyForIde(ShortenStrategy.Companion, (KtElement)ktFile2);
        }
        return ShortenUtilsKt.shortenReferencesInRange(ktFile2, textRange, shortenOptions, function1, function12);
    }

    @Deprecated(message="Use shortenReferencesInRange instead", replaceWith=@ReplaceWith(expression="shortenReferencesInRange(file, selection, shortenOptions, classShortenStrategy, callableShortenStrategy)", imports={}), level=DeprecationLevel.HIDDEN)
    @JvmName(name="shortenReferencesInRange")
    public static final /* synthetic */ PsiElement shortenReferencesInRange(KtFile file, TextRange selection, ShortenOptions shortenOptions, Function1 classShortenStrategy, Function1 callableShortenStrategy) {
        KtElement ktElement;
        block1: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
            Intrinsics.checkNotNullParameter((Object)shortenOptions, (String)"shortenOptions");
            Intrinsics.checkNotNullParameter((Object)classShortenStrategy, (String)"classShortenStrategy");
            Intrinsics.checkNotNullParameter((Object)callableShortenStrategy, (String)"callableShortenStrategy");
            for (SmartPsiElementPointer it : (Iterable)ShortenUtilsKt.shortenReferencesInRange(file, selection, shortenOptions, (Function1<? super KaClassLikeSymbol, ? extends ShortenStrategy>)classShortenStrategy, (Function1<? super KaCallableSymbol, ? extends ShortenStrategy>)callableShortenStrategy)) {
                boolean bl = false;
                KtElement ktElement2 = (KtElement)it.getElement();
                if (ktElement2 == null) continue;
                ktElement = ktElement2;
                break block1;
            }
            ktElement = null;
        }
        return (PsiElement)ktElement;
    }

    public static /* synthetic */ PsiElement shortenReferencesInRange$default(KtFile ktFile2, TextRange textRange, ShortenOptions shortenOptions, Function1 function1, Function1 function12, int n, Object object) {
        if ((n & 2) != 0) {
            TextRange textRange2 = ktFile2.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"getTextRange(...)");
            textRange = textRange2;
        }
        if ((n & 4) != 0) {
            shortenOptions = ShortenOptions.Companion.getDEFAULT();
        }
        if ((n & 8) != 0) {
            function1 = ShortenStrategy.Companion.getDefaultClassShortenStrategy();
        }
        if ((n & 0x10) != 0) {
            function12 = ShortenStrategy.Companion.getDefaultCallableShortenStrategy();
        }
        return ShortenUtilsKt.shortenReferencesInRange(ktFile2, textRange, shortenOptions, function1, function12);
    }

    @NotNull
    public static final List<SmartPsiElementPointer<KtElement>> invokeShortening(@NotNull ShortenCommand $this$invokeShortening) {
        Intrinsics.checkNotNullParameter((Object)$this$invokeShortening, (String)"<this>");
        KtFile ktFile2 = (KtFile)$this$invokeShortening.getTargetFile().getElement();
        if (ktFile2 == null) {
            return CollectionsKt.emptyList();
        }
        KtFile targetFile = ktFile2;
        Project project = targetFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
        for (FqName fqName2 : $this$invokeShortening.getImportsToAdd()) {
            ImportInsertionKt.addImport$default(targetFile, fqName2, false, null, null, 14, null);
        }
        for (FqName fqName2 : $this$invokeShortening.getStarImportsToAdd()) {
            ImportInsertionKt.addImport$default(targetFile, fqName2, true, null, null, 12, null);
        }
        List shorteningResults = new ArrayList();
        for (TypeToShortenInfo object : $this$invokeShortening.getListOfTypeToShortenInfo()) {
            KtUserType type2;
            SmartPsiElementPointer<KtUserType> typePointer = object.component1();
            String shortenedRef = object.component2();
            if ((KtUserType)typePointer.getElement() == null) continue;
            type2.deleteQualifier();
            if (shortenedRef != null) {
                KtSimpleNameExpression ktSimpleNameExpression = type2.getReferenceExpression();
                if (ktSimpleNameExpression != null) {
                    ktSimpleNameExpression.replace((PsiElement)psiFactory.createExpression(shortenedRef));
                }
            }
            ((Collection)shorteningResults).add(SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)type2)));
        }
        for (QualifierToShortenInfo qualifierToShortenInfo : $this$invokeShortening.getListOfQualifierToShortenInfo()) {
            KtExpression selectorExpression;
            KtDotQualifiedExpression call;
            SmartPsiElementPointer<KtDotQualifiedExpression> qualifierToShorten = qualifierToShortenInfo.component1();
            String shortenedReference = qualifierToShortenInfo.component2();
            if ((KtDotQualifiedExpression)qualifierToShorten.getElement() == null) continue;
            if (shortenedReference != null) {
                KtExpression ktExpression;
                KtExpression selector2 = call.getSelectorExpression();
                KtExpression ktExpression2 = ktExpression = selector2 instanceof KtArrayAccessExpression ? ((KtArrayAccessExpression)selector2).getArrayExpression() : org.jetbrains.kotlin.resolve.calls.util.PsiUtilsKt.getCalleeExpressionIfAny((KtElement)((KtElement)selector2));
                if (ktExpression != null) {
                    ktExpression.replace((PsiElement)psiFactory.createExpression(shortenedReference));
                }
            }
            if (call.getSelectorExpression() == null) continue;
            PsiElement psiElement = call.replace((PsiElement)selectorExpression);
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            KtExpression expression = (KtExpression)psiElement;
            ((Collection)shorteningResults).add(SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)expression)));
        }
        Iterator<Object> iterator2 = $this$invokeShortening.getThisLabelsToShorten().iterator();
        while (iterator2.hasNext()) {
            KtThisExpression thisWithLabel;
            SmartPsiElementPointer<KtThisExpression> labelToShorten = ((ThisLabelToShortenInfo)iterator2.next()).component1();
            if ((KtThisExpression)labelToShorten.getElement() == null) continue;
            KtContainerNode ktContainerNode = thisWithLabel.getLabelQualifier();
            if (ktContainerNode != null) {
                ktContainerNode.delete();
            }
            ((Collection)shorteningResults).add(SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)thisWithLabel)));
        }
        for (SmartPsiElementPointer smartPsiElementPointer : $this$invokeShortening.getKDocQualifiersToShorten()) {
            KDocName kDocName;
            if ((KDocName)smartPsiElementPointer.getElement() == null) continue;
            ShortenUtilsKt.deleteQualifier(kDocName);
            ((Collection)shorteningResults).add(SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)kDocName)));
        }
        return shorteningResults;
    }

    private static final void deleteQualifier(KDocName $this$deleteQualifier) {
        PsiElement psiElement;
        PsiElement it = psiElement = $this$deleteQualifier.getLastChild();
        boolean bl = false;
        Object object = Intrinsics.areEqual((Object)it.getNode().getElementType(), (Object)KtTokens.IDENTIFIER) ? psiElement : null;
        if (object == null) {
            return;
        }
        PsiElement identifier = object;
        Sequence $this$forEach$iv = SequencesKt.takeWhile((Sequence)((Sequence)PsiUtilsKt.getAllChildren((PsiElement)((PsiElement)$this$deleteQualifier))), arg_0 -> ShortenUtilsKt.deleteQualifier$lambda$1(identifier, arg_0));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiElement it2 = (PsiElement)element$iv;
            boolean bl2 = false;
            it2.delete();
        }
    }

    private static final <A, B, C> Function1<A, C> andThen(Function1<? super A, ? extends B> $this$andThen, Function1<? super B, ? extends C> function) {
        boolean $i$f$andThen = false;
        return new Function1<A, C>(function, $this$andThen){
            final /* synthetic */ Function1<B, C> $function;
            final /* synthetic */ Function1<A, B> $this_andThen;
            {
                this.$function = $function;
                this.$this_andThen = $receiver;
            }

            public final C invoke(A it) {
                return (C)this.$function.invoke(this.$this_andThen.invoke(it));
            }
        };
    }

    @ApiStatus.Internal
    @NotNull
    public static final ShortenCommand collectPossibleReferenceShorteningsForIde(@NotNull KaSession kaSession, @NotNull KtFile file, @NotNull TextRange selection, @NotNull ShortenOptions shortenOptions, @NotNull Function1<? super KaClassLikeSymbol, ? extends ShortenStrategy> classShortenStrategy, @NotNull Function1<? super KaCallableSymbol, ? extends ShortenStrategy> callableShortenStrategy) {
        Intrinsics.checkNotNullParameter((Object)kaSession, (String)"$context-KaSession");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        Intrinsics.checkNotNullParameter((Object)shortenOptions, (String)"shortenOptions");
        Intrinsics.checkNotNullParameter(classShortenStrategy, (String)"classShortenStrategy");
        Intrinsics.checkNotNullParameter(callableShortenStrategy, (String)"callableShortenStrategy");
        return KaReferenceShortenerKt.collectPossibleReferenceShortenings(kaSession, file, selection, shortenOptions, classShortenStrategy, callableShortenStrategy);
    }

    public static /* synthetic */ ShortenCommand collectPossibleReferenceShorteningsForIde$default(KaSession kaSession, KtFile ktFile2, TextRange textRange, ShortenOptions shortenOptions, Function1 function1, Function1 function12, int n, Object object) {
        if ((n & 4) != 0) {
            TextRange textRange2 = ktFile2.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"getTextRange(...)");
            textRange = textRange2;
        }
        if ((n & 8) != 0) {
            shortenOptions = ShortenOptions.Companion.getDEFAULT();
        }
        if ((n & 0x10) != 0) {
            function1 = ShortenUtilsKt.defaultClassShortenStrategyForIde(ShortenStrategy.Companion, (KtElement)ktFile2);
        }
        if ((n & 0x20) != 0) {
            function12 = ShortenUtilsKt.defaultCallableShortenStrategyForIde(ShortenStrategy.Companion, (KtElement)ktFile2);
        }
        return ShortenUtilsKt.collectPossibleReferenceShorteningsForIde(kaSession, ktFile2, textRange, shortenOptions, function1, function12);
    }

    @ApiStatus.Internal
    @NotNull
    public static final Function1<KaClassLikeSymbol, ShortenStrategy> defaultClassShortenStrategyForIde(@NotNull ShortenStrategy.Companion $this$defaultClassShortenStrategyForIde, @Nullable KtElement context2) {
        Intrinsics.checkNotNullParameter((Object)$this$defaultClassShortenStrategyForIde, (String)"<this>");
        if (context2 == null) {
            return $this$defaultClassShortenStrategyForIde.getDefaultClassShortenStrategy();
        }
        KtFile ktFile2 = context2.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"getContainingKtFile(...)");
        KotlinCodeStyleSettings codeStyleSettings = CodeStyleUtilsKt.getKotlinCustomSettings((PsiFile)((PsiFile)ktFile2));
        boolean importNestedClasses = codeStyleSettings.IMPORT_NESTED_CLASSES;
        return arg_0 -> ShortenUtilsKt.defaultClassShortenStrategyForIde$lambda$0(importNestedClasses, arg_0);
    }

    @ApiStatus.Internal
    @NotNull
    public static final Function1<KaCallableSymbol, ShortenStrategy> defaultCallableShortenStrategyForIde(@NotNull ShortenStrategy.Companion $this$defaultCallableShortenStrategyForIde, @Nullable KtElement context2) {
        Intrinsics.checkNotNullParameter((Object)$this$defaultCallableShortenStrategyForIde, (String)"<this>");
        if (context2 == null) {
            return $this$defaultCallableShortenStrategyForIde.getDefaultCallableShortenStrategy();
        }
        KtFile ktFile2 = context2.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"getContainingKtFile(...)");
        KotlinCodeStyleSettings codeStyleSettings = CodeStyleUtilsKt.getKotlinCustomSettings((PsiFile)((PsiFile)ktFile2));
        boolean importNestedClasses = codeStyleSettings.IMPORT_NESTED_CLASSES;
        return arg_0 -> ShortenUtilsKt.defaultCallableShortenStrategyForIde$lambda$0(importNestedClasses, arg_0);
    }

    private static final KtElement shortenReferences$shortenReferences$lambda$2(SmartPsiElementPointer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (KtElement)it.getElement();
    }

    /*
     * WARNING - void declaration
     */
    private static final void shortenReferences$shortenReferences(List<? extends SmartPsiElementPointer<KtElement>> elementPointers, ShortenOptions $shortenOptions, Function1<? super KaClassLikeSymbol, ? extends ShortenStrategy> $classShortenStrategy, Function1<? super KaCallableSymbol, ? extends ShortenStrategy> $callableShortenStrategy, Function1<? super ShortenStrategy, ? extends ShortenStrategy> function) {
        void $this$forEach$iv;
        Sequence sequence = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)elementPointers), ShortenUtilsKt::shortenReferences$shortenReferences$lambda$2);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtElement element = (KtElement)element$iv;
            boolean bl = false;
            Object $this$andThen$iv = $classShortenStrategy;
            boolean $i$f$andThen = false;
            Function1 function1 = new /* invalid duplicate definition of identical inner class */;
            $this$andThen$iv = $callableShortenStrategy;
            $i$f$andThen = false;
            ShortenUtilsKt.shortenReferences(element, $shortenOptions, (Function1<? super KaClassLikeSymbol, ? extends ShortenStrategy>)function1, (Function1<? super KaCallableSymbol, ? extends ShortenStrategy>)new /* invalid duplicate definition of identical inner class */);
        }
    }

    private static final ShortenStrategy shortenReferences$lambda$4(ShortenStrategy it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return (ShortenStrategy)((Object)RangesKt.coerceAtMost((Comparable)((Comparable)((Object)it)), (Comparable)((Comparable)((Object)ShortenStrategy.SHORTEN_IF_ALREADY_IMPORTED))));
    }

    private static final ShortenStrategy shortenReferences$lambda$5(ShortenStrategy it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return it;
    }

    private static final boolean deleteQualifier$lambda$1(PsiElement $identifier, PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !Intrinsics.areEqual((Object)it, (Object)$identifier);
    }

    private static final ShortenStrategy defaultClassShortenStrategyForIde$lambda$0(boolean $importNestedClasses, KaClassLikeSymbol classLikeSymbol) {
        Intrinsics.checkNotNullParameter((Object)classLikeSymbol, (String)"classLikeSymbol");
        ClassId classId = classLikeSymbol.getClassId();
        return (classId != null ? classId.isNestedClass() : false) && !$importNestedClasses ? ShortenStrategy.SHORTEN_IF_ALREADY_IMPORTED : ShortenStrategy.SHORTEN_AND_IMPORT;
    }

    private static final ShortenStrategy defaultCallableShortenStrategyForIde$lambda$0(boolean $importNestedClasses, KaCallableSymbol callableSymbol) {
        ShortenStrategy shortenStrategy;
        Intrinsics.checkNotNullParameter((Object)callableSymbol, (String)"callableSymbol");
        KaCallableSymbol kaCallableSymbol = callableSymbol;
        if (kaCallableSymbol instanceof KaEnumEntrySymbol) {
            shortenStrategy = ShortenStrategy.DO_NOT_SHORTEN;
        } else if (kaCallableSymbol instanceof KaConstructorSymbol) {
            boolean isNestedClassConstructor;
            ClassId classId = ((KaConstructorSymbol)callableSymbol).getContainingClassId();
            boolean bl = classId != null ? classId.isNestedClass() : (isNestedClassConstructor = false);
            shortenStrategy = isNestedClassConstructor && !$importNestedClasses ? ShortenStrategy.SHORTEN_IF_ALREADY_IMPORTED : ShortenStrategy.SHORTEN_AND_IMPORT;
        } else {
            CallableId callableId = callableSymbol.getCallableId();
            boolean isNotTopLevel = (callableId != null ? callableId.getClassId() : null) != null;
            shortenStrategy = isNotTopLevel ? ShortenStrategy.SHORTEN_IF_ALREADY_IMPORTED : ShortenStrategy.SHORTEN_AND_IMPORT;
        }
        return shortenStrategy;
    }
}

