/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.analysisApiPlatform.java;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.platform.java.KotlinJavaModulePsiAnnotationsProvider;
import org.jetbrains.kotlin.idea.base.analysisApiPlatform.java.UtilsKt;
import org.jetbrains.kotlin.idea.vfilefinder.IdeVirtualFileFinder;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/base/analysisApiPlatform/java/IdeKotlinJavaModuleAnnotationsProvider;", "Lorg/jetbrains/kotlin/analysis/api/platform/java/KotlinJavaModulePsiAnnotationsProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "virtualFileFinder", "Lorg/jetbrains/kotlin/idea/vfilefinder/IdeVirtualFileFinder;", "getVirtualFileFinder", "()Lorg/jetbrains/kotlin/idea/vfilefinder/IdeVirtualFileFinder;", "virtualFileFinder$delegate", "Lkotlin/Lazy;", "getAnnotationsForModuleOwnerOfClass", "", "Lcom/intellij/psi/PsiAnnotation;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "intellij.kotlin.base.analysis.platform"})
public final class IdeKotlinJavaModuleAnnotationsProvider
implements KotlinJavaModulePsiAnnotationsProvider {
    @NotNull
    private final Project project;
    @NotNull
    private final Lazy virtualFileFinder$delegate;

    public IdeKotlinJavaModuleAnnotationsProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.virtualFileFinder$delegate = LazyKt.lazy(() -> IdeKotlinJavaModuleAnnotationsProvider.virtualFileFinder_delegate$lambda$0(this));
    }

    private final IdeVirtualFileFinder getVirtualFileFinder() {
        Lazy lazy = this.virtualFileFinder$delegate;
        return (IdeVirtualFileFinder)((Object)lazy.getValue());
    }

    @Override
    @Nullable
    public List<PsiAnnotation> getAnnotationsForModuleOwnerOfClass(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        VirtualFile virtualFile = this.getVirtualFileFinder().findVirtualFileWithHeader(classId);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        Object[] objectArray = UtilsKt.findJavaModule(this.project, virtualFile2);
        return objectArray != null && (objectArray = objectArray.getAnnotations()) != null ? ArraysKt.toList((Object[])objectArray) : null;
    }

    private static final IdeVirtualFileFinder virtualFileFinder_delegate$lambda$0(IdeKotlinJavaModuleAnnotationsProvider this$0) {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this$0.project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(...)");
        return new IdeVirtualFileFinder(globalSearchScope, this$0.project);
    }
}

