/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.codeInsight;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.components.KaScopeProviderKt;
import org.jetbrains.kotlin.analysis.api.components.KaSymbolRelationProviderKt;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassKind;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaDeclarationSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaFunctionSymbol;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a!\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0007R\u00020\u0002j\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006\u001a\u0018\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0007\u001a#\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\nH\u0007R\u00020\u0002j\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\f\u001a\f\u0010\r\u001a\u00020\u0001*\u00020\u000eH\u0007\u001a\f\u0010\r\u001a\u00020\u0001*\u00020\u000fH\u0007\u00a8\u0006\u0010"}, d2={"isSoftDeprecatedEnumValuesMethodAndEntriesPropertyExists", "", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "<unused var>", "symbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaCallableSymbol;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/analysis/api/symbols/KaCallableSymbol;)Z", "isSoftDeprecatedEnumValuesMethod", "valuesMethodSymbol", "enumClassSymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaClassSymbol;", "getEntriesPropertyOfEnumClass", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/analysis/api/symbols/KaClassSymbol;)Lorg/jetbrains/kotlin/analysis/api/symbols/KaCallableSymbol;", "isEnumValuesSoftDeprecateEnabled", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "intellij.kotlin.base.codeInsight"})
public final class EnumValuesSoftDeprecateKt {
    @ApiStatus.Internal
    public static final boolean isSoftDeprecatedEnumValuesMethodAndEntriesPropertyExists(@NotNull KaSession kaSession, @NotNull KaCallableSymbol symbol) {
        Intrinsics.checkNotNullParameter((Object)kaSession, (String)"$context-KaSession");
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        KaDeclarationSymbol kaDeclarationSymbol = KaSymbolRelationProviderKt.getContainingDeclaration(kaSession, symbol);
        KaClassSymbol kaClassSymbol = kaDeclarationSymbol instanceof KaClassSymbol ? (KaClassSymbol)kaDeclarationSymbol : null;
        if (kaClassSymbol == null) {
            return false;
        }
        KaClassSymbol enumClassSymbol = kaClassSymbol;
        return EnumValuesSoftDeprecateKt.isSoftDeprecatedEnumValuesMethod(symbol, enumClassSymbol) && EnumValuesSoftDeprecateKt.getEntriesPropertyOfEnumClass(kaSession, enumClassSymbol) != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ApiStatus.Internal
    public static final boolean isSoftDeprecatedEnumValuesMethod(@NotNull KaCallableSymbol valuesMethodSymbol, @NotNull KaClassSymbol enumClassSymbol) {
        Intrinsics.checkNotNullParameter((Object)valuesMethodSymbol, (String)"valuesMethodSymbol");
        Intrinsics.checkNotNullParameter((Object)enumClassSymbol, (String)"enumClassSymbol");
        if (KaClassKind.ENUM_CLASS != enumClassSymbol.getClassKind()) return false;
        CallableId callableId = valuesMethodSymbol.getCallableId();
        if (!Intrinsics.areEqual((Object)StandardNames.ENUM_VALUES, (Object)(callableId != null ? callableId.getCallableName() : null))) return false;
        if (!(valuesMethodSymbol instanceof KaFunctionSymbol)) return false;
        if (!((KaFunctionSymbol)valuesMethodSymbol).getValueParameters().isEmpty()) return false;
        return true;
    }

    @ApiStatus.Internal
    @Nullable
    public static final KaCallableSymbol getEntriesPropertyOfEnumClass(@NotNull KaSession kaSession, @NotNull KaClassSymbol enumClassSymbol) {
        Intrinsics.checkNotNullParameter((Object)kaSession, (String)"$context-KaSession");
        Intrinsics.checkNotNullParameter((Object)enumClassSymbol, (String)"enumClassSymbol");
        Name[] nameArray = new Name[]{StandardNames.ENUM_ENTRIES};
        return (KaCallableSymbol)SequencesKt.firstOrNull(KaScopeProviderKt.getStaticMemberScope(kaSession, enumClassSymbol).callables(nameArray));
    }

    @ApiStatus.Internal
    public static final boolean isEnumValuesSoftDeprecateEnabled(@NotNull PsiElement $this$isEnumValuesSoftDeprecateEnabled) {
        Intrinsics.checkNotNullParameter((Object)$this$isEnumValuesSoftDeprecateEnabled, (String)"<this>");
        return EnumValuesSoftDeprecateKt.isEnumValuesSoftDeprecateEnabled(LanguageVersionSettingsProviderUtils.getLanguageVersionSettings($this$isEnumValuesSoftDeprecateEnabled));
    }

    @ApiStatus.Internal
    public static final boolean isEnumValuesSoftDeprecateEnabled(@NotNull LanguageVersionSettings $this$isEnumValuesSoftDeprecateEnabled) {
        Intrinsics.checkNotNullParameter((Object)$this$isEnumValuesSoftDeprecateEnabled, (String)"<this>");
        return $this$isEnumValuesSoftDeprecateEnabled.supportsFeature(LanguageFeature.EnumEntries);
    }
}

