/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.codeInsight;

import com.intellij.psi.PsiElement;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.idea.base.codeInsight.KotlinMainFunctionDetector;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiHeuristics;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/base/codeInsight/PsiOnlyKotlinMainFunctionDetector;", "Lorg/jetbrains/kotlin/idea/base/codeInsight/KotlinMainFunctionDetector;", "<init>", "()V", "isMain", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "configuration", "Lorg/jetbrains/kotlin/idea/base/codeInsight/KotlinMainFunctionDetector$Configuration;", "isMainCheckParameter", "intellij.kotlin.base.codeInsight"})
@ApiStatus.Internal
public final class PsiOnlyKotlinMainFunctionDetector
implements KotlinMainFunctionDetector {
    @NotNull
    public static final PsiOnlyKotlinMainFunctionDetector INSTANCE = new PsiOnlyKotlinMainFunctionDetector();

    private PsiOnlyKotlinMainFunctionDetector() {
    }

    @Override
    @RequiresReadLock
    public boolean isMain(@NotNull KtNamedFunction function, @NotNull KotlinMainFunctionDetector.Configuration configuration2) {
        KtTypeReference returnTypeReference;
        String string;
        block12: {
            block11: {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
                if (function.isLocal()) break block11;
                List list2 = function.getTypeParameters();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getTypeParameters(...)");
                if (!(!((Collection)list2).isEmpty())) break block12;
            }
            return false;
        }
        boolean isTopLevel = function.isTopLevel();
        int parameterCount = function.getValueParameters().size() + (function.getReceiverTypeReference() != null ? 1 : 0);
        switch (parameterCount) {
            case 0: {
                if (!isTopLevel) {
                    return false;
                }
                if (LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)function).supportsFeature(LanguageFeature.ExtendedMainConvention)) break;
                return false;
            }
            case 1: {
                if (!configuration2.getCheckParameterType() || this.isMainCheckParameter(function)) break;
                return false;
            }
            default: {
                return false;
            }
        }
        if ((string = KotlinPsiHeuristics.findJvmName$default((KtAnnotated)function, null, 2, null)) == null) {
            string = function.getName();
        }
        if (!Intrinsics.areEqual((Object)string, (Object)"main")) {
            return false;
        }
        if (!isTopLevel && configuration2.getCheckJvmStaticAnnotation() && !KotlinPsiHeuristics.hasJvmStaticAnnotation((KtAnnotated)function)) {
            return false;
        }
        return !configuration2.getCheckResultType() || (returnTypeReference = function.getTypeReference()) == null || KotlinPsiHeuristics.INSTANCE.typeMatches(returnTypeReference, StandardClassIds.INSTANCE.getUnit(), new ClassId[0]);
    }

    private final boolean isMainCheckParameter(KtNamedFunction function) {
        boolean bl;
        KtTypeReference receiverTypeReference = function.getReceiverTypeReference();
        if (receiverTypeReference != null) {
            ClassId[] classIdArray = new ClassId[]{StandardClassIds.INSTANCE.getString()};
            return KotlinPsiHeuristics.INSTANCE.typeMatches(receiverTypeReference, StandardClassIds.INSTANCE.getArray(), classIdArray);
        }
        KtParameter ktParameter = (KtParameter)CollectionsKt.singleOrNull((List)function.getValueParameters());
        if (ktParameter == null) {
            return false;
        }
        KtParameter parameter = ktParameter;
        KtTypeReference ktTypeReference = parameter.getTypeReference();
        if (ktTypeReference == null) {
            return false;
        }
        KtTypeReference parameterTypeReference = ktTypeReference;
        if (parameter.isVarArg()) {
            bl = KotlinPsiHeuristics.INSTANCE.typeMatches(parameterTypeReference, StandardClassIds.INSTANCE.getString(), new ClassId[0]);
        } else {
            ClassId[] classIdArray = new ClassId[]{StandardClassIds.INSTANCE.getString()};
            bl = KotlinPsiHeuristics.INSTANCE.typeMatches(parameterTypeReference, StandardClassIds.INSTANCE.getArray(), classIdArray);
        }
        return bl;
    }
}

