/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.codeInsight.compiler;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaExperimentalApi;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.components.KaCompilationResult;
import org.jetbrains.kotlin.analysis.api.components.KaCompiledFile;
import org.jetbrains.kotlin.analysis.api.components.KaCompilerTarget;
import org.jetbrains.kotlin.analysis.api.diagnostics.KaDiagnostic;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a@\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\r\u001a\u00020\u000eH\u0007\u001a@\u0010\u000f\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\r\u001a\u00020\u000eH\u0007\u00a8\u0006\u0010"}, d2={"compileToDirectory", "Lorg/jetbrains/kotlin/analysis/api/components/KaCompilationResult;", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "target", "Lorg/jetbrains/kotlin/analysis/api/components/KaCompilerTarget;", "allowedErrorFilter", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/analysis/api/diagnostics/KaDiagnostic;", "", "destination", "Ljava/io/File;", "compileToJar", "intellij.kotlin.base.codeInsight"})
@JvmName(name="KtCompilerFacilityUtils")
public final class KtCompilerFacilityUtils {
    @KaExperimentalApi
    @ApiStatus.Internal
    @NotNull
    public static final KaCompilationResult compileToDirectory(@NotNull KaSession $this$compileToDirectory, @NotNull KtFile file, @NotNull CompilerConfiguration configuration2, @NotNull KaCompilerTarget target, @NotNull Function1<? super KaDiagnostic, Boolean> allowedErrorFilter, @NotNull File destination) {
        Intrinsics.checkNotNullParameter((Object)$this$compileToDirectory, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter(allowedErrorFilter, (String)"allowedErrorFilter");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        KaCompilationResult result2 = $this$compileToDirectory.compile(file, configuration2, target, allowedErrorFilter);
        if (result2 instanceof KaCompilationResult.Success) {
            for (KaCompiledFile outputFile : ((KaCompilationResult.Success)result2).getOutput()) {
                File target2 = new File(destination, outputFile.getPath());
                File file2 = target2.getParentFile();
                if (file2 == null) {
                    throw new IllegalStateException(("Can't find parent for file " + target2).toString());
                }
                file2.mkdirs();
                FilesKt.writeBytes((File)target2, (byte[])outputFile.getContent());
            }
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KaExperimentalApi
    @ApiStatus.Internal
    @NotNull
    public static final KaCompilationResult compileToJar(@NotNull KaSession $this$compileToJar, @NotNull KtFile file, @NotNull CompilerConfiguration configuration2, @NotNull KaCompilerTarget target, @NotNull Function1<? super KaDiagnostic, Boolean> allowedErrorFilter, @NotNull File destination) {
        Intrinsics.checkNotNullParameter((Object)$this$compileToJar, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter(allowedErrorFilter, (String)"allowedErrorFilter");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        KaCompilationResult result2 = $this$compileToJar.compile(file, configuration2, target, allowedErrorFilter);
        if (result2 instanceof KaCompilationResult.Success) {
            Closeable closeable = new FileOutputStream(destination);
            int n = 8192;
            closeable = closeable instanceof BufferedOutputStream ? (BufferedOutputStream)closeable : new BufferedOutputStream((OutputStream)closeable, n);
            Throwable throwable = null;
            try {
                BufferedOutputStream os = (BufferedOutputStream)closeable;
                boolean bl = false;
                Closeable closeable2 = new ZipOutputStream(os);
                Throwable throwable2 = null;
                try {
                    ZipOutputStream zos = (ZipOutputStream)closeable2;
                    boolean bl2 = false;
                    for (KaCompiledFile outputFile : ((KaCompilationResult.Success)result2).getOutput()) {
                        zos.putNextEntry(new ZipEntry(outputFile.getPath()));
                        zos.write(outputFile.getContent());
                        zos.closeEntry();
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        return result2;
    }
}

