/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.fe10.codeInsight;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\tJ\u0018\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000RB\u0010\u0007\u001a6\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \n*\b\u0012\u0002\b\u0003\u0018\u00010\t0\t \n*\u001a\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \n*\b\u0012\u0002\b\u0003\u0018\u00010\t0\t\u0018\u00010\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/base/fe10/codeInsight/NoDeclarationDescriptorsChecker;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "checkedQuickFixClasses", "", "Ljava/lang/Class;", "kotlin.jvm.PlatformType", "", "check", "", "quickFixClass", "checkType", "type", "Ljava/lang/reflect/Type;", "field", "Ljava/lang/reflect/Field;", "kotlin.base.fe10.code-insight"})
@SourceDebugExtension(value={"SMAP\nFe10QuickFixProviderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Fe10QuickFixProviderImpl.kt\norg/jetbrains/kotlin/idea/base/fe10/codeInsight/NoDeclarationDescriptorsChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,186:1\n1#2:187\n14060#3,2:188\n14060#3,2:190\n*S KotlinDebug\n*F\n+ 1 Fe10QuickFixProviderImpl.kt\norg/jetbrains/kotlin/idea/base/fe10/codeInsight/NoDeclarationDescriptorsChecker\n*L\n179#1:188,2\n183#1:190,2\n*E\n"})
final class NoDeclarationDescriptorsChecker {
    @NotNull
    public static final NoDeclarationDescriptorsChecker INSTANCE = new NoDeclarationDescriptorsChecker();
    @NotNull
    private static final Logger LOG;
    private static final Set<Class<?>> checkedQuickFixClasses;

    private NoDeclarationDescriptorsChecker() {
    }

    public final void check(@NotNull Class<?> quickFixClass) {
        block2: {
            Intrinsics.checkNotNullParameter(quickFixClass, (String)"quickFixClass");
            if (!checkedQuickFixClasses.add(quickFixClass)) {
                return;
            }
            Field[] fieldArray = quickFixClass.getDeclaredFields();
            Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"getDeclaredFields(...)");
            for (Field field2 : fieldArray) {
                Type type2 = field2.getGenericType();
                Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"getGenericType(...)");
                Intrinsics.checkNotNull((Object)field2);
                this.checkType(type2, field2);
            }
            Class<?> clazz = quickFixClass.getSuperclass();
            if (clazz == null) break block2;
            Class<?> it = clazz;
            boolean bl = false;
            INSTANCE.check(it);
        }
    }

    private final void checkType(Type type2, Field field2) {
        block5: {
            Type type3;
            block7: {
                block6: {
                    block4: {
                        type3 = type2;
                        if (!(type3 instanceof Class)) break block4;
                        if (DeclarationDescriptor.class.isAssignableFrom((Class)type2) || KotlinType.class.isAssignableFrom((Class)type2) || Diagnostic.class.isAssignableFrom((Class)type2)) {
                            LOG.error("QuickFix class " + field2.getDeclaringClass().getName() + " contains field " + field2.getName() + " that holds " + ((Class)type2).getSimpleName() + ". This leads to holding too much memory through this quick-fix instance. Possible solution can be wrapping it using KotlinIntentionActionFactoryWithDelegate.");
                        }
                        if (!IntentionAction.class.isAssignableFrom((Class)type2)) break block5;
                        this.check((Class)type2);
                        break block5;
                    }
                    if (!(type3 instanceof GenericArrayType)) break block6;
                    Type type4 = ((GenericArrayType)type2).getGenericComponentType();
                    Intrinsics.checkNotNullExpressionValue((Object)type4, (String)"getGenericComponentType(...)");
                    this.checkType(type4, field2);
                    break block5;
                }
                if (!(type3 instanceof ParameterizedType)) break block7;
                Type type5 = ((ParameterizedType)type2).getRawType();
                Intrinsics.checkNotNull((Object)type5, (String)"null cannot be cast to non-null type java.lang.Class<*>");
                if (!Collection.class.isAssignableFrom((Class)type5)) break block5;
                Type[] typeArray = ((ParameterizedType)type2).getActualTypeArguments();
                Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"getActualTypeArguments(...)");
                Object[] $this$forEach$iv = typeArray;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Type it = (Type)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    INSTANCE.checkType(it, field2);
                }
                break block5;
            }
            if (type3 instanceof WildcardType) {
                Type[] typeArray = ((WildcardType)type2).getUpperBounds();
                Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"getUpperBounds(...)");
                Object[] $this$forEach$iv = typeArray;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Type it = (Type)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    INSTANCE.checkType(it, field2);
                }
            }
        }
    }

    static {
        Logger logger = Logger.getInstance(NoDeclarationDescriptorsChecker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        checkedQuickFixClasses = Collections.synchronizedSet(new HashSet());
    }
}

