/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.fir.analysisApiPlatform;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessor;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ConcurrentList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.platform.modification.KaElementModificationType;
import org.jetbrains.kotlin.analysis.api.platform.modification.KaSourceModificationService;
import org.jetbrains.kotlin.analysis.api.platform.modification.UtilsKt;
import org.jetbrains.kotlin.idea.base.fir.analysisApiPlatform.FirIdeOutOfBlockPsiTreeChangePreprocessorKt;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.utils.exceptions.ExceptionAttachementBuilderUtilsKt;
import org.jetbrains.kotlin.utils.exceptions.ExceptionAttachmentBuilder;
import org.jetbrains.kotlin.utils.exceptions.KotlinExceptionWithAttachments;
import org.jetbrains.kotlin.utils.exceptions.KotlinIllegalArgumentExceptionWithAttachments;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0014\u0010\u000e\u001a\u00020\u000b*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/base/fir/analysisApiPlatform/FirIdeOutOfBlockPsiTreeChangePreprocessor;", "Lcom/intellij/psi/impl/PsiTreeChangePreprocessor;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "treeChanged", "", "event", "Lcom/intellij/psi/impl/PsiTreeChangeEventImpl;", "isInjectionChange", "", "rootElement", "Lcom/intellij/psi/PsiElement;", "containsInjectionAt", "Lcom/intellij/injected/editor/DocumentWindow;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "intellij.kotlin.analysis.platform"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nFirIdeOutOfBlockPsiTreeChangePreprocessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirIdeOutOfBlockPsiTreeChangePreprocessor.kt\norg/jetbrains/kotlin/idea/base/fir/analysisApiPlatform/FirIdeOutOfBlockPsiTreeChangePreprocessor\n+ 2 ExceptionAttachmentBuilder.kt\norg/jetbrains/kotlin/utils/exceptions/ExceptionAttachmentBuilderKt\n+ 3 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,133:1\n81#2,7:134\n76#2,2:141\n57#2:143\n78#2:144\n66#3,2:145\n1807#4,3:147\n13225#5,2:150\n*S KotlinDebug\n*F\n+ 1 FirIdeOutOfBlockPsiTreeChangePreprocessor.kt\norg/jetbrains/kotlin/idea/base/fir/analysisApiPlatform/FirIdeOutOfBlockPsiTreeChangePreprocessor\n*L\n84#1:134,7\n84#1:141,2\n84#1:143\n84#1:144\n98#1:145,2\n111#1:147,3\n115#1:150,2\n*E\n"})
public final class FirIdeOutOfBlockPsiTreeChangePreprocessor
implements PsiTreeChangePreprocessor {
    @NotNull
    private final Project project;

    public FirIdeOutOfBlockPsiTreeChangePreprocessor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    public void treeChanged(@NotNull PsiTreeChangeEventImpl event) {
        PsiElement child;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.project.isDefault()) {
            return;
        }
        PsiTreeChangeEventImpl.PsiEventType eventCode = event.getCode();
        if (!PsiModificationTrackerImpl.canAffectPsi((PsiTreeChangeEventImpl)event) || event.isGenericChange() || eventCode == PsiTreeChangeEventImpl.PsiEventType.BEFORE_CHILD_ADDITION) {
            return;
        }
        if (FirIdeOutOfBlockPsiTreeChangePreprocessorKt.access$isGlobalChange(event)) {
            UtilsKt.publishGlobalSourceOutOfBlockModificationEvent(this.project);
            return;
        }
        PsiElement rootElement = event.getParent();
        if (rootElement != null && eventCode != PsiTreeChangeEventImpl.PsiEventType.BEFORE_CHILD_REPLACEMENT && this.isInjectionChange(rootElement)) {
            UtilsKt.publishGlobalSourceOutOfBlockModificationEvent(this.project);
            return;
        }
        PsiTreeChangeEventImpl.PsiEventType psiEventType = eventCode;
        switch (psiEventType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[psiEventType.ordinal()]) {
            case 1: {
                PsiElement psiElement = rootElement;
                break;
            }
            case 2: {
                PsiElement psiElement = event.getOldChild();
                break;
            }
            default: {
                PsiElement psiElement = child = event.getChild();
            }
        }
        if (rootElement == null || !rootElement.isPhysical()) {
            return;
        }
        PsiFile containingFile = rootElement.getContainingFile();
        if (containingFile instanceof KtCodeFragment) {
            PsiElement psiElement = ((KtCodeFragment)containingFile).getContext();
            boolean bl = psiElement != null ? !psiElement.isValid() : false;
            if (bl) {
                return;
            }
        }
        PsiTreeChangeEventImpl.PsiEventType psiEventType2 = eventCode;
        KaElementModificationType modificationType = switch (psiEventType2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[psiEventType2.ordinal()]) {
            case 3 -> KaElementModificationType.ElementAdded.INSTANCE;
            case 1 -> {
                PsiElement v6 = event.getChild();
                if (v6 == null) {
                    void $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
                    void $this$buildAttachment$iv$iv$iv;
                    ExceptionAttachmentBuilder var20_18;
                    void cause$iv$iv;
                    void message$iv$iv;
                    String message$iv = "A " + PsiTreeChangeEventImpl.PsiEventType.CHILD_REMOVED + " PSI tree change event should have a child element";
                    Object cause$iv = null;
                    String attachmentName$iv = "info.txt";
                    boolean $i$f$errorWithAttachment = false;
                    String var12_10 = message$iv;
                    Object var13_11 = cause$iv;
                    String attachmentName$iv$iv = attachmentName$iv;
                    boolean $i$f$buildErrorWithAttachment = false;
                    KotlinIllegalArgumentExceptionWithAttachments exception$iv$iv = new KotlinIllegalArgumentExceptionWithAttachments((String)message$iv$iv, (Throwable)cause$iv$iv);
                    KotlinExceptionWithAttachments var17_15 = (KotlinExceptionWithAttachments)exception$iv$iv;
                    String name$iv$iv$iv = attachmentName$iv$iv;
                    boolean $i$f$buildAttachment = false;
                    ExceptionAttachmentBuilder var21_19 = var20_18 = new ExceptionAttachmentBuilder();
                    String var22_20 = name$iv$iv$iv;
                    void var23_21 = $this$buildAttachment$iv$iv$iv;
                    boolean $i$a$-buildAttachment-ExceptionAttachmentBuilderKt$buildErrorWithAttachment$2$iv$iv = false;
                    void $this$treeChanged_u24lambda_u240 = $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
                    boolean $i$a$-errorWithAttachment$default-FirIdeOutOfBlockPsiTreeChangePreprocessor$treeChanged$modificationType$removedElement$1 = false;
                    $this$treeChanged_u24lambda_u240.withEntry("psiTreeChangeEvent", event.toString());
                    ExceptionAttachementBuilderUtilsKt.withPsiEntry((ExceptionAttachmentBuilder)$this$treeChanged_u24lambda_u240, (String)"rootElement", (PsiElement)rootElement);
                    var23_21.withAttachment(var22_20, (Object)var20_18.buildString());
                    throw (Throwable)exception$iv$iv;
                }
                PsiElement removedElement = v6;
                yield new KaElementModificationType.ElementRemoved(removedElement);
            }
            default -> KaElementModificationType.Unknown.INSTANCE;
        };
        KaSourceModificationService kaSourceModificationService = KaSourceModificationService.Companion.getInstance(this.project);
        PsiElement psiElement = child;
        if (psiElement == null) {
            psiElement = rootElement;
        }
        kaSourceModificationService.handleElementModification(psiElement, modificationType);
    }

    private final boolean isInjectionChange(PsiElement rootElement) {
        boolean bl;
        block5: {
            PsiElement $this$parentOfType_u24default$iv = rootElement;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            PsiLanguageInjectionHost injectionHost = (PsiLanguageInjectionHost)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, PsiLanguageInjectionHost.class, (boolean)true);
            if (injectionHost == null) {
                return false;
            }
            ConcurrentList concurrentList = InjectedLanguageUtilBase.getCachedInjectedDocuments((PsiFile)rootElement.getContainingFile());
            Intrinsics.checkNotNullExpressionValue((Object)concurrentList, (String)"getCachedInjectedDocuments(...)");
            ConcurrentList injectedDocuments = concurrentList;
            if (injectedDocuments.isEmpty()) {
                return false;
            }
            TextRange textRange = rootElement.getTextRange();
            Iterable $this$any$iv = (Iterable)injectedDocuments;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    DocumentWindow it = (DocumentWindow)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it);
                    Intrinsics.checkNotNull((Object)textRange);
                    if (!this.containsInjectionAt(it, textRange)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean containsInjectionAt(DocumentWindow $this$containsInjectionAt, TextRange textRange) {
        boolean bl;
        block1: {
            Segment[] segmentArray = $this$containsInjectionAt.getHostRanges();
            Intrinsics.checkNotNullExpressionValue((Object)segmentArray, (String)"getHostRanges(...)");
            Object[] $this$any$iv = segmentArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                Segment it = (Segment)element$iv;
                boolean bl2 = false;
                if (!textRange.intersects(it)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PsiTreeChangeEventImpl.PsiEventType.values().length];
            try {
                nArray[PsiTreeChangeEventImpl.PsiEventType.CHILD_REMOVED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PsiTreeChangeEventImpl.PsiEventType.BEFORE_CHILD_REPLACEMENT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PsiTreeChangeEventImpl.PsiEventType.CHILD_ADDED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

