/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.injection;

import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.util.ProcessingContext;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.injection.KotlinPatternBasesKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\f\b'\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J%\u0010\u0005\u001a\u00020\u0006*\u00020\u00022\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\"\u00020\tH&\u00a2\u0006\u0002\u0010\nJ\u0014\u0010\u000b\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\f\u001a\u00020\tH&J\u001f\u0010\r\u001a\u00020\u00002\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\"\u00020\t\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\tJ\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\tJ\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\t\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/base/injection/KotlinFunctionPatternBase;", "Lcom/intellij/patterns/PsiElementPattern;", "Lorg/jetbrains/kotlin/psi/KtFunction;", "<init>", "()V", "matchParameters", "", "parameterTypes", "", "", "(Lorg/jetbrains/kotlin/psi/KtFunction;[Ljava/lang/String;)Z", "matchReceiver", "receiverFqName", "withParameters", "([Ljava/lang/String;)Lorg/jetbrains/kotlin/idea/base/injection/KotlinFunctionPatternBase;", "withReceiver", "definedInClass", "fqName", "definedInPackage", "packageFqName", "DefinedInClassCondition", "kotlin.base.injection"})
@ApiStatus.Internal
public abstract class KotlinFunctionPatternBase
extends PsiElementPattern<KtFunction, KotlinFunctionPatternBase> {
    public KotlinFunctionPatternBase() {
        super(KtFunction.class);
    }

    public abstract boolean matchParameters(@NotNull KtFunction var1, String ... var2);

    public abstract boolean matchReceiver(@NotNull KtFunction var1, @NotNull String var2);

    @NotNull
    public final KotlinFunctionPatternBase withParameters(String ... parameterTypes) {
        Intrinsics.checkNotNullParameter((Object)parameterTypes, (String)"parameterTypes");
        return (KotlinFunctionPatternBase)KotlinPatternBasesKt.access$withPatternCondition(this, "kotlinFunctionPattern-withParameters", (arg_0, arg_1) -> KotlinFunctionPatternBase.withParameters$lambda$0(parameterTypes, this, arg_0, arg_1));
    }

    @NotNull
    public final KotlinFunctionPatternBase withReceiver(@NotNull String receiverFqName) {
        Intrinsics.checkNotNullParameter((Object)receiverFqName, (String)"receiverFqName");
        return (KotlinFunctionPatternBase)KotlinPatternBasesKt.access$withPatternCondition(this, "kotlinFunctionPattern-withReceiver", (arg_0, arg_1) -> KotlinFunctionPatternBase.withReceiver$lambda$0(receiverFqName, this, arg_0, arg_1));
    }

    @NotNull
    public final KotlinFunctionPatternBase definedInClass(@NotNull String fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        ObjectPattern objectPattern = this.with(new DefinedInClassCondition(fqName2));
        Intrinsics.checkNotNullExpressionValue((Object)objectPattern, (String)"with(...)");
        return (KotlinFunctionPatternBase)objectPattern;
    }

    @NotNull
    public final KotlinFunctionPatternBase definedInPackage(@NotNull String packageFqName) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        return (KotlinFunctionPatternBase)KotlinPatternBasesKt.access$withPatternCondition(this, "kotlinFunctionPattern-definedInPackage", (arg_0, arg_1) -> KotlinFunctionPatternBase.definedInPackage$lambda$0(packageFqName, arg_0, arg_1));
    }

    private static final boolean withParameters$lambda$0(String[] $parameterTypes, KotlinFunctionPatternBase this$0, KtFunction function, ProcessingContext processingContext) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        if (function.getValueParameters().size() != $parameterTypes.length) {
            return false;
        }
        return this$0.matchParameters(function, Arrays.copyOf($parameterTypes, $parameterTypes.length));
    }

    private static final boolean withReceiver$lambda$0(String $receiverFqName, KotlinFunctionPatternBase this$0, KtFunction function, ProcessingContext processingContext) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        if (function.getReceiverTypeReference() == null) {
            return false;
        }
        if (Intrinsics.areEqual((Object)$receiverFqName, (Object)"?")) {
            return true;
        }
        return this$0.matchReceiver(function, $receiverFqName);
    }

    private static final boolean definedInPackage$lambda$0(String $packageFqName, KtFunction function, ProcessingContext processingContext) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        if (!(function.getParent() instanceof KtFile)) {
            return false;
        }
        return Intrinsics.areEqual((Object)function.getContainingKtFile().getPackageFqName().asString(), (Object)$packageFqName);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/base/injection/KotlinFunctionPatternBase$DefinedInClassCondition;", "Lcom/intellij/patterns/PatternCondition;", "Lorg/jetbrains/kotlin/psi/KtFunction;", "fqName", "", "<init>", "(Ljava/lang/String;)V", "getFqName", "()Ljava/lang/String;", "accepts", "", "element", "context", "Lcom/intellij/util/ProcessingContext;", "kotlin.base.injection"})
    public static final class DefinedInClassCondition
    extends PatternCondition<KtFunction> {
        @NotNull
        private final String fqName;

        public DefinedInClassCondition(@NotNull String fqName2) {
            Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
            super("kotlinFunctionPattern-definedInClass");
            this.fqName = fqName2;
        }

        @NotNull
        public final String getFqName() {
            return this.fqName;
        }

        public boolean accepts(@NotNull KtFunction element, @Nullable ProcessingContext context2) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            if (element.getParent() instanceof KtFile) {
                return false;
            }
            KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)element));
            return Intrinsics.areEqual((Object)(ktClassOrObject != null && (ktClassOrObject = ktClassOrObject.getFqName()) != null ? ktClassOrObject.asString() : null), (Object)this.fqName);
        }
    }
}

