/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.projectStructure;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.platform.workspace.jps.entities.ModuleId;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaExperimentalApi;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.idea.base.projectStructure.KaSourceModuleKind;
import org.jetbrains.kotlin.idea.base.projectStructure.KaSourceModuleWithKind;
import org.jetbrains.kotlin.idea.base.projectStructure.KtModuleByModuleInfoBase;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleDependencyCollector;
import org.jetbrains.kotlin.idea.base.projectStructure.ProjectModuleByModuleInfoKt;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.base.util.K1ModeProjectStructureApi;
import org.jetbrains.kotlin.name.Name;

@K1ModeProjectStructureApi
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u00108VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0012R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001e\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/KtSourceModuleByModuleInfo;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/KtModuleByModuleInfoBase;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/KaSourceModuleWithKind;", "moduleInfo", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/ModuleSourceInfo;", "<init>", "(Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/ModuleSourceInfo;)V", "ideaModule", "Lcom/intellij/openapi/module/Module;", "getIdeaModule", "()Lcom/intellij/openapi/module/Module;", "kind", "Lorg/jetbrains/kotlin/idea/base/projectStructure/KaSourceModuleKind;", "getKind", "()Lorg/jetbrains/kotlin/idea/base/projectStructure/KaSourceModuleKind;", "name", "", "getName", "()Ljava/lang/String;", "stableModuleName", "getStableModuleName$annotations", "()V", "getStableModuleName", "moduleId", "Lcom/intellij/platform/workspace/jps/entities/ModuleId;", "getModuleId", "()Lcom/intellij/platform/workspace/jps/entities/ModuleId;", "computeDirectRegularDependencies", "", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "baseContentScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "getBaseContentScope", "()Lcom/intellij/psi/search/GlobalSearchScope;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "intellij.kotlin.base.projectStructure"})
@ApiStatus.Internal
public class KtSourceModuleByModuleInfo
extends KtModuleByModuleInfoBase
implements KaSourceModuleWithKind {
    @NotNull
    private final ModuleSourceInfo moduleInfo;

    public KtSourceModuleByModuleInfo(@NotNull ModuleSourceInfo moduleInfo) {
        Intrinsics.checkNotNullParameter((Object)moduleInfo, (String)"moduleInfo");
        super(moduleInfo);
        this.moduleInfo = moduleInfo;
    }

    @NotNull
    public final Module getIdeaModule() {
        return this.moduleInfo.getModule();
    }

    @Override
    @NotNull
    public KaSourceModuleKind getKind() {
        return this.moduleInfo.getSourceModuleKind();
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.getIdeaModule().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @Override
    @Nullable
    public String getStableModuleName() {
        Name name2 = this.moduleInfo.getStableName();
        return name2 != null ? name2.asString() : null;
    }

    @KaExperimentalApi
    public static /* synthetic */ void getStableModuleName$annotations() {
    }

    @NotNull
    public final ModuleId getModuleId() {
        return new ModuleId(this.getName());
    }

    @Override
    @NotNull
    protected List<KaModule> computeDirectRegularDependencies() {
        return ProjectModuleByModuleInfoKt.collectDependencies(this.moduleInfo, ModuleDependencyCollector.CollectionMode.COLLECT_NON_IGNORED);
    }

    @Override
    @NotNull
    public GlobalSearchScope getBaseContentScope() {
        return this.moduleInfo.getContentScope();
    }

    @Override
    @NotNull
    public LanguageVersionSettings getLanguageVersionSettings() {
        return LanguageVersionSettingsProviderUtils.getLanguageVersionSettings(this.moduleInfo.getModule());
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.getIdeaModule().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return project;
    }
}

