/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.SdkInfoBase;
import org.jetbrains.kotlin.idea.base.projectStructure.KotlinBaseProjectStructureBundle;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.ModuleOrigin;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.SdkScope;
import org.jetbrains.kotlin.idea.base.projectStructure.scope.PoweredLibraryScopeBaseKt;
import org.jetbrains.kotlin.idea.base.util.K1ModeProjectStructureApi;
import org.jetbrains.kotlin.idea.framework.KotlinSdkType;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.CommonPlatforms;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatforms;
import org.jetbrains.kotlin.resolve.PlatformDependentAnalyzerServices;
import org.jetbrains.kotlin.resolve.jvm.platform.JvmPlatformAnalyzerServices;

@K1ModeProjectStructureApi
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00010\"H\u0016J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00010$H\u0016J\t\u0010-\u001a\u00020\u0004H\u00c6\u0003J\t\u0010.\u001a\u00020\u0006H\u00c6\u0003J\u001d\u0010/\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0014\u00100\u001a\u0002012\b\u00102\u001a\u0004\u0018\u000103H\u00d6\u0083\u0004J\n\u00104\u001a\u000205H\u00d6\u0081\u0004J\n\u00106\u001a\u00020\u000fH\u00d6\u0081\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010%\u001a\u00020&8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0014\u0010)\u001a\u00020*8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,\u00a8\u00067"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/SdkInfo;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/IdeaModuleInfo;", "Lorg/jetbrains/kotlin/analyzer/SdkInfoBase;", "project", "Lcom/intellij/openapi/project/Project;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/projectRoots/Sdk;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSdk", "()Lcom/intellij/openapi/projectRoots/Sdk;", "topClassesPackageNames", "", "", "entriesVirtualFileSystems", "Lcom/intellij/openapi/vfs/newvfs/NewVirtualFileSystem;", "moduleOrigin", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/ModuleOrigin;", "getModuleOrigin", "()Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/ModuleOrigin;", "name", "Lorg/jetbrains/kotlin/name/Name;", "getName", "()Lorg/jetbrains/kotlin/name/Name;", "displayedName", "getDisplayedName", "()Ljava/lang/String;", "contentScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "getContentScope", "()Lcom/intellij/psi/search/GlobalSearchScope;", "dependencies", "", "dependenciesWithoutSelf", "Lkotlin/sequences/Sequence;", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getPlatform", "()Lorg/jetbrains/kotlin/platform/TargetPlatform;", "analyzerServices", "Lorg/jetbrains/kotlin/resolve/PlatformDependentAnalyzerServices;", "getAnalyzerServices", "()Lorg/jetbrains/kotlin/resolve/PlatformDependentAnalyzerServices;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.kotlin.base.projectStructure"})
public final class SdkInfo
implements IdeaModuleInfo,
SdkInfoBase {
    @NotNull
    private final Project project;
    @NotNull
    private final Sdk sdk;
    @Nullable
    private final Set<String> topClassesPackageNames;
    @Nullable
    private final Set<NewVirtualFileSystem> entriesVirtualFileSystems;
    @NotNull
    private final Name name;

    public SdkInfo(@NotNull Project project, @NotNull Sdk sdk) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        this.project = project;
        this.sdk = sdk;
        Object object = ActionsKt.runReadAction(() -> SdkInfo._init_$lambda$0(this));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction(...)");
        VirtualFile[] classes = (VirtualFile[])object;
        this.topClassesPackageNames = PoweredLibraryScopeBaseKt.calculateTopPackageNames(classes);
        this.entriesVirtualFileSystems = PoweredLibraryScopeBaseKt.calculateEntriesVirtualFileSystems(classes);
        Name name2 = Name.special((String)("<sdk " + this.sdk.getName() + ">"));
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"special(...)");
        this.name = name2;
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @NotNull
    public final Sdk getSdk() {
        return this.sdk;
    }

    @Override
    @NotNull
    public ModuleOrigin getModuleOrigin() {
        return ModuleOrigin.LIBRARY;
    }

    @NotNull
    public Name getName() {
        return this.name;
    }

    @NotNull
    public String getDisplayedName() {
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)this.sdk.getName(), (String)"getName(...)");
        return KotlinBaseProjectStructureBundle.message("sdk.0", objectArray);
    }

    @Override
    @NotNull
    public GlobalSearchScope getContentScope() {
        return (GlobalSearchScope)new SdkScope(this.getProject(), this.topClassesPackageNames, this.entriesVirtualFileSystems, this.sdk);
    }

    @Override
    @NotNull
    public List<IdeaModuleInfo> dependencies() {
        return CollectionsKt.listOf((Object)this);
    }

    @Override
    @NotNull
    public Sequence<IdeaModuleInfo> dependenciesWithoutSelf() {
        return SequencesKt.emptySequence();
    }

    @NotNull
    public TargetPlatform getPlatform() {
        return this.sdk.getSdkType() instanceof KotlinSdkType ? CommonPlatforms.INSTANCE.getDefaultCommonPlatform() : JvmPlatforms.INSTANCE.getUnspecifiedJvmPlatform();
    }

    @NotNull
    public PlatformDependentAnalyzerServices getAnalyzerServices() {
        return (PlatformDependentAnalyzerServices)JvmPlatformAnalyzerServices.INSTANCE;
    }

    @NotNull
    public final Project component1() {
        return this.project;
    }

    @NotNull
    public final Sdk component2() {
        return this.sdk;
    }

    @NotNull
    public final SdkInfo copy(@NotNull Project project, @NotNull Sdk sdk) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        return new SdkInfo(project, sdk);
    }

    public static /* synthetic */ SdkInfo copy$default(SdkInfo sdkInfo, Project project, Sdk sdk, int n, Object object) {
        if ((n & 1) != 0) {
            project = sdkInfo.project;
        }
        if ((n & 2) != 0) {
            sdk = sdkInfo.sdk;
        }
        return sdkInfo.copy(project, sdk);
    }

    @NotNull
    public String toString() {
        return "SdkInfo(project=" + this.project + ", sdk=" + this.sdk + ")";
    }

    public int hashCode() {
        int result2 = this.project.hashCode();
        result2 = result2 * 31 + this.sdk.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SdkInfo)) {
            return false;
        }
        SdkInfo sdkInfo = (SdkInfo)other;
        if (!Intrinsics.areEqual((Object)this.project, (Object)sdkInfo.project)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.sdk, (Object)sdkInfo.sdk);
    }

    private static final VirtualFile[] _init_$lambda$0(SdkInfo this$0) {
        return this$0.sdk.getRootProvider().getFiles(OrderRootType.CLASSES);
    }
}

