/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.projectStructure.scope;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.projectStructure.KotlinBaseProjectStructureBundle;
import org.jetbrains.kotlin.idea.base.projectStructure.scope.AbstractVirtualFileRootsScope;
import org.jetbrains.kotlin.idea.base.projectStructure.scope.CombinableSourceAndClassRootsScope;
import org.jetbrains.kotlin.idea.base.projectStructure.scope.ModuleSourcesScopeKt;
import org.jetbrains.kotlin.idea.base.projectStructure.scope.RootUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0007\u0018\u0000 '2\u00020\u00012\u00020\u0002:\u0002&'B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001a\u001a\u00020\u000bH\u0014J\u0010\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u0004H\u0016J\b\u0010\u001d\u001a\u00020\u000fH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0014\u0010 \u001a\u00020\u000f2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0096\u0082\u0004J\b\u0010#\u001a\u00020$H\u0014J\n\u0010%\u001a\u00020\u001fH\u0096\u0080\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/scope/ModuleSourcesScope;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/scope/AbstractVirtualFileRootsScope;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/scope/CombinableSourceAndClassRootsScope;", "module", "Lcom/intellij/openapi/module/Module;", "sourceRootKind", "Lorg/jetbrains/kotlin/idea/base/projectStructure/scope/ModuleSourcesScope$SourceRootKind;", "<init>", "(Lcom/intellij/openapi/module/Module;Lorg/jetbrains/kotlin/idea/base/projectStructure/scope/ModuleSourcesScope$SourceRootKind;)V", "roots", "Lit/unimi/dsi/fastutil/objects/Object2IntMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "getRoots", "()Lit/unimi/dsi/fastutil/objects/Object2IntMap;", "isEmpty", "", "modules", "", "getModules", "()Ljava/util/Set;", "includesLibraryClassRoots", "getIncludesLibraryClassRoots", "()Z", "includesLibrarySourceRoots", "getIncludesLibrarySourceRoots", "getFileRoot", "file", "isSearchInModuleContent", "aModule", "isSearchInLibraries", "getDisplayName", "", "equals", "other", "", "calcHashCode", "", "toString", "SourceRootKind", "Companion", "intellij.kotlin.base.projectStructure"})
@ApiStatus.Internal
public final class ModuleSourcesScope
extends AbstractVirtualFileRootsScope
implements CombinableSourceAndClassRootsScope {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Module module;
    @NotNull
    private final SourceRootKind sourceRootKind;
    @NotNull
    private final Object2IntMap<VirtualFile> roots;

    public ModuleSourcesScope(@NotNull Module module, @NotNull SourceRootKind sourceRootKind) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)((Object)sourceRootKind), (String)"sourceRootKind");
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        super(project);
        this.module = module;
        this.sourceRootKind = sourceRootKind;
        this.roots = RootUtilsKt.toObject2IndexMap(ModuleSourcesScopeKt.access$calculateRootsSet(this.module, this.sourceRootKind));
    }

    @Override
    @NotNull
    public Object2IntMap<VirtualFile> getRoots() {
        return this.roots;
    }

    public final boolean isEmpty() {
        return this.getRoots().isEmpty();
    }

    @Override
    @NotNull
    public Set<Module> getModules() {
        return SetsKt.setOf((Object)this.module);
    }

    @Override
    public boolean getIncludesLibraryClassRoots() {
        return false;
    }

    @Override
    public boolean getIncludesLibrarySourceRoots() {
        return false;
    }

    @Override
    @Nullable
    protected VirtualFile getFileRoot(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.getMyProjectFileIndex().getModuleSourceOrLibraryClassesRoot(file);
    }

    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        Intrinsics.checkNotNullParameter((Object)aModule, (String)"aModule");
        return Intrinsics.areEqual((Object)aModule, (Object)this.module);
    }

    public boolean isSearchInLibraries() {
        return false;
    }

    @NotNull
    public String getDisplayName() {
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)this.module.getName(), (String)"getName(...)");
        return KotlinBaseProjectStructureBundle.message("module.sources.scope.0", objectArray);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof ModuleSourcesScope)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.module, (Object)((ModuleSourcesScope)other).module) && this.sourceRootKind == ((ModuleSourcesScope)other).sourceRootKind;
    }

    protected int calcHashCode() {
        return this.sourceRootKind.hashCode() + 31 * this.module.hashCode();
    }

    @NotNull
    public String toString() {
        return this.sourceRootKind + " sources of module:" + this.module.getName();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/scope/ModuleSourcesScope$Companion;", "", "<init>", "()V", "production", "Lorg/jetbrains/kotlin/idea/base/projectStructure/scope/ModuleSourcesScope;", "module", "Lcom/intellij/openapi/module/Module;", "tests", "intellij.kotlin.base.projectStructure"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ModuleSourcesScope production(@NotNull Module module) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            return new ModuleSourcesScope(module, SourceRootKind.PRODUCTION);
        }

        @NotNull
        public final ModuleSourcesScope tests(@NotNull Module module) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            return new ModuleSourcesScope(module, SourceRootKind.TESTS);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/scope/ModuleSourcesScope$SourceRootKind;", "", "<init>", "(Ljava/lang/String;I)V", "PRODUCTION", "TESTS", "intellij.kotlin.base.projectStructure"})
    public static final class SourceRootKind
    extends Enum<SourceRootKind> {
        public static final /* enum */ SourceRootKind PRODUCTION = new SourceRootKind();
        public static final /* enum */ SourceRootKind TESTS = new SourceRootKind();
        private static final /* synthetic */ SourceRootKind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static SourceRootKind[] values() {
            return (SourceRootKind[])$VALUES.clone();
        }

        public static SourceRootKind valueOf(String value) {
            return Enum.valueOf(SourceRootKind.class, value);
        }

        @NotNull
        public static EnumEntries<SourceRootKind> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = sourceRootKindArray = new SourceRootKind[]{SourceRootKind.PRODUCTION, SourceRootKind.TESTS};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

