/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.util.caching;

import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.util.ConcurrencyUtil;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u00020\u0002B\u001b\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J'\u0010\b\u001a\u00028\u00012\u0006\u0010\t\u001a\u00028\u00002\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0015\u0010\u0010\u001a\u0004\u0018\u00018\u00012\u0006\u0010\t\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0011J\u0006\u0010\u0012\u001a\u00020\u0013R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/base/util/caching/ConcurrentFactoryCache;", "Key", "", "Value", "storage", "Ljava/util/concurrent/ConcurrentMap;", "<init>", "(Ljava/util/concurrent/ConcurrentMap;)V", "get", "key", "factory", "Lkotlin/Function1;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "contains", "", "(Ljava/lang/Object;)Z", "remove", "(Ljava/lang/Object;)Ljava/lang/Object;", "clear", "", "intellij.kotlin.base.util"})
@ApiStatus.Internal
public final class ConcurrentFactoryCache<Key, Value> {
    @NotNull
    private final ConcurrentMap<Key, Value> storage;

    public ConcurrentFactoryCache(@NotNull ConcurrentMap<Key, Value> storage) {
        Intrinsics.checkNotNullParameter(storage, (String)"storage");
        this.storage = storage;
    }

    @NotNull
    public final Value get(@NotNull Key key, @NotNull Function1<? super Key, ? extends Value> factory2) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(factory2, (String)"factory");
        ConcurrentMap<Key, Value> storage = this.storage;
        Object value = storage.get(key);
        if (value == null) {
            RecursionGuard.StackStamp stackStamp = RecursionManager.markStack();
            Intrinsics.checkNotNullExpressionValue((Object)stackStamp, (String)"markStack(...)");
            RecursionGuard.StackStamp stamp = stackStamp;
            value = factory2.invoke(key);
            if (stamp.mayCacheNow()) {
                value = ConcurrencyUtil.cacheOrGet(storage, key, value);
            }
        }
        return (Value)value;
    }

    public final boolean contains(@NotNull Key key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return this.storage.containsKey(key);
    }

    @Nullable
    public final Value remove(@NotNull Key key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return (Value)this.storage.remove(key);
    }

    public final void clear() {
        this.storage.clear();
    }
}

