/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.idea.caches.ImplicitPackagePrefixCache;
import org.jetbrains.kotlin.idea.util.FileUtils;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtilKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\bJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\nH\u0007J\r\u0010\u0012\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0013J\"\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000b0\t2\u0006\u0010\u000e\u001a\u00020\bH\u0002J:\u0010\u0015\u001a\u00020\u0010*\u0018\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000b0\tj\u0002`\f2\u0006\u0010\u0016\u001a\u00020\b2\u000e\b\u0002\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J@\u0010\u001a\u001a\u00020\u001b*\u0018\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000b0\tj\u0002`\f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J*\u0010\u001e\u001a\u00020\u0010*\u0018\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000b0\tj\u0002`\f2\u0006\u0010\u001f\u001a\u00020\bH\u0002J8\u0010 \u001a\u00020\u0010*\u0018\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000b0\tj\u0002`\f2\u0006\u0010\u001f\u001a\u00020\u001d2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\u0015\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020#H\u0000\u00a2\u0006\u0002\b$J\u0012\u0010%\u001a\u00020\u00102\b\u0010\u001f\u001a\u0004\u0018\u00010\bH\u0002J\u0012\u0010&\u001a\u00020\u00102\b\u0010\u001f\u001a\u0004\u0018\u00010\bH\u0002J\u0015\u0010!\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b$R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\u0006\u001a$\u0012\u0004\u0012\u00020\b\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000b0\tj\u0002`\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/idea/caches/ImplicitPackagePrefixCache;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "implicitPackageCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "", "Lorg/jetbrains/kotlin/name/FqName;", "", "Lorg/jetbrains/kotlin/idea/caches/ImplicitPackageData;", "getPrefix", "sourceRoot", "setPrefix", "", "fqName", "clear", "clear$intellij_kotlin_base_analysis", "analyzeImplicitPackagePrefixes", "addFile", "ktFile", "topDirectories", "", "", "addPsiFile", "", "psiFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "removeFile", "file", "updateFile", "update", "event", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "update$intellij_kotlin_base_analysis", "checkNewFileInSourceRoot", "checkDeletedFileInSourceRoot", "intellij.kotlin.base.analysis"})
@SourceDebugExtension(value={"SMAP\nPerModulePackageCacheService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerModulePackageCacheService.kt\norg/jetbrains/kotlin/idea/caches/ImplicitPackagePrefixCache\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,530:1\n72#2,2:531\n72#2,2:534\n1#3:533\n1#3:536\n1586#4:537\n1661#4,3:538\n1849#4,3:541\n383#5,7:544\n*S KotlinDebug\n*F\n+ 1 PerModulePackageCacheService.kt\norg/jetbrains/kotlin/idea/caches/ImplicitPackagePrefixCache\n*L\n122#1:531,2\n128#1:534,2\n122#1:533\n128#1:536\n185#1:537\n185#1:538,3\n191#1:541,3\n195#1:544,7\n*E\n"})
public final class ImplicitPackagePrefixCache {
    @NotNull
    private final Project project;
    @NotNull
    private final ConcurrentHashMap<VirtualFile, Map<FqName, List<VirtualFile>>> implicitPackageCache;

    public ImplicitPackagePrefixCache(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.implicitPackageCache = new ConcurrentHashMap();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final FqName getPrefix(@NotNull VirtualFile sourceRoot) {
        Map implicitPackageMap;
        FqName fqName2;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)sourceRoot, (String)"sourceRoot");
        ConcurrentMap concurrentMap = this.implicitPackageCache;
        VirtualFile key$iv = sourceRoot;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key$iv);
        if (object == null) {
            boolean bl = false;
            Map<FqName, List<VirtualFile>> default$iv = this.analyzeImplicitPackagePrefixes(sourceRoot);
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        if ((fqName2 = (FqName)CollectionsKt.singleOrNull((Iterable)(implicitPackageMap = (Map)object).keySet())) == null) {
            fqName2 = FqName.ROOT;
        }
        return fqName2;
    }

    /*
     * WARNING - void declaration
     */
    @TestOnly
    public final void setPrefix(@NotNull VirtualFile sourceRoot, @NotNull FqName fqName2) {
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)sourceRoot, (String)"sourceRoot");
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        ConcurrentMap concurrentMap = this.implicitPackageCache;
        VirtualFile key$iv = sourceRoot;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key$iv);
        if (object == null) {
            boolean bl = false;
            Map<FqName, List<VirtualFile>> default$iv = this.analyzeImplicitPackagePrefixes(sourceRoot);
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Map implicitPackageMap = (Map)object;
        List toMutableList = (List)((Map.Entry)CollectionsKt.first((Iterable)implicitPackageMap.entrySet())).getValue();
        Map map2 = this.implicitPackageCache;
        Object object2 = new Pair[]{TuplesKt.to((Object)fqName2, (Object)toMutableList)};
        object2 = MapsKt.mutableMapOf((Pair[])object2);
        map2.put(sourceRoot, object2);
    }

    public final void clear$intellij_kotlin_base_analysis() {
        this.implicitPackageCache.clear();
    }

    private final Map<FqName, List<VirtualFile>> analyzeImplicitPackagePrefixes(VirtualFile sourceRoot) {
        Map result2 = new LinkedHashMap();
        VirtualFileVisitor.Option[] optionArray = new VirtualFileVisitor.Option[]{VirtualFileVisitor.limit((int)10)};
        VirtualFileVisitor.Option[] optionArray2 = optionArray;
        VfsUtilCore.visitChildrenRecursively((VirtualFile)sourceRoot, (VirtualFileVisitor)((VirtualFileVisitor)new VirtualFileVisitor<Object>(this, (Map<FqName, List<VirtualFile>>)result2, sourceRoot, optionArray2){
            final /* synthetic */ ImplicitPackagePrefixCache this$0;
            final /* synthetic */ Map<FqName, List<VirtualFile>> $result;
            final /* synthetic */ VirtualFile $sourceRoot;
            {
                this.this$0 = $receiver;
                this.$result = $result;
                this.$sourceRoot = $sourceRoot;
                super($super_call_param$1);
            }

            public VirtualFileVisitor.Result visitFileEx(VirtualFile file) {
                VirtualFile $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                ProgressManager.checkCanceled();
                if (!file.isDirectory()) {
                    VirtualFileVisitor.Result result2 = VirtualFileVisitor.CONTINUE;
                    Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"CONTINUE");
                    return result2;
                }
                VirtualFile[] virtualFileArray = file.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
                Object[] $this$filter$iv = virtualFileArray;
                boolean $i$f$filter = false;
                Object[] objectArray = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (void element$iv$iv : $this$filterTo$iv$iv) {
                    VirtualFile p0 = (VirtualFile)element$iv$iv;
                    boolean bl = false;
                    if (!FileUtils.isKotlinFileType(p0)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List ktFiles = (List)destination$iv$iv;
                if (ktFiles.isEmpty()) {
                    VirtualFileVisitor.Result result3 = VirtualFileVisitor.CONTINUE;
                    Intrinsics.checkNotNullExpressionValue((Object)result3, (String)"CONTINUE");
                    return result3;
                }
                VirtualFile virtualFile = file;
                $this$filterTo$iv$iv = this.$sourceRoot;
                VirtualFile it = virtualFile;
                boolean bl = false;
                List topDirectories = CollectionsKt.reversed((Iterable)SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.generateSequence((Object)(!Intrinsics.areEqual((Object)it, (Object)$this$filterTo$iv$iv) ? virtualFile : null), arg_0 -> analyzeImplicitPackagePrefixes.1.visitFileEx$lambda$1(this.$sourceRoot, arg_0)), analyzeImplicitPackagePrefixes.1::visitFileEx$lambda$2)));
                for (VirtualFile ktFile2 : ktFiles) {
                    Intrinsics.checkNotNull((Object)ktFile2);
                    ImplicitPackagePrefixCache.access$addFile(this.this$0, this.$result, ktFile2, topDirectories);
                }
                VirtualFileVisitor.Result result4 = VirtualFileVisitor.SKIP_CHILDREN;
                Intrinsics.checkNotNullExpressionValue((Object)result4, (String)"SKIP_CHILDREN");
                return result4;
            }

            private static final VirtualFile visitFileEx$lambda$1(VirtualFile $sourceRoot, VirtualFile f) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)f, (String)"f");
                VirtualFile virtualFile = f.getParent();
                if (virtualFile != null) {
                    VirtualFile virtualFile2;
                    VirtualFile it = virtualFile2 = virtualFile;
                    boolean bl = false;
                    object = !Intrinsics.areEqual((Object)it, (Object)$sourceRoot) ? virtualFile2 : null;
                } else {
                    object = null;
                }
                return object;
            }

            private static final String visitFileEx$lambda$2(VirtualFile it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.getName();
            }
        }));
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addFile(Map<FqName, List<VirtualFile>> $this$addFile, VirtualFile ktFile2, List<String> topDirectories) {
        Map<FqName, List<VirtualFile>> map2 = $this$addFile;
        synchronized (map2) {
            boolean bl = false;
            PsiFile psiFile = PsiManager.getInstance((Project)this.project).findFile(ktFile2);
            KtFile ktFile3 = psiFile instanceof KtFile ? (KtFile)psiFile : null;
            if (ktFile3 == null) {
                return;
            }
            KtFile psiFile2 = ktFile3;
            boolean bl2 = this.addPsiFile($this$addFile, psiFile2, ktFile2, topDirectories);
        }
    }

    static /* synthetic */ void addFile$default(ImplicitPackagePrefixCache implicitPackagePrefixCache, Map map2, VirtualFile virtualFile, List list2, int n, Object object) {
        if ((n & 2) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        implicitPackagePrefixCache.addFile(map2, virtualFile, list2);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean addPsiFile(Map<FqName, List<VirtualFile>> $this$addPsiFile, KtFile psiFile, VirtualFile ktFile2, List<String> topDirectories) {
        Object object;
        void $this$getOrPut$iv;
        Object pathSegments;
        FqName fqName2;
        FqName packageFqName = psiFile.getPackageFqName();
        if (topDirectories.isEmpty()) {
            fqName2 = packageFqName;
        } else {
            void $this$fold$iv;
            void $this$mapTo$iv$iv;
            pathSegments = packageFqName.pathSegments();
            Iterable $this$map$iv = CollectionsKt.takeLast((List)pathSegments, (int)topDirectories.size());
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Name name2 = (Name)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.asString());
            }
            List lastSegments = (List)destination$iv$iv;
            if (!Intrinsics.areEqual((Object)lastSegments, topDirectories)) {
                return false;
            }
            $this$map$iv = CollectionsKt.dropLast((List)pathSegments, (int)topDirectories.size());
            FqName initial$iv = FqName.ROOT;
            boolean $i$f$fold = false;
            FqName accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void segment;
                Object item$iv$iv;
                item$iv$iv = (Name)element$iv;
                FqName prefix2 = accumulator$iv;
                boolean bl = false;
                accumulator$iv = prefix2.child((Name)segment);
            }
            fqName2 = accumulator$iv;
        }
        FqName key = fqName2;
        pathSegments = $this$addPsiFile;
        FqName key$iv = key;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            List answer$iv = new ArrayList();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return ((List)object).add(ktFile2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeFile(Map<FqName, List<VirtualFile>> $this$removeFile, VirtualFile file) {
        Map<FqName, List<VirtualFile>> map2 = $this$removeFile;
        synchronized (map2) {
            boolean bl = false;
            for (Map.Entry<FqName, List<VirtualFile>> entry : $this$removeFile.entrySet()) {
                FqName key = entry.getKey();
                List<VirtualFile> value = entry.getValue();
                if (!value.remove(file)) continue;
                if (!value.isEmpty()) break;
                $this$removeFile.remove(key);
                break;
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateFile(Map<FqName, List<VirtualFile>> $this$updateFile, KtFile file, List<String> topDirectories) {
        Map<FqName, List<VirtualFile>> map2 = $this$updateFile;
        synchronized (map2) {
            boolean bl = false;
            VirtualFile virtualFile = file.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
            this.removeFile($this$updateFile, virtualFile);
            VirtualFile virtualFile2 = file.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getVirtualFile(...)");
            boolean bl2 = this.addPsiFile($this$updateFile, file, virtualFile2, topDirectories);
        }
    }

    public final void update$intellij_kotlin_base_analysis(@NotNull VFileEvent event) {
        block3: {
            VFileEvent vFileEvent;
            block5: {
                block4: {
                    block2: {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        vFileEvent = event;
                        if (!(vFileEvent instanceof VFileCreateEvent)) break block2;
                        this.checkNewFileInSourceRoot(((VFileCreateEvent)event).getFile());
                        break block3;
                    }
                    if (!(vFileEvent instanceof VFileDeleteEvent)) break block4;
                    this.checkDeletedFileInSourceRoot(((VFileDeleteEvent)event).getFile());
                    break block3;
                }
                if (!(vFileEvent instanceof VFileCopyEvent)) break block5;
                VirtualFile virtualFile = ((VFileCopyEvent)event).getNewParent();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getNewParent(...)");
                VirtualFile newParent = virtualFile;
                if (!newParent.isValid()) break block3;
                this.checkNewFileInSourceRoot(newParent.findChild(((VFileCopyEvent)event).getNewChildName()));
                break block3;
            }
            if (!(vFileEvent instanceof VFileMoveEvent)) break block3;
            this.checkNewFileInSourceRoot(((VFileMoveEvent)event).getFile());
            VirtualFile virtualFile = ((VFileMoveEvent)event).getOldParent();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getOldParent(...)");
            if (Intrinsics.areEqual((Object)ProjectRootsUtilKt.getSourceRoot(virtualFile, this.project), (Object)((VFileMoveEvent)event).getOldParent())) {
                Map<FqName, List<VirtualFile>> map2 = this.implicitPackageCache.get(((VFileMoveEvent)event).getOldParent());
                if (map2 != null) {
                    VirtualFile virtualFile2 = ((VFileMoveEvent)event).getFile();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getFile(...)");
                    this.removeFile(map2, virtualFile2);
                }
            }
        }
    }

    private final void checkNewFileInSourceRoot(VirtualFile file) {
        block2: {
            if (file == null) {
                return;
            }
            if (!Intrinsics.areEqual((Object)ProjectRootsUtilKt.getSourceRoot(file, this.project), (Object)file.getParent())) break block2;
            Map<FqName, List<VirtualFile>> map2 = this.implicitPackageCache.get(file.getParent());
            if (map2 != null) {
                ImplicitPackagePrefixCache.addFile$default(this, map2, file, null, 2, null);
            }
        }
    }

    private final void checkDeletedFileInSourceRoot(VirtualFile file) {
        block2: {
            VirtualFile directory;
            VirtualFile virtualFile = file;
            Object object = directory = virtualFile != null ? virtualFile.getParent() : null;
            if (directory == null || !directory.isValid()) {
                return;
            }
            if (!Intrinsics.areEqual((Object)ProjectRootsUtilKt.getSourceRoot(directory, this.project), (Object)directory)) break block2;
            Map<FqName, List<VirtualFile>> map2 = this.implicitPackageCache.get(directory);
            if (map2 != null) {
                this.removeFile(map2, file);
            }
        }
    }

    public final void update$intellij_kotlin_base_analysis(@NotNull KtFile ktFile2) {
        Intrinsics.checkNotNullParameter((Object)ktFile2, (String)"ktFile");
        VirtualFile virtualFile = ProjectRootsUtilKt.getSourceRoot((PsiFileSystemItem)ktFile2);
        if (virtualFile == null) {
            return;
        }
        VirtualFile sourceRoot = virtualFile;
        VirtualFile virtualFile2 = ktFile2.getVirtualFile();
        if (virtualFile2 == null) {
            return;
        }
        VirtualFile file = virtualFile2;
        List topDirectories = new ArrayList();
        while (!Intrinsics.areEqual((Object)file, (Object)sourceRoot) && file != null) {
            VirtualFile parent = file.getParent();
            if (Intrinsics.areEqual((Object)parent, (Object)sourceRoot)) {
                Map<FqName, List<VirtualFile>> map2 = this.implicitPackageCache.get(parent);
                if (map2 != null) {
                    this.updateFile(map2, ktFile2, CollectionsKt.asReversedMutable((List)topDirectories));
                }
                break;
            }
            ((Collection)topDirectories).add(parent.getName());
            file = parent;
        }
    }

    public static final /* synthetic */ void access$addFile(ImplicitPackagePrefixCache $this, Map $receiver, VirtualFile ktFile2, List topDirectories) {
        $this.addFile($receiver, ktFile2, topDirectories);
    }
}

