/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.resolve;

import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.resolve.diagnostics.DiagnosticsElementsCache;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0000H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/caches/resolve/MergedDiagnostics;", "Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;", "diagnostics", "", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "noSuppressionDiagnostics", "modificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "<init>", "(Ljava/util/Collection;Ljava/util/Collection;Lcom/intellij/openapi/util/ModificationTracker;)V", "getDiagnostics", "()Ljava/util/Collection;", "getNoSuppressionDiagnostics", "getModificationTracker", "()Lcom/intellij/openapi/util/ModificationTracker;", "elementsCache", "Lorg/jetbrains/kotlin/resolve/diagnostics/DiagnosticsElementsCache;", "all", "forElement", "", "psiElement", "Lcom/intellij/psi/PsiElement;", "noSuppression", "kotlin.base.fe10.analysis"})
final class MergedDiagnostics
implements Diagnostics {
    @NotNull
    private final Collection<Diagnostic> diagnostics;
    @NotNull
    private final Collection<Diagnostic> noSuppressionDiagnostics;
    @NotNull
    private final ModificationTracker modificationTracker;
    @NotNull
    private final DiagnosticsElementsCache elementsCache;

    public MergedDiagnostics(@NotNull Collection<? extends Diagnostic> diagnostics, @NotNull Collection<? extends Diagnostic> noSuppressionDiagnostics, @NotNull ModificationTracker modificationTracker) {
        Intrinsics.checkNotNullParameter(diagnostics, (String)"diagnostics");
        Intrinsics.checkNotNullParameter(noSuppressionDiagnostics, (String)"noSuppressionDiagnostics");
        Intrinsics.checkNotNullParameter((Object)modificationTracker, (String)"modificationTracker");
        this.diagnostics = diagnostics;
        this.noSuppressionDiagnostics = noSuppressionDiagnostics;
        this.modificationTracker = modificationTracker;
        this.elementsCache = new DiagnosticsElementsCache((Diagnostics)this, MergedDiagnostics::elementsCache$lambda$0);
    }

    @NotNull
    public final Collection<Diagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    @NotNull
    public final Collection<Diagnostic> getNoSuppressionDiagnostics() {
        return this.noSuppressionDiagnostics;
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        return this.modificationTracker;
    }

    @NotNull
    public Collection<Diagnostic> all() {
        return this.diagnostics;
    }

    @NotNull
    public Collection<Diagnostic> forElement(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        Collection collection = this.elementsCache.getDiagnostics(psiElement);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getDiagnostics(...)");
        return collection;
    }

    @NotNull
    public MergedDiagnostics noSuppression() {
        return this.noSuppressionDiagnostics.isEmpty() ? this : new MergedDiagnostics(this.noSuppressionDiagnostics, CollectionsKt.emptyList(), this.getModificationTracker());
    }

    private static final Boolean elementsCache$lambda$0(Diagnostic it) {
        return true;
    }
}

