/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.trackers;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.caches.project.CacheUtilsKt;
import org.jetbrains.kotlin.idea.caches.trackers.KotlinCodeBlockModificationListener;
import org.jetbrains.kotlin.idea.caches.trackers.ModuleDependencyProviderExtension;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u0000 \u00142\u00020\u0001:\u0003\u0013\u0014\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR!\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/caches/trackers/KotlinModuleOutOfCodeBlockModificationTracker;", "Lcom/intellij/openapi/util/ModificationTracker;", "module", "Lcom/intellij/openapi/module/Module;", "<init>", "(Lcom/intellij/openapi/module/Module;)V", "kotlinOutOfCodeBlockTracker", "updater", "Lorg/jetbrains/kotlin/idea/caches/trackers/KotlinModuleOutOfCodeBlockModificationTracker$Updater;", "getUpdater", "()Lorg/jetbrains/kotlin/idea/caches/trackers/KotlinModuleOutOfCodeBlockModificationTracker$Updater;", "dependencies", "Ljava/util/HashSet;", "getDependencies", "()Ljava/util/HashSet;", "dependencies$delegate", "Lkotlin/Lazy;", "getModificationCount", "", "KeyForCachedDependencies", "Companion", "Updater", "kotlin.base.fe10.analysis"})
public final class KotlinModuleOutOfCodeBlockModificationTracker
implements ModificationTracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Module module;
    @NotNull
    private final ModificationTracker kotlinOutOfCodeBlockTracker;
    @NotNull
    private final Lazy dependencies$delegate;

    public KotlinModuleOutOfCodeBlockModificationTracker(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        this.module = module;
        Project project = this.module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.kotlinOutOfCodeBlockTracker = KotlinCodeBlockModificationListener.Companion.getInstance(project).getKotlinOutOfCodeBlockTracker();
        this.dependencies$delegate = LazyKt.lazy(() -> KotlinModuleOutOfCodeBlockModificationTracker.dependencies_delegate$lambda$0(this));
    }

    private final Updater getUpdater() {
        Project project = this.module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return Companion.getUpdaterInstance$kotlin_base_fe10_analysis(project);
    }

    private final HashSet<Module> getDependencies() {
        Lazy lazy = this.dependencies$delegate;
        return (HashSet)lazy.getValue();
    }

    public long getModificationCount() {
        long currentGlobalCount = this.kotlinOutOfCodeBlockTracker.getModificationCount();
        if (this.getUpdater().hasPerModuleModificationCounts$kotlin_base_fe10_analysis()) {
            long selfCount = this.getUpdater().getModificationCount(this.module);
            if (selfCount == currentGlobalCount) {
                return selfCount;
            }
            long maxCount = selfCount;
            Iterator<Module> iterator2 = this.getDependencies().iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
            Iterator<Module> iterator3 = iterator2;
            while (iterator3.hasNext()) {
                Module dependency;
                Intrinsics.checkNotNullExpressionValue((Object)iterator3.next(), (String)"next(...)");
                long depCount = this.getUpdater().getModificationCount(dependency);
                if (depCount == currentGlobalCount) {
                    return currentGlobalCount;
                }
                if (depCount <= maxCount) continue;
                maxCount = depCount;
            }
            return maxCount;
        }
        return currentGlobalCount;
    }

    private static final HashSet dependencies_delegate$lambda$0$0(Module $module) {
        HashSet modules2 = new HashSet();
        Processor processor2 = Processors.cancelableCollectProcessor((Collection)modules2);
        Intrinsics.checkNotNullExpressionValue((Object)processor2, (String)"cancelableCollectProcessor(...)");
        Processor processor3 = processor2;
        ModuleRootManager.getInstance((Module)$module).orderEntries().recursively().forEachModule(processor3);
        Project project = $module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ModuleDependencyProviderExtension.Companion.getInstance(project).processAdditionalDependencyModules($module, (Processor<Module>)processor3);
        return modules2;
    }

    private static final HashSet dependencies_delegate$lambda$0(KotlinModuleOutOfCodeBlockModificationTracker this$0) {
        Module module = this$0.module;
        return (HashSet)CacheUtilsKt.cacheByClassInvalidatingOnRootModifications(module, KeyForCachedDependencies.class, () -> KotlinModuleOutOfCodeBlockModificationTracker.dependencies_delegate$lambda$0$0(module));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/caches/trackers/KotlinModuleOutOfCodeBlockModificationTracker$Companion;", "", "<init>", "()V", "getUpdaterInstance", "Lorg/jetbrains/kotlin/idea/caches/trackers/KotlinModuleOutOfCodeBlockModificationTracker$Updater;", "project", "Lcom/intellij/openapi/project/Project;", "getUpdaterInstance$kotlin_base_fe10_analysis", "incrementModificationCountForAllModules", "", "getModificationCount", "", "module", "Lcom/intellij/openapi/module/Module;", "kotlin.base.fe10.analysis"})
    @SourceDebugExtension(value={"SMAP\nKotlinModuleOutOfCodeBlockModificationTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinModuleOutOfCodeBlockModificationTracker.kt\norg/jetbrains/kotlin/idea/caches/trackers/KotlinModuleOutOfCodeBlockModificationTracker$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,128:1\n30#2,2:129\n*S KotlinDebug\n*F\n+ 1 KotlinModuleOutOfCodeBlockModificationTracker.kt\norg/jetbrains/kotlin/idea/caches/trackers/KotlinModuleOutOfCodeBlockModificationTracker$Companion\n*L\n60#1:129,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Updater getUpdaterInstance$kotlin_base_fe10_analysis(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<Updater> serviceClass$iv = Updater.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (Updater)object;
        }

        public final void incrementModificationCountForAllModules(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.getUpdaterInstance$kotlin_base_fe10_analysis(project).incrementModificationCountForAllModules$kotlin_base_fe10_analysis();
        }

        @TestOnly
        public final long getModificationCount(@NotNull Module module) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Project project = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            return this.getUpdaterInstance$kotlin_base_fe10_analysis(project).getModificationCount(module);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/kotlin/idea/caches/trackers/KotlinModuleOutOfCodeBlockModificationTracker$KeyForCachedDependencies;", "", "<init>", "()V", "kotlin.base.fe10.analysis"})
    public static final class KeyForCachedDependencies {
        @NotNull
        public static final KeyForCachedDependencies INSTANCE = new KeyForCachedDependencies();

        private KeyForCachedDependencies() {
        }
    }

    @Service(value={Service.Level.PROJECT})
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\fH\u0007J\r\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0016J\r\u0010\u0017\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u0019J\u001d\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u001eJ\u0017\u0010\u001f\u001a\u00020\u00152\b\b\u0002\u0010 \u001a\u00020!H\u0000\u00a2\u0006\u0002\b\"J\b\u0010#\u001a\u00020\u0015H\u0002J\b\u0010$\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0011\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/idea/caches/trackers/KotlinModuleOutOfCodeBlockModificationTracker$Updater;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "kotlinOfOfCodeBlockTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "getKotlinOfOfCodeBlockTracker", "()Lcom/intellij/openapi/util/ModificationTracker;", "perModuleModCount", "", "Lcom/intellij/openapi/module/Module;", "", "lastAffectedModule", "lastAffectedModuleModCount", "perModuleChangesHighWatermark", "Ljava/lang/Long;", "getModificationCount", "module", "incrementModificationCountForAllModules", "", "incrementModificationCountForAllModules$kotlin_base_fe10_analysis", "hasPerModuleModificationCounts", "", "hasPerModuleModificationCounts$kotlin_base_fe10_analysis", "onKotlinPhysicalFileOutOfBlockChange", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "immediateUpdatesProcess", "onKotlinPhysicalFileOutOfBlockChange$kotlin_base_fe10_analysis", "onPsiModificationTrackerUpdate", "customIncrement", "", "onPsiModificationTrackerUpdate$kotlin_base_fe10_analysis", "clean", "dispose", "kotlin.base.fe10.analysis"})
    public static final class Updater
    implements Disposable {
        @NotNull
        private final Project project;
        @NotNull
        private final Map<Module, Long> perModuleModCount;
        @Nullable
        private Module lastAffectedModule;
        private long lastAffectedModuleModCount;
        @Nullable
        private Long perModuleChangesHighWatermark;

        public Updater(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
            this.perModuleModCount = new LinkedHashMap();
            this.lastAffectedModuleModCount = -1L;
        }

        private final ModificationTracker getKotlinOfOfCodeBlockTracker() {
            return KotlinCodeBlockModificationListener.Companion.getInstance(this.project).getKotlinOutOfCodeBlockTracker();
        }

        @ApiStatus.Internal
        public final long getModificationCount(@NotNull Module module) {
            long l;
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Long l2 = this.perModuleModCount.get(module);
            if (l2 != null) {
                l = l2;
            } else {
                Long l3 = this.perModuleChangesHighWatermark;
                l = l3 != null ? l3.longValue() : this.getKotlinOfOfCodeBlockTracker().getModificationCount();
            }
            return l;
        }

        public final void incrementModificationCountForAllModules$kotlin_base_fe10_analysis() {
            this.perModuleModCount.replaceAll((arg_0, arg_1) -> Updater.incrementModificationCountForAllModules$lambda$1(Updater::incrementModificationCountForAllModules$lambda$0, arg_0, arg_1));
        }

        public final boolean hasPerModuleModificationCounts$kotlin_base_fe10_analysis() {
            return this.perModuleChangesHighWatermark != null;
        }

        public final void onKotlinPhysicalFileOutOfBlockChange$kotlin_base_fe10_analysis(@NotNull KtFile ktFile2, boolean immediateUpdatesProcess) {
            Intrinsics.checkNotNullParameter((Object)ktFile2, (String)"ktFile");
            this.lastAffectedModule = ModuleUtil.findModuleForPsiElement((PsiElement)((PsiElement)ktFile2));
            this.lastAffectedModuleModCount = this.getKotlinOfOfCodeBlockTracker().getModificationCount();
            if (immediateUpdatesProcess) {
                this.onPsiModificationTrackerUpdate$kotlin_base_fe10_analysis(0);
            }
        }

        public final void onPsiModificationTrackerUpdate$kotlin_base_fe10_analysis(int customIncrement) {
            long newModCount = this.getKotlinOfOfCodeBlockTracker().getModificationCount();
            Module affectedModule = this.lastAffectedModule;
            if (affectedModule != null && newModCount == this.lastAffectedModuleModCount + (long)customIncrement) {
                if (this.perModuleChangesHighWatermark == null) {
                    this.perModuleChangesHighWatermark = this.lastAffectedModuleModCount;
                }
                this.perModuleModCount.put(affectedModule, newModCount);
            } else {
                this.clean();
            }
        }

        public static /* synthetic */ void onPsiModificationTrackerUpdate$kotlin_base_fe10_analysis$default(Updater updater2, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 0;
            }
            updater2.onPsiModificationTrackerUpdate$kotlin_base_fe10_analysis(n);
        }

        private final void clean() {
            this.perModuleChangesHighWatermark = null;
            this.lastAffectedModule = null;
            this.perModuleModCount.clear();
        }

        public void dispose() {
            this.clean();
        }

        private static final Long incrementModificationCountForAllModules$lambda$0(Module module, Long count) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"<unused var>");
            Intrinsics.checkNotNullParameter((Object)count, (String)"count");
            return count + 1L;
        }

        private static final Long incrementModificationCountForAllModules$lambda$1(Function2 $tmp0, Object p0, Object p1) {
            return (Long)$tmp0.invoke(p0, p1);
        }
    }
}

