/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.inspections.shared;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.ULong;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import kotlin.text.UStringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.base.KaConstantValue;
import org.jetbrains.kotlin.analysis.api.components.KaEvaluatorKt;
import org.jetbrains.kotlin.analysis.api.components.KaExpressionTypeProviderKt;
import org.jetbrains.kotlin.analysis.api.components.KaTypeInformationProviderKt;
import org.jetbrains.kotlin.analysis.api.components.KaTypeRelationChecker;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfoKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallableMemberCall;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.api.symbols.KaFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.idea.base.psi.IfThenUtilsKt;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.ConvertTwoComparisonsToRangeCheckQuickFix;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.utils.RangeInspectionUtilsKt;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinApplicableInspectionBase;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinModCommandQuickFix;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.ConstantUtilsKt;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.UtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0003$%&B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0003H\u0014J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u000e\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u0012H\u0002J\f\u0010\u0013\u001a\u00020\u000f*\u00020\u0012H\u0002J\u000e\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u0002H\u0002J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u0002H\u0016J'\u0010\u0017\u001a\u0004\u0018\u00010\u0007*\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u00020\u0018j\u0006\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0002\u0010\u001cJ\u001f\u0010\u001d\u001a\u0004\u0018\u00010\u0007*\u00020\u0012H\u0002R\u00020\u0018j\u0006\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0002\u0010\u001eJ\u001f\u0010\u001f\u001a\u0004\u0018\u00010\u0012*\u00020\u0012H\u0002R\u00020\u0018j\u0006\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0002\u0010 J\u0016\u0010!\u001a\u0004\u0018\u00010\u0003*\u00020\u00182\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u001e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020#2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0003H\u0014\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/ConvertTwoComparisonsToRangeCheckInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinApplicableInspectionBase$Simple;", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/ConvertTwoComparisonsToRangeCheckInspection$Context;", "<init>", "()V", "getProblemDescription", "", "element", "context", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "asComparison", "Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/ConvertTwoComparisonsToRangeCheckInspection$ComparisonData;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isSimple", "getPsiContext", "Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/ConvertTwoComparisonsToRangeCheckInspection$PsiContext;", "isApplicableByPsi", "renderConstantPlusOne", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "<unused var>", "expressionType", "Lorg/jetbrains/kotlin/analysis/api/types/KaType;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/analysis/api/types/KaType;)Ljava/lang/String;", "adjustLowerBoundForExclusive", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtExpression;)Ljava/lang/String;", "asDoubleConstantExpression", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtExpression;)Lorg/jetbrains/kotlin/psi/KtExpression;", "prepareContext", "createQuickFix", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinModCommandQuickFix;", "ComparisonData", "PsiContext", "Context", "kotlin.code-insight.inspections.shared"})
@SourceDebugExtension(value={"SMAP\nConvertTwoComparisonsToRangeCheckInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConvertTwoComparisonsToRangeCheckInspection.kt\norg/jetbrains/kotlin/idea/codeInsight/inspections/shared/ConvertTwoComparisonsToRangeCheckInspection\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 KotlinPsiModificationUtils.kt\norg/jetbrains/kotlin/idea/base/psi/KotlinPsiModificationUtils\n+ 5 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 6 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 7 KaSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KaSessionProvider\n*L\n1#1,317:1\n52#2:318\n52#2:319\n1#3:320\n21#4:321\n249#5:322\n30#6,2:323\n36#7,15:325\n*S KotlinDebug\n*F\n+ 1 ConvertTwoComparisonsToRangeCheckInspection.kt\norg/jetbrains/kotlin/idea/codeInsight/inspections/shared/ConvertTwoComparisonsToRangeCheckInspection\n*L\n99#1:318\n100#1:319\n195#1:321\n274#1:322\n282#1:323,2\n282#1:325,15\n*E\n"})
public final class ConvertTwoComparisonsToRangeCheckInspection
extends KotlinApplicableInspectionBase.Simple<KtBinaryExpression, Context> {
    @Override
    @NotNull
    protected String getProblemDescription(@NotNull KtBinaryExpression element, @NotNull Context context2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return KotlinBundle.message((String)"two.comparisons.should.be.converted.to.a.range.check", (Object[])new Object[0]);
    }

    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        return VisitorWrappersKt.binaryExpressionVisitor(arg_0 -> ConvertTwoComparisonsToRangeCheckInspection.buildVisitor$lambda$0(this, holder2, isOnTheFly, arg_0));
    }

    private final ComparisonData asComparison(KtExpression $this$asComparison) {
        Pair pair;
        if (!($this$asComparison instanceof KtBinaryExpression)) {
            return null;
        }
        IElementType iElementType = ((KtBinaryExpression)$this$asComparison).getOperationToken();
        if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LT) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LTEQ)) {
            pair = TuplesKt.to((Object)((KtBinaryExpression)$this$asComparison).getLeft(), (Object)((KtBinaryExpression)$this$asComparison).getRight());
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.GT) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.GTEQ)) {
            pair = TuplesKt.to((Object)((KtBinaryExpression)$this$asComparison).getRight(), (Object)((KtBinaryExpression)$this$asComparison).getLeft());
        } else {
            return null;
        }
        Pair pair2 = pair;
        KtExpression lesser = (KtExpression)pair2.component1();
        KtExpression greater = (KtExpression)pair2.component2();
        KtExpression ktExpression = lesser;
        if (ktExpression == null || (ktExpression = IfThenUtilsKt.getSingleUnwrappedStatementOrThis(ktExpression)) == null) {
            return null;
        }
        KtExpression ktExpression2 = greater;
        if (ktExpression2 == null || (ktExpression2 = IfThenUtilsKt.getSingleUnwrappedStatementOrThis(ktExpression2)) == null) {
            return null;
        }
        return new ComparisonData(ktExpression, ktExpression2, Intrinsics.areEqual((Object)((KtBinaryExpression)$this$asComparison).getOperationToken(), (Object)KtTokens.LT) || Intrinsics.areEqual((Object)((KtBinaryExpression)$this$asComparison).getOperationToken(), (Object)KtTokens.GT));
    }

    private final boolean isSimple(KtExpression $this$isSimple) {
        return $this$isSimple instanceof KtConstantExpression || $this$isSimple instanceof KtNameReferenceExpression;
    }

    private final PsiContext getPsiContext(KtBinaryExpression $this$getPsiContext) {
        Pair pair;
        Object object;
        Object leftComparison;
        boolean isInverseCheck;
        block22: {
            block21: {
                ComparisonData comparisonData;
                Object object2;
                block20: {
                    block19: {
                        ComparisonData comparisonData2;
                        boolean bl;
                        IElementType iElementType = $this$getPsiContext.getOperationToken();
                        if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.ANDAND)) {
                            bl = false;
                        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.OROR)) {
                            bl = true;
                        } else {
                            return null;
                        }
                        isInverseCheck = bl;
                        object2 = $this$getPsiContext.getLeft();
                        if (object2 == null || (object2 = this.asComparison((KtExpression)object2)) == null) break block19;
                        Object object3 = object2;
                        boolean condition$iv = isInverseCheck;
                        boolean $i$f$applyIf = false;
                        if (condition$iv) {
                            void $this$getPsiContext_u24lambda_u240 = $this$applyIf$iv;
                            boolean bl2 = false;
                            comparisonData2 = $this$getPsiContext_u24lambda_u240.inverted();
                        } else {
                            comparisonData2 = object2 = $this$applyIf$iv;
                        }
                        if (comparisonData2 != null) break block20;
                    }
                    return null;
                }
                leftComparison = object2;
                object = $this$getPsiContext.getRight();
                if (object == null || (object = this.asComparison((KtExpression)object)) == null) break block21;
                Object condition$iv = object;
                boolean condition$iv2 = isInverseCheck;
                boolean $i$f$applyIf = false;
                if (condition$iv2) {
                    void $this$getPsiContext_u24lambda_u241 = $this$applyIf$iv;
                    boolean bl = false;
                    comparisonData = $this$getPsiContext_u24lambda_u241.inverted();
                } else {
                    comparisonData = object = $this$applyIf$iv;
                }
                if (comparisonData != null) break block22;
            }
            return null;
        }
        Object rightComparison = object;
        if (((ComparisonData)leftComparison).isLowBoundFor((ComparisonData)rightComparison)) {
            pair = TuplesKt.to((Object)leftComparison, (Object)rightComparison);
        } else if (((ComparisonData)rightComparison).isLowBoundFor((ComparisonData)leftComparison)) {
            pair = TuplesKt.to((Object)rightComparison, (Object)leftComparison);
        } else {
            return null;
        }
        Pair pair2 = pair;
        ComparisonData lowBound = (ComparisonData)pair2.component1();
        ComparisonData highBound = (ComparisonData)pair2.component2();
        KtExpression min = lowBound.getLesser();
        KtExpression max = highBound.getGreater();
        if (!this.isSimple(min) || !this.isSimple(max)) {
            return null;
        }
        return new PsiContext(lowBound.getGreater(), min, lowBound.getStrict(), max, highBound.getStrict(), isInverseCheck);
    }

    @Override
    public boolean isApplicableByPsi(@NotNull KtBinaryExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.getPsiContext(element) != null;
    }

    private final String renderConstantPlusOne(KaSession kaSession, KtExpression $this$renderConstantPlusOne, KaType expressionType) {
        String string;
        KaConstantValue kaConstantValue = KaEvaluatorKt.evaluate(kaSession, $this$renderConstantPlusOne);
        if (kaConstantValue == null) {
            return null;
        }
        KaConstantValue constant = kaConstantValue;
        if (constant instanceof KaConstantValue.CharValue) {
            return "'" + ConstantUtilsKt.renderAsEscapeSequence((char)(((KaConstantValue.CharValue)constant).getValue().charValue() + '\u0001')) + "'";
        }
        String text = $this$renderConstantPlusOne.getText();
        Intrinsics.checkNotNull((Object)text);
        Pair pair = StringsKt.startsWith$default((String)text, (String)"0x", (boolean)false, (int)2, null) ? TuplesKt.to((Object)"0x", (Object)16) : (StringsKt.startsWith$default((String)text, (String)"0b", (boolean)false, (int)2, null) ? TuplesKt.to((Object)"0b", (Object)2) : TuplesKt.to((Object)"", (Object)10));
        String prefix2 = (String)pair.component1();
        int radix2 = ((Number)pair.component2()).intValue();
        if (RangeInspectionUtilsKt.isUnsignedIntegralType(kaSession, expressionType)) {
            long l;
            KaConstantValue kaConstantValue2 = constant;
            if (kaConstantValue2 instanceof KaConstantValue.ULongValue) {
                l = ((KaConstantValue.ULongValue)constant).getValue-s-VKNKU();
            } else if (kaConstantValue2 instanceof KaConstantValue.UIntValue) {
                l = ULong.constructor-impl((long)((long)((KaConstantValue.UIntValue)constant).getValue-pVg5ArA() & 0xFFFFFFFFL));
            } else if (kaConstantValue2 instanceof KaConstantValue.UShortValue) {
                l = ULong.constructor-impl((long)((long)((KaConstantValue.UShortValue)constant).getValue-Mh2AYeg() & 0xFFFFL));
            } else if (kaConstantValue2 instanceof KaConstantValue.UByteValue) {
                l = ULong.constructor-impl((long)((long)((KaConstantValue.UByteValue)constant).getValue-w2LRezQ() & 0xFFL));
            } else {
                return null;
            }
            long uLongValue = l;
            string = prefix2 + UStringsKt.toString-JSWoG40((long)ULong.constructor-impl((long)(uLongValue + ULong.constructor-impl((long)(1L & 0xFFFFFFFFL)))), (int)radix2) + "u";
        } else if (RangeInspectionUtilsKt.isSignedIntegralType(kaSession, expressionType)) {
            Object object = constant.getValue();
            Number number = object instanceof Number ? (Number)((Number)object) : (Number)null;
            if (number == null) {
                return null;
            }
            long longValue = number.longValue();
            String string2 = Long.toString(longValue + 1L, CharsKt.checkRadix((int)radix2));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            string = prefix2 + string2;
        } else {
            string = null;
        }
        return string;
    }

    private final String adjustLowerBoundForExclusive(KaSession kaSession, KtExpression $this$adjustLowerBoundForExclusive) {
        KaType kaType = KaExpressionTypeProviderKt.getExpressionType(kaSession, $this$adjustLowerBoundForExclusive);
        if (kaType == null) {
            return null;
        }
        KaType type2 = kaType;
        if (!RangeInspectionUtilsKt.isIntegralType(kaSession, type2) && !KaTypeInformationProviderKt.isCharType(kaSession, type2)) {
            return null;
        }
        Object[] objectArray = this.renderConstantPlusOne(kaSession, $this$adjustLowerBoundForExclusive, type2);
        if (objectArray != null) {
            Object[] it = objectArray;
            boolean bl = false;
            return it;
        }
        Project project = $this$adjustLowerBoundForExclusive.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        objectArray = new Object[1];
        PsiElement $this$copied$iv = (PsiElement)$this$adjustLowerBoundForExclusive;
        boolean $i$f$copied = false;
        PsiElement psiElement = $this$copied$iv.copy();
        if (psiElement == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
        }
        objectArray[0] = (PsiElement)((KtExpression)psiElement);
        return CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)new KtPsiFactory(project, false, 2, null), (String)"($0 + 1)", (Object[])objectArray, (boolean)false, (int)4, null).getText();
    }

    private final KtExpression asDoubleConstantExpression(KaSession kaSession, KtExpression $this$asDoubleConstantExpression) {
        KaConstantValue kaConstantValue = KaEvaluatorKt.evaluate(kaSession, $this$asDoubleConstantExpression);
        Object object = kaConstantValue != null ? kaConstantValue.getValue() : null;
        Number number = object instanceof Number ? (Number)((Number)object) : (Number)null;
        if (number == null) {
            return null;
        }
        Number constantVal = number;
        Project project = $this$asDoubleConstantExpression.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return new KtPsiFactory(project, false, 2, null).createExpression(String.valueOf(constantVal.doubleValue()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    @Nullable
    public Context prepareContext(@NotNull KaSession $this$prepareContext, @NotNull KtBinaryExpression element) {
        block45: {
            block47: {
                block49: {
                    block48: {
                        block46: {
                            block44: {
                                Intrinsics.checkNotNullParameter((Object)$this$prepareContext, (String)"<this>");
                                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                                v0 = this.getPsiContext(element);
                                if (v0 == null) {
                                    return null;
                                }
                                psiContext = v0;
                                v1 = $this$prepareContext.getExpressionType(psiContext.getValue());
                                if (v1 == null || (v1 = $this$prepareContext.lowerBoundIfFlexible(v1)) == null) {
                                    return null;
                                }
                                valueType = v1;
                                if (!KaTypeRelationChecker.isSubtypeOf$default((KaTypeRelationChecker)$this$prepareContext, valueType, StandardClassIds.INSTANCE.getComparable(), null, 2, null)) {
                                    return null;
                                }
                                min = null;
                                min = psiContext.getMin();
                                max = null;
                                max = psiContext.getMax();
                                v2 = $this$prepareContext.getExpressionType(min);
                                if (v2 == null || (v2 = $this$prepareContext.lowerBoundIfFlexible(v2)) == null) {
                                    return null;
                                }
                                minType = v2;
                                v3 = $this$prepareContext.getExpressionType(max);
                                if (v3 == null || (v3 = $this$prepareContext.lowerBoundIfFlexible(v3)) == null) {
                                    return null;
                                }
                                maxType = v3;
                                if (!KaTypeRelationChecker.semanticallyEquals$default($this$prepareContext, valueType, minType, null, 2, null)) break block44;
                                if (KaTypeRelationChecker.semanticallyEquals$default($this$prepareContext, valueType, maxType, null, 2, null)) break block45;
                            }
                            if (!RangeInspectionUtilsKt.isSignedIntegralType($this$prepareContext, valueType)) break block46;
                            v4 = RangeInspectionUtilsKt.isSignedIntegralType($this$prepareContext, minType) && RangeInspectionUtilsKt.isSignedIntegralType($this$prepareContext, maxType);
                            break block47;
                        }
                        if (!RangeInspectionUtilsKt.isUnsignedIntegralType($this$prepareContext, valueType)) break block48;
                        v4 = RangeInspectionUtilsKt.isUnsignedIntegralType($this$prepareContext, minType) && RangeInspectionUtilsKt.isUnsignedIntegralType($this$prepareContext, maxType);
                        break block47;
                    }
                    if (!RangeInspectionUtilsKt.isFloatingPointType($this$prepareContext, valueType)) break block49;
                    if (RangeInspectionUtilsKt.isFloatingPointType($this$prepareContext, minType)) ** GOTO lbl-1000
                    if (RangeInspectionUtilsKt.isSignedIntegralType($this$prepareContext, minType)) {
                        v5 = this.asDoubleConstantExpression($this$prepareContext, min);
                        if (v5 != null) {
                            it = var12_9 = v5;
                            $i$a$-also-ConvertTwoComparisonsToRangeCheckInspection$prepareContext$canCompare$minCompatible$1 = false;
                            min = it;
                            v6 = var12_9;
                        } else {
                            v6 = null;
                        }
                        ** if (v6 == null) goto lbl-1000
                    }
                    ** GOTO lbl-1000
lbl-1000:
                    // 2 sources

                    {
                        v7 = true;
                        ** GOTO lbl53
                    }
lbl-1000:
                    // 2 sources

                    {
                        v7 = minCompatible = false;
                    }
lbl53:
                    // 2 sources

                    if (RangeInspectionUtilsKt.isFloatingPointType($this$prepareContext, maxType)) ** GOTO lbl-1000
                    if (RangeInspectionUtilsKt.isSignedIntegralType($this$prepareContext, maxType)) {
                        v8 = this.asDoubleConstantExpression($this$prepareContext, max);
                        if (v8 != null) {
                            it = it = v8;
                            $i$a$-also-ConvertTwoComparisonsToRangeCheckInspection$prepareContext$canCompare$maxCompatible$1 = false;
                            max = it;
                            v9 = it;
                        } else {
                            v9 = null;
                        }
                        ** if (v9 == null) goto lbl-1000
                    }
                    ** GOTO lbl-1000
lbl-1000:
                    // 2 sources

                    {
                        v10 = true;
                        ** GOTO lbl68
                    }
lbl-1000:
                    // 2 sources

                    {
                        v10 = maxCompatible = false;
                    }
lbl68:
                    // 2 sources

                    v4 = minCompatible && maxCompatible;
                    break block47;
                }
                v4 = canCompare = false;
            }
            if (!canCompare) {
                return null;
            }
        }
        if (psiContext.getMinExclusive()) {
            if (!RangeInspectionUtilsKt.isIntegralType($this$prepareContext, valueType) && !$this$prepareContext.isCharType(valueType)) {
                return null;
            }
            v11 = this.adjustLowerBoundForExclusive($this$prepareContext, min);
            if (v11 == null) {
                return null;
            }
        } else {
            minCompatible = min.getText();
            Intrinsics.checkNotNull((Object)minCompatible);
            v11 = minCompatible;
        }
        minText = v11;
        if (!psiContext.getMaxExclusive()) {
            v12 = "..";
        } else if (RangeInspectionUtilsKt.canUseRangeUntil($this$prepareContext, (KtElement)element)) {
            v12 = "..<";
        } else if (RangeInspectionUtilsKt.isIntegralType($this$prepareContext, valueType) || $this$prepareContext.isCharType(valueType)) {
            v12 = " until ";
        } else {
            return null;
        }
        rangeOp = v12;
        v13 = SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)psiContext.getValue()));
        v14 = max.getText();
        Intrinsics.checkNotNullExpressionValue((Object)v14, (String)"getText(...)");
        context = new Context((SmartPsiElementPointer<KtExpression>)v13, minText, v14, rangeOp, psiContext.isInverseCheck());
        $this$getStrictParentOfType$iv = (PsiElement)element;
        $i$f$getStrictParentOfType = false;
        containingFunction = (KtNamedFunction)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtNamedFunction.class, (boolean)true);
        if (containingFunction != null && containingFunction.hasModifier(KtTokens.OPERATOR_KEYWORD) && Intrinsics.areEqual((Object)containingFunction.getNameAsName(), (Object)OperatorNameConventions.CONTAINS)) {
            v15 = context.createExpression();
            if (v15 == null) {
                return null;
            }
            replacementExpression = v15;
            v16 = containingFunction.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)v16, (String)"getProject(...)");
            v17 = new KtPsiFactory(v16, false, 2, null);
            v18 = replacementExpression.getText();
            Intrinsics.checkNotNullExpressionValue((Object)v18, (String)"getText(...)");
            fragment = v17.createExpressionCodeFragment(v18, (PsiElement)element);
            var17_23 = fragment.getContentElement();
            v19 = var17_23 instanceof KtBinaryExpression != false ? (KtBinaryExpression)var17_23 : null;
            if (v19 == null) {
                return null;
            }
            fragmentExpression = v19;
            useSiteElement$iv = (KtElement)fragment;
            $i$f$analyze = false;
            v20 = useSiteElement$iv.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)v20, (String)"getProject(...)");
            var18_26 = KaSessionProvider.Companion.getInstance(v20);
            useSiteElement$iv$iv = useSiteElement$iv;
            $i$f$analyze = false;
            analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(useSiteElement$iv$iv);
            this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
            try {
                var23_31 = lock$iv$iv = new Object();
                synchronized (var23_31) {
                    block42: {
                        block41: {
                            $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv = false;
                            $this$prepareContext_u24lambda_u242 = analysisSession$iv$iv;
                            $i$a$-analyze-ConvertTwoComparisonsToRangeCheckInspection$prepareContext$1 = false;
                            v21 = fragmentExpression.getOperationReference();
                            Intrinsics.checkNotNullExpressionValue((Object)v21, (String)"getOperationReference(...)");
                            v22 /* !! */  = $this$prepareContext_u24lambda_u242.resolveToCall((KtElement)v21);
                            if (v22 /* !! */  != null && (v22 /* !! */  = KaCallInfoKt.singleFunctionCallOrNull(v22 /* !! */ )) != null && (v22 /* !! */  = (KaFunctionSymbol)KaCallKt.getSymbol((KaCallableMemberCall)v22 /* !! */ )) != null) break block41;
                            var31_38 = null;
                            // MONITOREXIT @DISABLED, blocks:[0, 1, 7, 40] lbl139 : MonitorExitStatement: MONITOREXIT : var23_31
                            var32_39 = var31_38;
                            return var32_39;
                        }
                        resolvedSymbol /* !! */  = v22 /* !! */ ;
                        if (!Intrinsics.areEqual((Object)resolvedSymbol /* !! */ , (Object)$this$prepareContext_u24lambda_u242.getSymbol(containingFunction))) break block42;
                        var29_41 = null;
                        // MONITOREXIT @DISABLED, blocks:[0, 3, 7, 40] lbl146 : MonitorExitStatement: MONITOREXIT : var23_31
                        var30_42 = var29_41;
                        return var30_42;
                    }
                    var24_35 = Unit.INSTANCE;
                }
                var22_30 = var24_35;
            }
            catch (Throwable throwable$iv$iv) {
                this_$iv$iv.handleAnalysisException(throwable$iv$iv, analysisSession$iv$iv, useSiteElement$iv$iv);
                throw new KotlinNothingValueException();
            }
            finally {
                this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
            }
        }
        return context;
    }

    @Override
    @NotNull
    protected KotlinModCommandQuickFix<KtBinaryExpression> createQuickFix(@NotNull KtBinaryExpression element, @NotNull Context context2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new ConvertTwoComparisonsToRangeCheckQuickFix(context2);
    }

    private static final Unit buildVisitor$lambda$0(ConvertTwoComparisonsToRangeCheckInspection this$0, ProblemsHolder $holder, boolean $isOnTheFly, KtBinaryExpression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.visitTargetElement((KtElement)it, $holder, $isOnTheFly);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0000J\u0006\u0010\u0010\u001a\u00020\u0000J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0014\u0010\u0015\u001a\u00020\u00062\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0016\u001a\u00020\u0017H\u00d6\u0081\u0004J\n\u0010\u0018\u001a\u00020\u0019H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/ConvertTwoComparisonsToRangeCheckInspection$ComparisonData;", "", "lesser", "Lorg/jetbrains/kotlin/psi/KtExpression;", "greater", "strict", "", "<init>", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/psi/KtExpression;Z)V", "getLesser", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "getGreater", "getStrict", "()Z", "isLowBoundFor", "other", "inverted", "component1", "component2", "component3", "copy", "equals", "hashCode", "", "toString", "", "kotlin.code-insight.inspections.shared"})
    private static final class ComparisonData {
        @NotNull
        private final KtExpression lesser;
        @NotNull
        private final KtExpression greater;
        private final boolean strict;

        public ComparisonData(@NotNull KtExpression lesser, @NotNull KtExpression greater, boolean strict) {
            Intrinsics.checkNotNullParameter((Object)lesser, (String)"lesser");
            Intrinsics.checkNotNullParameter((Object)greater, (String)"greater");
            this.lesser = lesser;
            this.greater = greater;
            this.strict = strict;
        }

        @NotNull
        public final KtExpression getLesser() {
            return this.lesser;
        }

        @NotNull
        public final KtExpression getGreater() {
            return this.greater;
        }

        public final boolean getStrict() {
            return this.strict;
        }

        public final boolean isLowBoundFor(@NotNull ComparisonData other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return !(this.greater instanceof KtConstantExpression) && UtilsKt.isSimplifiableTo(this.greater, other.lesser);
        }

        @NotNull
        public final ComparisonData inverted() {
            return this.copy(this.greater, this.lesser, !this.strict);
        }

        @NotNull
        public final KtExpression component1() {
            return this.lesser;
        }

        @NotNull
        public final KtExpression component2() {
            return this.greater;
        }

        public final boolean component3() {
            return this.strict;
        }

        @NotNull
        public final ComparisonData copy(@NotNull KtExpression lesser, @NotNull KtExpression greater, boolean strict) {
            Intrinsics.checkNotNullParameter((Object)lesser, (String)"lesser");
            Intrinsics.checkNotNullParameter((Object)greater, (String)"greater");
            return new ComparisonData(lesser, greater, strict);
        }

        public static /* synthetic */ ComparisonData copy$default(ComparisonData comparisonData, KtExpression ktExpression, KtExpression ktExpression2, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                ktExpression = comparisonData.lesser;
            }
            if ((n & 2) != 0) {
                ktExpression2 = comparisonData.greater;
            }
            if ((n & 4) != 0) {
                bl = comparisonData.strict;
            }
            return comparisonData.copy(ktExpression, ktExpression2, bl);
        }

        @NotNull
        public String toString() {
            return "ComparisonData(lesser=" + this.lesser + ", greater=" + this.greater + ", strict=" + this.strict + ")";
        }

        public int hashCode() {
            int result2 = this.lesser.hashCode();
            result2 = result2 * 31 + this.greater.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.strict);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ComparisonData)) {
                return false;
            }
            ComparisonData comparisonData = (ComparisonData)other;
            if (!Intrinsics.areEqual((Object)this.lesser, (Object)comparisonData.lesser)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.greater, (Object)comparisonData.greater)) {
                return false;
            }
            return this.strict == comparisonData.strict;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B5\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0006\u0010\u0017\u001a\u00020\u0006J\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\u000f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\nH\u00c6\u0003JA\u0010\u001f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0014\u0010 \u001a\u00020\n2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\"\u001a\u00020#H\u00d6\u0081\u0004J\n\u0010$\u001a\u00020\u0006H\u00d6\u0081\u0004R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0010\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/ConvertTwoComparisonsToRangeCheckInspection$Context;", "", "value", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "minExpressionText", "", "maxExpressionText", "rangeOperator", "inverted", "", "<init>", "(Lcom/intellij/psi/SmartPsiElementPointer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)V", "getValue", "()Lcom/intellij/psi/SmartPsiElementPointer;", "getMinExpressionText", "()Ljava/lang/String;", "getMaxExpressionText", "getRangeOperator", "getInverted", "()Z", "inOperator", "getInOperator", "createDisplayText", "createExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "kotlin.code-insight.inspections.shared"})
    @SourceDebugExtension(value={"SMAP\nConvertTwoComparisonsToRangeCheckInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConvertTwoComparisonsToRangeCheckInspection.kt\norg/jetbrains/kotlin/idea/codeInsight/inspections/shared/ConvertTwoComparisonsToRangeCheckInspection$Context\n+ 2 KotlinPsiModificationUtils.kt\norg/jetbrains/kotlin/idea/base/psi/KotlinPsiModificationUtils\n*L\n1#1,317:1\n21#2:318\n*S KotlinDebug\n*F\n+ 1 ConvertTwoComparisonsToRangeCheckInspection.kt\norg/jetbrains/kotlin/idea/codeInsight/inspections/shared/ConvertTwoComparisonsToRangeCheckInspection$Context\n*L\n141#1:318\n*E\n"})
    public static final class Context {
        @NotNull
        private final SmartPsiElementPointer<KtExpression> value;
        @NotNull
        private final String minExpressionText;
        @NotNull
        private final String maxExpressionText;
        @NotNull
        private final String rangeOperator;
        private final boolean inverted;

        public Context(@NotNull SmartPsiElementPointer<KtExpression> value, @NotNull String minExpressionText, @NotNull String maxExpressionText, @NotNull String rangeOperator, boolean inverted) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)minExpressionText, (String)"minExpressionText");
            Intrinsics.checkNotNullParameter((Object)maxExpressionText, (String)"maxExpressionText");
            Intrinsics.checkNotNullParameter((Object)rangeOperator, (String)"rangeOperator");
            this.value = value;
            this.minExpressionText = minExpressionText;
            this.maxExpressionText = maxExpressionText;
            this.rangeOperator = rangeOperator;
            this.inverted = inverted;
        }

        @NotNull
        public final SmartPsiElementPointer<KtExpression> getValue() {
            return this.value;
        }

        @NotNull
        public final String getMinExpressionText() {
            return this.minExpressionText;
        }

        @NotNull
        public final String getMaxExpressionText() {
            return this.maxExpressionText;
        }

        @NotNull
        public final String getRangeOperator() {
            return this.rangeOperator;
        }

        public final boolean getInverted() {
            return this.inverted;
        }

        private final String getInOperator() {
            return this.inverted ? "!in" : "in";
        }

        @NotNull
        public final String createDisplayText() {
            return this.getInOperator() + " " + this.minExpressionText + this.rangeOperator + this.maxExpressionText;
        }

        @Nullable
        public final KtBinaryExpression createExpression() {
            KtExpression ktExpression;
            KtPsiFactory factory2;
            block5: {
                block4: {
                    Project project = this.value.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    factory2 = new KtPsiFactory(project, false, 2, null);
                    ktExpression = (KtExpression)this.value.getElement();
                    if (ktExpression == null) break block4;
                    PsiElement $this$copied$iv = (PsiElement)ktExpression;
                    boolean $i$f$copied = false;
                    PsiElement psiElement = $this$copied$iv.copy();
                    if (psiElement == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                    }
                    ktExpression = (KtExpression)((PsiElement)((KtExpression)psiElement));
                    if (ktExpression != null) break block5;
                }
                return null;
            }
            KtExpression valuePsi = ktExpression;
            KtExpression minPsi = factory2.createExpression(this.minExpressionText);
            KtExpression maxPsi = factory2.createExpression(this.maxExpressionText);
            Object[] objectArray = new Object[]{valuePsi, minPsi, maxPsi};
            KtExpression ktExpression2 = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)factory2, (String)("$0 " + this.getInOperator() + " $1" + this.rangeOperator + "$2"), (Object[])objectArray, (boolean)false, (int)4, null);
            return ktExpression2 instanceof KtBinaryExpression ? (KtBinaryExpression)ktExpression2 : null;
        }

        @NotNull
        public final SmartPsiElementPointer<KtExpression> component1() {
            return this.value;
        }

        @NotNull
        public final String component2() {
            return this.minExpressionText;
        }

        @NotNull
        public final String component3() {
            return this.maxExpressionText;
        }

        @NotNull
        public final String component4() {
            return this.rangeOperator;
        }

        public final boolean component5() {
            return this.inverted;
        }

        @NotNull
        public final Context copy(@NotNull SmartPsiElementPointer<KtExpression> value, @NotNull String minExpressionText, @NotNull String maxExpressionText, @NotNull String rangeOperator, boolean inverted) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)minExpressionText, (String)"minExpressionText");
            Intrinsics.checkNotNullParameter((Object)maxExpressionText, (String)"maxExpressionText");
            Intrinsics.checkNotNullParameter((Object)rangeOperator, (String)"rangeOperator");
            return new Context(value, minExpressionText, maxExpressionText, rangeOperator, inverted);
        }

        public static /* synthetic */ Context copy$default(Context context2, SmartPsiElementPointer smartPsiElementPointer, String string, String string2, String string3, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                smartPsiElementPointer = context2.value;
            }
            if ((n & 2) != 0) {
                string = context2.minExpressionText;
            }
            if ((n & 4) != 0) {
                string2 = context2.maxExpressionText;
            }
            if ((n & 8) != 0) {
                string3 = context2.rangeOperator;
            }
            if ((n & 0x10) != 0) {
                bl = context2.inverted;
            }
            return context2.copy(smartPsiElementPointer, string, string2, string3, bl);
        }

        @NotNull
        public String toString() {
            return "Context(value=" + this.value + ", minExpressionText=" + this.minExpressionText + ", maxExpressionText=" + this.maxExpressionText + ", rangeOperator=" + this.rangeOperator + ", inverted=" + this.inverted + ")";
        }

        public int hashCode() {
            int result2 = this.value.hashCode();
            result2 = result2 * 31 + this.minExpressionText.hashCode();
            result2 = result2 * 31 + this.maxExpressionText.hashCode();
            result2 = result2 * 31 + this.rangeOperator.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.inverted);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Context)) {
                return false;
            }
            Context context2 = (Context)other;
            if (!Intrinsics.areEqual(this.value, context2.value)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.minExpressionText, (Object)context2.minExpressionText)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.maxExpressionText, (Object)context2.maxExpressionText)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.rangeOperator, (Object)context2.rangeOperator)) {
                return false;
            }
            return this.inverted == context2.inverted;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0016\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0006H\u00c6\u0003JE\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\u0006H\u00c6\u0001J\u0014\u0010\u001a\u001a\u00020\u00062\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u001c\u001a\u00020\u001dH\u00d6\u0081\u0004J\n\u0010\u001e\u001a\u00020\u001fH\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0010\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/ConvertTwoComparisonsToRangeCheckInspection$PsiContext;", "", "value", "Lorg/jetbrains/kotlin/psi/KtExpression;", "min", "minExclusive", "", "max", "maxExclusive", "isInverseCheck", "<init>", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/psi/KtExpression;ZLorg/jetbrains/kotlin/psi/KtExpression;ZZ)V", "getValue", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "getMin", "getMinExclusive", "()Z", "getMax", "getMaxExclusive", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hashCode", "", "toString", "", "kotlin.code-insight.inspections.shared"})
    private static final class PsiContext {
        @NotNull
        private final KtExpression value;
        @NotNull
        private final KtExpression min;
        private final boolean minExclusive;
        @NotNull
        private final KtExpression max;
        private final boolean maxExclusive;
        private final boolean isInverseCheck;

        public PsiContext(@NotNull KtExpression value, @NotNull KtExpression min, boolean minExclusive, @NotNull KtExpression max, boolean maxExclusive, boolean isInverseCheck) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)min, (String)"min");
            Intrinsics.checkNotNullParameter((Object)max, (String)"max");
            this.value = value;
            this.min = min;
            this.minExclusive = minExclusive;
            this.max = max;
            this.maxExclusive = maxExclusive;
            this.isInverseCheck = isInverseCheck;
        }

        @NotNull
        public final KtExpression getValue() {
            return this.value;
        }

        @NotNull
        public final KtExpression getMin() {
            return this.min;
        }

        public final boolean getMinExclusive() {
            return this.minExclusive;
        }

        @NotNull
        public final KtExpression getMax() {
            return this.max;
        }

        public final boolean getMaxExclusive() {
            return this.maxExclusive;
        }

        public final boolean isInverseCheck() {
            return this.isInverseCheck;
        }

        @NotNull
        public final KtExpression component1() {
            return this.value;
        }

        @NotNull
        public final KtExpression component2() {
            return this.min;
        }

        public final boolean component3() {
            return this.minExclusive;
        }

        @NotNull
        public final KtExpression component4() {
            return this.max;
        }

        public final boolean component5() {
            return this.maxExclusive;
        }

        public final boolean component6() {
            return this.isInverseCheck;
        }

        @NotNull
        public final PsiContext copy(@NotNull KtExpression value, @NotNull KtExpression min, boolean minExclusive, @NotNull KtExpression max, boolean maxExclusive, boolean isInverseCheck) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)min, (String)"min");
            Intrinsics.checkNotNullParameter((Object)max, (String)"max");
            return new PsiContext(value, min, minExclusive, max, maxExclusive, isInverseCheck);
        }

        public static /* synthetic */ PsiContext copy$default(PsiContext psiContext, KtExpression ktExpression, KtExpression ktExpression2, boolean bl, KtExpression ktExpression3, boolean bl2, boolean bl3, int n, Object object) {
            if ((n & 1) != 0) {
                ktExpression = psiContext.value;
            }
            if ((n & 2) != 0) {
                ktExpression2 = psiContext.min;
            }
            if ((n & 4) != 0) {
                bl = psiContext.minExclusive;
            }
            if ((n & 8) != 0) {
                ktExpression3 = psiContext.max;
            }
            if ((n & 0x10) != 0) {
                bl2 = psiContext.maxExclusive;
            }
            if ((n & 0x20) != 0) {
                bl3 = psiContext.isInverseCheck;
            }
            return psiContext.copy(ktExpression, ktExpression2, bl, ktExpression3, bl2, bl3);
        }

        @NotNull
        public String toString() {
            return "PsiContext(value=" + this.value + ", min=" + this.min + ", minExclusive=" + this.minExclusive + ", max=" + this.max + ", maxExclusive=" + this.maxExclusive + ", isInverseCheck=" + this.isInverseCheck + ")";
        }

        public int hashCode() {
            int result2 = this.value.hashCode();
            result2 = result2 * 31 + this.min.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.minExclusive);
            result2 = result2 * 31 + this.max.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.maxExclusive);
            result2 = result2 * 31 + Boolean.hashCode(this.isInverseCheck);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PsiContext)) {
                return false;
            }
            PsiContext psiContext = (PsiContext)other;
            if (!Intrinsics.areEqual((Object)this.value, (Object)psiContext.value)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.min, (Object)psiContext.min)) {
                return false;
            }
            if (this.minExclusive != psiContext.minExclusive) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.max, (Object)psiContext.max)) {
                return false;
            }
            if (this.maxExclusive != psiContext.maxExclusive) {
                return false;
            }
            return this.isInverseCheck == psiContext.isInverseCheck;
        }
    }
}

