/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.inspections.shared;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNameIdentifierOwner;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.projectStructure.KotlinProjectStructureUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.NamingConventionInspection;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.NamingConventionInspectionsKt;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.NamingRule;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0014\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/FunctionNameInspection;", "Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/NamingConventionInspection;", "<init>", "()V", "getNamingRules", "", "Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/NamingRule;", "()[Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/NamingRule;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "kotlin.code-insight.inspections.shared"})
public final class FunctionNameInspection
extends NamingConventionInspection {
    public FunctionNameInspection() {
        super(KotlinBundle.message((String)"function", (Object[])new Object[0]), "[a-z][A-Za-z\\d]*", null);
    }

    @Override
    @NotNull
    protected NamingRule[] getNamingRules() {
        NamingRule[] namingRuleArray = new NamingRule[]{NamingConventionInspectionsKt.access$getSTART_LOWER$p(), NamingConventionInspectionsKt.access$getNO_UNDERSCORES$p(), NamingConventionInspectionsKt.access$getNO_BAD_CHARACTERS$p()};
        return namingRuleArray;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        return (PsiElementVisitor)VisitorWrappersKt.namedFunctionVisitor(arg_0 -> FunctionNameInspection.buildVisitor$lambda$0(this, holder2, arg_0));
    }

    private static final boolean buildVisitor$lambda$0$0(KtNamedFunction $function) {
        return !NamingConventionInspectionsKt.access$isFactoryFunction($function);
    }

    private static final Unit buildVisitor$lambda$0(FunctionNameInspection this$0, ProblemsHolder $holder, KtNamedFunction function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        if (function.hasModifier(KtTokens.OVERRIDE_KEYWORD)) {
            return Unit.INSTANCE;
        }
        VirtualFile virtualFile = function.getContainingFile().getVirtualFile();
        if (virtualFile == null) {
            return Unit.INSTANCE;
        }
        VirtualFile virtualFile2 = virtualFile;
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)function.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(...)");
        if (!KotlinProjectStructureUtils.isInTestSource(projectFileIndex, virtualFile2)) {
            this$0.verifyName((PsiNameIdentifierOwner)function, $holder, (Function0<Boolean>)((Function0)() -> FunctionNameInspection.buildVisitor$lambda$0$0(function)));
        }
        return Unit.INSTANCE;
    }
}

