/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.inspections.shared;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.components.KaTypeInformationProviderKt;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassSymbol;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.CheckResult;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.NamingConventionInspectionSettings;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.NamingRule;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtDeclarationWithReturnType;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a'\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004H\u0002\u00a2\u0006\u0002\u0010\u0006\u001a\f\u0010\u0011\u001a\u00020\u0012*\u00020\u0013H\u0002\u001a\f\u0010\u0014\u001a\u00020\u0012*\u00020\u0013H\u0002\u001a%\u0010\u0015\u001a\u00020\u0012*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0001H\u0002R\u00020\u0016j\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u001a\u001a\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002\u001a\u001a\u0010#\u001a\u0004\u0018\u00010\u001c2\u0006\u0010$\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020 H\u0002\"\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\"\u00a8\u0006%"}, d2={"findRuleMessage", "", "checkString", "rules", "", "Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/NamingRule;", "(Ljava/lang/String;[Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/NamingRule;)Ljava/lang/String;", "START_UPPER", "START_LOWER", "NO_UNDERSCORES", "NO_START_UPPER", "NO_START_UNDERSCORE", "NO_MIDDLE_UNDERSCORES", "NO_UNDERSCORES_IN_CAMEL_CASE", "NO_BAD_CHARACTERS", "NO_BAD_CHARACTERS_OR_UNDERSCORE", "NO_LOWER", "isFactoryFunction", "", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "isFactoryFunctionByAnalyze", "hasShortName", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "<unused var>", "Lorg/jetbrains/kotlin/analysis/api/types/KaType;", "shortName", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/analysis/api/types/KaType;Ljava/lang/String;)Z", "checkPackageDirective", "Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/CheckResult;", "directive", "Lorg/jetbrains/kotlin/psi/KtPackageDirective;", "namingSettings", "Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/NamingConventionInspectionSettings;", "PART_RULES", "[Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/NamingRule;", "checkQualifiedName", "qualifiedName", "kotlin.code-insight.inspections.shared"})
@SourceDebugExtension(value={"SMAP\nNamingConventionInspections.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NamingConventionInspections.kt\norg/jetbrains/kotlin/idea/codeInsight/inspections/shared/NamingConventionInspectionsKt\n+ 2 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 3 KaSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KaSessionProvider\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,547:1\n30#2,2:548\n36#3,14:550\n50#3:566\n1276#4,2:564\n1#5:567\n1107#6,2:568\n1107#6,2:570\n1107#6,2:572\n1107#6,2:574\n*S KotlinDebug\n*F\n+ 1 NamingConventionInspections.kt\norg/jetbrains/kotlin/idea/codeInsight/inspections/shared/NamingConventionInspectionsKt\n*L\n243#1:548,2\n243#1:550,14\n243#1:566\n248#1:564,2\n85#1:568,2\n89#1:570,2\n93#1:572,2\n97#1:574,2\n*E\n"})
public final class NamingConventionInspectionsKt {
    @NotNull
    private static final NamingRule START_UPPER = new NamingRule(KotlinBundle.message((String)"should.start.with.an.uppercase.letter", (Object[])new Object[0]), (Function1<? super String, Boolean>)((Function1)NamingConventionInspectionsKt::START_UPPER$lambda$0));
    @NotNull
    private static final NamingRule START_LOWER = new NamingRule(KotlinBundle.message((String)"should.start.with.a.lowercase.letter", (Object[])new Object[0]), (Function1<? super String, Boolean>)((Function1)NamingConventionInspectionsKt::START_LOWER$lambda$0));
    @NotNull
    private static final NamingRule NO_UNDERSCORES = new NamingRule(KotlinBundle.message((String)"should.not.contain.underscores", (Object[])new Object[0]), (Function1<? super String, Boolean>)((Function1)NamingConventionInspectionsKt::NO_UNDERSCORES$lambda$0));
    @NotNull
    private static final NamingRule NO_START_UPPER = new NamingRule(KotlinBundle.message((String)"should.not.start.with.an.uppercase.letter", (Object[])new Object[0]), (Function1<? super String, Boolean>)((Function1)NamingConventionInspectionsKt::NO_START_UPPER$lambda$0));
    @NotNull
    private static final NamingRule NO_START_UNDERSCORE = new NamingRule(KotlinBundle.message((String)"should.not.start.with.an.underscore", (Object[])new Object[0]), (Function1<? super String, Boolean>)((Function1)NamingConventionInspectionsKt::NO_START_UNDERSCORE$lambda$0));
    @NotNull
    private static final NamingRule NO_MIDDLE_UNDERSCORES = new NamingRule(KotlinBundle.message((String)"should.not.contain.underscores.in.the.middle.or.the.end", (Object[])new Object[0]), (Function1<? super String, Boolean>)((Function1)NamingConventionInspectionsKt::NO_MIDDLE_UNDERSCORES$lambda$0));
    @NotNull
    private static final NamingRule NO_UNDERSCORES_IN_CAMEL_CASE = new NamingRule(KotlinBundle.message((String)"should.not.contain.underscores.with.camel.case", (Object[])new Object[0]), (Function1<? super String, Boolean>)((Function1)NamingConventionInspectionsKt::NO_UNDERSCORES_IN_CAMEL_CASE$lambda$0));
    @NotNull
    private static final NamingRule NO_BAD_CHARACTERS = new NamingRule(KotlinBundle.message((String)"may.contain.only.letters.and.digits", (Object[])new Object[0]), (Function1<? super String, Boolean>)((Function1)NamingConventionInspectionsKt::NO_BAD_CHARACTERS$lambda$0));
    @NotNull
    private static final NamingRule NO_BAD_CHARACTERS_OR_UNDERSCORE = new NamingRule(KotlinBundle.message((String)"may.contain.only.letters.digits.or.underscores", (Object[])new Object[0]), (Function1<? super String, Boolean>)((Function1)NamingConventionInspectionsKt::NO_BAD_CHARACTERS_OR_UNDERSCORE$lambda$0));
    @NotNull
    private static final NamingRule NO_LOWER = new NamingRule(KotlinBundle.message((String)"should.not.contain.lowercase.letter", (Object[])new Object[0]), (Function1<? super String, Boolean>)((Function1)NamingConventionInspectionsKt::NO_LOWER$lambda$0));
    @NotNull
    private static final NamingRule[] PART_RULES;

    private static final String findRuleMessage(String checkString, NamingRule[] rules2) {
        for (NamingRule rule : rules2) {
            if (!((Boolean)rule.getMatcher().invoke((Object)checkString)).booleanValue()) continue;
            return rule.getMessage();
        }
        return null;
    }

    private static final boolean isFactoryFunction(KtNamedFunction $this$isFactoryFunction) {
        boolean bl;
        KtTypeElement typeElement2;
        String string = $this$isFactoryFunction.getName();
        if (string == null) {
            return false;
        }
        String functionName = string;
        KtTypeReference ktTypeReference = $this$isFactoryFunction.getTypeReference();
        Object object = typeElement2 = ktTypeReference != null ? ktTypeReference.getTypeElement() : null;
        if (typeElement2 != null) {
            KtTypeElement ktTypeElement = KtPsiUtilKt.unwrapNullability((KtTypeElement)typeElement2);
            KtUserType ktUserType = ktTypeElement instanceof KtUserType ? (KtUserType)ktTypeElement : null;
            bl = Intrinsics.areEqual((Object)(ktUserType != null ? ktUserType.getReferencedName() : null), (Object)functionName);
        } else {
            bl = NamingConventionInspectionsKt.isFactoryFunctionByAnalyze($this$isFactoryFunction);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static final boolean isFactoryFunctionByAnalyze(KtNamedFunction $this$isFactoryFunctionByAnalyze) {
        useSiteElement$iv = (KtElement)$this$isFactoryFunctionByAnalyze;
        $i$f$analyze = false;
        v0 = useSiteElement$iv.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getProject(...)");
        var3_3 = KaSessionProvider.Companion.getInstance(v0);
        useSiteElement$iv$iv = useSiteElement$iv;
        $i$f$analyze = false;
        analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(useSiteElement$iv$iv);
        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
        try {
            var8_8 = lock$iv$iv = new Object();
            synchronized (var8_8) {
                block14: {
                    $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv = false;
                    $this$isFactoryFunctionByAnalyze_u24lambda_u240 = analysisSession$iv$iv;
                    $i$a$-analyze-NamingConventionInspectionsKt$isFactoryFunctionByAnalyze$1 = false;
                    if ($this$isFactoryFunctionByAnalyze.getName() != null) break block14;
                    var23_14 = false;
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 6] lbl21 : MonitorExitStatement: MONITOREXIT : var8_8
                    var24_15 = var23_14;
                    return var24_15;
                }
                try {
                    block15: {
                        functionName = v1;
                        returnType = $this$isFactoryFunctionByAnalyze_u24lambda_u240.getReturnType((KtDeclarationWithReturnType)$this$isFactoryFunctionByAnalyze);
                        if (NamingConventionInspectionsKt.hasShortName($this$isFactoryFunctionByAnalyze_u24lambda_u240, returnType, functionName)) ** GOTO lbl-1000
                        $this$any$iv = $this$isFactoryFunctionByAnalyze_u24lambda_u240.getAllSupertypes(returnType);
                        $i$f$any = false;
                        for (E element$iv : $this$any$iv) {
                            it = (KaType)element$iv;
                            $i$a$-any-NamingConventionInspectionsKt$isFactoryFunctionByAnalyze$1$1 = false;
                            if (!NamingConventionInspectionsKt.hasShortName($this$isFactoryFunctionByAnalyze_u24lambda_u240, it, functionName)) continue;
                            v2 = true;
                            break block15;
                        }
                        v2 = false;
                    }
                    if (v2) lbl-1000:
                    // 2 sources

                    {
                        v3 = true;
                    } else {
                        v3 = false;
                    }
                    var21_24 = v3;
                    // MONITOREXIT @DISABLED, blocks:[0, 3, 6] lbl44 : MonitorExitStatement: MONITOREXIT : var8_8
                    var22_25 = var21_24;
                    return var22_25;
                }
                catch (Throwable var20_26) {
                    try {
                        throw var20_26;
                    }
                    catch (Throwable throwable$iv$iv) {
                        this_$iv$iv.handleAnalysisException(throwable$iv$iv, analysisSession$iv$iv, useSiteElement$iv$iv);
                        throw new KotlinNothingValueException();
                    }
                }
            }
        }
        finally {
            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
        }
    }

    private static final boolean hasShortName(KaSession kaSession, KaType $this$hasShortName, String shortName) {
        String string;
        block3: {
            block2: {
                FqName fqName2;
                FqName fqName3;
                FqName fqName4;
                ClassId classId;
                KaClassSymbol kaClassSymbol = KaTypeInformationProviderKt.getExpandedSymbol(kaSession, $this$hasShortName);
                if (kaClassSymbol == null || (classId = kaClassSymbol.getClassId()) == null || (fqName4 = classId.getRelativeClassName()) == null) break block2;
                FqName p0 = fqName3 = fqName4;
                boolean bl = false;
                Object object = fqName2 = !p0.isRoot() ? fqName3 : null;
                if (fqName2 != null && (fqName3 = fqName2.shortName()) != null && (string = fqName3.getIdentifierOrNullIfSpecial()) != null) break block3;
            }
            return false;
        }
        String typeShortName = string;
        return Intrinsics.areEqual((Object)shortName, (Object)typeShortName);
    }

    private static final CheckResult checkPackageDirective(KtPackageDirective directive, NamingConventionInspectionSettings namingSettings) {
        String string = directive.getQualifiedName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getQualifiedName(...)");
        return NamingConventionInspectionsKt.checkQualifiedName(string, namingSettings);
    }

    private static final CheckResult checkQualifiedName(String qualifiedName, NamingConventionInspectionSettings namingSettings) {
        String string;
        block6: {
            block5: {
                if (((CharSequence)qualifiedName).length() == 0) break block5;
                Regex regex = namingSettings.getNameRegex();
                if (regex != null ? !regex.matches((CharSequence)qualifiedName) : false) break block6;
            }
            return null;
        }
        if (Intrinsics.areEqual((Object)namingSettings.getNamePattern(), (Object)namingSettings.getDefaultNamePattern())) {
            char[] cArray = new char[]{'.'};
            string = (String)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)StringsKt.split$default((CharSequence)qualifiedName, (char[])cArray, (boolean)false, (int)0, (int)6, null)), NamingConventionInspectionsKt::checkQualifiedName$lambda$0));
        } else {
            string = null;
        }
        String partErrorMessage = string;
        return partErrorMessage != null ? new CheckResult(partErrorMessage, true) : new CheckResult(namingSettings.getDefaultErrorMessage(), false);
    }

    private static final boolean START_UPPER$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Character c = StringsKt.getOrNull((CharSequence)it, (int)0);
        return c != null ? !Character.isUpperCase(c.charValue()) : false;
    }

    private static final boolean START_LOWER$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Character c = StringsKt.getOrNull((CharSequence)it, (int)0);
        return c != null ? !Character.isLowerCase(c.charValue()) : false;
    }

    private static final boolean NO_UNDERSCORES$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.contains$default((CharSequence)it, (char)'_', (boolean)false, (int)2, null);
    }

    private static final boolean NO_START_UPPER$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Character c = StringsKt.getOrNull((CharSequence)it, (int)0);
        return c != null ? Character.isUpperCase(c.charValue()) : false;
    }

    private static final boolean NO_START_UNDERSCORE$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.startsWith$default((CharSequence)it, (char)'_', (boolean)false, (int)2, null);
    }

    private static final boolean NO_MIDDLE_UNDERSCORES$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.substring(1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return StringsKt.contains$default((CharSequence)string, (char)'_', (boolean)false, (int)2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean NO_UNDERSCORES_IN_CAMEL_CASE$lambda$0(String it) {
        char it2;
        char element$iv;
        int n;
        boolean $i$f$any;
        CharSequence $this$any$iv;
        block4: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            if (!StringsKt.contains$default((CharSequence)it, (char)'_', (boolean)false, (int)2, null)) return false;
            $this$any$iv = it;
            $i$f$any = false;
            n = 0;
            while (n < $this$any$iv.length()) {
                it2 = element$iv = $this$any$iv.charAt(n);
                boolean bl = false;
                if (!Character.isUpperCase(it2)) {
                    ++n;
                    continue;
                }
                break block4;
            }
            return false;
        }
        boolean bl = true;
        if (!bl) return false;
        $this$any$iv = it;
        $i$f$any = false;
        n = 0;
        while (n < $this$any$iv.length()) {
            it2 = element$iv = $this$any$iv.charAt(n);
            boolean bl2 = false;
            if (Character.isLowerCase(it2)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean NO_BAD_CHARACTERS$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CharSequence $this$any$iv = it;
        boolean $i$f$any = false;
        int n = 0;
        while (n < $this$any$iv.length()) {
            char element$iv;
            char c = element$iv = $this$any$iv.charAt(n);
            boolean bl = false;
            if (!('a' <= c ? c < '{' : false)) {
                if (!('A' <= c ? c < '[' : false)) {
                    if ('0' > c) return true;
                    if (c >= ':') return true;
                    boolean bl2 = true;
                    if (!bl2) {
                        return true;
                    }
                }
            }
            boolean bl3 = false;
            if (bl3) {
                return true;
            }
            ++n;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean NO_BAD_CHARACTERS_OR_UNDERSCORE$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CharSequence $this$any$iv = it;
        boolean $i$f$any = false;
        int n = 0;
        while (n < $this$any$iv.length()) {
            char element$iv;
            char c = element$iv = $this$any$iv.charAt(n);
            boolean bl = false;
            if (!('a' <= c ? c < '{' : false)) {
                if (!('A' <= c ? c < '[' : false)) {
                    if (!('0' <= c ? c < ':' : false) && c != '_') {
                        return true;
                    }
                }
            }
            boolean bl2 = false;
            if (bl2) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static final boolean NO_LOWER$lambda$0(String it) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            CharSequence $this$any$iv = it;
            boolean $i$f$any = false;
            for (int j = 0; j < $this$any$iv.length(); ++j) {
                char element$iv;
                char c = element$iv = $this$any$iv.charAt(j);
                boolean bl2 = false;
                if (!Character.isLowerCase(c)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private static final String checkQualifiedName$lambda$0(String part) {
        Intrinsics.checkNotNullParameter((Object)part, (String)"part");
        return NamingConventionInspectionsKt.findRuleMessage(part, PART_RULES);
    }

    public static final /* synthetic */ String access$findRuleMessage(String checkString, NamingRule[] rules2) {
        return NamingConventionInspectionsKt.findRuleMessage(checkString, rules2);
    }

    public static final /* synthetic */ NamingRule access$getSTART_UPPER$p() {
        return START_UPPER;
    }

    public static final /* synthetic */ NamingRule access$getNO_UNDERSCORES$p() {
        return NO_UNDERSCORES;
    }

    public static final /* synthetic */ NamingRule access$getNO_BAD_CHARACTERS$p() {
        return NO_BAD_CHARACTERS;
    }

    public static final /* synthetic */ NamingRule access$getNO_START_UNDERSCORE$p() {
        return NO_START_UNDERSCORE;
    }

    public static final /* synthetic */ NamingRule access$getNO_BAD_CHARACTERS_OR_UNDERSCORE$p() {
        return NO_BAD_CHARACTERS_OR_UNDERSCORE;
    }

    public static final /* synthetic */ NamingRule access$getNO_UNDERSCORES_IN_CAMEL_CASE$p() {
        return NO_UNDERSCORES_IN_CAMEL_CASE;
    }

    public static final /* synthetic */ NamingRule access$getSTART_LOWER$p() {
        return START_LOWER;
    }

    public static final /* synthetic */ boolean access$isFactoryFunction(KtNamedFunction $receiver) {
        return NamingConventionInspectionsKt.isFactoryFunction($receiver);
    }

    public static final /* synthetic */ NamingRule access$getNO_MIDDLE_UNDERSCORES$p() {
        return NO_MIDDLE_UNDERSCORES;
    }

    public static final /* synthetic */ NamingRule access$getNO_START_UPPER$p() {
        return NO_START_UPPER;
    }

    public static final /* synthetic */ NamingRule access$getNO_LOWER$p() {
        return NO_LOWER;
    }

    public static final /* synthetic */ CheckResult access$checkPackageDirective(KtPackageDirective directive, NamingConventionInspectionSettings namingSettings) {
        return NamingConventionInspectionsKt.checkPackageDirective(directive, namingSettings);
    }

    public static final /* synthetic */ CheckResult access$checkQualifiedName(String qualifiedName, NamingConventionInspectionSettings namingSettings) {
        return NamingConventionInspectionsKt.checkQualifiedName(qualifiedName, namingSettings);
    }

    static {
        NamingRule[] namingRuleArray = new NamingRule[]{NO_BAD_CHARACTERS_OR_UNDERSCORE, NO_START_UPPER};
        PART_RULES = namingRuleArray;
    }
}

