/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.inspections.shared;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiModificationUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.RemoveCurlyBracesFromTemplateInspectionKt;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinApplicableInspectionBase;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinModCommandQuickFix;
import org.jetbrains.kotlin.psi.KtBlockStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.KtVisitorVoid;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0011\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\b\u001a\u00020\u0003*\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J \u0010\u000b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u001d\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0003H\u0014\u00a2\u0006\u0002\u0010\u0013J\u001d\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0003H\u0014\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0002H\u0016J#\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u00192\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0003H\u0014\u00a2\u0006\u0002\u0010\u001aJ\r\u0010\u001b\u001a\u00070\u001c\u00a2\u0006\u0002\b\u001dH\u0016R\u0012\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/RemoveCurlyBracesFromTemplateInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinApplicableInspectionBase$Simple;", "Lorg/jetbrains/kotlin/psi/KtBlockStringTemplateEntry;", "", "reportWithoutWhitespace", "", "<init>", "(Z)V", "prepareContext", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "element", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "getProblemDescription", "", "context", "(Lorg/jetbrains/kotlin/psi/KtBlockStringTemplateEntry;Lkotlin/Unit;)Ljava/lang/String;", "getProblemHighlightType", "Lcom/intellij/codeInspection/ProblemHighlightType;", "(Lorg/jetbrains/kotlin/psi/KtBlockStringTemplateEntry;Lkotlin/Unit;)Lcom/intellij/codeInspection/ProblemHighlightType;", "isApplicableByPsi", "createQuickFix", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinModCommandQuickFix;", "(Lorg/jetbrains/kotlin/psi/KtBlockStringTemplateEntry;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinModCommandQuickFix;", "getOptionsPane", "Lcom/intellij/codeInspection/options/OptPane;", "Lorg/jetbrains/annotations/NotNull;", "kotlin.code-insight.inspections.shared"})
public final class RemoveCurlyBracesFromTemplateInspection
extends KotlinApplicableInspectionBase.Simple<KtBlockStringTemplateEntry, Unit> {
    @JvmField
    public boolean reportWithoutWhitespace;

    public RemoveCurlyBracesFromTemplateInspection(boolean reportWithoutWhitespace) {
        this.reportWithoutWhitespace = reportWithoutWhitespace;
    }

    public /* synthetic */ RemoveCurlyBracesFromTemplateInspection(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    @Override
    public void prepareContext(@NotNull KaSession $this$prepareContext, @NotNull KtBlockStringTemplateEntry element) {
        Intrinsics.checkNotNullParameter((Object)$this$prepareContext, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
    }

    @Override
    @NotNull
    public KtVisitor<?, ?> buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        return (KtVisitor)new KtVisitorVoid(this, holder2, isOnTheFly){
            final /* synthetic */ RemoveCurlyBracesFromTemplateInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ boolean $isOnTheFly;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
                this.$isOnTheFly = $isOnTheFly;
            }

            public void visitBlockStringTemplateEntry(KtBlockStringTemplateEntry element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                RemoveCurlyBracesFromTemplateInspection.access$visitTargetElement(this.this$0, element, this.$holder, this.$isOnTheFly);
            }
        };
    }

    @Override
    @NotNull
    protected String getProblemDescription(@NotNull KtBlockStringTemplateEntry element, @NotNull Unit context2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return KotlinBundle.message((String)"redundant.curly.braces.in.string.template", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    protected ProblemHighlightType getProblemHighlightType(@NotNull KtBlockStringTemplateEntry element, @NotNull Unit context2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return this.reportWithoutWhitespace || RemoveCurlyBracesFromTemplateInspectionKt.access$hasWhitespaceAround(element) ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.INFORMATION;
    }

    @Override
    public boolean isApplicableByPsi(@NotNull KtBlockStringTemplateEntry element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return KotlinPsiModificationUtils.canDropCurlyBrackets(element);
    }

    @Override
    @NotNull
    protected KotlinModCommandQuickFix<KtBlockStringTemplateEntry> createQuickFix(@NotNull KtBlockStringTemplateEntry element, @NotNull Unit context2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new KotlinModCommandQuickFix<KtBlockStringTemplateEntry>(){

            public String getFamilyName() {
                return KotlinBundle.message((String)"remove.curly.braces", (Object[])new Object[0]);
            }

            protected void applyFix(Project project, KtBlockStringTemplateEntry element, ModPsiUpdater updater2) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
                KotlinPsiModificationUtils.dropCurlyBracketsIfPossible(element);
            }
        };
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptRegularComponent[] optRegularComponentArray = new OptRegularComponent[]{OptPane.checkbox((String)"reportWithoutWhitespace", (String)KotlinBundle.message((String)"report.also.for.a.variables.without.a.whitespace.around", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])};
        OptPane optPane = OptPane.pane((OptRegularComponent[])optRegularComponentArray);
        Intrinsics.checkNotNullExpressionValue((Object)optPane, (String)"pane(...)");
        return optPane;
    }

    public RemoveCurlyBracesFromTemplateInspection() {
        this(false, 1, null);
    }

    public static final /* synthetic */ void access$visitTargetElement(RemoveCurlyBracesFromTemplateInspection $this, KtBlockStringTemplateEntry element, ProblemsHolder holder2, boolean isOnTheFly) {
        $this.visitTargetElement((KtElement)element, holder2, isOnTheFly);
    }
}

