/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.inspections.shared;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinApplicableInspectionBase;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinModCommandQuickFix;
import org.jetbrains.kotlin.idea.codeinsight.utils.KotlinPsiUtilsKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.KtVisitorVoid;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0003H\u0014\u00a2\u0006\u0002\u0010\u000bJ#\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\r2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0003H\u0014\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\t\u001a\u00020\u0002H\u0016J \u0010\u0012\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0014\u0010\u0018\u001a\u00020\u0003*\u00020\u00192\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/RemoveUnnecessaryParenthesesInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinApplicableInspectionBase$Simple;", "Lorg/jetbrains/kotlin/psi/KtParenthesizedExpression;", "", "<init>", "()V", "getProblemDescription", "", "Lcom/intellij/codeInspection/util/InspectionMessage;", "element", "context", "(Lorg/jetbrains/kotlin/psi/KtParenthesizedExpression;Lkotlin/Unit;)Ljava/lang/String;", "createQuickFix", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinModCommandQuickFix;", "(Lorg/jetbrains/kotlin/psi/KtParenthesizedExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinModCommandQuickFix;", "getApplicableRanges", "", "Lcom/intellij/openapi/util/TextRange;", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "prepareContext", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "kotlin.code-insight.inspections.shared"})
public final class RemoveUnnecessaryParenthesesInspection
extends KotlinApplicableInspectionBase.Simple<KtParenthesizedExpression, Unit> {
    @Override
    @NotNull
    protected String getProblemDescription(@NotNull KtParenthesizedExpression element, @NotNull Unit context2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return KotlinBundle.message((String)"inspection.remove.unnecessary.parentheses.problem.description", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    protected KotlinModCommandQuickFix<KtParenthesizedExpression> createQuickFix(@NotNull KtParenthesizedExpression element, @NotNull Unit context2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new KotlinModCommandQuickFix<KtParenthesizedExpression>(){

            public String getFamilyName() {
                return KotlinBundle.message((String)"inspection.remove.unnecessary.parentheses.quickfix.text", (Object[])new Object[0]);
            }

            protected void applyFix(Project project, KtParenthesizedExpression element, ModPsiUpdater updater2) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
                KotlinPsiUtilsKt.removeUnnecessaryParentheses(element);
            }
        };
    }

    @Override
    @NotNull
    public List<TextRange> getApplicableRanges(@NotNull KtParenthesizedExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtExpression ktExpression = element.getExpression();
        if (ktExpression == null) {
            return CollectionsKt.emptyList();
        }
        KtExpression inner = ktExpression;
        if (!KtPsiUtil.areParenthesesUseless((KtParenthesizedExpression)element)) {
            return CollectionsKt.emptyList();
        }
        TextRange elementRange = element.getTextRange();
        TextRange innerRange = inner.getTextRange();
        TextRange left = innerRange.getStartOffset() > elementRange.getStartOffset() ? new TextRange(0, innerRange.getStartOffset() - elementRange.getStartOffset()) : null;
        TextRange right = innerRange.getEndOffset() < elementRange.getEndOffset() ? new TextRange(innerRange.getEndOffset() - elementRange.getStartOffset(), elementRange.getLength()) : null;
        Object[] objectArray = new TextRange[]{left, right};
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    @Override
    @NotNull
    public KtVisitor<?, ?> buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        return (KtVisitor)new KtVisitorVoid(this, holder2, isOnTheFly){
            final /* synthetic */ RemoveUnnecessaryParenthesesInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ boolean $isOnTheFly;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
                this.$isOnTheFly = $isOnTheFly;
            }

            public void visitParenthesizedExpression(KtParenthesizedExpression expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                RemoveUnnecessaryParenthesesInspection.access$visitTargetElement(this.this$0, expression, this.$holder, this.$isOnTheFly);
            }
        };
    }

    @Override
    public void prepareContext(@NotNull KaSession $this$prepareContext, @NotNull KtParenthesizedExpression element) {
        Intrinsics.checkNotNullParameter((Object)$this$prepareContext, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
    }

    public static final /* synthetic */ void access$visitTargetElement(RemoveUnnecessaryParenthesesInspection $this, KtParenthesizedExpression element, ProblemsHolder holder2, boolean isOnTheFly) {
        $this.visitTargetElement((KtElement)element, holder2, isOnTheFly);
    }
}

