/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.inspections.shared;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.SetterBackingFieldAssignmentInspectionKt;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.SuspiciousVarPropertyInspectionKt;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinApplicableInspectionBase;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinModCommandQuickFix;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.idea.util.AnalysisUtilsKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u001b\u0010\u0012\u001a\u0004\u0018\u00010\u0003*\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0014J\"\u0010\u0015\u001a\u00070\u0016\u00a2\u0006\u0002\b\u00172\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0003H\u0014\u00a2\u0006\u0002\u0010\u0019J#\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0003H\u0014\u00a2\u0006\u0002\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/SetterBackingFieldAssignmentInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinApplicableInspectionBase$Simple;", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "", "Lcom/intellij/codeInspection/CleanupLocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "isApplicableByPsi", "element", "getApplicableRanges", "", "Lcom/intellij/openapi/util/TextRange;", "prepareContext", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;)Lkotlin/Unit;", "getProblemDescription", "", "Lcom/intellij/codeInspection/util/InspectionMessage;", "context", "(Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;Lkotlin/Unit;)Ljava/lang/String;", "createQuickFix", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinModCommandQuickFix;", "(Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinModCommandQuickFix;", "kotlin.code-insight.inspections.shared"})
@SourceDebugExtension(value={"SMAP\nSetterBackingFieldAssignmentInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SetterBackingFieldAssignmentInspection.kt\norg/jetbrains/kotlin/idea/codeInsight/inspections/shared/SetterBackingFieldAssignmentInspection\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 ContextProvider.kt\norg/jetbrains/kotlin/idea/codeinsight/api/applicable/ContextProviderKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,138:1\n420#2:139\n431#2,10:140\n453#2:150\n48#3:151\n1807#4,3:152\n*S KotlinDebug\n*F\n+ 1 SetterBackingFieldAssignmentInspection.kt\norg/jetbrains/kotlin/idea/codeInsight/inspections/shared/SetterBackingFieldAssignmentInspection\n*L\n58#1:139\n58#1:140,10\n58#1:150\n79#1:151\n67#1:152,3\n*E\n"})
public final class SetterBackingFieldAssignmentInspection
extends KotlinApplicableInspectionBase.Simple<KtPropertyAccessor, Unit>
implements CleanupLocalInspectionTool {
    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        return VisitorWrappersKt.propertyAccessorVisitor(arg_0 -> SetterBackingFieldAssignmentInspection.buildVisitor$lambda$0(this, holder2, isOnTheFly, arg_0));
    }

    @Override
    public boolean isApplicableByPsi(@NotNull KtPropertyAccessor element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!element.isSetter()) {
            return false;
        }
        KtBlockExpression ktBlockExpression = element.getBodyBlockExpression();
        if (ktBlockExpression == null) {
            return false;
        }
        KtBlockExpression bodyExpression = ktBlockExpression;
        if (bodyExpression.getFirstStatement() instanceof KtThrowExpression) {
            return false;
        }
        return CollectionsKt.singleOrNull((List)element.getValueParameters()) != null;
    }

    @Override
    @NotNull
    public List<TextRange> getApplicableRanges(@NotNull KtPropertyAccessor element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement name2 = element.getNamePlaceholder();
        KtParameterList ktParameterList = element.getParameterList();
        if (ktParameterList == null || (ktParameterList = ktParameterList.getRightParenthesis()) == null) {
            ktParameterList = name2;
        }
        KtParameterList right = ktParameterList;
        TextRange textRange = new TextRange(PsiUtilsKt.getStartOffset((PsiElement)name2), PsiUtilsKt.getEndOffset((PsiElement)right)).shiftLeft(PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)element)));
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"shiftLeft(...)");
        TextRange range2 = textRange;
        return CollectionsKt.listOf((Object)range2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Unit prepareContext(@NotNull KaSession $this$prepareContext, @NotNull KtPropertyAccessor element) {
        void $this$findDescendantOfType$iv$iv$iv;
        void $this$findDescendantOfType$iv$iv;
        void $this$anyDescendantOfType$iv;
        Intrinsics.checkNotNullParameter((Object)$this$prepareContext, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtProperty property = element.getProperty();
        if (!AnalysisUtilsKt.isBackingFieldRequired($this$prepareContext, property)) {
            return null;
        }
        KtParameter ktParameter = (KtParameter)CollectionsKt.singleOrNull((List)element.getValueParameters());
        if (ktParameter == null) {
            return null;
        }
        KtParameter parameter = ktParameter;
        KtBlockExpression ktBlockExpression = element.getBodyBlockExpression();
        if (ktBlockExpression == null) {
            return null;
        }
        KtBlockExpression bodyExpression = ktBlockExpression;
        PsiElement psiElement = (PsiElement)bodyExpression;
        Function1 predicate$iv = arg_0 -> SetterBackingFieldAssignmentInspection.prepareContext$lambda$0($this$prepareContext, property, parameter, arg_0);
        boolean $i$f$anyDescendantOfType = false;
        void var10_11 = $this$anyDescendantOfType$iv;
        Function1 predicate$iv$iv = predicate$iv;
        boolean $i$f$findDescendantOfType = false;
        void var13_14 = $this$findDescendantOfType$iv$iv;
        Function1 predicate$iv$iv$iv = predicate$iv$iv;
        boolean $i$f$findDescendantOfType2 = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$findDescendantOfType$iv$iv$iv);
        Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
        $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv$iv$iv, result$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $predicate;
                this.$result = $result;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtExpression && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                    this.$result.element = element;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
            }
        });
        boolean hasAllowedUsage = (PsiElement)result$iv$iv$iv.element != null;
        boolean $this$asUnit$iv = !hasAllowedUsage;
        boolean $i$f$getAsUnit = false;
        return $this$asUnit$iv ? Unit.INSTANCE : null;
    }

    @Override
    @NotNull
    protected String getProblemDescription(@NotNull KtPropertyAccessor element, @NotNull Unit context2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return KotlinBundle.message((String)"existing.backing.field.is.not.assigned.by.the.setter", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    protected KotlinModCommandQuickFix<KtPropertyAccessor> createQuickFix(@NotNull KtPropertyAccessor element, @NotNull Unit context2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new KotlinModCommandQuickFix<KtPropertyAccessor>(){

            public String getFamilyName() {
                return KotlinBundle.message((String)"assign.backing.field.fix.text", (Object[])new Object[0]);
            }

            protected void applyFix(Project project, KtPropertyAccessor element, ModPsiUpdater updater2) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
                KtParameter ktParameter = (KtParameter)CollectionsKt.firstOrNull((List)element.getValueParameters());
                if (ktParameter == null) {
                    return;
                }
                KtParameter parameter = ktParameter;
                KtBlockExpression ktBlockExpression = element.getBodyBlockExpression();
                if (ktBlockExpression == null) {
                    return;
                }
                KtBlockExpression bodyExpression = ktBlockExpression;
                SetterBackingFieldAssignmentInspectionKt.access$removeRedundantWhiteSpace(bodyExpression);
                KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
                KtExpression assignment2 = psiFactory.createExpression("field = " + parameter.getName());
                List list2 = bodyExpression.getStatements();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getStatements(...)");
                KtExpression lastStatement = (KtExpression)CollectionsKt.lastOrNull((List)list2);
                if (lastStatement != null) {
                    bodyExpression.addAfter((PsiElement)assignment2, (PsiElement)lastStatement);
                    bodyExpression.addAfter(psiFactory.createNewLine(), (PsiElement)lastStatement);
                    v3 = GenericPsiUtils.reformatted$default((PsiElement)bodyExpression, false, 1, null);
                } else {
                    v3 = bodyExpression.addBefore((PsiElement)assignment2, bodyExpression.getRBrace());
                }
            }
        };
    }

    private static final Unit buildVisitor$lambda$0(SetterBackingFieldAssignmentInspection this$0, ProblemsHolder $holder, boolean $isOnTheFly, KtPropertyAccessor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.visitTargetElement((KtElement)it, $holder, $isOnTheFly);
        return Unit.INSTANCE;
    }

    private static final boolean prepareContext$lambda$0(KaSession $this_prepareContext, KtProperty $property, KtParameter $parameter, KtExpression expr) {
        boolean bl;
        block9: {
            Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
            KtExpression ktExpression = expr;
            if (ktExpression instanceof KtBinaryExpression) {
                bl = SuspiciousVarPropertyInspectionKt.isBackingFieldReference($this_prepareContext, ((KtBinaryExpression)expr).getLeft(), $property) && CollectionsKt.contains((Iterable)SetterBackingFieldAssignmentInspectionKt.access$getAssignmentOperators$p(), (Object)((KtBinaryExpression)expr).getOperationToken());
            } else if (ktExpression instanceof KtUnaryExpression) {
                bl = SuspiciousVarPropertyInspectionKt.isBackingFieldReference($this_prepareContext, ((KtUnaryExpression)expr).getBaseExpression(), $property) && CollectionsKt.contains((Iterable)SetterBackingFieldAssignmentInspectionKt.access$getIncrementAndDecrementOperators$p(), (Object)((KtUnaryExpression)expr).getOperationToken());
            } else if (ktExpression instanceof KtCallExpression) {
                Iterable $this$any$iv = ((KtCallExpression)expr).getValueArguments();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        KtReference ktReference;
                        KtValueArgument arg = (KtValueArgument)element$iv;
                        boolean bl2 = false;
                        KtExpression ktExpression2 = arg.getArgumentExpression();
                        KaSymbol argumentSymbol = ktExpression2 != null && (ktReference = ReferenceUtilsKt.getMainReference((KtElement)((KtElement)ktExpression2))) != null ? $this_prepareContext.resolveToSymbol(ktReference) : null;
                        if (!(argumentSymbol != null && Intrinsics.areEqual((Object)argumentSymbol, (Object)$this_prepareContext.getSymbol($parameter)))) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }
}

