/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.inspections.shared;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinApplicableInspectionBase;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinModCommandQuickFix;
import org.jetbrains.kotlin.idea.codeinsight.utils.NegatedBinaryExpressionSimplificationUtils;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001b\u0010\u0006\u001a\u0004\u0018\u00010\u0003*\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0002H\u0016J \u0010\u000b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0003H\u0014J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0003H\u0014J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u00162\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0003H\u0014\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/SimplifyNegatedBinaryExpressionInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinApplicableInspectionBase$Simple;", "Lorg/jetbrains/kotlin/psi/KtPrefixExpression;", "", "<init>", "()V", "prepareContext", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "element", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtPrefixExpression;)Ljava/lang/Boolean;", "isApplicableByPsi", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "getProblemDescription", "", "context", "getProblemHighlightType", "Lcom/intellij/codeInspection/ProblemHighlightType;", "createQuickFix", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinModCommandQuickFix;", "kotlin.code-insight.inspections.shared"})
public final class SimplifyNegatedBinaryExpressionInspection
extends KotlinApplicableInspectionBase.Simple<KtPrefixExpression, Boolean> {
    @Override
    @Nullable
    public Boolean prepareContext(@NotNull KaSession $this$prepareContext, @NotNull KtPrefixExpression element) {
        Intrinsics.checkNotNullParameter((Object)$this$prepareContext, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return NegatedBinaryExpressionSimplificationUtils.INSTANCE.canBeSimplified(element) ? Boolean.valueOf(NegatedBinaryExpressionSimplificationUtils.INSTANCE.canBeSimplifiedWithoutChangingSemantics(element)) : null;
    }

    @Override
    public boolean isApplicableByPsi(@NotNull KtPrefixExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return NegatedBinaryExpressionSimplificationUtils.INSTANCE.canBeSimplified(element);
    }

    @Override
    @NotNull
    public KtVisitor<?, ?> buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        return (KtVisitor)VisitorWrappersKt.prefixExpressionVisitor(arg_0 -> SimplifyNegatedBinaryExpressionInspection.buildVisitor$lambda$0(this, holder2, isOnTheFly, arg_0));
    }

    @Override
    @NotNull
    protected String getProblemDescription(@NotNull KtPrefixExpression element, boolean context2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return KotlinBundle.message((String)"negated.operation.can.be.simplified", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    protected ProblemHighlightType getProblemHighlightType(@NotNull KtPrefixExpression element, boolean context2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return context2 ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.INFORMATION;
    }

    @Override
    @NotNull
    protected KotlinModCommandQuickFix<KtPrefixExpression> createQuickFix(@NotNull KtPrefixExpression element, boolean context2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return new KotlinModCommandQuickFix<KtPrefixExpression>(element){
            final /* synthetic */ KtPrefixExpression $element;
            {
                this.$element = $element;
            }

            public String getFamilyName() {
                return KotlinBundle.message((String)"simplify.negated.operation", (Object[])new Object[0]);
            }

            public String getName() {
                KtExpression ktExpression = KtPsiUtil.deparenthesize((KtExpression)this.$element.getBaseExpression());
                KtOperationExpression ktOperationExpression = ktExpression instanceof KtOperationExpression ? (KtOperationExpression)ktExpression : null;
                if (ktOperationExpression == null) {
                    return this.getFamilyName();
                }
                KtOperationExpression expression = ktOperationExpression;
                IElementType iElementType = expression.getOperationReference().getReferencedNameElementType();
                KtSingleValueToken ktSingleValueToken = iElementType instanceof KtSingleValueToken ? (KtSingleValueToken)iElementType : null;
                if (ktSingleValueToken == null) {
                    return this.getFamilyName();
                }
                KtSingleValueToken operation = ktSingleValueToken;
                KtSingleValueToken ktSingleValueToken2 = NegatedBinaryExpressionSimplificationUtils.INSTANCE.negate((IElementType)operation);
                if (ktSingleValueToken2 == null) {
                    return this.getFamilyName();
                }
                KtSingleValueToken negatedOperation = ktSingleValueToken2;
                String message2 = NegatedBinaryExpressionSimplificationUtils.INSTANCE.canBeSimplifiedWithoutChangingSemantics(this.$element) ? "replace.negated.0.operation.with.1" : "replace.negated.0.operation.with.1.may.change.semantics.with.floating.point.types";
                Object[] objectArray = new Object[2];
                Intrinsics.checkNotNullExpressionValue((Object)operation.getValue(), (String)"getValue(...)");
                Intrinsics.checkNotNullExpressionValue((Object)negatedOperation.getValue(), (String)"getValue(...)");
                return KotlinBundle.message((String)message2, (Object[])objectArray);
            }

            protected void applyFix(Project project, KtPrefixExpression element, ModPsiUpdater updater2) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
                NegatedBinaryExpressionSimplificationUtils.INSTANCE.simplify(element);
            }
        };
    }

    private static final Unit buildVisitor$lambda$0(SimplifyNegatedBinaryExpressionInspection this$0, ProblemsHolder $holder, boolean $isOnTheFly, KtPrefixExpression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.visitTargetElement((KtElement)it, $holder, $isOnTheFly);
        return Unit.INSTANCE;
    }
}

