/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.inspections.shared;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.TrailingCommaInspection;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.codeinsight.utils.TrailingCommaUtilsKt;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.visitor.TrailingCommaVisitor;
import org.jetbrains.kotlin.idea.core.formatter.KotlinCodeStyleSettings;
import org.jetbrains.kotlin.idea.formatter.CodeStyleUtilsKt;
import org.jetbrains.kotlin.idea.formatter.trailingComma.TrailingCommaContext;
import org.jetbrains.kotlin.idea.formatter.trailingComma.TrailingCommaHelper;
import org.jetbrains.kotlin.idea.formatter.trailingComma.UtilKt;
import org.jetbrains.kotlin.idea.util.FormatterUtilKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.utils.KotlinExceptionWithAttachments;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000eB\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003H\u0016J\r\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rH\u0016R\u0012\u0010\u0002\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/TrailingCommaInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractKotlinInspection;", "addCommaWarning", "", "<init>", "(Z)V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "getOptionsPane", "Lcom/intellij/codeInspection/options/OptPane;", "Lorg/jetbrains/annotations/NotNull;", "ReformatTrailingCommaFix", "kotlin.code-insight.inspections.shared"})
public final class TrailingCommaInspection
extends AbstractKotlinInspection {
    @JvmField
    public boolean addCommaWarning;

    public TrailingCommaInspection(boolean addCommaWarning) {
        this.addCommaWarning = addCommaWarning;
    }

    public /* synthetic */ TrailingCommaInspection(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        return (PsiElementVisitor)new TrailingCommaVisitor(this, isOnTheFly, holder2){
            static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
            private final boolean recursively;
            private final ReadWriteProperty useTrailingComma$delegate;
            final /* synthetic */ TrailingCommaInspection this$0;
            final /* synthetic */ boolean $isOnTheFly;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$isOnTheFly = $isOnTheFly;
                this.$holder = $holder;
                this.useTrailingComma$delegate = Delegates.INSTANCE.notNull();
            }

            protected boolean getRecursively() {
                return this.recursively;
            }

            private final boolean getUseTrailingComma() {
                return (Boolean)this.useTrailingComma$delegate.getValue((Object)((Object)this), $$delegatedProperties[0]);
            }

            private final void setUseTrailingComma(boolean bl) {
                this.useTrailingComma$delegate.setValue((Object)((Object)this), $$delegatedProperties[0], (Object)bl);
            }

            protected void process(TrailingCommaContext trailingCommaContext) {
                Intrinsics.checkNotNullParameter((Object)trailingCommaContext, (String)"trailingCommaContext");
                KtElement element = trailingCommaContext.getKtElement();
                KtFile ktFile2 = element.getContainingKtFile();
                Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"getContainingKtFile(...)");
                KotlinCodeStyleSettings kotlinCustomSettings = CodeStyleUtilsKt.getKotlinCustomSettings((PsiFile)((PsiFile)ktFile2));
                this.setUseTrailingComma(UtilKt.addTrailingCommaIsAllowedFor((KotlinCodeStyleSettings)kotlinCustomSettings, (PsiElement)((PsiElement)element)));
                switch (buildVisitor.WhenMappings.$EnumSwitchMapping$0[trailingCommaContext.getState().ordinal()]) {
                    case 1: 
                    case 2: {
                        this.checkCommaPosition(element);
                        this.checkLineBreaks(element);
                        break;
                    }
                }
                this.checkTrailingComma(trailingCommaContext);
            }

            private final void checkLineBreaks(KtElement commaOwner) {
                PsiElement last;
                PsiElement psiElement;
                PsiElement first2 = TrailingCommaHelper.INSTANCE.elementBeforeFirstElement(commaOwner);
                PsiElement psiElement2 = first2;
                boolean bl = psiElement2 != null && (psiElement2 = PsiUtilsKt.nextLeaf((PsiElement)psiElement2, (boolean)true)) != null ? !FormatterUtilKt.isLineBreak((PsiElement)psiElement2) : false;
                if (bl) {
                    PsiElement psiElement3 = first2.getNextSibling();
                    if (psiElement3 != null) {
                        PsiElement it = psiElement3;
                        boolean bl2 = false;
                        this.registerProblemForLineBreak(commaOwner, it, ProblemHighlightType.INFORMATION);
                    }
                }
                boolean bl3 = (psiElement = (last = TrailingCommaHelper.INSTANCE.elementAfterLastElement(commaOwner))) != null && (psiElement = PsiUtilsKt.prevLeaf((PsiElement)psiElement, (boolean)true)) != null ? !FormatterUtilKt.isLineBreak((PsiElement)psiElement) : false;
                if (bl3) {
                    this.registerProblemForLineBreak(commaOwner, last, this.this$0.addCommaWarning ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.INFORMATION);
                }
            }

            private final void checkCommaPosition(KtElement commaOwner) {
                for (PsiElement invalidComma : TrailingCommaHelper.INSTANCE.findInvalidCommas(commaOwner)) {
                    buildVisitor.1.reportProblem$default(this, invalidComma, KotlinBundle.message((String)"inspection.trailing.comma.comma.loses.the.advantages.in.this.position", (Object[])new Object[0]), KotlinBundle.message((String)"inspection.trailing.comma.fix.comma.position", (Object[])new Object[0]), null, false, 24, null);
                }
            }

            private final void checkTrailingComma(TrailingCommaContext trailingCommaContext) {
                KtElement commaOwner = trailingCommaContext.getKtElement();
                PsiElement psiElement = TrailingCommaHelper.INSTANCE.trailingCommaOrLastElement(commaOwner);
                if (psiElement == null) {
                    return;
                }
                PsiElement trailingCommaOrLastElement = psiElement;
                switch (buildVisitor.WhenMappings.$EnumSwitchMapping$0[trailingCommaContext.getState().ordinal()]) {
                    case 1: {
                        if (!TrailingCommaUtilsKt.trailingCommaAllowedInModule((PsiElement)commaOwner)) {
                            return;
                        }
                        buildVisitor.1.reportProblem$default(this, trailingCommaOrLastElement, KotlinBundle.message((String)"inspection.trailing.comma.missing.trailing.comma", (Object[])new Object[0]), KotlinBundle.message((String)"inspection.trailing.comma.add.trailing.comma", (Object[])new Object[0]), this.this$0.addCommaWarning ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.INFORMATION, false, 16, null);
                        break;
                    }
                    case 3: {
                        this.reportProblem(trailingCommaOrLastElement, KotlinBundle.message((String)"inspection.trailing.comma.redundant.trailing.comma", (Object[])new Object[0]), KotlinBundle.message((String)"inspection.trailing.comma.remove.trailing.comma", (Object[])new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, false);
                        break;
                    }
                }
            }

            private final void reportProblem(PsiElement commaOrElement, @InspectionMessage String message2, @IntentionFamilyName String fixMessage, ProblemHighlightType highlightType, boolean checkTrailingCommaSettings) {
                PsiElement psiElement = commaOrElement.getParent();
                Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
                KtElement commaOwner = (KtElement)psiElement;
                PsiElement problemOwner = this.commonParent((PsiElement)commaOwner, commaOrElement);
                ProblemHighlightType highlightTypeWithAppliedCondition = this.applyCondition(highlightType, !checkTrailingCommaSettings || this.getUseTrailingComma());
                if (this.$isOnTheFly || highlightTypeWithAppliedCondition != ProblemHighlightType.INFORMATION) {
                    LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{this.createQuickFix(fixMessage, commaOwner)};
                    this.$holder.registerProblem(problemOwner, message2, highlightTypeWithAppliedCondition, this.getTextRangeOfCommaOrSymbolAfter(commaOrElement).shiftLeft(PsiUtilsKt.getStartOffset((PsiElement)problemOwner)), localQuickFixArray);
                }
            }

            static /* synthetic */ void reportProblem$default(buildVisitor.1 var0, PsiElement psiElement, String string, String string2, ProblemHighlightType problemHighlightType, boolean bl, int n, Object object) {
                if ((n & 8) != 0) {
                    problemHighlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                }
                if ((n & 0x10) != 0) {
                    bl = true;
                }
                var0.reportProblem(psiElement, string, string2, problemHighlightType, bl);
            }

            private final void registerProblemForLineBreak(KtElement commaOwner, PsiElement elementForTextRange, ProblemHighlightType highlightType) {
                PsiElement problemElement = this.commonParent((PsiElement)commaOwner, elementForTextRange);
                ProblemHighlightType highlightTypeWithAppliedCondition = this.applyCondition(highlightType, this.getUseTrailingComma());
                if (this.$isOnTheFly || highlightTypeWithAppliedCondition != ProblemHighlightType.INFORMATION) {
                    LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{this.createQuickFix(KotlinBundle.message((String)"inspection.trailing.comma.add.line.break", (Object[])new Object[0]), commaOwner)};
                    this.$holder.registerProblem(problemElement, KotlinBundle.message((String)"inspection.trailing.comma.missing.line.break", (Object[])new Object[0]), highlightTypeWithAppliedCondition, TextRange.from((int)PsiUtilsKt.getStartOffset((PsiElement)elementForTextRange), (int)1).shiftLeft(PsiUtilsKt.getStartOffset((PsiElement)problemElement)), localQuickFixArray);
                }
            }

            private final PsiElement commonParent(PsiElement commaOwner, PsiElement elementForTextRange) {
                PsiElement psiElement = PsiTreeUtil.findCommonParent((PsiElement)commaOwner, (PsiElement)elementForTextRange);
                if (psiElement == null) {
                    throw new KotlinExceptionWithAttachments("Common parent not found").withPsiAttachment("commaOwner", commaOwner).withAttachment("commaOwnerRange", (Object)commaOwner.getTextRange()).withPsiAttachment("elementForTextRange", elementForTextRange).withAttachment("elementForTextRangeRange", (Object)elementForTextRange.getTextRange()).withPsiAttachment("parent", commaOwner.getParent()).withAttachment("parentRange", (Object)commaOwner.getParent().getTextRange());
                }
                return psiElement;
            }

            private final ProblemHighlightType applyCondition(ProblemHighlightType $this$applyCondition, boolean condition2) {
                boolean $i$f$isUnitTestMode = false;
                return ApplicationManager.getApplication().isUnitTestMode() ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : (condition2 ? $this$applyCondition : ProblemHighlightType.INFORMATION);
            }

            private final PsiUpdateModCommandQuickFix createQuickFix(@IntentionFamilyName String fixMessage, KtElement commaOwner) {
                return new ReformatTrailingCommaFix(commaOwner, fixMessage);
            }

            private final TextRange getTextRangeOfCommaOrSymbolAfter(PsiElement $this$textRangeOfCommaOrSymbolAfter) {
                Object object;
                block5: {
                    TextRange textRange;
                    block4: {
                        textRange = $this$textRangeOfCommaOrSymbolAfter.getTextRange();
                        if (FormatterUtilKt.isComma((PsiElement)$this$textRangeOfCommaOrSymbolAfter)) {
                            Intrinsics.checkNotNull((Object)textRange);
                            return textRange;
                        }
                        object = PsiUtilsKt.nextLeaf$default((PsiElement)$this$textRangeOfCommaOrSymbolAfter, (boolean)false, (int)1, null);
                        if (object == null || (object = FormatterUtilKt.leafIgnoringWhitespaceAndComments$default((PsiElement)object, (boolean)false, (boolean)false, (int)2, null)) == null) break block4;
                        Integer n = PsiUtilsKt.getEndOffset((PsiElement)object);
                        int it = ((Number)n).intValue();
                        boolean bl = false;
                        object = it > 0 ? n : null;
                        if (object == null) break block4;
                        int it2 = ((Number)object).intValue();
                        boolean bl2 = false;
                        TextRange textRange2 = TextRange.create((int)(it2 - 1), (int)it2).intersection(textRange);
                        object = textRange2;
                        if (textRange2 != null) break block5;
                    }
                    TextRange textRange3 = TextRange.create((int)(textRange.getEndOffset() - 1), (int)textRange.getEndOffset());
                    object = textRange3;
                    Intrinsics.checkNotNullExpressionValue((Object)textRange3, (String)"create(...)");
                }
                return object;
            }

            static {
                KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(buildVisitor.1.class, "useTrailingComma", "getUseTrailingComma()Z", 0)))};
                $$delegatedProperties = kPropertyArray;
            }
        };
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptRegularComponent[] optRegularComponentArray = new OptRegularComponent[]{OptPane.checkbox((String)"addCommaWarning", (String)KotlinBundle.message((String)"inspection.trailing.comma.report.also.a.missing.comma", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])};
        OptPane optPane = OptPane.pane((OptRegularComponent[])optRegularComponentArray);
        Intrinsics.checkNotNullExpressionValue((Object)optPane, (String)"pane(...)");
        return optPane;
    }

    public TrailingCommaInspection() {
        this(false, 1, null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\n\u001a\u00070\u0005\u00a2\u0006\u0002\b\u000bH\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/TrailingCommaInspection$ReformatTrailingCommaFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandQuickFix;", "commaOwner", "Lorg/jetbrains/kotlin/psi/KtElement;", "fixMessage", "", "<init>", "(Lorg/jetbrains/kotlin/psi/KtElement;Ljava/lang/String;)V", "commaOwnerPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "getFamilyName", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "element", "Lcom/intellij/psi/PsiElement;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "createFormatterTextRange", "Lcom/intellij/openapi/util/TextRange;", "kotlin.code-insight.inspections.shared"})
    public static final class ReformatTrailingCommaFix
    extends PsiUpdateModCommandQuickFix {
        @NotNull
        private final String fixMessage;
        @NotNull
        private final SmartPsiElementPointer<KtElement> commaOwnerPointer;

        public ReformatTrailingCommaFix(@NotNull KtElement commaOwner, @IntentionFamilyName @NotNull String fixMessage) {
            Intrinsics.checkNotNullParameter((Object)commaOwner, (String)"commaOwner");
            Intrinsics.checkNotNullParameter((Object)fixMessage, (String)"fixMessage");
            this.fixMessage = fixMessage;
            this.commaOwnerPointer = SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)commaOwner));
        }

        @NotNull
        public String getFamilyName() {
            return this.fixMessage;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
            KtElement ktElement = (KtElement)updater2.getWritable(this.commaOwnerPointer.getElement());
            if (ktElement == null) {
                return;
            }
            KtElement element2 = ktElement;
            TextRange range2 = this.createFormatterTextRange(element2);
            CodeStyle.runWithLocalSettings((Project)project, (CodeStyleSettings)CodeStyle.getSettings((PsiFile)((PsiFile)element2.getContainingKtFile())), arg_0 -> ReformatTrailingCommaFix.applyFix$lambda$1(arg_0 -> ReformatTrailingCommaFix.applyFix$lambda$0(project, element2, range2, arg_0), arg_0));
        }

        private final TextRange createFormatterTextRange(KtElement commaOwner) {
            PsiElement psiElement;
            PsiElement startElement;
            PsiElement psiElement2 = TrailingCommaHelper.INSTANCE.elementBeforeFirstElement(commaOwner);
            if (psiElement2 == null) {
                psiElement2 = startElement = (PsiElement)commaOwner;
            }
            if ((psiElement = TrailingCommaHelper.INSTANCE.elementAfterLastElement(commaOwner)) == null) {
                psiElement = (PsiElement)commaOwner;
            }
            PsiElement endElement = psiElement;
            TextRange textRange = TextRange.create((int)PsiUtilsKt.getStartOffset((PsiElement)startElement), (int)PsiUtilsKt.getEndOffset((PsiElement)endElement));
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"create(...)");
            return textRange;
        }

        private static final Unit applyFix$lambda$0(Project $project, KtElement $element, TextRange $range, CodeStyleSettings tempSettings) {
            Intrinsics.checkNotNullParameter((Object)tempSettings, (String)"tempSettings");
            CodeStyleUtilsKt.getKotlinCustomSettings((CodeStyleSettings)tempSettings).ALLOW_TRAILING_COMMA = true;
            CodeStyleUtilsKt.getKotlinCustomSettings((CodeStyleSettings)tempSettings).ALLOW_TRAILING_COMMA_ON_CALL_SITE = true;
            CodeStyleManager.getInstance((Project)$project).reformatRange((PsiElement)$element, $range.getStartOffset(), $range.getEndOffset());
            return Unit.INSTANCE;
        }

        private static final void applyFix$lambda$1(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }
    }
}

