/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.inspections.shared.blockingCallsDetection;

import com.intellij.codeInsight.actions.OptimizeImportsProcessor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.components.KaResolverKt;
import org.jetbrains.kotlin.analysis.api.components.KaTypeInformationProviderKt;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.resolution.KaCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfoKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallableMemberCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaFunctionCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaReceiverValue;
import org.jetbrains.kotlin.analysis.api.resolution.KaSuccessCallInfo;
import org.jetbrains.kotlin.analysis.api.signatures.KaVariableSignature;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassLikeSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaValueParameterSymbol;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.idea.base.codeInsight.ShortenReferencesFacility;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.blockingCallsDetection.CoroutineBlockingCallInspectionUtils$findFlowOnCall$;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.blockingCallsDetection.CoroutineBlockingCallInspectionUtilsKt;
import org.jetbrains.kotlin.idea.codeinsight.utils.DocumentUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtNamedFunction;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0016\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tR\u00020\u0006j\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u001f\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eR\u00020\u0006j\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000fJ\u001f\u0010\u0010\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eR\u00020\u0006j\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000fJ!\u0010\u0011\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u00020\u0006j\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016J$\u0010\u0017\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0018*\u00020\u0019H\u0086\u0010R\u00020\u0006j\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001eR\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010#\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010&\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010%R\u0011\u0010(\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010%R\u0011\u0010*\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010%R\u0011\u0010,\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010%R\u0011\u0010.\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010%R\u0011\u00100\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010%R\u0011\u00102\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010%R\u0011\u00104\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010%R\u0011\u00106\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010%\u00a8\u00068"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/blockingCallsDetection/CoroutineBlockingCallInspectionUtils;", "", "<init>", "()V", "isInSuspendLambdaOrFunction", "", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "<unused var>", "ktElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtElement;)Z", "isKotlinxOnClasspath", "isInsideFlowChain", "call", "Lorg/jetbrains/kotlin/analysis/api/resolution/KaCall;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/analysis/api/resolution/KaCall;)Z", "isCalledInsideNonIoContext", "isNonBlockingDispatcher", "postProcessQuickFix", "", "replacedElement", "project", "Lcom/intellij/openapi/project/Project;", "findFlowOnCall", "Lorg/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtExpression;)Lorg/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall;", "BLOCKING_EXECUTOR_ANNOTATION", "Lorg/jetbrains/kotlin/name/ClassId;", "getBLOCKING_EXECUTOR_ANNOTATION", "()Lorg/jetbrains/kotlin/name/ClassId;", "NONBLOCKING_EXECUTOR_ANNOTATION", "getNONBLOCKING_EXECUTOR_ANNOTATION", "DISPATCHERS_FQN", "Lorg/jetbrains/kotlin/name/FqName;", "IO_DISPATCHER_FQN", "getIO_DISPATCHER_FQN", "()Lorg/jetbrains/kotlin/name/FqName;", "MAIN_DISPATCHER_FQN", "getMAIN_DISPATCHER_FQN", "DEFAULT_DISPATCHER_FQN", "getDEFAULT_DISPATCHER_FQN", "COROUTINE_SCOPE", "getCOROUTINE_SCOPE", "COROUTINE_CONTEXT", "getCOROUTINE_CONTEXT", "FLOW_ON_FQN", "getFLOW_ON_FQN", "FLOW_PACKAGE_FQN", "getFLOW_PACKAGE_FQN", "FLOW_FQN", "getFLOW_FQN", "WITH_CONTEXT_FQN", "getWITH_CONTEXT_FQN", "COROUTINE_NAME", "getCOROUTINE_NAME", "kotlin.code-insight.inspections.shared"})
@SourceDebugExtension(value={"SMAP\nCoroutineBlockingCallInspectionUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoroutineBlockingCallInspectionUtils.kt\norg/jetbrains/kotlin/idea/codeInsight/inspections/shared/blockingCallsDetection/CoroutineBlockingCallInspectionUtils\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 4 KaCallInfo.kt\norg/jetbrains/kotlin/analysis/api/resolution/KaCallInfoKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,123:1\n66#2,2:124\n66#2,2:128\n249#3:126\n249#3:131\n99#4:127\n99#4:130\n479#5:132\n184#5,2:133\n*S KotlinDebug\n*F\n+ 1 CoroutineBlockingCallInspectionUtils.kt\norg/jetbrains/kotlin/idea/codeInsight/inspections/shared/blockingCallsDetection/CoroutineBlockingCallInspectionUtils\n*L\n30#1:124,2\n38#1:128,2\n32#1:126\n90#1:131\n33#1:127\n74#1:130\n94#1:132\n96#1:133,2\n*E\n"})
public final class CoroutineBlockingCallInspectionUtils {
    @NotNull
    public static final CoroutineBlockingCallInspectionUtils INSTANCE = new CoroutineBlockingCallInspectionUtils();
    @NotNull
    private static final ClassId BLOCKING_EXECUTOR_ANNOTATION = ClassId.Companion.topLevel(new FqName("org.jetbrains.annotations.BlockingExecutor"));
    @NotNull
    private static final ClassId NONBLOCKING_EXECUTOR_ANNOTATION = ClassId.Companion.topLevel(new FqName("org.jetbrains.annotations.NonBlockingExecutor"));
    @NotNull
    private static final FqName DISPATCHERS_FQN = new FqName("kotlinx.coroutines.Dispatchers");
    @NotNull
    private static final FqName IO_DISPATCHER_FQN = new FqName("kotlinx.coroutines.Dispatchers.IO");
    @NotNull
    private static final FqName MAIN_DISPATCHER_FQN = new FqName("kotlinx.coroutines.Dispatchers.Main");
    @NotNull
    private static final FqName DEFAULT_DISPATCHER_FQN = new FqName("kotlinx.coroutines.Dispatchers.Default");
    @NotNull
    private static final FqName COROUTINE_SCOPE = new FqName("kotlinx.coroutines.CoroutineScope");
    @NotNull
    private static final FqName COROUTINE_CONTEXT = new FqName("kotlin.coroutines.CoroutineContext");
    @NotNull
    private static final FqName FLOW_ON_FQN = new FqName("kotlinx.coroutines.flow.flowOn");
    @NotNull
    private static final FqName FLOW_PACKAGE_FQN = new FqName("kotlinx.coroutines.flow");
    @NotNull
    private static final FqName FLOW_FQN = new FqName("kotlinx.coroutines.flow.Flow");
    @NotNull
    private static final FqName WITH_CONTEXT_FQN = new FqName("kotlinx.coroutines.withContext");
    @NotNull
    private static final FqName COROUTINE_NAME = new FqName("kotlinx.coroutines.CoroutineName");

    private CoroutineBlockingCallInspectionUtils() {
    }

    public final boolean isInSuspendLambdaOrFunction(@NotNull KaSession kaSession, @NotNull KtElement ktElement) {
        block6: {
            KaLifetimeOwner kaLifetimeOwner;
            KtLambdaArgument lambdaArgument;
            block8: {
                block7: {
                    Intrinsics.checkNotNullParameter((Object)kaSession, (String)"$context-KaSession");
                    Intrinsics.checkNotNullParameter((Object)ktElement, (String)"ktElement");
                    PsiElement $this$parentOfType_u24default$iv = (PsiElement)ktElement;
                    boolean withSelf$iv = false;
                    boolean $i$f$parentOfType = false;
                    lambdaArgument = (KtLambdaArgument)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, KtLambdaArgument.class, (boolean)true);
                    if (lambdaArgument == null) break block6;
                    PsiElement $this$getStrictParentOfType$iv = (PsiElement)lambdaArgument;
                    boolean $i$f$getStrictParentOfType = false;
                    KtCallExpression ktCallExpression = (KtCallExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtCallExpression.class, (boolean)true);
                    if (ktCallExpression == null) {
                        return false;
                    }
                    KtCallExpression callExpression = ktCallExpression;
                    kaLifetimeOwner = KaResolverKt.resolveToCall(kaSession, (KtElement)callExpression);
                    if (kaLifetimeOwner == null) break block7;
                    KaCallInfo $this$successfulCallOrNull$iv = kaLifetimeOwner;
                    boolean $i$f$successfulCallOrNull = false;
                    KaSuccessCallInfo kaSuccessCallInfo = $this$successfulCallOrNull$iv instanceof KaSuccessCallInfo ? (KaSuccessCallInfo)$this$successfulCallOrNull$iv : null;
                    KaCall kaCall = kaSuccessCallInfo != null ? kaSuccessCallInfo.getCall() : null;
                    if (!(kaCall instanceof KaFunctionCall)) {
                        kaCall = null;
                    }
                    if ((kaLifetimeOwner = (KaFunctionCall)((KaCall)((KaFunctionCall)kaCall))) != null) break block8;
                }
                return false;
            }
            KaLifetimeOwner call = kaLifetimeOwner;
            KaVariableSignature<KaValueParameterSymbol> kaVariableSignature = call.getArgumentMapping().get(lambdaArgument.getArgumentExpression());
            if (kaVariableSignature == null) {
                return false;
            }
            KaVariableSignature<KaValueParameterSymbol> parameterForArgument = kaVariableSignature;
            return KaTypeInformationProviderKt.isSuspendFunctionType(kaSession, parameterForArgument.getReturnType());
        }
        PsiElement $this$parentOfType_u24default$iv = (PsiElement)ktElement;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        KtNamedFunction ktNamedFunction = (KtNamedFunction)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, KtNamedFunction.class, (boolean)true);
        return ktNamedFunction != null ? ktNamedFunction.hasModifier(KtTokens.SUSPEND_KEYWORD) : false;
    }

    public final boolean isKotlinxOnClasspath(@NotNull KtElement ktElement) {
        Intrinsics.checkNotNullParameter((Object)ktElement, (String)"ktElement");
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)ktElement));
        if (module == null) {
            return false;
        }
        Module module2 = module;
        GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleWithLibrariesScope((Module)module2);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"moduleWithLibrariesScope(...)");
        GlobalSearchScope searchScope = globalSearchScope;
        return JavaPsiFacade.getInstance((Project)module2.getProject()).findClass(DISPATCHERS_FQN.asString(), searchScope) != null;
    }

    public final boolean isInsideFlowChain(@NotNull KaSession kaSession, @NotNull KaCall call) {
        KaLifetimeOwner receiverType;
        KaLifetimeOwner kaLifetimeOwner;
        FqName callableFqName;
        Intrinsics.checkNotNullParameter((Object)kaSession, (String)"$context-KaSession");
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        if (!(call instanceof KaCallableMemberCall)) {
            return false;
        }
        Object symbol = KaCallKt.getSymbol((KaCallableMemberCall)call);
        CallableId callableId = ((KaCallableSymbol)symbol).getCallableId();
        FqName fqName2 = callableFqName = callableId != null ? callableId.asSingleFqName() : null;
        boolean isFlowGenerator = fqName2 != null ? fqName2.startsWith(FLOW_PACKAGE_FQN) : false;
        KaLifetimeOwner kaLifetimeOwner2 = ((KaCallableMemberCall)call).getPartiallyAppliedSymbol().getDispatchReceiver();
        if (kaLifetimeOwner2 == null || (kaLifetimeOwner2 = kaLifetimeOwner2.getType()) == null) {
            KaReceiverValue kaReceiverValue = ((KaCallableMemberCall)call).getPartiallyAppliedSymbol().getExtensionReceiver();
            kaLifetimeOwner2 = kaReceiverValue != null ? kaReceiverValue.getType() : null;
        }
        FqName receiverFqName = (kaLifetimeOwner = (receiverType = kaLifetimeOwner2)) != null && (kaLifetimeOwner = KaTypeInformationProviderKt.getExpandedSymbol(kaSession, (KaType)kaLifetimeOwner)) != null && (kaLifetimeOwner = ((KaClassLikeSymbol)kaLifetimeOwner).getClassId()) != null ? kaLifetimeOwner.asSingleFqName() : null;
        return Intrinsics.areEqual(receiverFqName, (Object)FLOW_FQN) || receiverType == null && isFlowGenerator;
    }

    public final boolean isCalledInsideNonIoContext(@NotNull KaSession kaSession, @NotNull KaCall call) {
        Intrinsics.checkNotNullParameter((Object)kaSession, (String)"$context-KaSession");
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        KaCallableMemberCall kaCallableMemberCall = call instanceof KaCallableMemberCall ? (KaCallableMemberCall)call : null;
        if (kaCallableMemberCall == null || (kaCallableMemberCall = KaCallKt.getSymbol(kaCallableMemberCall)) == null) {
            return false;
        }
        KaCallableMemberCall symbol = kaCallableMemberCall;
        CallableId callableId = ((KaCallableSymbol)((Object)symbol)).getCallableId();
        if (callableId == null || (callableId = callableId.asSingleFqName()) == null) {
            return false;
        }
        CallableId callFqName = callableId;
        if (!Intrinsics.areEqual((Object)callFqName, (Object)WITH_CONTEXT_FQN)) {
            return false;
        }
        return this.isNonBlockingDispatcher(kaSession, call);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isNonBlockingDispatcher(KaSession kaSession, KaCall call) {
        KaCallableMemberCall kaCallableMemberCall;
        void $this$successfulCallOrNull$iv;
        KtExpression ktExpression = CoroutineBlockingCallInspectionUtilsKt.getFirstArgumentExpression(kaSession, call);
        if (ktExpression == null) return false;
        KaCallInfo kaCallInfo = KaResolverKt.resolveToCall(kaSession, (KtElement)ktExpression);
        if (kaCallInfo == null) return false;
        KaCallInfo kaCallInfo2 = kaCallInfo;
        boolean $i$f$successfulCallOrNull = false;
        KaSuccessCallInfo kaSuccessCallInfo = $this$successfulCallOrNull$iv instanceof KaSuccessCallInfo ? (KaSuccessCallInfo)$this$successfulCallOrNull$iv : null;
        KaCall kaCall = kaSuccessCallInfo != null ? kaSuccessCallInfo.getCall() : null;
        if (!(kaCall instanceof KaCallableMemberCall)) {
            kaCall = null;
        }
        if ((kaCallableMemberCall = (KaCallableMemberCall)((KaCall)((KaCallableMemberCall)kaCall))) == null) return false;
        kaCallInfo2 = KaCallKt.getSymbol(kaCallableMemberCall);
        if (kaCallInfo2 == null) return false;
        CallableId callableId = ((KaCallableSymbol)((Object)kaCallInfo2)).getCallableId();
        if (callableId == null) return false;
        FqName fqName2 = callableId.asSingleFqName();
        FqName dispatcherFqName = fqName2;
        if (dispatcherFqName == null) return false;
        if (Intrinsics.areEqual(dispatcherFqName, (Object)IO_DISPATCHER_FQN)) return false;
        return true;
    }

    public final void postProcessQuickFix(@NotNull KtElement replacedElement, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)replacedElement, (String)"replacedElement");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        KtFile ktFile2 = replacedElement.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"getContainingKtFile(...)");
        KtFile containingKtFile = ktFile2;
        ShortenReferencesFacility shortenReferencesFacility = ShortenReferencesFacility.Companion.getInstance();
        PsiElement psiElement = GenericPsiUtils.reformatted$default((PsiElement)replacedElement, false, 1, null);
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
        shortenReferencesFacility.shorten((KtElement)psiElement);
        new OptimizeImportsProcessor(project, (PsiFile)containingKtFile).run();
        DocumentUtilsKt.commitAndUnblockDocument((PsiFile)containingKtFile);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final KaFunctionCall<?> findFlowOnCall(@NotNull KaSession kaSession, @NotNull KtExpression $this$findFlowOnCall) {
        KaFunctionCall kaFunctionCall;
        Intrinsics.checkNotNullParameter((Object)kaSession, (String)"$context-KaSession");
        Intrinsics.checkNotNullParameter((Object)$this$findFlowOnCall, (String)"<this>");
        CoroutineBlockingCallInspectionUtils coroutineBlockingCallInspectionUtils = this;
        while (true) {
            KaFunctionCall candidate;
            Object v3;
            KtDotQualifiedExpression dotQualifiedExpression;
            block3: {
                void $this$firstOrNull$iv;
                Sequence $this$filterIsInstance$iv;
                PsiElement $this$getStrictParentOfType$iv = (PsiElement)$this$findFlowOnCall;
                boolean $i$f$getStrictParentOfType = false;
                if ((KtDotQualifiedExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtDotQualifiedExpression.class, (boolean)true) == null) {
                    return null;
                }
                PsiElement[] psiElementArray = dotQualifiedExpression.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
                $this$getStrictParentOfType$iv = ArraysKt.asSequence((Object[])psiElementArray);
                boolean $i$f$filterIsInstance = false;
                Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)findFlowOnCall$$inlined$filterIsInstance$1.INSTANCE);
                Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                $this$filterIsInstance$iv = SequencesKt.mapNotNull((Sequence)sequence, arg_0 -> CoroutineBlockingCallInspectionUtils.findFlowOnCall$lambda$0(kaSession, arg_0));
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    KaFunctionCall call = (KaFunctionCall)element$iv;
                    boolean bl = false;
                    Object s = KaCallKt.getSymbol(call);
                    Object symbol = s instanceof KaCallableSymbol ? s : null;
                    Object object = symbol;
                    if (!Intrinsics.areEqual((Object)(object != null && (object = ((KaCallableSymbol)object).getCallableId()) != null ? object.asSingleFqName() : null), (Object)FLOW_ON_FQN)) continue;
                    v3 = element$iv;
                    break block3;
                }
                v3 = null;
            }
            kaFunctionCall = candidate = (KaFunctionCall)v3;
            if (kaFunctionCall != null) break;
            CoroutineBlockingCallInspectionUtils coroutineBlockingCallInspectionUtils2 = coroutineBlockingCallInspectionUtils;
            KaSession kaSession2 = kaSession;
            coroutineBlockingCallInspectionUtils = coroutineBlockingCallInspectionUtils2;
            kaSession = kaSession2;
            $this$findFlowOnCall = (KtExpression)dotQualifiedExpression;
        }
        return kaFunctionCall;
    }

    @NotNull
    public final ClassId getBLOCKING_EXECUTOR_ANNOTATION() {
        return BLOCKING_EXECUTOR_ANNOTATION;
    }

    @NotNull
    public final ClassId getNONBLOCKING_EXECUTOR_ANNOTATION() {
        return NONBLOCKING_EXECUTOR_ANNOTATION;
    }

    @NotNull
    public final FqName getIO_DISPATCHER_FQN() {
        return IO_DISPATCHER_FQN;
    }

    @NotNull
    public final FqName getMAIN_DISPATCHER_FQN() {
        return MAIN_DISPATCHER_FQN;
    }

    @NotNull
    public final FqName getDEFAULT_DISPATCHER_FQN() {
        return DEFAULT_DISPATCHER_FQN;
    }

    @NotNull
    public final FqName getCOROUTINE_SCOPE() {
        return COROUTINE_SCOPE;
    }

    @NotNull
    public final FqName getCOROUTINE_CONTEXT() {
        return COROUTINE_CONTEXT;
    }

    @NotNull
    public final FqName getFLOW_ON_FQN() {
        return FLOW_ON_FQN;
    }

    @NotNull
    public final FqName getFLOW_PACKAGE_FQN() {
        return FLOW_PACKAGE_FQN;
    }

    @NotNull
    public final FqName getFLOW_FQN() {
        return FLOW_FQN;
    }

    @NotNull
    public final FqName getWITH_CONTEXT_FQN() {
        return WITH_CONTEXT_FQN;
    }

    @NotNull
    public final FqName getCOROUTINE_NAME() {
        return COROUTINE_NAME;
    }

    private static final KaFunctionCall findFlowOnCall$lambda$0(KaSession kaSession, KtCallExpression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        KaCallInfo kaCallInfo = KaResolverKt.resolveToCall(kaSession, (KtElement)it);
        return kaCallInfo != null ? KaCallInfoKt.successfulFunctionCallOrNull(kaCallInfo) : null;
    }
}

