/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.inspections.shared.blockingCallsDetection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.blockingCallsDetection.BlockingMethodChecker;
import com.intellij.codeInspection.blockingCallsDetection.ElementContext;
import com.intellij.codeInspection.blockingCallsDetection.MethodContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.resolution.KaCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaSuccessCallInfo;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.blockingCallsDetection.ChangeContextFix;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.blockingCallsDetection.CoroutineBlockingCallInspectionUtils;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.blockingCallsDetection.FlowOnIoContextFix;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.blockingCallsDetection.WrapInWithContextFix;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u001b\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/blockingCallsDetection/CoroutineBlockingMethodChecker;", "Lcom/intellij/codeInspection/blockingCallsDetection/BlockingMethodChecker;", "<init>", "()V", "isApplicable", "", "file", "Lcom/intellij/psi/PsiFile;", "isMethodNonBlocking", "context", "Lcom/intellij/codeInspection/blockingCallsDetection/MethodContext;", "getQuickFixesFor", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "elementContext", "Lcom/intellij/codeInspection/blockingCallsDetection/ElementContext;", "(Lcom/intellij/codeInspection/blockingCallsDetection/ElementContext;)[Lcom/intellij/codeInspection/LocalQuickFix;", "getLanguageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "psiElement", "Lcom/intellij/psi/PsiElement;", "kotlin.code-insight.inspections.shared"})
@SourceDebugExtension(value={"SMAP\nCoroutineBlockingMethodChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoroutineBlockingMethodChecker.kt\norg/jetbrains/kotlin/idea/codeInsight/inspections/shared/blockingCallsDetection/CoroutineBlockingMethodChecker\n+ 2 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 3 KaSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KaSessionProvider\n+ 4 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 5 KaCallInfo.kt\norg/jetbrains/kotlin/analysis/api/resolution/KaCallInfoKt\n*L\n1#1,62:1\n30#2,2:63\n36#3,9:65\n49#3,2:77\n46#3,2:79\n66#4,2:74\n99#5:76\n*S KotlinDebug\n*F\n+ 1 CoroutineBlockingMethodChecker.kt\norg/jetbrains/kotlin/idea/codeInsight/inspections/shared/blockingCallsDetection/CoroutineBlockingMethodChecker\n*L\n46#1:63,2\n46#1:65,9\n46#1:77,2\n46#1:79,2\n47#1:74,2\n47#1:76\n*E\n"})
public final class CoroutineBlockingMethodChecker
implements BlockingMethodChecker {
    public boolean isApplicable(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!(file instanceof KtFile)) {
            return false;
        }
        LanguageVersionSettings languageVersionSettings = this.getLanguageVersionSettings((PsiElement)file);
        return languageVersionSettings.supportsFeature(LanguageFeature.ReleaseCoroutines);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isMethodNonBlocking(@NotNull MethodContext context2) {
        UElement uMethod;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        UElement uElement = uMethod = UastContextKt.toUElement((PsiElement)((PsiElement)context2.getElement()));
        UElement uElement2 = uElement;
        if (uElement == null) return false;
        if ((uElement2 = uElement2.getSourcePsi()) == null) {
            return false;
        }
        UElement sourcePsi = uElement2;
        if (!(sourcePsi instanceof KtNamedFunction)) return false;
        KtModifierList ktModifierList = ((KtNamedFunction)sourcePsi).getModifierList();
        if (ktModifierList == null) return false;
        if (!PsiUtilsKt.hasSuspendModifier((KtModifierList)ktModifierList)) return false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public LocalQuickFix[] getQuickFixesFor(@NotNull ElementContext elementContext) {
        void this_$iv$iv;
        Intrinsics.checkNotNullParameter((Object)elementContext, (String)"elementContext");
        PsiElement element = elementContext.getElement();
        if (!(element instanceof KtCallExpression)) {
            return new LocalQuickFix[0];
        }
        KtElement useSiteElement$iv = (KtElement)element;
        boolean $i$f$analyze = false;
        Project project = useSiteElement$iv.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project);
        KtElement useSiteElement$iv$iv = useSiteElement$iv;
        boolean $i$f$analyze2 = false;
        KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(useSiteElement$iv$iv);
        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
        try {
            Object lock$iv$iv;
            Object object = lock$iv$iv = new Object();
            synchronized (object) {
                try {
                    LocalQuickFix[] localQuickFixArray;
                    KaCall kaCall;
                    boolean bl = false;
                    KaSession $this$getQuickFixesFor_u24lambda_u240 = analysisSession$iv$iv;
                    boolean bl2 = false;
                    PsiElement $this$parentOfType_u24default$iv = element;
                    boolean withSelf$iv = false;
                    boolean $i$f$parentOfType = false;
                    Object object2 = (KtCallExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, KtCallExpression.class, (boolean)true);
                    if (object2 != null && (object2 = $this$getQuickFixesFor_u24lambda_u240.resolveToCall((KtElement)object2)) != null) {
                        Object $this$successfulCallOrNull$iv = object2;
                        boolean $i$f$successfulCallOrNull = false;
                        KaSuccessCallInfo kaSuccessCallInfo = $this$successfulCallOrNull$iv instanceof KaSuccessCallInfo ? (KaSuccessCallInfo)$this$successfulCallOrNull$iv : null;
                        kaCall = kaSuccessCallInfo != null ? kaSuccessCallInfo.getCall() : null;
                        if (!(kaCall instanceof KaCall)) {
                            kaCall = null;
                        }
                    } else {
                        kaCall = null;
                    }
                    KaCall resolvedCall = kaCall;
                    PsiFile psiFile = ((KtCallExpression)element).getContainingFile();
                    Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
                    if (!this.isApplicable(psiFile) || !CoroutineBlockingCallInspectionUtils.INSTANCE.isKotlinxOnClasspath((KtElement)element)) {
                        localQuickFixArray = new LocalQuickFix[]{};
                    } else if (resolvedCall != null && CoroutineBlockingCallInspectionUtils.INSTANCE.isCalledInsideNonIoContext($this$getQuickFixesFor_u24lambda_u240, resolvedCall) && CoroutineBlockingCallInspectionUtils.INSTANCE.isInSuspendLambdaOrFunction($this$getQuickFixesFor_u24lambda_u240, (KtElement)element)) {
                        var18_21 = new LocalQuickFix[]{new ChangeContextFix(), new WrapInWithContextFix()};
                        localQuickFixArray = var18_21;
                    } else if (resolvedCall != null && CoroutineBlockingCallInspectionUtils.INSTANCE.isInsideFlowChain($this$getQuickFixesFor_u24lambda_u240, resolvedCall)) {
                        var18_21 = new LocalQuickFix[]{new FlowOnIoContextFix(), new WrapInWithContextFix()};
                        localQuickFixArray = var18_21;
                    } else if (CoroutineBlockingCallInspectionUtils.INSTANCE.isInSuspendLambdaOrFunction($this$getQuickFixesFor_u24lambda_u240, (KtElement)element)) {
                        var18_21 = new LocalQuickFix[]{new WrapInWithContextFix()};
                        localQuickFixArray = var18_21;
                    } else {
                        localQuickFixArray = new LocalQuickFix[]{};
                    }
                    LocalQuickFix[] localQuickFixArray2 = localQuickFixArray;
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl58 : MonitorExitStatement: MONITOREXIT : var10_10
                    LocalQuickFix[] localQuickFixArray3 = localQuickFixArray2;
                    return localQuickFixArray3;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (Throwable throwable$iv$iv) {
                        this_$iv$iv.handleAnalysisException(throwable$iv$iv, analysisSession$iv$iv, useSiteElement$iv$iv);
                        throw new KotlinNothingValueException();
                    }
                }
            }
        }
        finally {
            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
        }
    }

    private final LanguageVersionSettings getLanguageVersionSettings(PsiElement psiElement) {
        Module module = GenericPsiUtils.getModule(psiElement);
        if (module == null || (module = LanguageVersionSettingsProviderUtils.getLanguageVersionSettings(module)) == null) {
            Project project = psiElement.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            module = LanguageVersionSettingsProviderUtils.getLanguageVersionSettings(project);
        }
        return module;
    }
}

