/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.inspections.shared.coroutines;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfoKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallableMemberCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaFunctionCall;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaFunctionSymbol;
import org.jetbrains.kotlin.idea.base.codeInsight.ShortenReferencesFacility;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.coroutines.CoroutinesIds;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.coroutines.CoroutinesUtilsKt;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.coroutines.SuspendCoroutineLacksCancellationGuaranteesInspectionKt;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinApplicableInspectionBase;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinModCommandQuickFix;
import org.jetbrains.kotlin.idea.codeinsight.utils.KotlinPsiUtilsKt;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.applicators.ApplicabilityRanges;
import org.jetbrains.kotlin.idea.refactoring.KotlinCommonRefactoringUtilKt;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLabelReferenceExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001d\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0003H\u0014J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u0002H\u0016J \u0010\u0010\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fH\u0016J\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u0003*\u00020\u00162\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u00182\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0003H\u0014\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/coroutines/SuspendCoroutineLacksCancellationGuaranteesInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinApplicableInspectionBase$Simple;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/coroutines/SuspendCoroutineLacksCancellationGuaranteesInspection$Context;", "<init>", "()V", "getProblemDescription", "", "Lcom/intellij/codeInspection/util/InspectionMessage;", "element", "context", "getApplicableRanges", "", "Lcom/intellij/openapi/util/TextRange;", "isApplicableByPsi", "", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "prepareContext", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "createQuickFix", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinModCommandQuickFix;", "Context", "kotlin.code-insight.inspections.shared"})
public final class SuspendCoroutineLacksCancellationGuaranteesInspection
extends KotlinApplicableInspectionBase.Simple<KtCallExpression, Context> {
    @Override
    @NotNull
    protected String getProblemDescription(@NotNull KtCallExpression element, @NotNull Context context2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return KotlinBundle.message((String)"inspection.suspend.coroutine.lacks.cancellation.guarantees.description", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public List<TextRange> getApplicableRanges(@NotNull KtCallExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return ApplicabilityRanges.INSTANCE.calleeExpression(element);
    }

    @Override
    public boolean isApplicableByPsi(@NotNull KtCallExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtSimpleNameExpression ktSimpleNameExpression = KtPsiUtilKt.getCallNameExpression((KtCallElement)((KtCallElement)element));
        return Intrinsics.areEqual((Object)(ktSimpleNameExpression != null ? ktSimpleNameExpression.getReferencedNameAsName() : null), (Object)SuspendCoroutineLacksCancellationGuaranteesInspectionKt.access$getSUSPEND_COROUTINE_ID$p().getCallableName());
    }

    @Override
    @NotNull
    public KtVisitor<?, ?> buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        return (KtVisitor)VisitorWrappersKt.callExpressionVisitor(arg_0 -> SuspendCoroutineLacksCancellationGuaranteesInspection.buildVisitor$lambda$0(this, holder2, isOnTheFly, arg_0));
    }

    @Override
    @Nullable
    public Context prepareContext(@NotNull KaSession $this$prepareContext, @NotNull KtCallExpression element) {
        List<KtLabelReferenceExpression> list2;
        Intrinsics.checkNotNullParameter((Object)$this$prepareContext, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KaCallInfo kaCallInfo = $this$prepareContext.resolveToCall((KtElement)element);
        KaFunctionCall<Object> functionCall = kaCallInfo != null ? KaCallInfoKt.successfulFunctionCallOrNull(kaCallInfo) : null;
        KaLifetimeOwner kaLifetimeOwner = functionCall;
        if (kaLifetimeOwner == null || (kaLifetimeOwner = (KaFunctionSymbol)KaCallKt.getSymbol((KaCallableMemberCall)kaLifetimeOwner)) == null) {
            return null;
        }
        KaLifetimeOwner calledFunction = kaLifetimeOwner;
        if (!Intrinsics.areEqual((Object)((KaCallableSymbol)calledFunction).getCallableId(), (Object)SuspendCoroutineLacksCancellationGuaranteesInspectionKt.access$getSUSPEND_COROUTINE_ID$p())) {
            return null;
        }
        if (!CoroutinesUtilsKt.canBeResolved($this$prepareContext, CoroutinesIds.INSTANCE.getSuspendCancellableCoroutine())) {
            return null;
        }
        KtExpression singlePassedArgument = (KtExpression)CollectionsKt.single((Iterable)functionCall.getArgumentMapping().keySet());
        KtExpression ktExpression = singlePassedArgument;
        if (ktExpression instanceof KtLambdaExpression && KotlinCommonRefactoringUtilKt.parentLabeledExpression(singlePassedArgument) == null) {
            KtFunctionLiteral ktFunctionLiteral = ((KtLambdaExpression)singlePassedArgument).getFunctionLiteral();
            Intrinsics.checkNotNullExpressionValue((Object)ktFunctionLiteral, (String)"getFunctionLiteral(...)");
            list2 = CoroutinesUtilsKt.findRelatedLabelReferences($this$prepareContext, (KtFunction)ktFunctionLiteral);
        } else {
            list2 = ktExpression instanceof KtNamedFunction ? CoroutinesUtilsKt.findRelatedLabelReferences($this$prepareContext, (KtFunction)singlePassedArgument) : CollectionsKt.emptyList();
        }
        List<KtLabelReferenceExpression> labelReferencesToUpdate = list2;
        return new Context(labelReferencesToUpdate);
    }

    @Override
    @NotNull
    protected KotlinModCommandQuickFix<KtCallExpression> createQuickFix(@NotNull KtCallExpression element, @NotNull Context context2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new KotlinModCommandQuickFix<KtCallExpression>(context2){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
            }

            public String getFamilyName() {
                return KotlinBundle.message((String)"inspection.suspend.coroutine.lacks.cancellation.guarantees.fix", (Object[])new Object[0]);
            }

            /*
             * WARNING - void declaration
             */
            protected void applyFix(Project project, KtCallExpression element, ModPsiUpdater updater2) {
                void $this$mapNotNullTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
                KtExpression ktExpression = new KtPsiFactory(project, false, 2, null).createExpression("return@" + CoroutinesIds.INSTANCE.getSuspendCancellableCoroutine().getCallableName());
                Intrinsics.checkNotNull((Object)ktExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtReturnExpression");
                KtReturnExpression labeledReturn = (KtReturnExpression)ktExpression;
                KtSimpleNameExpression ktSimpleNameExpression = labeledReturn.getTargetLabel();
                if (ktSimpleNameExpression == null) {
                    return;
                }
                KtSimpleNameExpression updatedLabeledExpression = ktSimpleNameExpression;
                Iterable $this$mapNotNull$iv = this.$context.getLabelReferencesToUpdate();
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    KtLabelReferenceExpression it$iv$iv;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    KtLabelReferenceExpression it = (KtLabelReferenceExpression)element$iv$iv;
                    boolean bl2 = false;
                    if ((KtLabelReferenceExpression)updater2.getWritable((PsiElement)it) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List writableLabelReferencesToUpdate = (List)destination$iv$iv;
                Iterable $this$forEach$iv = writableLabelReferencesToUpdate;
                boolean $i$f$forEach2 = false;
                for (E element$iv : $this$forEach$iv) {
                    KtLabelReferenceExpression it = (KtLabelReferenceExpression)element$iv;
                    boolean bl = false;
                    it.replace((PsiElement)updatedLabeledExpression);
                }
                KtDotQualifiedExpression ktDotQualifiedExpression = SuspendCoroutineLacksCancellationGuaranteesInspectionKt.access$replacePossiblyQualifiedCallee(element, CoroutinesIds.INSTANCE.getSuspendCancellableCoroutine());
                if (ktDotQualifiedExpression == null) {
                    return;
                }
                KtDotQualifiedExpression updatedCall = ktDotQualifiedExpression;
                TextRange textRange = KotlinPsiUtilsKt.getQualifiedCalleeExpressionTextRange((KtExpression)updatedCall);
                if (textRange == null) {
                    return;
                }
                TextRange updatedCallQualifierRangeInFile = textRange;
                ShortenReferencesFacility shortenReferencesFacility = ShortenReferencesFacility.Companion.getInstance();
                KtFile ktFile2 = updatedCall.getContainingKtFile();
                Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"getContainingKtFile(...)");
                shortenReferencesFacility.shorten(ktFile2, updatedCallQualifierRangeInFile);
            }
        };
    }

    private static final Unit buildVisitor$lambda$0(SuspendCoroutineLacksCancellationGuaranteesInspection this$0, ProblemsHolder $holder, boolean $isOnTheFly, KtCallExpression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.visitTargetElement((KtElement)it, $holder, $isOnTheFly);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/coroutines/SuspendCoroutineLacksCancellationGuaranteesInspection$Context;", "", "labelReferencesToUpdate", "", "Lorg/jetbrains/kotlin/psi/KtLabelReferenceExpression;", "<init>", "(Ljava/util/List;)V", "getLabelReferencesToUpdate", "()Ljava/util/List;", "kotlin.code-insight.inspections.shared"})
    public static final class Context {
        @NotNull
        private final List<KtLabelReferenceExpression> labelReferencesToUpdate;

        public Context(@NotNull List<KtLabelReferenceExpression> labelReferencesToUpdate) {
            Intrinsics.checkNotNullParameter(labelReferencesToUpdate, (String)"labelReferencesToUpdate");
            this.labelReferencesToUpdate = labelReferencesToUpdate;
        }

        @NotNull
        public final List<KtLabelReferenceExpression> getLabelReferencesToUpdate() {
            return this.labelReferencesToUpdate;
        }
    }
}

