/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.inspections.shared.runBlocking.rbgraph;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.runBlocking.RunBlockingInspection;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.runBlocking.rbgraph.FunctionNode;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.runBlocking.rbgraph.RBGraph;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.runBlocking.utils.ElementFilters;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.runBlocking.utils.MyPsiUtils;
import org.jetbrains.kotlin.idea.search.declarationsSearch.OverridersSearchKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0016\u001a\u00020\u00002\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000fJ\u001a\u0010\u0017\u001a\u00020\u00002\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\t0\u0007J\u001a\u0010\u0018\u001a\u00020\u00002\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007J\u001a\u0010\u0019\u001a\u00020\u00002\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\t0\u0007J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u001c\u001a\u00020\u0015J\u0010\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u000f2\u0006\u0010\"\u001a\u00020\u001fH\u0002J\u0018\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020&H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\r0\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/runBlocking/rbgraph/GraphBuilder;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "totalFilesTodo", "Lkotlin/Function1;", "", "", "incrementFilesDone", "", "rbFileFound", "Lcom/intellij/openapi/vfs/VirtualFile;", "relevantFiles", "", "level", "Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/runBlocking/RunBlockingInspection$ExplorationLevel;", "urlToVirtualFileMap", "", "rbGraph", "Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/runBlocking/rbgraph/RBGraph;", "setRelevantFiles", "setIncrementFilesDoneFunction", "setTotalFilesTodo", "setRbFileFound", "fileFound", "setExplorationLevel", "buildGraph", "createSubtree", "builder", "Lcom/intellij/psi/PsiElement;", "extractCallsFromBody", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "body", "exploreFunDeclaration", "currentPsiEl", "currentNode", "Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/runBlocking/rbgraph/FunctionNode;", "kotlin.code-insight.inspections.shared"})
@SourceDebugExtension(value={"SMAP\nGraphBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraphBuilder.kt\norg/jetbrains/kotlin/idea/codeInsight/inspections/shared/runBlocking/rbgraph/GraphBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,171:1\n1915#2,2:172\n1924#2,3:174\n812#2,12:177\n812#2,12:189\n777#2:201\n873#2,2:202\n1391#2:204\n1480#2,5:205\n1915#2,2:210\n1915#2,2:212\n1915#2,2:214\n1915#2,2:216\n*S KotlinDebug\n*F\n+ 1 GraphBuilder.kt\norg/jetbrains/kotlin/idea/codeInsight/inspections/shared/runBlocking/rbgraph/GraphBuilder\n*L\n42#1:172,2\n67#1:174,3\n106#1:177,12\n111#1:189,12\n114#1:201\n114#1:202,2\n117#1:204\n117#1:205,5\n158#1:210,2\n71#1:212,2\n76#1:214,2\n80#1:216,2\n*E\n"})
public final class GraphBuilder {
    @NotNull
    private final Project project;
    @NotNull
    private Function1<? super Integer, Unit> totalFilesTodo;
    @NotNull
    private Function1<? super String, Unit> incrementFilesDone;
    @NotNull
    private Function1<? super VirtualFile, Unit> rbFileFound;
    @NotNull
    private List<? extends VirtualFile> relevantFiles;
    @NotNull
    private RunBlockingInspection.ExplorationLevel level;
    @NotNull
    private Map<String, VirtualFile> urlToVirtualFileMap;
    @NotNull
    private final RBGraph rbGraph;

    public GraphBuilder(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.totalFilesTodo = GraphBuilder::totalFilesTodo$lambda$0;
        this.incrementFilesDone = GraphBuilder::incrementFilesDone$lambda$0;
        this.rbFileFound = GraphBuilder::rbFileFound$lambda$0;
        this.relevantFiles = CollectionsKt.emptyList();
        this.level = RunBlockingInspection.ExplorationLevel.DECLARATION;
        this.urlToVirtualFileMap = new LinkedHashMap();
        this.rbGraph = new RBGraph();
    }

    @NotNull
    public final GraphBuilder setRelevantFiles(@NotNull List<? extends VirtualFile> relevantFiles) {
        Intrinsics.checkNotNullParameter(relevantFiles, (String)"relevantFiles");
        this.relevantFiles = relevantFiles;
        Iterable $this$forEach$iv = relevantFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile it = (VirtualFile)element$iv;
            boolean bl = false;
            this.urlToVirtualFileMap.put(it.getUrl(), it);
        }
        return this;
    }

    @NotNull
    public final GraphBuilder setIncrementFilesDoneFunction(@NotNull Function1<? super String, Unit> incrementFilesDone) {
        Intrinsics.checkNotNullParameter(incrementFilesDone, (String)"incrementFilesDone");
        this.incrementFilesDone = incrementFilesDone;
        return this;
    }

    @NotNull
    public final GraphBuilder setTotalFilesTodo(@NotNull Function1<? super Integer, Unit> totalFilesTodo) {
        Intrinsics.checkNotNullParameter(totalFilesTodo, (String)"totalFilesTodo");
        this.totalFilesTodo = totalFilesTodo;
        return this;
    }

    @NotNull
    public final GraphBuilder setRbFileFound(@NotNull Function1<? super VirtualFile, Unit> fileFound) {
        Intrinsics.checkNotNullParameter(fileFound, (String)"fileFound");
        this.rbFileFound = fileFound;
        return this;
    }

    @NotNull
    public final GraphBuilder setExplorationLevel(@NotNull RunBlockingInspection.ExplorationLevel level) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        this.level = level;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final RBGraph buildGraph() {
        this.totalFilesTodo.invoke((Object)this.relevantFiles.size());
        Iterable $this$forEachIndexed$iv = this.relevantFiles;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void file;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            VirtualFile virtualFile = (VirtualFile)item$iv;
            int index2 = n;
            boolean bl = false;
            ActionsKt.runReadAction(() -> GraphBuilder.buildGraph$lambda$0$0(this, (VirtualFile)file));
        }
        return this.rbGraph;
    }

    private final void createSubtree(PsiElement builder2) {
        FunctionNode runBlockingNode = this.rbGraph.addBuilder(builder2);
        if (builder2 instanceof KtCallExpression) {
            KtLambdaArgument ktLambdaArgument = (KtLambdaArgument)CollectionsKt.lastOrNull((List)((KtCallExpression)builder2).getLambdaArguments());
            if (ktLambdaArgument == null || (ktLambdaArgument = ktLambdaArgument.getLambdaExpression()) == null) {
                return;
            }
            KtLambdaArgument lam = ktLambdaArgument;
            this.exploreFunDeclaration((PsiElement)lam, runBlockingNode);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<KtCallExpression> extractCallsFromBody(PsiElement body2) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        void $this$filterTo$iv$iv;
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstance$iv;
        void $this$filterIsInstanceTo$iv$iv2;
        Iterable $this$filterIsInstance$iv2 = MyPsiUtils.Companion.findAllChildren(body2, (Function1<? super PsiElement, Boolean>)((Function1)GraphBuilder::extractCallsFromBody$lambda$0), (Function1<? super PsiElement, Boolean>)((Function1)GraphBuilder::extractCallsFromBody$lambda$1));
        boolean $i$f$filterIsInstance22 = false;
        Iterable iterable = $this$filterIsInstance$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
            if (!(element$iv$iv instanceof KtCallExpression)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List methodCalls = (List)destination$iv$iv;
        Iterable $i$f$filterIsInstance22 = MyPsiUtils.Companion.findAllChildren(body2, (Function1<? super PsiElement, Boolean>)((Function1)GraphBuilder::extractCallsFromBody$lambda$2), (Function1<? super PsiElement, Boolean>)((Function1)GraphBuilder::extractCallsFromBody$lambda$3));
        boolean $i$f$filterIsInstance = false;
        destination$iv$iv = $this$filterIsInstance$iv;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KtLambdaExpression)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List lambdaExprs = (List)destination$iv$iv2;
        Iterable $this$filter$iv = lambdaExprs;
        boolean $i$f$filter = false;
        destination$iv$iv2 = $this$filter$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KtLambdaExpression it = (KtLambdaExpression)element$iv$iv;
            boolean bl = false;
            if (!(ElementFilters.Companion.getLambdaAsArgForInlineFun().isAccepted((PsiElement)it) || ElementFilters.Companion.isSuspendLambda().isAccepted((PsiElement)it))) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        List inlineLams = (List)destination$iv$iv3;
        $this$filter$iv = inlineLams;
        Collection collection = methodCalls;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv3 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            PsiElement p0 = (PsiElement)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.extractCallsFromBody(p0);
            CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv3));
    }

    private final void exploreFunDeclaration(PsiElement currentPsiEl, FunctionNode currentNode) {
        if (currentNode.getVisited()) {
            return;
        }
        currentNode.setVisited(true);
        List<KtCallExpression> methodCalls = this.extractCallsFromBody(currentPsiEl);
        for (KtCallExpression call : methodCalls) {
            VirtualFile funFile;
            KtExpression callee = call.getCalleeExpression();
            if (!(callee instanceof KtNameReferenceExpression)) continue;
            PsiReference psiReference = ((KtNameReferenceExpression)callee).getReference();
            Object psiFn = psiReference != null ? psiReference.resolve() : null;
            if (!(psiFn instanceof KtNamedFunction) || !this.relevantFiles.contains(funFile = MyPsiUtils.Companion.getFileForElement((PsiElement)psiFn))) continue;
            List toExplore = new ArrayList();
            switch (WhenMappings.$EnumSwitchMapping$0[this.level.ordinal()]) {
                case 1: {
                    if (OverridersSearchKt.hasOverridingElement((KtNamedDeclaration)psiFn)) break;
                    toExplore.add(psiFn);
                    break;
                }
                case 2: {
                    toExplore.add(psiFn);
                    break;
                }
                case 3: {
                    toExplore.add(psiFn);
                    OverridersSearchKt.forEachOverridingElement$default((KtNamedDeclaration)psiFn, null, false, (arg_0, arg_1) -> GraphBuilder.exploreFunDeclaration$lambda$0(this, toExplore, arg_0, arg_1), 3, null);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Iterable $this$forEach$iv = toExplore;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtNamedFunction fn = (KtNamedFunction)element$iv;
                boolean bl = false;
                if (fn.getFqName() == null) continue;
                FunctionNode functionNode = this.rbGraph.getOrCreateFunction(fn);
                String string = MyPsiUtils.Companion.getUrl((PsiElement)call);
                Intrinsics.checkNotNull((Object)string);
                this.rbGraph.connect(currentNode, functionNode, string, MyPsiUtils.Companion.getFileAndLine((PsiElement)call));
                this.exploreFunDeclaration((PsiElement)fn, functionNode);
            }
        }
    }

    private static final Unit totalFilesTodo$lambda$0(int it) {
        return Unit.INSTANCE;
    }

    private static final Unit incrementFilesDone$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final Unit rbFileFound$lambda$0(VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final Unit buildGraph$lambda$0$0(GraphBuilder this$0, VirtualFile $file) {
        Function1<? super String, Unit> function1 = this$0.incrementFilesDone;
        String string = $file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        function1.invoke((Object)string);
        Iterable $this$forEach$iv = MyPsiUtils.Companion.findRunBlockings($file, this$0.project);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiElement rb = (PsiElement)element$iv;
            boolean bl = false;
            this$0.createSubtree(rb);
            this$0.rbFileFound.invoke((Object)$file);
        }
        $this$forEach$iv = MyPsiUtils.Companion.findNonBlockingBuilders($file, this$0.project);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiElement builder2 = (PsiElement)element$iv;
            boolean bl = false;
            this$0.createSubtree(builder2);
        }
        $this$forEach$iv = MyPsiUtils.Companion.findSuspendFuns($file, this$0.project);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiElement susFun = (PsiElement)element$iv;
            boolean bl = false;
            if (!(susFun instanceof KtNamedFunction) || ((KtNamedFunction)susFun).getFqName() == null) continue;
            this$0.exploreFunDeclaration(susFun, this$0.rbGraph.getOrCreateFunction((KtNamedFunction)susFun));
        }
        return Unit.INSTANCE;
    }

    private static final boolean extractCallsFromBody$lambda$0(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof KtCallExpression;
    }

    private static final boolean extractCallsFromBody$lambda$1(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ElementFilters.Companion.getLaunchBuilder().isAccepted(it) || ElementFilters.Companion.getAsyncBuilder().isAccepted(it) || ElementFilters.Companion.getRunBlockingBuilderInvocation().isAccepted(it) || it instanceof KtLambdaExpression;
    }

    private static final boolean extractCallsFromBody$lambda$2(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof KtLambdaExpression;
    }

    private static final boolean extractCallsFromBody$lambda$3(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getParent() instanceof KtLambdaExpression;
    }

    private static final boolean exploreFunDeclaration$lambda$0(GraphBuilder this$0, List $toExplore, PsiElement psiElement, PsiElement overrideFn) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)overrideFn, (String)"overrideFn");
        if (overrideFn instanceof KtNamedFunction && this$0.relevantFiles.contains(MyPsiUtils.Companion.getFileForElement(overrideFn))) {
            $toExplore.add(overrideFn);
        }
        return true;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RunBlockingInspection.ExplorationLevel.values().length];
            try {
                nArray[RunBlockingInspection.ExplorationLevel.STRICT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RunBlockingInspection.ExplorationLevel.DECLARATION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RunBlockingInspection.ExplorationLevel.ALL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

