/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.inspections.shared.utils;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.components.KaTypeInformationProviderKt;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassLikeSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbolProviderKt;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.idea.base.projectStructure.ExternalCompilerVersionProvider;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.OptInUtilsKt;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinJpsPluginSettings;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.psi.KtElement;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001b\u0010\u0000\u001a\u00020\u0001*\u00020\u0004R\u00020\u0002j\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005\u001a\u0010\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0004H\u0002\"\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\"\u0010\n\u001a\u00020\u0001*\u00020\u000b8Fb\u00020\u0002\u008a\u0001\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\f\"\"\u0010\r\u001a\u00020\u0001*\u00020\u000b8Fb\u00020\u0002\u008a\u0001\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\f\"\"\u0010\u000e\u001a\u00020\u0001*\u00020\u000b8Fb\u00020\u0002\u008a\u0001\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\f\"\"\u0010\u000f\u001a\u00020\u0001*\u00020\u000b8Fb\u00020\u0002\u008a\u0001\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\f\"\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"canUseRangeUntil", "", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "<unused var>", "Lorg/jetbrains/kotlin/psi/KtElement;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtElement;)Z", "compilerVersionIsSufficientToUseRangeUntil", "element", "COMPILER_VERSION_WITH_RANGEUNTIL_SUPPORT", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion;", "isSignedIntegralType", "Lorg/jetbrains/kotlin/analysis/api/types/KaType;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/analysis/api/types/KaType;)Z", "isUnsignedIntegralType", "isIntegralType", "isFloatingPointType", "OPEN_END_RANGE_CLASS_ID", "Lorg/jetbrains/kotlin/name/ClassId;", "EXPERIMENTAL_STDLIB_API_CLASS_ID", "kotlin.code-insight.inspections.shared"})
public final class RangeInspectionUtilsKt {
    @NotNull
    private static final IdeKotlinVersion COMPILER_VERSION_WITH_RANGEUNTIL_SUPPORT = IdeKotlinVersion.Companion.get("1.7.20-Beta");
    @NotNull
    private static final ClassId OPEN_END_RANGE_CLASS_ID = ClassId.Companion.fromString$default((ClassId.Companion)ClassId.Companion, (String)"kotlin/ranges/OpenEndRange", (boolean)false, (int)2, null);
    @NotNull
    private static final ClassId EXPERIMENTAL_STDLIB_API_CLASS_ID = ClassId.Companion.fromString$default((ClassId.Companion)ClassId.Companion, (String)"kotlin/ExperimentalStdlibApi", (boolean)false, (int)2, null);

    public static final boolean canUseRangeUntil(@NotNull KaSession kaSession, @NotNull KtElement $this$canUseRangeUntil) {
        Intrinsics.checkNotNullParameter((Object)kaSession, (String)"$context-KaSession");
        Intrinsics.checkNotNullParameter((Object)$this$canUseRangeUntil, (String)"<this>");
        if (!RangeInspectionUtilsKt.compilerVersionIsSufficientToUseRangeUntil($this$canUseRangeUntil)) {
            return false;
        }
        if (!LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)$this$canUseRangeUntil).supportsFeature(LanguageFeature.RangeUntilOperator)) {
            return false;
        }
        KaClassLikeSymbol kaClassLikeSymbol = KaSymbolProviderKt.findClassLike(kaSession, OPEN_END_RANGE_CLASS_ID);
        if (kaClassLikeSymbol == null) {
            return false;
        }
        return OptInUtilsKt.isOptInSatisfied(kaSession, $this$canUseRangeUntil, kaClassLikeSymbol, EXPERIMENTAL_STDLIB_API_CLASS_ID);
    }

    private static final boolean compilerVersionIsSufficientToUseRangeUntil(KtElement element) {
        IdeKotlinVersion compilerVersion;
        Module module = GenericPsiUtils.getModule((PsiElement)element);
        if (module == null) {
            return false;
        }
        Module module2 = module;
        IdeKotlinVersion ideKotlinVersion = ExternalCompilerVersionProvider.INSTANCE.get(module2);
        if (ideKotlinVersion == null) {
            Project project = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            ideKotlinVersion = IdeKotlinVersion.Companion.opt(KotlinJpsPluginSettings.Companion.jpsVersion(project));
            if (ideKotlinVersion == null) {
                return false;
            }
        }
        return (compilerVersion = ideKotlinVersion).compareTo(COMPILER_VERSION_WITH_RANGEUNTIL_SUPPORT) >= 0;
    }

    public static final boolean isSignedIntegralType(@NotNull KaSession kaSession, @NotNull KaType $this$isSignedIntegralType) {
        Intrinsics.checkNotNullParameter((Object)kaSession, (String)"$context-KaSession");
        Intrinsics.checkNotNullParameter((Object)$this$isSignedIntegralType, (String)"<this>");
        return KaTypeInformationProviderKt.isIntType(kaSession, $this$isSignedIntegralType) || KaTypeInformationProviderKt.isLongType(kaSession, $this$isSignedIntegralType) || KaTypeInformationProviderKt.isShortType(kaSession, $this$isSignedIntegralType) || KaTypeInformationProviderKt.isByteType(kaSession, $this$isSignedIntegralType);
    }

    public static final boolean isUnsignedIntegralType(@NotNull KaSession kaSession, @NotNull KaType $this$isUnsignedIntegralType) {
        Intrinsics.checkNotNullParameter((Object)kaSession, (String)"$context-KaSession");
        Intrinsics.checkNotNullParameter((Object)$this$isUnsignedIntegralType, (String)"<this>");
        return KaTypeInformationProviderKt.isUIntType(kaSession, $this$isUnsignedIntegralType) || KaTypeInformationProviderKt.isULongType(kaSession, $this$isUnsignedIntegralType) || KaTypeInformationProviderKt.isUShortType(kaSession, $this$isUnsignedIntegralType) || KaTypeInformationProviderKt.isUByteType(kaSession, $this$isUnsignedIntegralType);
    }

    public static final boolean isIntegralType(@NotNull KaSession kaSession, @NotNull KaType $this$isIntegralType) {
        Intrinsics.checkNotNullParameter((Object)kaSession, (String)"$context-KaSession");
        Intrinsics.checkNotNullParameter((Object)$this$isIntegralType, (String)"<this>");
        return RangeInspectionUtilsKt.isSignedIntegralType(kaSession, $this$isIntegralType) || RangeInspectionUtilsKt.isUnsignedIntegralType(kaSession, $this$isIntegralType);
    }

    public static final boolean isFloatingPointType(@NotNull KaSession kaSession, @NotNull KaType $this$isFloatingPointType) {
        Intrinsics.checkNotNullParameter((Object)kaSession, (String)"$context-KaSession");
        Intrinsics.checkNotNullParameter((Object)$this$isFloatingPointType, (String)"<this>");
        return KaTypeInformationProviderKt.isFloatType(kaSession, $this$isFloatingPointType) || KaTypeInformationProviderKt.isDoubleType(kaSession, $this$isFloatingPointType);
    }
}

