/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.intentions.shared;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.idea.codeInsight.intentions.shared.AbstractChopListIntention;
import org.jetbrains.kotlin.idea.formatter.trailingComma.TrailingCommaContext;
import org.jetbrains.kotlin.idea.formatter.trailingComma.TrailingCommaHelper;
import org.jetbrains.kotlin.idea.formatter.trailingComma.TrailingCommaState;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0004B6\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u0012\u0011\u0010\b\u001a\r\u0012\t\u0012\u00070\n\u00a2\u0006\u0002\b\u000b0\t\u00a2\u0006\u0004\b\f\u0010\rJ\u001d\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J\u001f\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00028\u00002\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/intentions/shared/AbstractJoinListIntention;", "TList", "Lorg/jetbrains/kotlin/psi/KtElement;", "TElement", "Lorg/jetbrains/kotlin/idea/codeInsight/intentions/shared/AbstractChopListIntention;", "listClass", "Ljava/lang/Class;", "elementClass", "textGetter", "Ljava/util/function/Supplier;", "", "Lcom/intellij/codeInspection/util/IntentionName;", "<init>", "(Ljava/lang/Class;Ljava/lang/Class;Ljava/util/function/Supplier;)V", "isApplicableTo", "", "element", "caretOffset", "", "(Lorg/jetbrains/kotlin/psi/KtElement;I)Z", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lorg/jetbrains/kotlin/psi/KtElement;Lcom/intellij/openapi/editor/Editor;)V", "kotlin.code-insight.intentions.shared"})
@SourceDebugExtension(value={"SMAP\nJoinParameterListIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JoinParameterListIntention.kt\norg/jetbrains/kotlin/idea/codeInsight/intentions/shared/AbstractJoinListIntention\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,79:1\n1807#2,3:80\n1915#2,2:86\n2296#3,2:83\n1#4:85\n*S KotlinDebug\n*F\n+ 1 JoinParameterListIntention.kt\norg/jetbrains/kotlin/idea/codeInsight/intentions/shared/AbstractJoinListIntention\n*L\n31#1:80,3\n45#1:86,2\n32#1:83,2\n*E\n"})
public abstract class AbstractJoinListIntention<TList extends KtElement, TElement extends KtElement>
extends AbstractChopListIntention<TList, TElement> {
    public AbstractJoinListIntention(@NotNull Class<TList> listClass, @NotNull Class<TElement> elementClass, @NotNull Supplier<String> textGetter) {
        Intrinsics.checkNotNullParameter(listClass, (String)"listClass");
        Intrinsics.checkNotNullParameter(elementClass, (String)"elementClass");
        Intrinsics.checkNotNullParameter(textGetter, (String)"textGetter");
        super(listClass, elementClass, textGetter);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isApplicableTo(@NotNull TList element, int caretOffset) {
        boolean bl;
        Object element$iv;
        PsiElement it;
        Iterator iterator2;
        Intrinsics.checkNotNullParameter(element, (String)"element");
        List elements = this.elements(element);
        if (elements.isEmpty()) {
            return false;
        }
        if (!this.isApplicableCaretOffset(caretOffset, element)) {
            return false;
        }
        if (!this.hasLineBreakBefore((KtElement)CollectionsKt.first(elements))) {
            Iterable $this$any$iv = elements;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            iterator2 = $this$any$iv.iterator();
            do {
                if (!iterator2.hasNext()) return false;
                element$iv = iterator2.next();
                it = (KtElement)element$iv;
                boolean bl2 = false;
            } while (!this.hasLineBreakAfter(it));
            boolean bl3 = true;
            if (!bl3) return false;
        }
        Sequence $this$none$iv = (Sequence)PsiUtilsKt.getAllChildren((PsiElement)((PsiElement)element));
        boolean $i$f$none = false;
        iterator2 = $this$none$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            element$iv = iterator2.next();
            it = (PsiElement)element$iv;
            boolean bl4 = false;
            if (it instanceof PsiComment && Intrinsics.areEqual((Object)((PsiComment)it).getNode().getElementType(), (Object)KtTokens.EOL_COMMENT)) {
                return false;
            }
            bl = false;
        } while (!bl);
        return false;
    }

    @Override
    public void applyTo(@NotNull TList element, @Nullable Editor editor) {
        block6: {
            KtElement listElement;
            Object it;
            Intrinsics.checkNotNullParameter(element, (String)"element");
            Editor editor2 = editor;
            if (editor2 == null || (editor2 = editor2.getDocument()) == null) {
                return;
            }
            Editor document = editor2;
            List elements = this.elements(element);
            SmartPsiElementPointer pointer = SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)element));
            for (KtElement element2 : elements) {
                GenericPsiUtils.reformat$default((PsiElement)element2, false, 1, null);
            }
            PsiWhiteSpace psiWhiteSpace = this.nextBreak((KtElement)CollectionsKt.last(elements));
            if (psiWhiteSpace != null) {
                it = psiWhiteSpace;
                boolean bl = false;
                document.deleteString(PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)it)), PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)it)));
            }
            Iterable $this$forEach$iv = CollectionsKt.asReversed((List)CollectionsKt.dropLast(elements, (int)1));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PsiWhiteSpace it2;
                KtElement tElement = (KtElement)element$iv;
                boolean bl = false;
                if (this.nextBreak(tElement) == null) continue;
                boolean bl2 = false;
                document.replaceString(PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)it2)), PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)it2)), (CharSequence)" ");
            }
            PsiWhiteSpace psiWhiteSpace2 = this.prevBreak((KtElement)CollectionsKt.first(elements));
            if (psiWhiteSpace2 != null) {
                it = psiWhiteSpace2;
                boolean bl = false;
                document.deleteString(PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)it)), PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)it)));
            }
            Project project = ((PsiElement)element).getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
            documentManager.commitDocument((Document)document);
            PsiElement psiElement = pointer.getElement();
            KtElement ktElement = listElement = psiElement instanceof KtElement ? (KtElement)psiElement : null;
            if (listElement == null || TrailingCommaContext.Companion.create((PsiElement)listElement).getState() != TrailingCommaState.REDUNDANT) break block6;
            PsiElement psiElement2 = TrailingCommaHelper.INSTANCE.trailingCommaOrLastElement(listElement);
            if (psiElement2 != null) {
                psiElement2.delete();
            }
        }
    }
}

