/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.intentions.shared;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.rename.RenameProcessor;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.facet.platform.TargetPlatformDetectorUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeInsight.intentions.shared.ConvertCamelCaseTestFunctionToSpacedIntention;
import org.jetbrains.kotlin.idea.codeInsight.intentions.shared.ConvertSnakeCaseTestFunctionToSpacedIntention;
import org.jetbrains.kotlin.idea.codeInsight.intentions.shared.ConvertTestFunctionToSpacedIntention;
import org.jetbrains.kotlin.idea.codeInsight.intentions.shared.ConvertTestFunctionToSpacedIntentionKt;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.idea.testIntegration.framework.KotlinPsiBasedTestFramework;
import org.jetbrains.kotlin.platform.JsPlatformKt;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0011\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\t\u001a\u00020\u0004H&J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0004H&J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0004H\u0004J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0004H\u0002J\b\u0010\u0014\u001a\u00020\u000bH\u0016J\u001a\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00022\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016\u0082\u0001\u0002\u0018\u0019\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/intentions/shared/ConvertTestFunctionToSpacedIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "case", "", "<init>", "(Ljava/lang/String;)V", "split", "", "name", "isApplicableName", "", "isSnakeCase", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "convert", "startRename", "", "newName", "startInWriteAction", "applyTo", "editor", "Lcom/intellij/openapi/editor/Editor;", "Lorg/jetbrains/kotlin/idea/codeInsight/intentions/shared/ConvertCamelCaseTestFunctionToSpacedIntention;", "Lorg/jetbrains/kotlin/idea/codeInsight/intentions/shared/ConvertSnakeCaseTestFunctionToSpacedIntention;", "kotlin.code-insight.intentions.shared"})
public abstract sealed class ConvertTestFunctionToSpacedIntention
extends SelfTargetingRangeIntention<KtNamedFunction>
permits ConvertCamelCaseTestFunctionToSpacedIntention, ConvertSnakeCaseTestFunctionToSpacedIntention {
    private ConvertTestFunctionToSpacedIntention(String string) {
        Object[] objectArray = new Object[]{string};
        super(KtNamedFunction.class, KotlinBundle.messagePointer((String)"replace.0.name.with.spaces", (Object[])objectArray), null, 4, null);
    }

    @NotNull
    public abstract List<String> split(@NotNull String var1);

    public abstract boolean isApplicableName(@NotNull String var1);

    protected final boolean isSnakeCase(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        CharSequence charSequence = name2;
        return ConvertTestFunctionToSpacedIntentionKt.access$getSNAKE_CASE_REGEX$p().containsMatchIn(charSequence);
    }

    @Override
    @Nullable
    public TextRange applicabilityRange(@NotNull KtNamedFunction element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        TargetPlatform platform = TargetPlatformDetectorUtils.getPlatform((KtElement)element);
        if (TargetPlatformKt.isCommon((TargetPlatform)platform) || JsPlatformKt.isJs((TargetPlatform)platform)) {
            return null;
        }
        PsiElement psiElement = element.getNameIdentifier();
        if (psiElement == null || (psiElement = psiElement.getTextRange()) == null) {
            return null;
        }
        PsiElement range2 = psiElement;
        String string = element.getName();
        if (string == null) {
            return null;
        }
        String name2 = string;
        if (!this.isApplicableName(name2)) {
            return null;
        }
        String newName = this.convert(name2);
        if (Intrinsics.areEqual((Object)newName, (Object)KtPsiUtilKt.quoteIfNeeded((String)name2))) {
            return null;
        }
        if (KotlinPsiBasedTestFramework.Companion.findTestFramework$default(KotlinPsiBasedTestFramework.Companion, (KtNamedDeclaration)element, false, 2, null) == null) {
            return null;
        }
        Object[] objectArray = new Object[]{newName};
        this.setTextGetter(KotlinBundle.messagePointer((String)"rename.to.01", (Object[])objectArray));
        return range2;
    }

    private final String convert(String name2) {
        return KtPsiUtilKt.quoteIfNeeded((String)CollectionsKt.joinToString$default((Iterable)this.split(name2), (CharSequence)" ", null, null, (int)0, null, ConvertTestFunctionToSpacedIntention::convert$lambda$0, (int)30, null));
    }

    private final void startRename(KtNamedFunction element, String newName) {
        new RenameProcessor(element.getProject(), (PsiElement)element, newName, false, false).run();
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    public void applyTo(@NotNull KtNamedFunction element, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = element.getNameIdentifier();
        if (psiElement == null) {
            return;
        }
        PsiElement nameIdentifier = psiElement;
        String string = element.getName();
        if (string == null) {
            return;
        }
        String oldName = string;
        String oldId = KtPsiUtilKt.quoteIfNeeded((String)oldName);
        String newId = this.convert(oldName);
        if (editor == null) {
            this.startRename(element, newId);
            return;
        }
        TemplateBuilderImpl builder2 = new TemplateBuilderImpl(nameIdentifier);
        builder2.replaceElement(nameIdentifier, newId);
        Template template2 = (Template)ActionsKt.runWriteAction(() -> ConvertTestFunctionToSpacedIntention.applyTo$lambda$0(builder2));
        TemplateManager.getInstance((Project)element.getProject()).startTemplate(editor, template2, (TemplateEditingListener)new TemplateEditingAdapter(newId, oldId, this, element, editor){
            private String chosenId;
            private TextRange range;
            final /* synthetic */ String $oldId;
            final /* synthetic */ ConvertTestFunctionToSpacedIntention this$0;
            final /* synthetic */ KtNamedFunction $element;
            final /* synthetic */ Editor $editor;
            {
                this.$oldId = $oldId;
                this.this$0 = $receiver;
                this.$element = $element;
                this.$editor = $editor;
                this.chosenId = $newId;
            }

            public void beforeTemplateFinished(TemplateState state, Template template2) {
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                Object object = template2 instanceof TemplateImpl ? (TemplateImpl)template2 : null;
                if (object == null || (object = object.getVariableNameAt(0)) == null) {
                    return;
                }
                Object varName = object;
                Object object2 = state.getVariableValue((String)varName);
                if (object2 == null || (object2 = object2.getText()) == null || (object2 = KtPsiUtilKt.quoteIfNeeded((String)object2)) == null) {
                    return;
                }
                this.chosenId = object2;
                this.range = state.getVariableRange((String)varName);
            }

            public void templateFinished(Template template2, boolean brokenOff) {
                Intrinsics.checkNotNullParameter((Object)template2, (String)"template");
                TextRange textRange = this.range;
                if (textRange != null) {
                    TextRange textRange2 = textRange;
                    Editor editor = this.$editor;
                    KtNamedFunction ktNamedFunction = this.$element;
                    String string = this.$oldId;
                    TextRange it = textRange2;
                    boolean bl = false;
                    Document document = editor.getDocument();
                    Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
                    Document document2 = document;
                    ActionsKt.runWriteAction(() -> applyTo.1.templateFinished$lambda$0$0(document2, it, string));
                    PsiDocumentManager.getInstance((Project)ktNamedFunction.getProject()).commitDocument(document2);
                }
                if (!brokenOff && !Intrinsics.areEqual((Object)this.chosenId, (Object)this.$oldId)) {
                    ConvertTestFunctionToSpacedIntention.access$startRename(this.this$0, this.$element, this.chosenId);
                }
            }

            private static final Unit templateFinished$lambda$0$0(Document $document, TextRange $it, String $oldId) {
                $document.replaceString($it.getStartOffset(), $it.getEndOffset(), (CharSequence)$oldId);
                return Unit.INSTANCE;
            }
        });
    }

    private static final CharSequence convert$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((Object)StringsKt.trim((CharSequence)CapitalizeDecapitalizeKt.decapitalizeSmart$default((String)it, (boolean)false, (int)1, null))).toString();
    }

    private static final Template applyTo$lambda$0(TemplateBuilderImpl $builder) {
        return $builder.buildInlineTemplate();
    }

    public /* synthetic */ ConvertTestFunctionToSpacedIntention(String string, DefaultConstructorMarker $constructor_marker) {
        this(string);
    }

    public static final /* synthetic */ void access$startRename(ConvertTestFunctionToSpacedIntention $this, KtNamedFunction element, String newName) {
        $this.startRename(element, newName);
    }
}

