/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.intentions.shared;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.rename.RenameProcessor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/intentions/shared/RenameFileToMatchClassIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "<init>", "()V", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "startInWriteAction", "", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "kotlin.code-insight.intentions.shared"})
public final class RenameFileToMatchClassIntention
extends SelfTargetingRangeIntention<KtClassOrObject> {
    public RenameFileToMatchClassIntention() {
        super(KtClassOrObject.class, KotlinBundle.messagePointer((String)"rename.file.to.match.top.level.class.name", (Object[])new Object[0]), null, 4, null);
    }

    @Override
    @Nullable
    public TextRange applicabilityRange(@NotNull KtClassOrObject element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!element.isTopLevel()) {
            return null;
        }
        String string = element.getContainingKtFile().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String fileName = string;
        if (Intrinsics.areEqual((Object)FileUtil.getNameWithoutExtension((String)fileName), (Object)element.getName())) {
            return null;
        }
        Object[] objectArray = new Object[2];
        objectArray[0] = String.valueOf(element.getName());
        Intrinsics.checkNotNullExpressionValue((Object)FileUtilRt.getExtension((String)fileName), (String)"getExtension(...)");
        this.setTextGetter(KotlinBundle.messagePointer((String)"rename.file.to.0.1", (Object[])objectArray));
        PsiElement psiElement = element.getNameIdentifier();
        return psiElement != null ? psiElement.getTextRange() : null;
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    public void applyTo(@NotNull KtClassOrObject element, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtFile ktFile2 = element.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"getContainingKtFile(...)");
        KtFile file = ktFile2;
        String string = FileUtilRt.getExtension((String)file.getName());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExtension(...)");
        String extension = string;
        new RenameProcessor(file.getProject(), (PsiElement)file, element.getName() + "." + extension, RefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_FILE, RefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_FILE).run();
    }
}

