/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.lineMarkers;

import com.intellij.codeInsight.daemon.GutterIconDescriptor;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.NavigateAction;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Function;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbolModality;
import org.jetbrains.kotlin.analysis.api.symbols.KaValueParameterSymbol;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeInsight.lineMarkers.CallableOverridingsTooltip;
import org.jetbrains.kotlin.idea.codeInsight.lineMarkers.ClassInheritorsTooltip;
import org.jetbrains.kotlin.idea.codeInsight.lineMarkers.ImplementationsPopupHandler;
import org.jetbrains.kotlin.idea.codeInsight.lineMarkers.SuperDeclarationMarkerTooltip;
import org.jetbrains.kotlin.idea.codeInsight.lineMarkers.SuperDeclarationPopupHandler;
import org.jetbrains.kotlin.idea.codeInsight.lineMarkers.dsl.DslHighlightingMarkerKt;
import org.jetbrains.kotlin.idea.codeInsight.lineMarkers.shared.AbstractKotlinLineMarkerProvider;
import org.jetbrains.kotlin.idea.highlighter.markers.InheritanceMergeableLineMarkerInfo;
import org.jetbrains.kotlin.idea.highlighter.markers.KotlinLineMarkerOptions;
import org.jetbrains.kotlin.idea.search.KotlinSearchUsagesSupport;
import org.jetbrains.kotlin.idea.searching.inheritors.KotlinSearchUtilKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0016\u0010\t\u001a\u0012\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\u000b0\nj\u0002`\fH\u0016J$\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\t\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\u000b0\nH\u0002J$\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u000f2\u0012\u0010\t\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\u000b0\nH\u0002J$\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00132\u0012\u0010\t\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\u000b0\nH\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u0013H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/lineMarkers/KotlinLineMarkerProvider;", "Lorg/jetbrains/kotlin/idea/codeInsight/lineMarkers/shared/AbstractKotlinLineMarkerProvider;", "<init>", "()V", "doCollectSlowLineMarkers", "", "elements", "", "Lcom/intellij/psi/PsiElement;", "result", "", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "Lorg/jetbrains/kotlin/idea/codeInsight/lineMarkers/shared/LineMarkerInfos;", "collectCallableOverridings", "element", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "collectSuperDeclarations", "declaration", "collectInheritedClassMarker", "Lorg/jetbrains/kotlin/psi/KtClass;", "isUsedSamInterface", "", "intellij.kotlin.codeInsight.lineMarkers"})
@SourceDebugExtension(value={"SMAP\nKotlinLineMarkerProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinLineMarkerProvider.kt\norg/jetbrains/kotlin/idea/codeInsight/lineMarkers/KotlinLineMarkerProvider\n+ 2 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 3 KaSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KaSessionProvider\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,299:1\n30#2,2:300\n36#3,14:302\n50#3:319\n1786#4,3:316\n1#5:320\n*S KotlinDebug\n*F\n+ 1 KotlinLineMarkerProvider.kt\norg/jetbrains/kotlin/idea/codeInsight/lineMarkers/KotlinLineMarkerProvider\n*L\n106#1:300,2\n106#1:302,14\n106#1:319\n114#1:316,3\n*E\n"})
public final class KotlinLineMarkerProvider
extends AbstractKotlinLineMarkerProvider {
    @Override
    public void doCollectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result2) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        for (PsiElement psiElement : elements) {
            if (!(psiElement instanceof LeafPsiElement) || !Intrinsics.areEqual((Object)((LeafPsiElement)psiElement).getElementType(), (Object)KtTokens.IDENTIFIER)) continue;
            PsiElement psiElement2 = ((LeafPsiElement)psiElement).getParent();
            KtNamedDeclaration ktNamedDeclaration = psiElement2 instanceof KtNamedDeclaration ? (KtNamedDeclaration)psiElement2 : null;
            if (ktNamedDeclaration == null) continue;
            KtNamedDeclaration declaration = ktNamedDeclaration;
            KtNamedDeclaration ktNamedDeclaration2 = declaration;
            if (ktNamedDeclaration2 instanceof KtClass) {
                this.collectInheritedClassMarker((KtClass)declaration, result2);
                DslHighlightingMarkerKt.collectHighlightingDslMarkers((KtClass)declaration, result2);
                continue;
            }
            if (!(ktNamedDeclaration2 instanceof KtCallableDeclaration)) continue;
            this.collectSuperDeclarations((KtCallableDeclaration)declaration, result2);
            this.collectCallableOverridings((KtCallableDeclaration)declaration, result2);
        }
    }

    private final void collectCallableOverridings(KtCallableDeclaration element, Collection<? super LineMarkerInfo<?>> result2) {
        GutterIconDescriptor.Option gutter;
        if (!KotlinSearchUsagesSupport.SearchUtils.INSTANCE.isOverridable((KtDeclaration)element)) {
            return;
        }
        KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)element));
        if (ktClassOrObject == null) {
            return;
        }
        KtClassOrObject klass = ktClassOrObject;
        if (!(klass instanceof KtClass)) {
            return;
        }
        boolean isAbstract = CallableOverridingsTooltip.INSTANCE.isAbstract(element, (KtClass)klass);
        GutterIconDescriptor.Option option = gutter = isAbstract ? KotlinLineMarkerOptions.INSTANCE.getImplementedOption() : KotlinLineMarkerOptions.INSTANCE.getOverriddenOption();
        if (!gutter.isEnabled()) {
            return;
        }
        if (!(KotlinSearchUtilKt.hasAnyOverridings(element) || !KtPsiUtilKt.hasBody((KtDeclaration)((KtDeclaration)element)) && this.isUsedSamInterface((KtClass)klass))) {
            return;
        }
        PsiElement psiElement = element.getNameIdentifier();
        if (psiElement == null) {
            psiElement = (PsiElement)element;
        }
        PsiElement anchor = psiElement;
        Icon icon2 = gutter.getIcon();
        if (icon2 == null) {
            return;
        }
        Icon icon3 = icon2;
        TextRange textRange = anchor.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        InheritanceMergeableLineMarkerInfo lineMarkerInfo2 = new InheritanceMergeableLineMarkerInfo(anchor, textRange, icon3, (Function<? super PsiElement, String>)((Function)CallableOverridingsTooltip.INSTANCE), (GutterIconNavigationHandler<PsiElement>)((GutterIconNavigationHandler)ImplementationsPopupHandler.INSTANCE), GutterIconRenderer.Alignment.RIGHT, (Function0<String>)((Function0)() -> KotlinLineMarkerProvider.collectCallableOverridings$lambda$0(gutter)));
        NavigateAction.setNavigateAction((LineMarkerInfo)((LineMarkerInfo)lineMarkerInfo2), (String)KotlinBundle.message((String)"highlighter.action.text.go.to.overridden.methods", (Object[])new Object[0]), (String)"GotoImplementation");
        result2.add((LineMarkerInfo<?>)lineMarkerInfo2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void collectSuperDeclarations(KtCallableDeclaration declaration, Collection<? super LineMarkerInfo<?>> result) {
        if (!declaration.hasModifier(KtTokens.OVERRIDE_KEYWORD)) {
            v0 = declaration.getContainingFile();
            Intrinsics.checkNotNull((Object)v0, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
            if (!((KtFile)v0).isCompiled()) {
                return;
            }
        }
        useSiteElement$iv = (KtElement)declaration;
        $i$f$analyze = false;
        v1 = useSiteElement$iv.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getProject(...)");
        var5_5 = KaSessionProvider.Companion.getInstance(v1);
        useSiteElement$iv$iv = useSiteElement$iv;
        $i$f$analyze = false;
        analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(useSiteElement$iv$iv);
        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
        var10_11 = lock$iv$iv = new Object();
        synchronized (var10_11) {
            $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv = false;
            $this$collectSuperDeclarations_u24lambda_u240 = analysisSession$iv$iv;
            $i$a$-analyze-KotlinLineMarkerProvider$collectSuperDeclarations$1 = false;
            var14_17 = $this$collectSuperDeclarations_u24lambda_u240.getSymbol((KtDeclaration)declaration);
            if ((var14_17 instanceof KaCallableSymbol != false ? (KaCallableSymbol)var14_17 : null) == null) {
                // MONITOREXIT @DISABLED, blocks:[0, 18, 8] lbl25 : MonitorExitStatement: MONITOREXIT : var10_11
                this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
                return;
            }
            callableSymbol = v2;
            if (callableSymbol instanceof KaValueParameterSymbol) {
                v3 = ((KaValueParameterSymbol)callableSymbol).getGeneratedPrimaryConstructorProperty();
                if (v3 == null) {
                    // MONITOREXIT @DISABLED, blocks:[0, 16, 17, 8] lbl32 : MonitorExitStatement: MONITOREXIT : var10_11
                    this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
                    return;
                }
                v4 = callableSymbol = (KaCallableSymbol)v3;
            }
            if (!(allOverriddenSymbols = SequencesKt.toList($this$collectSuperDeclarations_u24lambda_u240.getAllOverriddenSymbols(callableSymbol))).isEmpty()) ** break block23
        }
        this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
        return;
        {
            block25: {
                try {
                    block24: {
                        if (callableSymbol.getModality() == KaSymbolModality.ABSTRACT) ** GOTO lbl-1000
                        $this$all$iv = allOverriddenSymbols;
                        $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            v5 = true;
                        } else {
                            for (T element$iv : $this$all$iv) {
                                it = (KaCallableSymbol)element$iv;
                                $i$a$-all-KotlinLineMarkerProvider$collectSuperDeclarations$1$implements$1 = false;
                                if (it.getModality() == KaSymbolModality.ABSTRACT) continue;
                                v5 = false;
                                break block24;
                            }
                            v5 = true;
                        }
                    }
                    if (v5) {
                        v6 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v6 = false;
                    }
                    implements = v6;
                    v7 = gutter = implements != false ? KotlinLineMarkerOptions.INSTANCE.getImplementingOption() : KotlinLineMarkerOptions.INSTANCE.getOverridingOption();
                    if (gutter.isEnabled()) break block25;
                    // MONITOREXIT @DISABLED, blocks:[4, 8] lbl63 : MonitorExitStatement: MONITOREXIT : var10_11
                    this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
                    return;
                }
                catch (Throwable throwable$iv$iv) {
                    this_$iv$iv.handleAnalysisException(throwable$iv$iv, analysisSession$iv$iv, useSiteElement$iv$iv);
                    throw new KotlinNothingValueException();
                }
            }
            v8 = declaration.getNameIdentifier();
            if (v8 == null) {
                v8 = (PsiElement)declaration;
            }
            anchor = v8;
            v9 = anchor.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"getTextRange(...)");
            v10 = gutter.getIcon();
            Intrinsics.checkNotNull((Object)v10);
            lineMarkerInfo = new InheritanceMergeableLineMarkerInfo(anchor, v9, v10, (Function<? super PsiElement, String>)((Function)SuperDeclarationMarkerTooltip.INSTANCE), (GutterIconNavigationHandler<PsiElement>)((GutterIconNavigationHandler)SuperDeclarationPopupHandler.INSTANCE), GutterIconRenderer.Alignment.RIGHT, (Function0<String>)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, collectSuperDeclarations$lambda$0$1(com.intellij.codeInsight.daemon.GutterIconDescriptor$Option ), ()Ljava/lang/String;)((GutterIconDescriptor.Option)gutter));
            NavigateAction.setNavigateAction((LineMarkerInfo)((LineMarkerInfo)lineMarkerInfo), (String)(declaration instanceof KtNamedFunction != false ? KotlinBundle.message((String)"highlighter.action.text.go.to.super.method", (Object[])new Object[0]) : KotlinBundle.message((String)"highlighter.action.text.go.to.super.property", (Object[])new Object[0])), (String)"GotoSuperMethod");
            var11_14 = result.add((LineMarkerInfo<?>)lineMarkerInfo);
            // MONITOREXIT @DISABLED, blocks:[5, 8] lbl79 : MonitorExitStatement: MONITOREXIT : var10_11
            var9_10 = var11_14;
            return;
        }
        {
            finally {
                this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
            }
        }
    }

    private final void collectInheritedClassMarker(KtClass element, Collection<? super LineMarkerInfo<?>> result2) {
        GutterIconDescriptor.Option gutter;
        if (!KotlinSearchUsagesSupport.SearchUtils.isInheritable(element)) {
            return;
        }
        PsiElement psiElement = element.getNameIdentifier();
        if (psiElement == null) {
            psiElement = (PsiElement)element;
        }
        PsiElement anchor = psiElement;
        boolean isInterface = element.isInterface();
        GutterIconDescriptor.Option option = gutter = isInterface ? KotlinLineMarkerOptions.INSTANCE.getImplementedOption() : KotlinLineMarkerOptions.INSTANCE.getOverriddenOption();
        if (!gutter.isEnabled()) {
            return;
        }
        if (!KotlinSearchUtilKt.hasAnyInheritors(element) && !this.isUsedSamInterface(element)) {
            return;
        }
        Icon icon2 = gutter.getIcon();
        if (icon2 == null) {
            return;
        }
        Icon icon3 = icon2;
        TextRange textRange = anchor.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        InheritanceMergeableLineMarkerInfo lineMarkerInfo2 = new InheritanceMergeableLineMarkerInfo(anchor, textRange, icon3, (Function<? super PsiElement, String>)((Function)ClassInheritorsTooltip.INSTANCE), (GutterIconNavigationHandler<PsiElement>)((GutterIconNavigationHandler)ImplementationsPopupHandler.INSTANCE), GutterIconRenderer.Alignment.RIGHT, (Function0<String>)((Function0)() -> KotlinLineMarkerProvider.collectInheritedClassMarker$lambda$0(gutter)));
        NavigateAction.setNavigateAction((LineMarkerInfo)((LineMarkerInfo)lineMarkerInfo2), (String)(isInterface ? KotlinBundle.message((String)"highlighter.action.text.go.to.implementations", (Object[])new Object[0]) : KotlinBundle.message((String)"highlighter.action.text.go.to.subclasses", (Object[])new Object[0])), (String)"GotoImplementation");
        result2.add((LineMarkerInfo<?>)lineMarkerInfo2);
    }

    private final boolean isUsedSamInterface(KtClass element) {
        boolean bl;
        KtLightClass ktLightClass = LightClassUtilsKt.toLightClass((KtClassOrObject)((KtClassOrObject)element));
        if (ktLightClass != null) {
            KtLightClass aClass = ktLightClass;
            boolean bl2 = false;
            bl = LambdaUtil.isFunctionalClass((PsiClass)((PsiClass)aClass)) && ReferencesSearch.search((PsiElement)((PsiElement)aClass)).findFirst() != null;
        } else {
            bl = false;
        }
        return bl;
    }

    private static final String collectCallableOverridings$lambda$0(GutterIconDescriptor.Option $gutter) {
        String string = $gutter.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    private static final String collectSuperDeclarations$lambda$0$1(GutterIconDescriptor.Option $gutter) {
        String string = $gutter.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    private static final String collectInheritedClassMarker$lambda$0(GutterIconDescriptor.Option $gutter) {
        String string = $gutter.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }
}

