/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeinsights.impl.base;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.psi.PsiLinesUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/codeinsights/impl/base/RemoveEmptyParenthesesFromLambdaCallUtils;", "", "<init>", "()V", "canRemoveByPsi", "", "list", "Lorg/jetbrains/kotlin/psi/KtValueArgumentList;", "removeArgumentList", "", "removeEmptyArgumentListIfApplicable", "intellij.kotlin.codeInsight.shared"})
public final class RemoveEmptyParenthesesFromLambdaCallUtils {
    @NotNull
    public static final RemoveEmptyParenthesesFromLambdaCallUtils INSTANCE = new RemoveEmptyParenthesesFromLambdaCallUtils();

    private RemoveEmptyParenthesesFromLambdaCallUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean canRemoveByPsi(@NotNull KtValueArgumentList list2) {
        Intrinsics.checkNotNullParameter((Object)list2, (String)"list");
        List list3 = list2.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getArguments(...)");
        if (!((Collection)list3).isEmpty()) {
            return false;
        }
        boolean bl = false;
        if (bl) {
            return false;
        }
        PsiElement psiElement = list2.getParent();
        if (!(psiElement instanceof KtCallExpression)) return false;
        KtCallExpression ktCallExpression = (KtCallExpression)psiElement;
        if (ktCallExpression == null) {
            return false;
        }
        KtCallExpression parent = ktCallExpression;
        KtExpression ktExpression = parent.getCalleeExpression();
        if (Intrinsics.areEqual((Object)(ktExpression != null ? ktExpression.getText() : null), (Object)KtTokens.SUSPEND_KEYWORD.getValue())) {
            return false;
        }
        KtLambdaArgument ktLambdaArgument = (KtLambdaArgument)CollectionsKt.singleOrNull((List)parent.getLambdaArguments());
        if (ktLambdaArgument == null) {
            return false;
        }
        KtLambdaArgument singleLambdaArgument = ktLambdaArgument;
        if (PsiLinesUtilsKt.getLineNumber((PsiElement)list2, false) != PsiLinesUtilsKt.getLineNumber((PsiElement)singleLambdaArgument, true)) {
            return false;
        }
        PsiElement prev = PsiUtilsKt.getPrevSiblingIgnoringWhitespaceAndComments$default((PsiElement)((PsiElement)list2), (boolean)false, (int)1, null);
        if (prev instanceof KtCallExpression) return false;
        KtQualifiedExpression ktQualifiedExpression = prev instanceof KtQualifiedExpression ? (KtQualifiedExpression)prev : null;
        if ((ktQualifiedExpression != null ? ktQualifiedExpression.getSelectorExpression() : null) instanceof KtCallExpression) return false;
        return true;
    }

    public final void removeArgumentList(@NotNull KtValueArgumentList list2) {
        Intrinsics.checkNotNullParameter((Object)list2, (String)"list");
        list2.delete();
    }

    public final void removeEmptyArgumentListIfApplicable(@NotNull KtValueArgumentList list2) {
        Intrinsics.checkNotNullParameter((Object)list2, (String)"list");
        if (this.canRemoveByPsi(list2)) {
            this.removeArgumentList(list2);
        }
    }
}

