/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeinsights.impl.base.inspections;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.components.KaExpressionTypeProviderKt;
import org.jetbrains.kotlin.analysis.api.components.KaResolverKt;
import org.jetbrains.kotlin.analysis.api.components.KaTypeRelationCheckerKt;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfoKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaPartiallyAppliedSymbolKt;
import org.jetbrains.kotlin.analysis.api.symbols.KaFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.codeinsight.utils.KotlinPsiUtilsKt;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u000bR\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\fJ-\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u000bR\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\fJE\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0014\u0010\u000f\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0012\u0004\u0012\u00020\u00120\u0010H\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0002J&\u0010\u0015\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00062\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u0018H\u0002J#\u0010\u0019\u001a\u00020\u00122\b\u0010\u001a\u001a\u0004\u0018\u00010\u0011H\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u001bJ#\u0010\u001c\u001a\u00020\u00122\b\u0010\u001a\u001a\u0004\u0018\u00010\u0011H\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u001b\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/codeinsights/impl/base/inspections/JavaCollectionsStaticMethodInspectionUtils;", "", "<init>", "()V", "getMethodIfItsArgumentIsMutableList", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlin/psi/KtValueArgument;", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "<unused var>", "expression", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;)Lkotlin/Pair;", "getMethodIfItsArgumentIsImmutableList", "getMethodIfCanReplaceItWithStdlib", "isValidFirstArgument", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/analysis/api/types/KaType;", "", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;Lkotlin/jvm/functions/Function1;)Lkotlin/Pair;", "checkApiVersion", "canReplaceWithStdLib", "fqName", "args", "", "isMutableListOrSubtype", "type", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/analysis/api/types/KaType;)Z", "isListOrSubtype", "intellij.kotlin.codeInsight.shared"})
public final class JavaCollectionsStaticMethodInspectionUtils {
    @NotNull
    public static final JavaCollectionsStaticMethodInspectionUtils INSTANCE = new JavaCollectionsStaticMethodInspectionUtils();

    private JavaCollectionsStaticMethodInspectionUtils() {
    }

    @Nullable
    public final Pair<String, KtValueArgument> getMethodIfItsArgumentIsMutableList(@NotNull KaSession kaSession, @NotNull KtDotQualifiedExpression expression) {
        Intrinsics.checkNotNullParameter((Object)kaSession, (String)"$context-KaSession");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        return this.getMethodIfCanReplaceItWithStdlib(kaSession, expression, (Function1<? super KaType, Boolean>)((Function1)arg_0 -> JavaCollectionsStaticMethodInspectionUtils.getMethodIfItsArgumentIsMutableList$lambda$0(kaSession, arg_0)));
    }

    @Nullable
    public final Pair<String, KtValueArgument> getMethodIfItsArgumentIsImmutableList(@NotNull KaSession kaSession, @NotNull KtDotQualifiedExpression expression) {
        Intrinsics.checkNotNullParameter((Object)kaSession, (String)"$context-KaSession");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        return this.getMethodIfCanReplaceItWithStdlib(kaSession, expression, (Function1<? super KaType, Boolean>)((Function1)arg_0 -> JavaCollectionsStaticMethodInspectionUtils.getMethodIfItsArgumentIsImmutableList$lambda$0(kaSession, arg_0)));
    }

    private final Pair<String, KtValueArgument> getMethodIfCanReplaceItWithStdlib(KaSession kaSession, KtDotQualifiedExpression expression, Function1<? super KaType, Boolean> isValidFirstArgument) {
        KaType firstArgType;
        KtCallExpression ktCallExpression = KotlinPsiUtilsKt.getCallExpression((KtQualifiedExpression)expression);
        if (ktCallExpression == null) {
            return null;
        }
        KtCallExpression callExpression = ktCallExpression;
        List args = callExpression.getValueArguments();
        KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.firstOrNull((List)args);
        if (ktValueArgument == null) {
            return null;
        }
        KtValueArgument firstArg = ktValueArgument;
        KtExpression ktExpression = firstArg.getArgumentExpression();
        KaType kaType = firstArgType = ktExpression != null ? KaExpressionTypeProviderKt.getExpressionType(kaSession, ktExpression) : null;
        if (!((Boolean)isValidFirstArgument.invoke((Object)firstArgType)).booleanValue()) {
            return null;
        }
        KaLifetimeOwner kaLifetimeOwner = KaResolverKt.resolveToCall(kaSession, (KtElement)callExpression);
        if (kaLifetimeOwner == null || (kaLifetimeOwner = KaCallInfoKt.singleFunctionCallOrNull((KaCallInfo)kaLifetimeOwner)) == null) {
            return null;
        }
        KaLifetimeOwner call = kaLifetimeOwner;
        CallableId callableId = ((KaFunctionSymbol)KaPartiallyAppliedSymbolKt.getSymbol(call.getPartiallyAppliedSymbol())).getCallableId();
        if (callableId == null) {
            return null;
        }
        CallableId callableId2 = callableId;
        String fqName2 = callableId2.asSingleFqName().asString();
        if (!this.canReplaceWithStdLib(expression, fqName2, args)) {
            return null;
        }
        String[] stringArray = new String[]{"."};
        String methodName = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)fqName2, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        return TuplesKt.to((Object)methodName, (Object)firstArg);
    }

    private final boolean checkApiVersion(KtDotQualifiedExpression expression) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)expression));
        if (module == null) {
            return true;
        }
        Module module2 = module;
        return LanguageVersionSettingsProviderUtils.getLanguageVersionSettings(module2).getApiVersion().compareTo(ApiVersion.KOTLIN_1_2) >= 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean canReplaceWithStdLib(KtDotQualifiedExpression expression, String fqName2, List<? extends KtValueArgument> args) {
        if (!StringsKt.startsWith$default((String)fqName2, (String)"java.util.Collections.", (boolean)false, (int)2, null)) {
            return false;
        }
        int size = args.size();
        switch (fqName2) {
            case "java.util.Collections.fill": {
                if (!this.checkApiVersion(expression)) return false;
                if (size != 2) return false;
                return true;
            }
            case "java.util.Collections.reverse": {
                if (size != 1) return false;
                return true;
            }
            case "java.util.Collections.shuffle": {
                if (!this.checkApiVersion(expression)) return false;
                if (size == 1) return true;
                if (size != 2) return false;
                return true;
            }
            case "java.util.Collections.sort": {
                if (size == 1) return true;
                if (size != 2) return false;
                KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.getOrNull(args, (int)1);
                if (!((ktValueArgument != null ? ktValueArgument.getArgumentExpression() : null) instanceof KtLambdaExpression)) return false;
                return true;
            }
            default: {
                return false;
            }
        }
    }

    private final boolean isMutableListOrSubtype(KaSession kaSession, KaType type2) {
        KaType kaType = type2;
        return kaType != null ? KaTypeRelationCheckerKt.isSubtypeOf$default(kaSession, kaType, StandardClassIds.INSTANCE.getMutableList(), null, 4, null) : false;
    }

    private final boolean isListOrSubtype(KaSession kaSession, KaType type2) {
        KaType kaType = type2;
        return kaType != null ? KaTypeRelationCheckerKt.isSubtypeOf$default(kaSession, kaType, StandardClassIds.INSTANCE.getList(), null, 4, null) : false;
    }

    private static final boolean getMethodIfItsArgumentIsMutableList$lambda$0(KaSession kaSession, KaType methodArgument) {
        return INSTANCE.isMutableListOrSubtype(kaSession, methodArgument);
    }

    private static final boolean getMethodIfItsArgumentIsImmutableList$lambda$0(KaSession kaSession, KaType methodArgument) {
        return INSTANCE.isListOrSubtype(kaSession, methodArgument) && !INSTANCE.isMutableListOrSubtype(kaSession, methodArgument);
    }
}

