/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeinsights.impl.base.intentions;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiCommentUtilsKt;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.psi.BuildStringUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a*\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00052\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0012\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006*\u00020\u0003H\u0002\u001a\f\u0010\f\u001a\u00020\r*\u00020\u0001H\u0002\u001a\f\u0010\u000e\u001a\u00020\n*\u00020\u0007H\u0002\u00a8\u0006\u000f"}, d2={"convertConcatenationToBuildStringCall", "Lorg/jetbrains/kotlin/psi/KtExpression;", "element", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "transformOperand", "Lkotlin/Pair;", "", "Lcom/intellij/psi/PsiElement;", "expression", "isLast", "", "collectOperands", "deleteTailComments", "", "isWhiteSpaceWithLineBreak", "intellij.kotlin.codeInsight.shared"})
@SourceDebugExtension(value={"SMAP\nConvertConcatenationToBuildStringIntentionUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConvertConcatenationToBuildStringIntentionUtils.kt\norg/jetbrains/kotlin/idea/codeinsights/impl/base/intentions/ConvertConcatenationToBuildStringIntentionUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 KotlinPsiModificationUtils.kt\norg/jetbrains/kotlin/idea/base/psi/KotlinPsiModificationUtils\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,65:1\n1596#2:66\n1629#2,4:67\n25#3,7:71\n1342#4,2:78\n*S KotlinDebug\n*F\n+ 1 ConvertConcatenationToBuildStringIntentionUtils.kt\norg/jetbrains/kotlin/idea/codeinsights/impl/base/intentions/ConvertConcatenationToBuildStringIntentionUtilsKt\n*L\n18#1:66\n18#1:67,4\n23#1:71,7\n62#1:78,2\n*E\n"})
public final class ConvertConcatenationToBuildStringIntentionUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final KtExpression convertConcatenationToBuildStringCall(@NotNull KtBinaryExpression element) {
        PsiElement psiElement;
        void $this$replaced$iv;
        PsiElement $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        List<KtExpression> operands = ConvertConcatenationToBuildStringIntentionUtilsKt.collectOperands(element);
        Iterable $this$mapIndexed$iv = operands;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index2;
            void expression;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            KtExpression ktExpression = (KtExpression)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ConvertConcatenationToBuildStringIntentionUtilsKt.transformOperand((KtExpression)expression, index2 == CollectionsKt.getLastIndex(operands)));
        }
        List operandsWithExtras = (List)destination$iv$iv;
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtExpression call = BuildStringUtilsKt.generateBuildStringCallWithExtras(project, operandsWithExtras);
        ConvertConcatenationToBuildStringIntentionUtilsKt.deleteTailComments((KtExpression)element);
        $this$mapIndexedTo$iv$iv = (PsiElement)element;
        PsiElement newElement$iv = (PsiElement)call;
        boolean $i$f$replaced = false;
        if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)newElement$iv)) {
            psiElement = newElement$iv;
        } else {
            PsiElement result$iv = $this$replaced$iv.replace(newElement$iv);
            if (result$iv instanceof KtExpression) {
                psiElement = result$iv;
            } else {
                Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                KtExpression ktExpression = ((KtParenthesizedExpression)result$iv).getExpression();
                if (ktExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                }
                psiElement = (PsiElement)ktExpression;
            }
        }
        KtExpression replacedElement = (KtExpression)psiElement;
        GenericPsiUtils.reformat((PsiElement)replacedElement, true);
        return replacedElement;
    }

    private static final Pair<KtExpression, List<PsiElement>> transformOperand(KtExpression expression, boolean isLast) {
        KtExpression ktExpression;
        if (expression instanceof KtStringTemplateExpression) {
            KtStringTemplateEntry[] ktStringTemplateEntryArray = ((KtStringTemplateExpression)expression).getEntries();
            Intrinsics.checkNotNullExpressionValue((Object)ktStringTemplateEntryArray, (String)"getEntries(...)");
            Object object = ArraysKt.singleOrNull((Object[])ktStringTemplateEntryArray);
            ktExpression = object instanceof KtStringTemplateEntryWithExpression ? (KtStringTemplateEntryWithExpression)object : null;
            if (ktExpression == null || (ktExpression = ktExpression.getExpression()) == null) {
                ktExpression = expression;
            }
        } else {
            ktExpression = expression;
        }
        KtExpression unpackedExpression = ktExpression;
        List<PsiElement> tailComments = KotlinPsiCommentUtilsKt.tailComments(expression, !isLast, (Function1<? super PsiElement, Boolean>)((Function1)ConvertConcatenationToBuildStringIntentionUtilsKt::transformOperand$lambda$0));
        return new Pair((Object)unpackedExpression, tailComments);
    }

    private static final List<KtExpression> collectOperands(KtBinaryExpression $this$collectOperands) {
        List expressions = new ArrayList();
        ConvertConcatenationToBuildStringIntentionUtilsKt.collectOperands$collect(expressions, (KtExpression)$this$collectOperands);
        return expressions;
    }

    private static final void deleteTailComments(KtExpression $this$deleteTailComments) {
        Sequence $this$forEach$iv = SequencesKt.filter((Sequence)SequencesKt.takeWhile((Sequence)PsiTreeUtilKt.siblings$default((PsiElement)((PsiElement)$this$deleteTailComments), (boolean)false, (boolean)false, (int)1, null), ConvertConcatenationToBuildStringIntentionUtilsKt::deleteTailComments$lambda$0), ConvertConcatenationToBuildStringIntentionUtilsKt::deleteTailComments$lambda$1);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiElement it = (PsiElement)element$iv;
            boolean bl = false;
            it.delete();
        }
    }

    private static final boolean isWhiteSpaceWithLineBreak(PsiElement $this$isWhiteSpaceWithLineBreak) {
        return $this$isWhiteSpaceWithLineBreak instanceof PsiWhiteSpace && $this$isWhiteSpaceWithLineBreak.textContains('\n');
    }

    private static final boolean transformOperand$lambda$0(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)it), (Object)KtTokens.PLUS);
    }

    private static final void collectOperands$collect(List<KtExpression> expressions, KtExpression expression) {
        KtExpression ktExpression = expression;
        if (ktExpression instanceof KtBinaryExpression) {
            ConvertConcatenationToBuildStringIntentionUtilsKt.collectOperands$collect(expressions, ((KtBinaryExpression)expression).getLeft());
            ConvertConcatenationToBuildStringIntentionUtilsKt.collectOperands$collect(expressions, ((KtBinaryExpression)expression).getRight());
        } else if (ktExpression != null) {
            expressions.add(expression);
        }
    }

    private static final boolean deleteTailComments$lambda$0(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !ConvertConcatenationToBuildStringIntentionUtilsKt.isWhiteSpaceWithLineBreak(it);
    }

    private static final boolean deleteTailComments$lambda$1(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof PsiComment;
    }
}

