/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeinsights.impl.base.intentions;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.PrefixedStringTemplateUtilsKt;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.psi.BuildStringUtilsKt;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a \u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"convertStringTemplateToBuildStringCall", "Lorg/jetbrains/kotlin/psi/KtExpression;", "element", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "createOperands", "", "createStringTemplate", "psiFactory", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "content", "", "prefixLength", "", "intellij.kotlin.codeInsight.shared"})
@SourceDebugExtension(value={"SMAP\nConvertStringTemplateToBuildStringIntentionUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConvertStringTemplateToBuildStringIntentionUtils.kt\norg/jetbrains/kotlin/idea/codeinsights/impl/base/intentions/ConvertStringTemplateToBuildStringIntentionUtilsKt\n+ 2 KotlinPsiModificationUtils.kt\norg/jetbrains/kotlin/idea/base/psi/KotlinPsiModificationUtils\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,57:1\n25#2,7:58\n14060#3,2:65\n*S KotlinDebug\n*F\n+ 1 ConvertStringTemplateToBuildStringIntentionUtils.kt\norg/jetbrains/kotlin/idea/codeinsights/impl/base/intentions/ConvertStringTemplateToBuildStringIntentionUtilsKt\n*L\n13#1:58,7\n37#1:65,2\n*E\n"})
public final class ConvertStringTemplateToBuildStringIntentionUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final KtExpression convertStringTemplateToBuildStringCall(@NotNull KtStringTemplateExpression element) {
        PsiElement psiElement;
        void $this$replaced$iv;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        List<KtExpression> operands = ConvertStringTemplateToBuildStringIntentionUtilsKt.createOperands(element);
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtExpression call = BuildStringUtilsKt.generateBuildStringCall(project, operands);
        PsiElement psiElement2 = (PsiElement)element;
        PsiElement newElement$iv = (PsiElement)call;
        boolean $i$f$replaced = false;
        if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)newElement$iv)) {
            psiElement = newElement$iv;
        } else {
            PsiElement result$iv = $this$replaced$iv.replace(newElement$iv);
            if (result$iv instanceof KtExpression) {
                psiElement = result$iv;
            } else {
                Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                KtExpression ktExpression = ((KtParenthesizedExpression)result$iv).getExpression();
                if (ktExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                }
                psiElement = (PsiElement)ktExpression;
            }
        }
        return (KtExpression)psiElement;
    }

    private static final List<KtExpression> createOperands(KtStringTemplateExpression element) {
        List operands = new ArrayList();
        StringBuilder stringBuilder = new StringBuilder();
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
        int oldPrefixLength = PrefixedStringTemplateUtilsKt.getEntryPrefixLength(element);
        KtStringTemplateEntry[] ktStringTemplateEntryArray = element.getEntries();
        Intrinsics.checkNotNullExpressionValue((Object)ktStringTemplateEntryArray, (String)"getEntries(...)");
        Object[] $this$forEach$iv = ktStringTemplateEntryArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtStringTemplateEntry entry = (KtStringTemplateEntry)element$iv;
            boolean bl = false;
            if (entry instanceof KtStringTemplateEntryWithExpression) {
                if (((KtStringTemplateEntryWithExpression)entry).getExpression() != null) {
                    KtExpression it;
                    boolean bl2 = false;
                    ConvertStringTemplateToBuildStringIntentionUtilsKt.createOperands$addStringOperand(stringBuilder, psiFactory, oldPrefixLength, operands);
                    operands.add(it);
                }
                continue;
            }
            stringBuilder.append(entry.getText());
        }
        ConvertStringTemplateToBuildStringIntentionUtilsKt.createOperands$addStringOperand(stringBuilder, psiFactory, oldPrefixLength, operands);
        return operands;
    }

    private static final KtStringTemplateExpression createStringTemplate(KtPsiFactory psiFactory, String content, int prefixLength) {
        return prefixLength > 1 ? KtPsiFactory.createMultiDollarStringTemplate$default((KtPsiFactory)psiFactory, (String)content, (int)prefixLength, (boolean)false, (int)4, null) : psiFactory.createStringTemplate(content);
    }

    private static final void createOperands$addStringOperand(StringBuilder stringBuilder, KtPsiFactory psiFactory, int oldPrefixLength, List<KtExpression> operands) {
        if (((CharSequence)stringBuilder).length() > 0) {
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            KtStringTemplateExpression withOriginalPrefix = ConvertStringTemplateToBuildStringIntentionUtilsKt.createStringTemplate(psiFactory, string, oldPrefixLength);
            int minimalSafePrefixLength = PrefixedStringTemplateUtilsKt.findPrefixLengthForPlainTextConversion(withOriginalPrefix);
            if (minimalSafePrefixLength < oldPrefixLength) {
                String string2 = stringBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                KtStringTemplateExpression withSmallerPrefix = ConvertStringTemplateToBuildStringIntentionUtilsKt.createStringTemplate(psiFactory, string2, minimalSafePrefixLength);
                v2 = operands.add((KtExpression)withSmallerPrefix);
            } else {
                v2 = operands.add((KtExpression)withOriginalPrefix);
            }
            StringsKt.clear((StringBuilder)stringBuilder);
        }
    }
}

