/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.compiler.configuration;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.JDOMUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinMavenArtifactFinder;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005J*\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\b\b\u0002\u0010\r\u001a\u00020\u0005\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/configuration/KotlinMavenUtils;", "", "<init>", "()V", "findLibraryVersion", "", "libraryFileName", "findArtifactOrFail", "Ljava/nio/file/Path;", "groupId", "artifactId", "version", "findArtifact", "suffix", "intellij.kotlin.base.plugin"})
public final class KotlinMavenUtils {
    @NotNull
    public static final KotlinMavenUtils INSTANCE = new KotlinMavenUtils();

    private KotlinMavenUtils() {
    }

    @NotNull
    public final String findLibraryVersion(@NotNull String libraryFileName) {
        List urlChunks;
        Object object;
        String firstRootUrl;
        Object mavenIdChunks;
        CharSequence mavenId;
        Intrinsics.checkNotNullParameter((Object)libraryFileName, (String)"libraryFileName");
        String[] stringArray = new String[]{".idea/libraries"};
        Path librariesDir = Paths.get(PathManager.getHomePath(), stringArray);
        Path libraryFile = librariesDir.resolve(libraryFileName);
        Element element = JDOMUtil.load((Path)libraryFile);
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"load(...)");
        Element libraryDocument = element;
        Element element2 = libraryDocument.getChild("library");
        if (element2 == null) {
            throw new IllegalStateException(("Invalid library file: " + libraryFile).toString());
        }
        Element libraryElement = element2;
        if (Intrinsics.areEqual((Object)libraryElement.getAttributeValue("type"), (Object)"repository")) {
            char[] cArray;
            Element propertiesElement;
            Element element3 = propertiesElement = libraryElement.getChild("properties");
            mavenId = element3 != null ? element3.getAttributeValue("maven-id") : null;
            CharSequence charSequence = mavenId;
            if (!(charSequence == null || charSequence.length() == 0) && (mavenIdChunks = (Object)StringsKt.split$default((CharSequence)mavenId, (char[])(cArray = new char[]{':'}), (boolean)false, (int)0, (int)6, null)).size() == 3) {
                return (String)mavenIdChunks.get(2);
            }
        }
        if (!((mavenId = (CharSequence)(firstRootUrl = (object = libraryElement.getChild("CLASSES")) != null && (object = object.getChild("root")) != null && (object = object.getAttributeValue("url")) != null ? StringsKt.substringBefore$default((String)object, (String)"!/", null, (int)2, null) : null)) == null || mavenId.length() == 0) && (urlChunks = StringsKt.split$default((CharSequence)firstRootUrl, (char[])(mavenIdChunks = (Object)new char[]{'/'}), (boolean)false, (int)0, (int)6, null)).size() >= 3) {
            String fileName = (String)urlChunks.get(CollectionsKt.getLastIndex((List)urlChunks));
            String version = (String)urlChunks.get(CollectionsKt.getLastIndex((List)urlChunks) - 1);
            String artifactId = (String)urlChunks.get(CollectionsKt.getLastIndex((List)urlChunks) - 2);
            if (StringsKt.startsWith$default((String)fileName, (String)(artifactId + "-" + version), (boolean)false, (int)2, null) && StringsKt.endsWith((String)fileName, (String)".jar", (boolean)true)) {
                return version;
            }
        }
        throw new IllegalStateException(("Can't get '" + libraryFileName + "' version").toString());
    }

    @NotNull
    public final Path findArtifactOrFail(@NotNull String groupId, @NotNull String artifactId, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Path path2 = KotlinMavenUtils.findArtifact$default(this, groupId, artifactId, version, null, 8, null);
        if (path2 == null) {
            throw new IllegalStateException(("Artifact " + groupId + ":" + artifactId + ":" + version + " not found").toString());
        }
        return path2;
    }

    @Nullable
    public final Path findArtifact(@NotNull String groupId, @NotNull String artifactId, @NotNull String version, @NotNull String suffix2) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)suffix2, (String)"suffix");
        return KotlinMavenArtifactFinder.Companion.getInstance().findArtifact(groupId, artifactId, version, suffix2);
    }

    public static /* synthetic */ Path findArtifact$default(KotlinMavenUtils kotlinMavenUtils, String string, String string2, String string3, String string4, int n, Object object) {
        if ((n & 8) != 0) {
            string4 = ".jar";
        }
        return kotlinMavenUtils.findArtifact(string, string2, string3, string4);
    }
}

