/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion.checkers;

import com.intellij.lang.jvm.JvmModifier;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.components.KaSymbolInformationProviderKt;
import org.jetbrains.kotlin.analysis.api.components.KaUseSiteVisibilityChecker;
import org.jetbrains.kotlin.analysis.api.components.KaVisibilityCheckerKt;
import org.jetbrains.kotlin.analysis.api.permissions.KaAnalysisPermissionRegistry;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassLikeSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaDeclarationSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbolProviderKt;
import org.jetbrains.kotlin.idea.base.projectStructure.ApiKt;
import org.jetbrains.kotlin.idea.base.util.FqNameUtils;
import org.jetbrains.kotlin.idea.completion.KotlinFirCompletionParameters;
import org.jetbrains.kotlin.idea.util.positionContext.KDocNameReferencePositionContext;
import org.jetbrains.kotlin.idea.util.positionContext.KotlinRawPositionContext;
import org.jetbrains.kotlin.idea.util.positionContext.KotlinSimpleNameReferencePositionContext;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationInfo;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationLevelValue;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\n\u001a\u00020\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J'\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\bR\u00020\u0016j\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u001bJ!\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\bH\u0002R\u00020\u0016j\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u001dR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/completion/checkers/CompletionVisibilityChecker;", "", "parameters", "Lorg/jetbrains/kotlin/idea/completion/KotlinFirCompletionParameters;", "<init>", "(Lorg/jetbrains/kotlin/idea/completion/KotlinFirCompletionParameters;)V", "visibilityCheckerPerPositionContextCache", "", "Lorg/jetbrains/kotlin/idea/util/positionContext/KotlinRawPositionContext;", "Lorg/jetbrains/kotlin/analysis/api/components/KaUseSiteVisibilityChecker;", "hasEffectiveVisibility", "", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "visibility", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "canBeVisible", "declaration", "Lcom/intellij/psi/PsiElement;", "canAccessInternalDeclarationsFromFile", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isVisible", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "<unused var>", "symbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol;", "positionContext", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol;Lorg/jetbrains/kotlin/idea/util/positionContext/KotlinRawPositionContext;)Z", "getCachedVisibilityChecker", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/idea/util/positionContext/KotlinRawPositionContext;)Lorg/jetbrains/kotlin/analysis/api/components/KaUseSiteVisibilityChecker;", "intellij.kotlin.completion.impl"})
@SourceDebugExtension(value={"SMAP\nCompletionVisibilityChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompletionVisibilityChecker.kt\norg/jetbrains/kotlin/idea/completion/checkers/CompletionVisibilityChecker\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 permissions.kt\norg/jetbrains/kotlin/analysis/api/permissions/PermissionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,122:1\n1276#2,2:123\n19#3,9:125\n383#4,7:134\n*S KotlinDebug\n*F\n+ 1 CompletionVisibilityChecker.kt\norg/jetbrains/kotlin/idea/completion/checkers/CompletionVisibilityChecker\n*L\n47#1:123,2\n50#1:125,9\n114#1:134,7\n*E\n"})
public final class CompletionVisibilityChecker {
    @NotNull
    private final KotlinFirCompletionParameters parameters;
    @NotNull
    private final Map<KotlinRawPositionContext, KaUseSiteVisibilityChecker> visibilityCheckerPerPositionContextCache;

    public CompletionVisibilityChecker(@NotNull KotlinFirCompletionParameters parameters2) {
        Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
        this.parameters = parameters2;
        this.visibilityCheckerPerPositionContextCache = new LinkedHashMap();
    }

    private final boolean hasEffectiveVisibility(KtDeclaration $this$hasEffectiveVisibility, KtModifierKeywordToken visibility2) {
        boolean bl;
        block1: {
            Sequence $this$any$iv = PsiUtilsKt.getParentsWithSelf((PsiElement)((PsiElement)$this$hasEffectiveVisibility));
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl2 = false;
                if (!(it instanceof KtModifierListOwner && ((KtModifierListOwner)it).hasModifier(visibility2))) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public final boolean canBeVisible(@NotNull PsiElement declaration) {
        block26: {
            block27: {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                description$iv = "canBeVisible";
                $i$f$forbidAnalysis = false;
                permissionRegistry$iv = KaAnalysisPermissionRegistry.Companion.getInstance();
                if (permissionRegistry$iv.getExplicitAnalysisRestriction() == null) break block26;
                $i$a$-forbidAnalysis-CompletionVisibilityChecker$canBeVisible$1 = false;
                originalFile = this.parameters.getOriginalFile();
                if (originalFile instanceof KtCodeFragment) {
                    return true;
                }
                if (!this.parameters.isRerun() && this.parameters.getInvocationCount() >= 2) {
                    return true;
                }
                v0 = declaration.getContainingFile();
                if (v0 == null) {
                    return false;
                }
                declarationContainingFile = v0;
                if (declarationContainingFile instanceof KtFile && declaration instanceof KtDeclaration) {
                    v1 = (KtDeclaration)declaration;
                    v2 = KtTokens.PRIVATE_KEYWORD;
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"PRIVATE_KEYWORD");
                    if (this.hasEffectiveVisibility(v1, v2) && !Intrinsics.areEqual((Object)declarationContainingFile, (Object)originalFile) && !Intrinsics.areEqual((Object)declarationContainingFile, (Object)this.parameters.getCompletionFile())) {
                        return false;
                    }
                    v3 = (KtDeclaration)declaration;
                    v4 = KtTokens.INTERNAL_KEYWORD;
                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"INTERNAL_KEYWORD");
                    if (this.hasEffectiveVisibility(v3, v4)) {
                        return this.canAccessInternalDeclarationsFromFile((KtFile)declarationContainingFile);
                    }
                    return true;
                }
                if (!(declaration instanceof PsiMember)) break block27;
                if (!((PsiMember)declaration).hasModifier(JvmModifier.PUBLIC)) ** GOTO lbl-1000
                v5 = ((PsiMember)declaration).getContainingClass();
                v6 = v5 != null ? v5.hasModifier(JvmModifier.PUBLIC) : false;
                if (v6) {
                    v7 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v7 = false;
                }
                return v7;
            }
            return false;
        }
        permissionRegistry$iv.setExplicitAnalysisRestriction(new KaAnalysisPermissionRegistry.KaExplicitAnalysisRestriction(description$iv));
        try {
            block28: {
                $i$a$-forbidAnalysis-CompletionVisibilityChecker$canBeVisible$1 = false;
                originalFile = this.parameters.getOriginalFile();
                if (originalFile instanceof KtCodeFragment) {
                    var15_12 = true;
                    return var15_12;
                }
                if (!this.parameters.isRerun() && this.parameters.getInvocationCount() >= 2) {
                    var14_13 = true;
                    return var14_13;
                }
                if (declaration.getContainingFile() == null) {
                    var13_14 = false;
                    return var13_14;
                }
                declarationContainingFile = v8;
                if (declarationContainingFile instanceof KtFile && declaration instanceof KtDeclaration) {
                    v9 = (KtDeclaration)declaration;
                    v10 = KtTokens.PRIVATE_KEYWORD;
                    Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"PRIVATE_KEYWORD");
                    if (this.hasEffectiveVisibility(v9, v10) && !Intrinsics.areEqual((Object)declarationContainingFile, (Object)originalFile) && !Intrinsics.areEqual((Object)declarationContainingFile, (Object)this.parameters.getCompletionFile())) {
                        var12_15 = false;
                        return var12_15;
                    }
                    v11 = (KtDeclaration)declaration;
                    v12 = KtTokens.INTERNAL_KEYWORD;
                    Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"INTERNAL_KEYWORD");
                    if (this.hasEffectiveVisibility(v11, v12)) {
                        var11_16 = this.canAccessInternalDeclarationsFromFile((KtFile)declarationContainingFile);
                        return var11_16;
                    }
                    var10_17 = true;
                    return var10_17;
                }
                if (!(declaration instanceof PsiMember)) break block28;
                if (!((PsiMember)declaration).hasModifier(JvmModifier.PUBLIC)) ** GOTO lbl-1000
                v13 = ((PsiMember)declaration).getContainingClass();
                v14 = v13 != null ? v13.hasModifier(JvmModifier.PUBLIC) : false;
                if (v14) {
                    v15 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v15 = false;
                }
                var9_18 = v15;
                return var9_18;
            }
            var8_19 = false;
            return var8_19;
        }
        finally {
            permissionRegistry$iv.setExplicitAnalysisRestriction(null);
        }
    }

    private final boolean canAccessInternalDeclarationsFromFile(KtFile file) {
        if (file.isCompiled()) {
            return false;
        }
        KaModule useSiteModule = KotlinFirCompletionParameters.Companion.getUseSiteModule(this.parameters);
        PsiElement psiElement = (PsiElement)file;
        Project project = this.parameters.getOriginalFile().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KaModule declarationModule = ApiKt.getKaModule(psiElement, project, useSiteModule);
        return Intrinsics.areEqual((Object)declarationModule, (Object)useSiteModule) || useSiteModule.getDirectFriendDependencies().contains(declarationModule);
    }

    public final boolean isVisible(@NotNull KaSession kaSession, @NotNull KaDeclarationSymbol symbol, @NotNull KotlinRawPositionContext positionContext) {
        FqName fqName2;
        ClassId classId;
        KaClassLikeSymbol kaClassLikeSymbol;
        Intrinsics.checkNotNullParameter((Object)kaSession, (String)"$context-KaSession");
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)positionContext, (String)"positionContext");
        if (positionContext instanceof KDocNameReferencePositionContext) {
            return true;
        }
        DeprecationInfo deprecationInfo2 = KaSymbolInformationProviderKt.getDeprecationStatus(kaSession, symbol);
        if ((deprecationInfo2 != null ? deprecationInfo2.getDeprecationLevel() : null) == DeprecationLevelValue.HIDDEN) {
            return false;
        }
        if (this.parameters.getInvocationCount() > 1) {
            return true;
        }
        KaClassLikeSymbol kaClassLikeSymbol2 = kaClassLikeSymbol = symbol instanceof KaClassLikeSymbol ? (KaClassLikeSymbol)symbol : null;
        boolean bl = kaClassLikeSymbol != null && (classId = kaClassLikeSymbol.getClassId()) != null && (fqName2 = classId.asSingleFqName()) != null ? FqNameUtils.isJavaClassNotToBeUsedInKotlin(fqName2) : false;
        if (bl) {
            return false;
        }
        KtFile originalFile = this.parameters.getOriginalFile();
        if (originalFile instanceof KtCodeFragment) {
            return true;
        }
        return this.getCachedVisibilityChecker(kaSession, positionContext).isVisible(symbol);
    }

    /*
     * WARNING - void declaration
     */
    private final KaUseSiteVisibilityChecker getCachedVisibilityChecker(KaSession kaSession, KotlinRawPositionContext positionContext) {
        Object object;
        void $this$getOrPut$iv;
        Map<KotlinRawPositionContext, KaUseSiteVisibilityChecker> map2 = this.visibilityCheckerPerPositionContextCache;
        KotlinRawPositionContext key$iv = positionContext;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            KotlinSimpleNameReferencePositionContext kotlinSimpleNameReferencePositionContext = positionContext instanceof KotlinSimpleNameReferencePositionContext ? (KotlinSimpleNameReferencePositionContext)positionContext : null;
            KaUseSiteVisibilityChecker answer$iv = KaVisibilityCheckerKt.createUseSiteVisibilityChecker(kaSession, KaSymbolProviderKt.getSymbol(kaSession, this.parameters.getOriginalFile()), (KtExpression)(kotlinSimpleNameReferencePositionContext != null ? kotlinSimpleNameReferencePositionContext.getExplicitReceiver() : null), positionContext.getPosition());
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (KaUseSiteVisibilityChecker)object;
    }
}

